/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewmediashape.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 13:56:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_slideshow.hxx"

// must be first
#include <canvas/debug.hxx>

#ifndef  _USE_MATH_DEFINES
#define  _USE_MATH_DEFINES  // needed by Visual C++ for math constants
#endif
#include <math.h>           // M_PI definition 

#include <viewmediashape.hxx>
#include <mediashape.hxx>
#include <tools.hxx>
#include <vcl/window.hxx>
#include <vcl/javachild.hxx>
#include <vcl/salbtype.hxx>

#ifndef _BGFX_NUMERIC_FTOOLS_HXX
#include <basegfx/numeric/ftools.hxx>
#endif
#ifndef _BGFX_POLYGON_B2DPOLYGON_HXX
#include <basegfx/polygon/b2dpolygon.hxx>
#endif
#ifndef _BGFX_POINT_B2DPOINT_HXX
#include <basegfx/point/b2dpoint.hxx>
#endif
#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif
#ifndef _BGFX_POLYGON_B2DPOLYGONTOOLS_HXX
#include <basegfx/polygon/b2dpolygontools.hxx>
#endif
#ifndef _CANVAS_VERBOSETRACE_HXX
#include <canvas/verbosetrace.hxx>
#endif
#ifndef _CANVAS_CANVASTOOLS_HXX
#include <canvas/canvastools.hxx>
#endif
#ifndef _CPPCANVAS_VCLFACTORY_HXX
#include <cppcanvas/vclfactory.hxx>
#endif
#ifndef _CPPCANVAS_BASEGFXFACTORY_HXX
#include <cppcanvas/basegfxfactory.hxx>
#endif
#ifndef _CPPCANVAS_BASEGFXFACTORY_HXX
#include <cppcanvas/basegfxfactory.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_MEDIA_XMANAGER_HPP_
#include <com/sun/star/media/XManager.hpp>
#endif
#ifndef _COM_SUN_STAR_MEDIA_XPLAYER_HPP_
#include <com/sun/star/media/XPlayer.hpp>
#endif
#ifndef _COM_SUN_STAR_MEDIA_XPLAYERWINDOW_HPP_
#include <com/sun/star/media/XPlayerWindow.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif
#ifndef _COM_SUN_STAR_RENDERING_XCANVAS_HPP_
#include <com/sun/star/rendering/XCanvas.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HDL_
#include <com/sun/star/lang/XComponent.hdl>
#endif

#ifdef WNT
#define AVMEDIA_MANAGER_SERVICE_NAME "com.sun.star.media.Manager_DirectX"
#else
#define AVMEDIA_MANAGER_SERVICE_NAME "com.sun.star.media.Manager_Java"
#endif

using namespace ::com::sun::star;

namespace presentation
{
    namespace internal
    {
        ViewMediaShape::ViewMediaShape( MediaShape& rMediaShape,
										const ViewLayerSharedPtr& rViewLayer,
										const uno::Reference< drawing::XShape >& rxShape ) :
			mpViewLayer( rViewLayer ),
			mpMediaWindow(),
			maWindowOffset( 0, 0 ),
			mrMediaShape( rMediaShape ),
			mxShape( rxShape ),
			mxPlayer(),
			mxPlayerWindow()
        {
            ENSURE_AND_THROW( mxShape.is(), "ViewMediaShape::ViewMediaShape(): Invalid Shape" );
            ENSURE_AND_THROW( mpViewLayer.get(), "ViewMediaShape::ViewMediaShape(): Invalid View" );
            ENSURE_AND_THROW( mpViewLayer->getCanvas().get(), "ViewMediaShape::ViewMediaShape(): Invalid ViewLayer canvas" );
        }

		// ---------------------------------------------------------------------
				
		ViewMediaShape::~ViewMediaShape()
		{		
            leaveAnimationMode();
		}

		// ---------------------------------------------------------------------

        ViewLayerSharedPtr ViewMediaShape::getViewLayer() const
        {
            return mpViewLayer;
        }

		// ---------------------------------------------------------------------
		
        bool ViewMediaShape::enterAnimationMode()
        {
            if( !mxPlayer.is() )
            {
                ::basegfx::B2DRectangle aAdjustedBounds( mrMediaShape.getPosSize() );
            
                implGetAdjustedBoundRect( aAdjustedBounds );
			    implInitialize( aAdjustedBounds );
            }

            if( mxPlayer.is() && ( mxPlayer->getDuration() > 0.0 ) )
				mxPlayer->start();
			
			return true;
        }

		// ---------------------------------------------------------------------
		
        void ViewMediaShape::leaveAnimationMode()
        {
			// shutdown player window
			if( mxPlayerWindow.is() )
			{
				uno::Reference< lang::XComponent > xComponent( mxPlayerWindow, uno::UNO_QUERY );
		
				if( xComponent.is() )
					xComponent->dispose();
			
				mxPlayerWindow.clear();
			}

            mpMediaWindow = ::std::auto_ptr< JavaChildWindow >();
            			
			// shutdown player
			if( mxPlayer.is() )
			{
				mxPlayer->stop();

				uno::Reference< lang::XComponent > xComponent( mxPlayer, uno::UNO_QUERY );
		
				if( xComponent.is() )
					xComponent->dispose();
			
				mxPlayer.clear();
			}
		}

		// ---------------------------------------------------------------------
		
        bool ViewMediaShape::isBackgroundDetached() const
        {
            return false;
        }

		// ---------------------------------------------------------------------
		
        bool ViewMediaShape::update( const ::basegfx::B2DRectangle&	rBounds ) const
        {
            ::cppcanvas::CanvasSharedPtr    pCanvas = mpViewLayer->getCanvas();;
            ::basegfx::B2DRectangle         aAdjustedBounds( rBounds );            
            
            implGetAdjustedBoundRect( aAdjustedBounds );

			if( !mpMediaWindow.get() )
			{
                // fill the shape background with black
                const ::basegfx::B2DPolygon aPoly(
                    ::basegfx::tools::createPolygonFromRect(
                        aAdjustedBounds ) );
                
                ::cppcanvas::PolyPolygonSharedPtr pPolyPoly( 
                    ::cppcanvas::BaseGfxFactory::getInstance().createPolyPolygon( pCanvas, aPoly ) );
                    
                if( pPolyPoly.get() )
                {
                    pPolyPoly->setRGBAFillColor( 0x000000FFU );
                    pPolyPoly->draw();
                }
			}

			if( mxPlayerWindow.is() )
            {			
				::basegfx::B2DRange aRangePix;
    					
				::canvas::tools::calcTransformedRectBounds( aRangePix, aAdjustedBounds, mpViewLayer->getCanvas()->getTransformation() );
				
				mxPlayerWindow->setEnable( !aRangePix.isEmpty() );
    														
				if( !aRangePix.isEmpty() )
				{
                    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow > xWindow( pCanvas->getUNOCanvas(), ::com::sun::star::uno::UNO_QUERY );
				    
				    if( xWindow.is() )
				    {
				        const ::com::sun::star::awt::Rectangle aRect( xWindow->getPosSize() );
				        
				        const_cast< ViewMediaShape* >( this )->maWindowOffset.X = aRect.X;
				        const_cast< ViewMediaShape* >( this )->maWindowOffset.Y = aRect.Y;
				    }
					
					const Point aPosPixel( FRound( aRangePix.getMinX() ) + maWindowOffset.X,
										   FRound( aRangePix.getMinY() ) + maWindowOffset.Y );
					const Size	aSizePixel( FRound( aRangePix.getMaxX() - aRangePix.getMinX() ),
										    FRound( aRangePix.getMaxY() - aRangePix.getMinY() ) );
							 
					if( mpMediaWindow.get() )
					{
						mpMediaWindow->SetPosSizePixel( aPosPixel, aSizePixel );
						mxPlayerWindow->setPosSize( 0, 0, 
													aSizePixel.Width(), aSizePixel.Height(), 
													0 );
					}
					else
					{
						mxPlayerWindow->setPosSize( aPosPixel.X(), aPosPixel.Y(), 
													aSizePixel.Width(), aSizePixel.Height(), 
													0 );
					}
			    }
			}

			return true;
        }
		
		// ---------------------------------------------------------------------
				
		bool ViewMediaShape::implInitialize( const ::basegfx::B2DRectangle& rBounds )
		{
			if( !mxPlayer.is() && mxShape.is() )
			{
				ENSURE_AND_RETURN( mpViewLayer->getCanvas().get(), "ViewMediaShape::update(): Invalid layer canvas" );

				uno::Reference< rendering::XCanvas > xCanvas( mpViewLayer->getCanvas()->getUNOCanvas() );

				if( xCanvas.is() )
				{
					uno::Reference< beans::XPropertySet >	xPropSet;
					::rtl::OUString 						aURL;
					
					try
					{
						xPropSet.set( mxShape, uno::UNO_QUERY );

						// create Player
						if( xPropSet.is() && 
							( xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "MediaURL" ) ) ) >>=aURL ) )
						{
							implInitializeMediaPlayer( aURL );
						}
						
						// create visible object
						uno::Sequence< uno::Any > aDeviceParams;
						
						if( ::canvas::tools::getDeviceInfo( xCanvas, aDeviceParams ).getLength() > 1 )
						{
							::rtl::OUString aImplName;
							
							aDeviceParams[ 0 ] >>= aImplName;
						
							if( aImplName.matchIgnoreAsciiCaseAsciiL( 
                                    RTL_CONSTASCII_STRINGPARAM("VCLCanvas") ))
                            {
								implInitializeVCLBasedPlayerWindow( rBounds, aDeviceParams );
                            }
							else if( aImplName.matchIgnoreAsciiCaseAsciiL( 
                                         RTL_CONSTASCII_STRINGPARAM("DXCanvas") ))
                            {
								implInitializeDXBasedPlayerWindow( rBounds, aDeviceParams );
                            }
						}
						
						// set player properties
						implSetMediaProperties( xPropSet );
					}
					catch( uno::Exception& )
					{
					}
				}
			}
			
			return( mxPlayer.is() || mpMediaWindow.get() );
	    }

		// ---------------------------------------------------------------------
		
		void ViewMediaShape::implSetMediaProperties( const uno::Reference< beans::XPropertySet >& rxProps )
		{
			if( mxPlayer.is() )
			{
				mxPlayer->setMediaTime( 0.0 );
			
				try
				{	
					sal_Bool bLoop = sal_Bool();
					rxProps->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Loop" ) ) ) >>= bLoop;
					mxPlayer->setPlaybackLoop( bLoop );
				}
				catch( const uno::Exception& )
				{
				}

				try
				{	
					sal_Bool bMute = sal_Bool();
					rxProps->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Mute" ) ) ) >>= bMute;
					mxPlayer->setMute( bMute );
				}
				catch( const uno::Exception& )
				{
				}
								
				try
				{	
					sal_Int16 nVolumeDB = sal_Int16();
					rxProps->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "VolumeDB" ) ) ) >>= nVolumeDB;
					mxPlayer->setVolumeDB( nVolumeDB );
				}
				catch( const uno::Exception& )
				{
				}
				
				if( mxPlayerWindow.is() )
				{
					try
					{	
						media::ZoomLevel eZoom;
						rxProps->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Zoom" ) ) ) >>= eZoom;
						mxPlayerWindow->setZoomLevel( eZoom );
					}
					catch( const uno::Exception& )
					{
					}
				}
			}
		}
		
		// ---------------------------------------------------------------------
				
		bool ViewMediaShape::implInitializeMediaPlayer( const ::rtl::OUString& rMediaURL )
		{
			if( !mxPlayer.is() )
			{
				try
				{
					if( rMediaURL.getLength() )
					{
						uno::Reference< lang::XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
					
						if( xFactory.is() )
						{
							uno::Reference< media::XManager > xManager;
								
							xManager.set( xFactory->createInstance( ::rtl::OUString::createFromAscii( 
								AVMEDIA_MANAGER_SERVICE_NAME ) ), uno::UNO_QUERY );
					
							if( xManager.is() )
								mxPlayer.set( xManager->createPlayer( rMediaURL ), uno::UNO_QUERY );
						}
					}
				}
				catch( const uno::Exception& )
				{
				}
			}
			
			return mxPlayer.is();
		}

		// ---------------------------------------------------------------------
					
		bool ViewMediaShape::implInitializeVCLBasedPlayerWindow( const ::basegfx::B2DRectangle& rBounds,
																 const uno::Sequence< uno::Any >& rVCLDeviceParams)
		{
			if( !mpMediaWindow.get() && !rBounds.isEmpty() )
			{
				try
				{
					sal_Int64 aVal;
					
					rVCLDeviceParams[ 1 ] >>= aVal;
					
					Window* pWindow = reinterpret_cast< Window* >( aVal );
					
					if( pWindow )
					{
						::basegfx::B2DRange aRangePix;
								
						::canvas::tools::calcTransformedRectBounds( aRangePix, rBounds, 
																	mpViewLayer->getCanvas()->getTransformation() );
																	
						if( !aRangePix.isEmpty() )
						{
							uno::Sequence< uno::Any > 	aArgs( 2 );
							awt::Rectangle				aAWTRect( FRound( aRangePix.getMinX() ),
																  FRound( aRangePix.getMinY() ),
														  		  FRound( aRangePix.getMaxX() - aRangePix.getMinX() ),
														  		  FRound( aRangePix.getMaxY() - aRangePix.getMinY() ) );

							mpMediaWindow = ::std::auto_ptr< JavaChildWindow >( new JavaChildWindow( pWindow, WB_CLIPCHILDREN ) );
							mpMediaWindow->SetBackground( Color( COL_BLACK ) );
							mpMediaWindow->SetPosSizePixel( Point( aAWTRect.X, aAWTRect.Y ),
															Size( aAWTRect.Width, aAWTRect.Height ) );
							mpMediaWindow->Show();
							
							if( mxPlayer.is() )
							{
								aArgs[ 0 ] = uno::makeAny( (sal_Int32) mpMediaWindow->getParentWindowHandleForJava() );
								
								aAWTRect.X = aAWTRect.Y = 0;
								aArgs[ 1 ] = uno::makeAny( aAWTRect );
								
								mxPlayerWindow.set( mxPlayer->createPlayerWindow( aArgs ) );
								
								if( mxPlayerWindow.is() )
								{
									mxPlayerWindow->setVisible( true );
									mxPlayerWindow->setEnable( true );
								}
							}
						}
					}
				}
				catch( uno::Exception& )
				{
				}
			}
			
			return( mxPlayerWindow.is() );
		}
		
		// ---------------------------------------------------------------------
	
		bool ViewMediaShape::implInitializeDXBasedPlayerWindow( const ::basegfx::B2DRectangle& rBounds,
																const uno::Sequence< uno::Any >& rDXDeviceParams )
		{
            if( !mxPlayerWindow.is() )
	    	{
        		try
		        {
				    if( rDXDeviceParams.getLength() == 2 )
				    {
					    sal_Int64 aWNDVal;
    					
					    rDXDeviceParams[ 1 ] >>= aWNDVal;
   					
					    if( aWNDVal )
					    {
						    ::basegfx::B2DRange aRangePix;
    								
						    ::canvas::tools::calcTransformedRectBounds( aRangePix, rBounds, 
																	    mpViewLayer->getCanvas()->getTransformation() );
    																	
						    if( !aRangePix.isEmpty() )
						    {
							    uno::Sequence< uno::Any > 	aArgs( 2 );
							    awt::Rectangle				aAWTRect( FRound( aRangePix.getMinX() ) + maWindowOffset.X,
																    FRound( aRangePix.getMinY() ) + maWindowOffset.Y,
														  		    FRound( aRangePix.getMaxX() - aRangePix.getMinX() ),
														  		    FRound( aRangePix.getMaxY() - aRangePix.getMinY() ) );

							    if( mxPlayer.is() )
							    {
								    aArgs[ 0 ] = uno::makeAny( (sal_Int32) aWNDVal );
								    aArgs[ 1 ] = uno::makeAny( aAWTRect );
    								
								    mxPlayerWindow.set( mxPlayer->createPlayerWindow( aArgs ) );
							    }
						    }
					    }
				    }
    			}
	    	    catch( uno::Exception& )
		        {
		        }
		    }
			
			return( mxPlayerWindow.is() );
		}

		// ---------------------------------------------------------------------
	
		::basegfx::B2DRectangle& ViewMediaShape::implGetAdjustedBoundRect( ::basegfx::B2DRectangle& rBounds ) const
	    {
    	    ::basegfx::B2DHomMatrix aMatrix( mpViewLayer->getCanvas()->getTransformation() );
    	    
    	    if( aMatrix.invert() )
    	    {
        	    const ::basegfx::B2DRange   aRangePix( 0.0, 0.0, 4.0, 4.0 );
        	    ::basegfx::B2DRange         aRangeLog;

    		    ::canvas::tools::calcTransformedRectBounds( aRangeLog, aRangePix, aMatrix );
	            rBounds.grow( ( aRangeLog.getWidth() + aRangeLog.getHeight() ) * -0.5 );
	        }
	    
	        return rBounds;
	    }
	}
}
