/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: class3d.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 04:54:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _E3D_GLOBL3D_HXX
#include <globl3d.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SVX_MATRIX3D_HXX
#include "matrix3d.hxx"
#endif

/*************************************************************************
|*
|* Cast-Operator auf homogene 4x4 Matrix
|*
\************************************************************************/

Old_Matrix3D::operator Matrix4D()
{
	Matrix4D aNewMat;

	aNewMat[0] = Point4D(M[0], aTranslation[0]);
	aNewMat[1] = Point4D(M[1], aTranslation[1]);
	aNewMat[2] = Point4D(M[2], aTranslation[2]);

	return aNewMat;
}

/*************************************************************************
|*
|* Zuweisungs-Operator mit homogener 4x4 Matrix
|*
\************************************************************************/

Old_Matrix3D Old_Matrix3D::operator=(const Matrix4D& rMat)
{
	M[0] = Vector3D(rMat[0][0], rMat[0][1], rMat[0][2]);
	M[1] = Vector3D(rMat[1][0], rMat[1][1], rMat[1][2]);
	M[2] = Vector3D(rMat[2][0], rMat[2][1], rMat[2][2]);
	aTranslation = Vector3D(rMat[0][3], rMat[1][3], rMat[2][3]);

	return *this;
}

/*************************************************************************
|*
|* Stream-In-Operator fuer Matrix3D
|*
\************************************************************************/

//BFS01SvStream& operator>>(SvStream& rIStream, Old_Matrix3D& rMatrix3D)
//BFS01{
//BFS01	for (int i = 0; i < 3; i++)
//BFS01		rIStream >> rMatrix3D.M[i];
//BFS01
//BFS01	rIStream >> rMatrix3D.aTranslation;
//BFS01
//BFS01	return rIStream;
//BFS01}

/*************************************************************************
|*
|* Stream-Out-Operator fuer Matrix3D
|*
\************************************************************************/

//BFS01SvStream& operator<<(SvStream& rOStream, const Old_Matrix3D& rMatrix3D)
//BFS01{
//BFS01	for (int i = 0; i < 3; i++)
//BFS01		rOStream << rMatrix3D.M[i];
//BFS01
//BFS01	rOStream << rMatrix3D.aTranslation;
//BFS01
//BFS01	return rOStream;
//BFS01}


