/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: label3d.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 04:56:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include "svdstr.hrc"
#include "svdglob.hxx"

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_LABEL3D_HXX
#include "label3d.hxx"
#endif

TYPEINIT1(E3dLabelObj, E3dPointObj);

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

E3dLabelObj::~E3dLabelObj()
{
	// zugehoeriges 2D-SdrObject loeschen
	delete p2DLabelObj;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dLabelObj::GetObjIdentifier() const
{
	return E3D_LABELOBJ_ID;
}

/*************************************************************************
|*
|* virtuelle Methode, die ein 2D-Objekt zurueckgibt, falls moeglich
|*
\************************************************************************/

//E3dDisplayObj* E3dLabelObj::MakeViewTransform(Viewport3D& rViewpt,
//											  E3dLightList&,
//											  E3dDisplayObj* pDispObj)
//{
//	aViewPos = rViewpt.GetViewTransform() * GetTransPosition();
//
//	// 2D-Position des Labels bestimmen
//	Point a2DPos = rViewpt.ProjectAndMap(aViewPos);
//	aViewPos -= rViewpt.GetPRP();
//
//	if ( p2DLabelObj )
//		p2DLabelObj->SetAnchorPos(a2DPos);
//
//	if ( pDispObj )
//	{
//		pDispObj->Set2DObj(p2DLabelObj);
//		pDispObj->Set3DObj(this);
//	}
//	else
//		pDispObj = new E3dDisplayObj(this, p2DLabelObj);
//
//	SetDisplayObj(pDispObj);
//
//	return pDispObj;
//}

/*************************************************************************
|*
|* SdrPage auch an p2DLabelObj setzen
|*
\************************************************************************/

void E3dLabelObj::SetPage(SdrPage* pNewPage)
{
	E3dPointObj::SetPage(pNewPage);
	if ( p2DLabelObj )
		p2DLabelObj->SetPage(pNewPage);
}

/*************************************************************************
|*
|* SdrModel auch an p2DLabelObj setzen
|*
\************************************************************************/

void E3dLabelObj::SetModel(SdrModel* pNewModel)
{
	E3dPointObj::SetModel(pNewModel);
	if ( p2DLabelObj )
		p2DLabelObj->SetModel(pNewModel);
}

/*************************************************************************
|*
|* Anzahl der Handles zurueckgeben
|*
\************************************************************************/

USHORT E3dLabelObj::GetHdlCount() const
{
	if ( p2DLabelObj )	return p2DLabelObj->GetHdlCount();
	else				return E3dPointObj::GetHdlCount();
}

/*************************************************************************
|*
|* Handle-Liste fuellen
|*
\************************************************************************/

void E3dLabelObj::AddToHdlList(SdrHdlList& rHdlList) const
{
	if ( p2DLabelObj )	p2DLabelObj->AddToHdlList(rHdlList);
	else				E3dPointObj::AddToHdlList(rHdlList);
}

/*************************************************************************
|*
|* In Stream schreiben
|*
\************************************************************************/

//BFS01void E3dLabelObj::WriteData(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	E3dPointObj::WriteData(rOut);
//BFS01
//BFS01#ifdef E3D_STREAMING
//BFS01
//BFS01	SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01	aCompat.SetID("E3dLabelObj");
//BFS01#endif
//BFS01	DBG_ASSERT(p2DLabelObj, "p2DLabelObj muss vor dem Speichern definiert sein!");
//BFS01
//BFS01	rOut << *p2DLabelObj;
//BFS01#endif
//BFS01#endif	// #ifndef SVX_LIGHT
//BFS01}

/*************************************************************************
|*
|* Aus Stream laden
|*
\************************************************************************/

//BFS01void E3dLabelObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if (ImpCheckSubRecords (rHead, rIn))
//BFS01	{
//BFS01		E3dPointObj::ReadData(rHead, rIn);
//BFS01
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dLabelObj");
//BFS01#endif
//BFS01
//BFS01	// loeschen, falls schon vorhanden
//BFS01		delete p2DLabelObj;
//BFS01		p2DLabelObj = NULL;
//BFS01
//BFS01		SdrObjIOHeaderLookAhead aHead(rIn, STREAM_READ);
//BFS01
//BFS01		p2DLabelObj = SdrObjFactory::MakeNewObject(aHead.nInventor,
//BFS01												   aHead.nIdentifier, GetPage());
//BFS01		if ( p2DLabelObj != NULL )
//BFS01		{
//BFS01			rIn >> *p2DLabelObj;
//BFS01			p2DLabelObj->SetModel(GetModel());
//BFS01		}
//BFS01		else
//BFS01		{
//BFS01			aHead.SkipRecord();
//BFS01		}
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dLabelObj::operator=(const SdrObject& rObj)
{
	E3dPointObj::operator=(rObj);

	const E3dLabelObj& r3DObj = (const E3dLabelObj&)rObj;
	if ( p2DLabelObj != NULL )
		delete p2DLabelObj;

	p2DLabelObj = r3DObj.p2DLabelObj->Clone();
}

/*************************************************************************
|*
|* Get the name of the object (singular)
|*
\************************************************************************/

void E3dLabelObj::TakeObjNameSingul(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNameSingulLabel3d);

	String aName( GetName() );
	if(aName.Len())
	{
		rName += sal_Unicode(' ');
		rName += sal_Unicode('\'');
		rName += aName;
		rName += sal_Unicode('\'');
	}
}

/*************************************************************************
|*
|* Get the name of the object (plural)
|*
\************************************************************************/

void E3dLabelObj::TakeObjNamePlural(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNamePluralLabel3d);
}

// eof
