/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pntobj3d.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/18 11:54:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_PNTOBJ3D_HXX
#include "pntobj3d.hxx"
#endif

TYPEINIT1(E3dPointObj, E3dObject);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj(const Vector3D& rPos) :
	aPosition(rPos),
	bTransPosValid(sal_False)
{
	aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* Leer-Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj() :
	aPosition(Vector3D()),
	bTransPosValid(sal_False)
{
	aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* bei Aenderung der Transformation
|*
\************************************************************************/

void E3dPointObj::SetTransformChanged()
{
	E3dObject::SetTransformChanged();
	bTransPosValid = sal_False;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dPointObj::GetObjIdentifier() const
{
	return E3D_POINTOBJ_ID;
}

/*************************************************************************
|*
|* neue Position setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dPointObj::SetPosition(const Vector3D& rNewPos)
{
	if ( aPosition != rNewPos )
	{
		aPosition = rNewPos;
		bBoundVolValid = FALSE;
		bTransPosValid = sal_False;
		StructureChanged(this);
	}
}

/*************************************************************************
|*
|* Transformierte Position zurueckgeben
|*
\************************************************************************/

const Vector3D& E3dPointObj::GetTransPosition()
{
	if ( !bTransPosValid )
	{
		aTransPos = GetFullTransform() * aPosition;
		bTransPosValid = sal_True;
	}
	return aTransPos;
}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

//BFS01void E3dPointObj::WriteData(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	E3dObject::WriteData(rOut);
//BFS01
//BFS01#ifdef E3D_STREAMING
//BFS01
//BFS01	SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01	aCompat.SetID("E3dPointObj");
//BFS01#endif
//BFS01
//BFS01	rOut << aPosition;
//BFS01#endif
//BFS01#endif	// #ifndef SVX_LIGHT
//BFS01}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

//BFS01void E3dPointObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if (ImpCheckSubRecords (rHead, rIn))
//BFS01	{
//BFS01		E3dObject::ReadData(rHead, rIn);
//BFS01
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dPointObj");
//BFS01#endif
//BFS01
//BFS01		rIn >> aPosition;
//BFS01
//BFS01		bTransPosValid = sal_False;
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dPointObj::operator=(const SdrObject& rObj)
{
	E3dObject::operator=(rObj);

	const E3dPointObj& r3DObj = (const E3dPointObj&) rObj;
	aPosition = r3DObj.aPosition;
	// sicher ist sicher...
	bTransPosValid = sal_False;
}

// eof
