/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vocofmasterpagedescriptor.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 05:39:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_CONTACT_VOCOFMASTERPAGEDESCRIPTOR_HXX
#include <svx/sdr/contact/vocofmasterpagedescriptor.hxx>
#endif

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		// basic constructor.
		VOCOfMasterPageDescriptor::VOCOfMasterPageDescriptor(ObjectContact& rObjectContact, ViewContactOfMasterPageDescriptor& rViewContact)
		:	VOCBitmapBuffer(rObjectContact, rViewContact),
			rViewContactOfMasterPageDescriptor(rViewContact)
		{
		}

		// The destructor.
		VOCOfMasterPageDescriptor::~VOCOfMasterPageDescriptor()
		{
		}

		// Prepare deletion of this object.
		void VOCOfMasterPageDescriptor::PrepareDelete()
		{
			// allow ViewContactOfMasterPageDescriptor to buffer the last valid painted
			// buffer of this object to re-use it when re-displaying
			if(maBuffer.BufferIsValid())
			{
				rViewContactOfMasterPageDescriptor.OfferBufferedData(
					maBuffer.GetBufferedBitmap(), maBuffer.GetBufferedMapMode());
			}

			// call parent
			VOCBitmapBuffer::PrepareDelete();
		}

		void VOCOfMasterPageDescriptor::PaintObject(DisplayInfo& rDisplayInfo)
		{
			// see if cached data is available
			OutputDevice* pOriginalOutDev = rDisplayInfo.GetOutputDevice();
			if(pOriginalOutDev && !maBuffer.BufferIsValid())
			{
				Bitmap aBitmap(rViewContactOfMasterPageDescriptor.RequestBufferedData(pOriginalOutDev->GetMapMode()));

				if(!aBitmap.IsEmpty())
				{
					maBuffer.SetBufferedData(pOriginalOutDev->GetMapMode(), aBitmap);
				}
			}

			// call parent
			VOCBitmapBuffer::PaintObject(rDisplayInfo);

			// #i37869# Paint evtl. necessary borders and grids. Paint this over the evtl.
			// buffered MasterPage where those outputs are suppresed by purpose.
			rViewContactOfMasterPageDescriptor.PaintBackgroundPageBordersAndGrids(rDisplayInfo);
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
