/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdcrtmt.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 05:47:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include "xpoly.hxx"
#include "svdtrans.hxx"
#include "svdpagv.hxx"
#include "svdobj.hxx"
#include "svdcrtmt.hxx"

////////////////////////////////////////////////////////////////////////////////////////////////////

TYPEINIT1(ImpSdrCreateLibObjMove,SdrDragMove);

void ImpSdrCreateLibObjMove::Draw() const
{
	View().DrawCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjMove::Show()
{
	View().ShowCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjMove::Hide()
{
	View().HideCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjMove::TakeComment(XubString& /*rStr*/) const
{
}

FASTBOOL ImpSdrCreateLibObjMove::Beg()
{
	CreateObj().TakeXorPoly(CreatePV().DragPoly0(),TRUE);
	aObjRect=CreateObj().GetSnapRect();
	aObjCenter=aObjRect.Center();
	CreatePV().DragPoly0().Move(-aObjCenter.X(),-aObjCenter.Y());
	CreatePV().DragPoly()=CreatePV().DragPoly0();
	Point aNow(DragStat().GetStart());
	CreatePV().DragPoly().Move(aNow.X(),aNow.Y());
	DragStat().SetNoSnap();
	DragStat().NextPoint();
	Show();
	return TRUE;
}

void ImpSdrCreateLibObjMove::MovAllPoints()
{
	CreatePV().DragPoly()=CreatePV().DragPoly0();
	Point aNow(DragStat().GetNow());
	CreatePV().DragPoly().Move(aNow.X(),aNow.Y());
}

void ImpSdrCreateLibObjMove::Mov(const Point& rPntNoSnap)
{
	if (DragStat().CheckMinMoved(rPntNoSnap)) {
		Rectangle aRect(aObjRect);
		aRect.Move(rPntNoSnap.X()-aObjCenter.X(),rPntNoSnap.Y()-aObjCenter.Y());
		long nDX=0;
		long nDY=0;
		View().SnapRect(aRect,&CreatePV(),nDX,nDY);
		Point aPnt(rPntNoSnap);
		aPnt.X()+=nDX;
		aPnt.Y()+=nDY;
		if (aPnt!=DragStat().GetNow()) {
			aRect.Move(nDX,nDY);
			DragStat().SetActionRect(aRect);
			Hide();
			DragStat().NextMove(aPnt);
			MovAllPoints();
			Show();
		}
	}
}

FASTBOOL ImpSdrCreateLibObjMove::End(FASTBOOL /*bCopy*/)
{
	Hide();
	if (DragStat().IsMinMoved()) {
		Point aNow(DragStat().GetNow());
		aNow-=aObjCenter;
		CreateObj().NbcMove(Size(aNow.X(),aNow.Y()));
		return TRUE;
	}
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TYPEINIT1(ImpSdrCreateLibObjResize,SdrDragResize);

void ImpSdrCreateLibObjResize::Draw() const
{
	View().DrawCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjResize::Show()
{
	View().ShowCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjResize::Hide()
{
	View().HideCreateObj(GetDragWin(),FALSE);
}

void ImpSdrCreateLibObjResize::TakeComment(XubString& /*rStr*/) const
{
}

FASTBOOL ImpSdrCreateLibObjResize::Beg()
{
	aObjRect=CreateObj().GetSnapRect();
	Point aMov(DragStat().GetStart());
	aMov-=aObjRect.TopLeft();
	CreateObj().NbcMove(Size(aMov.X(),aMov.Y()));
	aObjRect.Move(aMov.X(),aMov.Y());
	SdrObjTransformInfoRec aInfo;
	CreateObj().TakeObjInfo(aInfo);
	bForceOrtho=!aInfo.bResizeFreeAllowed;
	CreateObj().TakeXorPoly(CreatePV().DragPoly0(),TRUE);
	CreatePV().DragPoly()=XPolyPolygon();
	DragStat().NextPoint();
	Show();
	return TRUE;
}

void ImpSdrCreateLibObjResize::MovAllPoints()
{
	CreatePV().DragPoly()=CreatePV().DragPoly0();
	if (View().IsCreate1stPointAsCenter()) {
		CreatePV().DragPoly().Move(-aObjRect.GetWidth()/2,-aObjRect.GetHeight()/2);
	}
	ResizeXPoly(CreatePV().DragPoly(),DragStat().GetStart(),aXFact,aYFact);
}

void ImpSdrCreateLibObjResize::Mov(const Point& rPntNoSnap)
{
	if (DragStat().CheckMinMoved(rPntNoSnap)) {
		Point aPnt(View().GetSnapPos(rPntNoSnap,&CreatePV()));
		FASTBOOL bOrtho=bForceOrtho || View().IsOrtho();
		Point aDelta(aPnt);
		aDelta-=DragStat().GetStart();
		long nXMul=aDelta.X();
		long nYMul=aDelta.Y();
		long nXDiv=aObjRect.GetWidth()-1;
		long nYDiv=aObjRect.GetHeight()-1;
		FASTBOOL bXNeg=nXMul<0 != nXDiv<0;
		FASTBOOL bYNeg=nYMul<0 != nYDiv<0;
		if (nXMul<0) nXMul=-nXMul;
		if (nXDiv<0) nXMul=-nXDiv;
		if (nYMul<0) nYMul=-nYMul;
		if (nYDiv<0) nYMul=-nYDiv;
		if (View().IsCreate1stPointAsCenter()) {
			nXDiv/=2;
			nYDiv/=2;
		}
		if (nXDiv==0) nXDiv=1;
		if (nYDiv==0) nYDiv=1;
		Fraction aXFact0(aXFact);
		Fraction aYFact0(aYFact);
		aXFact=Fraction(nXMul,nXDiv);
		aYFact=Fraction(nYMul,nYDiv);
		if (bOrtho) {
			if (aXFact<aYFact != rView.IsBigOrtho()) {
				aYFact=aXFact;
			} else {
				aXFact=aYFact;
			}
		}
		if (bXNeg) aXFact*=Fraction(-1,1);
		if (bYNeg) aYFact*=Fraction(-1,1);

		if (aXFact!=aXFact0 || aYFact!=aYFact0) {
			Rectangle aRect(aObjRect);
			if (View().IsCreate1stPointAsCenter()) {
				aRect.Move(-aObjRect.GetWidth()/2,-aObjRect.GetHeight()/2);
			}
			ResizeRect(aRect,DragStat().GetStart(),aXFact,aYFact);
			DragStat().SetActionRect(aRect);
			Hide();
			DragStat().NextMove(aPnt);
			MovAllPoints();
			Show();
		}
	}
}

FASTBOOL ImpSdrCreateLibObjResize::End(FASTBOOL /*bCopy*/)
{
	Hide();

	if(DragStat().GetNow() != DragStat().GetStart())
	{
		if(View().IsCreate1stPointAsCenter())
		{
			CreateObj().NbcMove(Size(-aObjRect.GetWidth()/2, -aObjRect.GetHeight()/2));
		}

		CreateObj().NbcResize(DragStat().GetStart(), aXFact, aYFact);
		return TRUE;
	}
	return FALSE;
}

