/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xline.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 13:31:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"



#include <stdlib.h>
#include <math.h>
#include <tools/bigint.hxx>
#include <tools/poly.hxx>
#include <vcl/svapp.hxx>
#include <vcl/virdev.hxx>
#include <vcl/metaact.hxx>
#include <vcl/gdimtf.hxx>
#include <vcl/gradient.hxx>
#include "xpoly.hxx"
#include "xoutx.hxx"

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYGON_HXX
#include <basegfx/polygon/b2dpolygon.hxx>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYGONTOOLS_HXX
#include <basegfx/polygon/b2dpolygontools.hxx>
#endif

#include <algorithm>

#define GLOBALOVERFLOW

/*************************************************************************
|*
|* eine der Haelften einer Bezierkurve berechnen
|*
\************************************************************************/

void SplitBezier(const XPolygon& rBez, XPolygon& rSplit, BOOL bFirstPart)
{
	if ( bFirstPart )
	{
		rSplit[0] = rBez[0];
		rSplit[1] = (rBez[0] + rBez[1]) / 2;
		rSplit[2] = (rBez[0] + rBez[1] * 2 + rBez[2]) / 4;
		rSplit[3] = (rBez[0] + rBez[1] * 3 + rBez[2] * 3 + rBez[3]) / 8;
	}
	else
	{
		rSplit[1] = (rBez[3] + rBez[2] * 2 + rBez[1]) / 4;
		rSplit[2] = (rBez[3] + rBez[2]) / 2;
		rSplit[3] = rBez[3];
	}
}

/*************************************************************************
|*
|* pruefen, ob die uebergebene Bezierkurve eine gerade Linie ist
|*
\************************************************************************/

BOOL IsBezierStraight(const XPolygon& rBez)
{
	// Point-on-Line-Test nach Graphics Gems I, S. 49f.
	long X0 = rBez[0].X(), Y0 = rBez[0].Y();
	long X1 = rBez[1].X(), Y1 = rBez[1].Y();
	long X2 = rBez[2].X(), Y2 = rBez[2].Y();
	long X3 = rBez[3].X(), Y3 = rBez[3].Y();
	BigInt DX(X3 - X0);
	BigInt DY(Y3 - Y0);
	BigInt nAbsDX(DX), nAbsDY(DY);
	nAbsDX.Abs();
	nAbsDY.Abs();
	BigInt nMax(nAbsDX > nAbsDY ? nAbsDX : nAbsDY);
	BigInt nCompare;

	// Kontrollpunkte auf der (unendlichen) Linie durch P3 und P0?
	nCompare = DY * BigInt(X1-X0) - DX * BigInt(Y1-Y0);
	nCompare.Abs();
	if ( nCompare >= nMax )
		return FALSE;

	nCompare = DY * BigInt(X2-X0) - DX * BigInt(Y2-Y0);
	nCompare.Abs();
	if ( nCompare >= nMax )
		return FALSE;

	//                                                  ____
	// wenn ja, dann pruefen, ob ausserhalb der Strecke P3P0
	if ( (X3 < X0 && X0 < X1) || (Y3 < Y0 && Y0 < Y1) ) return FALSE;
	if ( (X1 < X0 && X0 < X3) || (Y1 < Y0 && Y0 < Y3) ) return FALSE;
	if ( (X0 < X3 && X3 < X1) || (Y0 < Y3 && Y3 < Y1) ) return FALSE;
	if ( (X1 < X3 && X3 < X0) || (Y1 < Y3 && Y3 < Y3) ) return FALSE;

	if ( (X3 < X0 && X0 < X2) || (Y3 < Y0 && Y0 < Y2) ) return FALSE;
	if ( (X2 < X0 && X0 < X3) || (Y2 < Y0 && Y0 < Y3) ) return FALSE;
	if ( (X0 < X3 && X3 < X2) || (Y0 < Y3 && Y3 < Y2) ) return FALSE;
	if ( (X2 < X3 && X3 < X0) || (Y2 < Y3 && Y3 < Y3) ) return FALSE;

	return TRUE;
}

/*************************************************************************
|*
|* Bezierkurve durch Iteration bestimmen
|*
\************************************************************************/

void XOutIterateBezier(const XPolygon& rBez, Rectangle& rRect, USHORT nMaxDepth)
{
	// Das Folgende Statement ist Optimierung
	if (rRect.IsInside(rBez[0]) && rRect.IsInside(rBez[1]) &&
		rRect.IsInside(rBez[2]) && rRect.IsInside(rBez[3])) return;

	if ( nMaxDepth == 0 || IsBezierStraight(rBez) )
	{
		long nX = rBez[3].X(),
			 nY = rBez[3].Y();
		rRect.Left()    = Min(nX, rRect.Left());
		rRect.Right()   = Max(nX, rRect.Right());
		rRect.Top()     = Min(nY, rRect.Top());
		rRect.Bottom()  = Max(nY, rRect.Bottom());
	}
	else
	{
		XPolygon aSplitBez(4);

		nMaxDepth--;
		SplitBezier(rBez, aSplitBez, TRUE);
		XOutIterateBezier(aSplitBez, rRect, nMaxDepth);
		aSplitBez[0] = aSplitBez[3];
		SplitBezier(rBez, aSplitBez, FALSE);
		XOutIterateBezier(aSplitBez, rRect, nMaxDepth);
	}
}

/*************************************************************************
|*
|*    XOutputDevice::XOutCalcXPolyExtent()
|*
|*    Beschreibung
|*    Ersterstellung    14.08.95 ESO
|*    Letzte Aenderung  15.08.95 ESO
|*
*************************************************************************/

//BFS09Rectangle XOutCalcXPolyExtent(const XPolygon& rXPoly, OutputDevice* pOut)
//BFS09{
//BFS09	if ( rXPoly.GetPointCount() == 0 )
//BFS09		return Rectangle();
//BFS09
//BFS09	USHORT i;
//BFS09	USHORT nPntMax=rXPoly.GetPointCount()-1;
//BFS09
//BFS09	FASTBOOL bHasBezier=FALSE;
//BFS09	Rectangle aRect(rXPoly[0],rXPoly[0]);
//BFS09	// zunaechst das Rect der Stuetzstellen (ohne Kontrollpunkte) bestimmen
//BFS09	Point aPt;
//BFS09	for (i=nPntMax; i>0; i--) {
//BFS09		if (!rXPoly.IsControl(i)) {
//BFS09			aPt=rXPoly[i]; // lokal kopieren fuer bessere Performance
//BFS09			if (aPt.X()<aRect.Left  ()) aRect.Left  ()=aPt.X();
//BFS09			if (aPt.X()>aRect.Right ()) aRect.Right ()=aPt.X();
//BFS09			if (aPt.Y()<aRect.Top   ()) aRect.Top   ()=aPt.Y();
//BFS09			if (aPt.Y()>aRect.Bottom()) aRect.Bottom()=aPt.Y();
//BFS09		} else bHasBezier=TRUE;
//BFS09	}
//BFS09	if (!bHasBezier) return aRect;
//BFS09
//BFS09	if (pOut!=NULL)
//BFS09		aRect = pOut->LogicToPixel(aRect);
//BFS09	i=0;
//BFS09	while ( i < nPntMax )
//BFS09	{
//BFS09		if ( i <= nPntMax - 3 && rXPoly.GetFlags(i+1) == XPOLY_CONTROL )
//BFS09		{
//BFS09			XPolygon aBez(4);
//BFS09
//BFS09			if ( pOut )
//BFS09			{
//BFS09				aBez[0] = pOut->LogicToPixel(rXPoly[i]);
//BFS09				aBez[1] = pOut->LogicToPixel(rXPoly[i+1]);
//BFS09				aBez[2] = pOut->LogicToPixel(rXPoly[i+2]);
//BFS09				aBez[3] = pOut->LogicToPixel(rXPoly[i+3]);
//BFS09			}
//BFS09			else
//BFS09			{
//BFS09				aBez[0] = rXPoly[i];
//BFS09				aBez[1] = rXPoly[i+1];
//BFS09				aBez[2] = rXPoly[i+2];
//BFS09				aBez[3] = rXPoly[i+3];
//BFS09			}
//BFS09			XOutIterateBezier(aBez, aRect, 8);
//BFS09			i += 3;
//BFS09		}
//BFS09		else
//BFS09		{
//BFS09			Point aPnt(rXPoly[++i]);
//BFS09			if ( pOut )
//BFS09				aPnt = pOut->LogicToPixel(aPnt);
//BFS09
//BFS09			aRect.Left()    = Min(aPnt.X(), aRect.Left());
//BFS09			aRect.Right()   = Max(aPnt.X(), aRect.Right());
//BFS09			aRect.Top()     = Min(aPnt.Y(), aRect.Top());
//BFS09			aRect.Bottom()  = Max(aPnt.Y(), aRect.Bottom());
//BFS09		}
//BFS09	}
//BFS09	if ( pOut )
//BFS09		aRect = pOut->PixelToLogic(aRect);
//BFS09	return aRect;
//BFS09}

/*************************************************************************
|*
|*    XOutputDevice::CalcBezierStepCount()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  14.12.94 ESO
|*
*************************************************************************/

//BFS09long XOutCalcBezierStepCount( const XPolygon& rXPoly, USHORT nIndex,
//BFS09							  OutputDevice* pOut, USHORT nRough )
//BFS09{
//BFS09	long nSteps;
//BFS09
//BFS09	if( pOut || nRough )
//BFS09	{
//BFS09		const Point& aPt = rXPoly[ nIndex++ ];
//BFS09		const Point& aPt1 = rXPoly[ nIndex++ ];
//BFS09		const Point& aPt2 = rXPoly[ nIndex++ ];
//BFS09		const Point& aPt3 = rXPoly[ nIndex ];
//BFS09		long nDx1 = Abs( aPt1.X() - aPt.X() ) * 2;
//BFS09		long nDy1 = Abs( aPt1.Y() - aPt.Y() ) * 2;
//BFS09		long nDx2 = Abs( aPt3.X() - aPt2.X() ) * 2;
//BFS09		long nDy2 = Abs( aPt3.Y() - aPt2.Y() ) * 2;
//BFS09		long nDxHndl = Abs( aPt2.X() - aPt1.X() );
//BFS09		long nDyHndl = Abs( aPt2.Y() - aPt1.Y() );
//BFS09
//BFS09		long nDelta = Max(Max(nDx1, nDy1), Max(nDx2, nDy2));
//BFS09		nDelta = Max(nDelta, Max(nDxHndl, nDyHndl));
//BFS09		if( pOut )
//BFS09			nDelta = pOut->LogicToPixel(Size(nDelta, 0)).Width();
//BFS09		if( nRough )
//BFS09			nSteps = nDelta / nRough + 4;
//BFS09		else
//BFS09			nSteps = nDelta / 25 + 4;
//BFS09	}
//BFS09	else nSteps = 10;
//BFS09
//BFS09    // #i19674# For nSteps^3 in the vicinity of LONG_MAX, the
//BFS09    // XOutCalcBezier algorithm below will overflow.
//BFS09	return ::std::min( 1024L, nSteps );
//BFS09}


/*************************************************************************
|*
|*    XOutputDevice::CalcBezier()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  14.12.94 ESO
|*
*************************************************************************/

//BFS09void XOutCalcBezier( const XPolygon& rXPoly, USHORT nBezIndex, Polygon& rPoly,
//BFS09					 USHORT nPolyIndex, long nSteps )
//BFS09{
//BFS09	if ( nPolyIndex > XPOLY_MAXPOINTS )
//BFS09	{
//BFS09		return;
//BFS09	}
//BFS09
//BFS09	double nX;
//BFS09	double nY;
//BFS09	double nX0, nX1, nX2, nX3;
//BFS09	double nY0, nY1, nY2, nY3;
//BFS09
//BFS09	long nDiff = nSteps - 1;
//BFS09	long nDiv = nSteps * nSteps * nSteps;
//BFS09	rPoly[nPolyIndex++] = rXPoly[nBezIndex];
//BFS09
//BFS09	nX0 = rXPoly[nBezIndex  ].X();
//BFS09	nY0 = rXPoly[nBezIndex++].Y();
//BFS09	nX1 = rXPoly[nBezIndex  ].X() * 3;
//BFS09	nY1 = rXPoly[nBezIndex++].Y() * 3;
//BFS09	nX2 = rXPoly[nBezIndex  ].X() * 3;
//BFS09	nY2 = rXPoly[nBezIndex++].Y() * 3;
//BFS09	nX3 = rXPoly[nBezIndex  ].X();
//BFS09	nY3 = rXPoly[nBezIndex  ].Y();
//BFS09
//BFS09	for (long nStep = 1; nStep < nSteps; nStep++, nDiff--, nPolyIndex++)
//BFS09	{
//BFS09		long nAcc = nDiff * nDiff * nDiff;
//BFS09
//BFS09		nX = nX0 * nAcc;
//BFS09		nY = nY0 * nAcc;
//BFS09		nAcc = nAcc / nDiff * nStep;
//BFS09		nX += nX1 * nAcc;
//BFS09		nY += nY1 * nAcc;
//BFS09		nAcc = nAcc / nDiff * nStep;
//BFS09		nX += nX2 * nAcc;
//BFS09		nY += nY2 * nAcc;
//BFS09		nAcc = nAcc / nDiff * nStep;
//BFS09		nX += nX3 * nAcc;
//BFS09		nY += nY3 * nAcc;
//BFS09
//BFS09		rPoly[nPolyIndex].X() = (long) (nX / nDiv);
//BFS09		rPoly[nPolyIndex].Y() = (long) (nY / nDiv);
//BFS09	}
//BFS09	rPoly[nPolyIndex] = rXPoly[nBezIndex];
//BFS09}

/*************************************************************************
|*
|*    XOutputDevice::CreatePolygon()
|*
|*    Beschreibung
|*    Ersterstellung    09.11.94
|*    Letzte Aenderung  14.12.94
|*
*************************************************************************/

//BFS09
Polygon XOutCreatePolygon(const XPolygon& rXPoly)
{
	Polygon aRetval(0);

	if(rXPoly.GetPointCount())
	{
		::basegfx::B2DPolygon aB2DPolygon(rXPoly.getB2DPolygon());

		if(aB2DPolygon.areControlPointsUsed())
		{
			aB2DPolygon = ::basegfx::tools::adaptiveSubdivideByAngle(aB2DPolygon);
		}

		aRetval = Polygon(aB2DPolygon);
	}

	return aRetval;
}

//BFS09Polygon XOutCreatePolygon( const XPolygon& rXPoly, OutputDevice* pOut,
//BFS09						   USHORT nRough )
//BFS09{
//BFS09	if ( rXPoly.GetPointCount() == 0 )
//BFS09		return Polygon(0);
//BFS09
//BFS09	USHORT i = 0;
//BFS09	ULONG  nPolySize = 1;
//BFS09	USHORT nPntMax = rXPoly.GetPointCount()-1;
//BFS09
//BFS09	while (i<nPntMax) {
//BFS09		if (i+3<=nPntMax && rXPoly.IsControl(i+1)) {
//BFS09#ifdef DGB_UTIL
//BFS09			// am 14.2.1997 von Joe
//BFS09			if (!rXPoly.IsControl(i+2)) {
//BFS09				ByteString aMsg("XOutCreatePolygon(): Fehlender Kontrollpunkt an Position ");
//BFS09				aMsg += i+2;
//BFS09				aMsg += ". Stattdessen ist dort eine normale Stuetzstelle.";
//BFS09				DGB_ERROR(aMsg.GetBuffer());
//BFS09			}
//BFS09			if (rXPoly.IsControl(i+3)) {
//BFS09				ByteString aMsg("XOutCreatePolygon(): Fehlende Stuetzstelle an Position ");
//BFS09				aMsg += i+3;
//BFS09				aMsg += ". Stattdessen ist dort ein Kontrollpunkt.";
//BFS09				DGB_ERROR(aMsg.GetBuffer());
//BFS09			}
//BFS09#endif
//BFS09			nPolySize+=(USHORT)XOutCalcBezierStepCount(rXPoly,i,pOut,nRough);
//BFS09			i+=3;
//BFS09		} else {
//BFS09			nPolySize++;
//BFS09			i++;
//BFS09		}
//BFS09	}
//BFS09
//BFS09	if ( nPolySize > XPOLY_MAXPOINTS )
//BFS09		nPolySize = XPOLY_MAXPOINTS;
//BFS09
//BFS09	Polygon aPoly( (USHORT) nPolySize );
//BFS09	USHORT  nPolyPos = 0, nPolyPosMax = nPolySize - 1;
//BFS09    
//BFS09    aPoly[ 0 ] = rXPoly[ i = 0 ];
//BFS09
//BFS09	while( i < nPntMax && nPolyPos < nPolySize )
//BFS09	{
//BFS09		if( i + 3 <= nPntMax && rXPoly.GetFlags( i + 1 ) == XPOLY_CONTROL )
//BFS09		{
//BFS09			USHORT nSteps = (USHORT) XOutCalcBezierStepCount( rXPoly, i, pOut, nRough );
//BFS09			
//BFS09            if( nPolyPos + nSteps >= (USHORT) nPolySize )
//BFS09				nSteps = (USHORT)( nPolySize - nPolyPos - 1 );
//BFS09			
//BFS09            XOutCalcBezier( rXPoly, i, aPoly, nPolyPos, nSteps );
//BFS09			nPolyPos += (USHORT) nSteps;
//BFS09			i += 3;
//BFS09		}
//BFS09		else if( nPolyPos < nPolyPosMax )
//BFS09			aPoly[ ++nPolyPos ] = rXPoly[ ++i ];
//BFS09	}
//BFS09
//BFS09	return aPoly;
//BFS09}

//BFS09Polygon XOutCreatePolygonBezier( const XPolygon& rXPoly, OutputDevice* pOut )
//BFS09Polygon XOutCreatePolygonBezier(const XPolygon& rXPoly)
//BFS09{
//BFS09	sal_uInt16 i, nPtCount = rXPoly.GetPointCount();
//BFS09	Polygon aPoly( nPtCount );
//BFS09	for ( i = 0; i < nPtCount; i++ )
//BFS09	{
//BFS09		aPoly[ i ] = rXPoly[ i ];
//BFS09        aPoly.SetFlags( i, (PolyFlags)( rXPoly.GetFlags( i ) ) );
//BFS09	}
//BFS09	return aPoly;
//BFS09}

//BFS09PolyPolygon XOutCreatePolyPolygonBezier( const XPolyPolygon& rXPolyPoly, OutputDevice* pOut )
//BFS09PolyPolygon XOutCreatePolyPolygonBezier(const XPolyPolygon& rXPolyPoly)
//BFS09{
//BFS09	PolyPolygon aPolyPoly;
//BFS09
//BFS09	USHORT	nCount = rXPolyPoly.Count(), i;
//BFS09
//BFS09	for( i = 0; i < nCount; i++ )
//BFS09	{
//BFS09		if( rXPolyPoly[i].GetPointCount() > 0 )
//BFS09		{
//BFS09			aPolyPoly.Insert(XOutCreatePolygonBezier(rXPolyPoly[i]));
//BFS09		}
//BFS09//BFS09			aPolyPoly.Insert(XOutCreatePolygonBezier(rXPolyPoly[i], pOut));
//BFS09	}
//BFS09
//BFS09	return aPolyPoly;
//BFS09}

/*************************************************************************
|*
|*    Parameterklassse fuer dicke Linien mit Linienmuster
|*
\************************************************************************/

class XLineParam
{
 public:
	long    nPatSeg;
	long    nPatRemain;
	BOOL    bHasJoin, bUseJoin3;
	Point   aJoin1, aJoin2, aJoin3;
	double  fLength;
	long    nLineDx, nLineDy;
	long    nDxW, nDyW;

	XLineParam() {}

	void Init(const Point& rP1, const Point& rP2, long nWidth);
};

void XLineParam::Init(const Point& rP1, const Point& rP2, long nWidth)
{
	double fWidth = 0, fRound;

	nPatSeg = -1;
	nPatRemain = 0;
	bHasJoin = FALSE;
	bUseJoin3 = FALSE;
	nLineDx = rP2.X() - rP1.X();
	nLineDy = rP2.Y() - rP1.Y();
	fLength = sqrt((double) nLineDx * nLineDx + (double) nLineDy * nLineDy);
	if ( fLength > 0 )
		fWidth = nWidth / fLength;
	if ( nLineDy >= 0 ) fRound =  0.5;
	else                fRound = -0.5;
	nDxW =   (long) (fWidth * nLineDy + fRound);
	if ( nLineDx >= 0 ) fRound =  0.5;
	else                fRound = -0.5;
	nDyW = - (long) (fWidth * nLineDx + fRound);

	aJoin1.X() = rP2.X() + nDxW / 2;
	aJoin1.Y() = rP2.Y() + nDyW / 2;
	aJoin2 = aJoin1;
	aJoin2.X() -= nDxW;
	aJoin2.Y() -= nDyW;
	aJoin3 = aJoin1;
}

/*************************************************************************
|*
|*    XOutputDevice::CalcFatLineJoin()
|*
|*    Beschreibung      Uebergang zwischen zwei Linien eines Polygons
|*                      berechnen
|*    Ersterstellung    02.12.94
|*    Letzte Aenderung  09.01.95
|*
\************************************************************************/

void XOutputDevice::CalcFatLineJoin(const Point& rEnd, const Point& rNext,
									XLineParam& rParam)
{
	long nNextDx = rNext.X() - rEnd.X();
	long nNextDy = rNext.Y() - rEnd.Y();

	if ( nNextDx || nNextDy )
	{
		double fRound;
		long nJoinDx, nJoinDy;
		BOOL bFlatJoin = FALSE;
		BOOL bResetJoin = FALSE;

		double fNextLen = sqrt((double) nNextDx * nNextDx +
							   (double) nNextDy * nNextDy);

		// Berechnung des Anschlussuebergangs durch Auswertung
		// der Seitenverhaeltnisse in den Uebergangsdreiecken
		long nPrevDxW = rParam.nDxW;
		long nPrevDyW = rParam.nDyW;

		double fWidth = (double) nLineWidth / fNextLen;
		if ( nNextDy >= 0 ) fRound =  0.5;
		else                fRound = -0.5;
		long nNextDxW =   (long) (fWidth * nNextDy + fRound);
		if ( nNextDx >= 0 ) fRound =  0.5;
		else                fRound = -0.5;
		long nNextDyW = - (long) (fWidth * nNextDx + fRound);
		long nDxA = nNextDxW - nPrevDxW;
		long nDyA = nNextDyW - nPrevDyW;
		long nDxU = nPrevDxW + nNextDxW;
		long nDyU = nPrevDyW + nNextDyW;
		double fJoin = nDxA * nDxA + nDyA * nDyA;
		double fULen = nDxU * nDxU + nDyU * nDyU;

		if ( fULen > 0 )    fJoin = sqrt(fJoin / fULen) / 2;
		else                fJoin = 0;

		if ( fJoin > 0.7 )
		{
			double fJoinLen = fJoin * nLineWidth;
			double fLen = rParam.fLength < fNextLen ? rParam.fLength : fNextLen;

			if ( fJoinLen > fLen )
			{
				fJoin = 0;
				if ( fLen == rParam.fLength )
					bResetJoin = TRUE;
			}
			bFlatJoin = TRUE;
		}

		if ( nPrevDyW >= 0 )    fRound =  0.5;
		else                    fRound = -0.5;
		nJoinDx = -(long) (fJoin * nPrevDyW + fRound);

		if ( nPrevDxW >= 0 )    fRound =  0.5;
		else                    fRound = -0.5;
		nJoinDy = (long) (fJoin * nPrevDxW + fRound);

		// mit Vektorprodukt feststellen, ob Anschlusslinie links oder rechts
		// von der ersten Linie verlaeuft; < 0 -> links
		BOOL bLeftTurn =( (rParam.nLineDx * nNextDy -
						   rParam.nLineDy * nNextDx) < 0 );

		if ( bLeftTurn )
		{
			nJoinDx = - nJoinDx;
			nJoinDy = - nJoinDy;
		}
		rParam.bUseJoin3 = FALSE;

		if ( bFlatJoin )
		{
			if ( bLeftTurn )
			{
				rParam.aJoin3 = rParam.aJoin1;
				rParam.aJoin1 = rParam.aJoin2;
				if ( bResetJoin )
					rParam.aJoin3 = rParam.aJoin2;
				else
				{
					rParam.aJoin3.X() += nJoinDx;
					rParam.aJoin3.Y() += nJoinDy;
				}
				rParam.aJoin2.X() = rEnd.X() - nNextDxW / 2;
				rParam.aJoin2.Y() = rEnd.Y() - nNextDyW / 2;
				rParam.bUseJoin3 = TRUE;
			}
			else
			{
				if ( bResetJoin )
					rParam.aJoin2 = rParam.aJoin1;
				else
				{
					rParam.aJoin2.X() -= nJoinDx;
					rParam.aJoin2.Y() -= nJoinDy;
				}
				rParam.aJoin3.X() = rEnd.X() + nNextDxW / 2;
				rParam.aJoin3.Y() = rEnd.Y() + nNextDyW / 2;
			}
		}
		else
		{
			rParam.aJoin1.X() += nJoinDx;
			rParam.aJoin1.Y() += nJoinDy;
			rParam.aJoin2.X() -= nJoinDx;
			rParam.aJoin2.Y() -= nJoinDy;
			rParam.aJoin3 = rParam.aJoin1;
		}
		rParam.bHasJoin = TRUE;

		rParam.fLength = fNextLen;
		rParam.nLineDx = nNextDx;
		rParam.nLineDy = nNextDy;
		rParam.nDxW = nNextDxW;
		rParam.nDyW = nNextDyW;
	}
}

/*************************************************************************
|*
|*    XOutputDevice::DrawStartEndPoly()
|*
|*    Linienanfang- bzw. -endpolygon zeichnen
|*    Ersterstellung    17.01.95 ESO
|*    Letzte Aenderung  18.01.95 ESO
|*
\************************************************************************/

void XOutputDevice::DrawStartEndPoly(const Point& rPos,
									 const XPolygon& rXPoly,
									 const XLineParam& rParam)
{
	XPolygon    aXPoly(rXPoly);
	Polygon     aPoly;


	if ( rParam.fLength )
		aXPoly.Rotate(Point(0,0), (double) rParam.nLineDx / rParam.fLength,
								  (double) rParam.nLineDy / rParam.fLength);
	aXPoly.Translate(rPos);
//BFS09	aPoly = XOutCreatePolygon(aXPoly, pOut);
	aPoly = XOutCreatePolygon(aXPoly);
	pOut->DrawPolygon(aPoly);
}

/*************************************************************************
|*
|*    XOutputDevice::DrawLineStartEnd()
|*
|*    Linienanfang bzw. -ende eines Polygons zeichnen
|*    Ersterstellung    18.01.95 ESO
|*    Letzte Aenderung  20.01.95 ESO
|*
\************************************************************************/

void XOutputDevice::DrawLineStartEnd(const Polygon& rPoly)
{
	Point   aDiff;
	USHORT  nPntMax = rPoly.GetSize() - 1;
	USHORT  i = 0;

	if ( bLineStart || bLineEnd )
	{   // Linien mit Laenge 0 nicht beruecksichtigen
		while ( i < nPntMax )
		{
			aDiff = rPoly[i+1] - rPoly[i];
			if ( aDiff.X() || aDiff.Y() )
				break;
			i++;
		}
		while ( nPntMax > i )
		{
			aDiff = rPoly[nPntMax] - rPoly[0];
			if ( aDiff.X() || aDiff.Y() )
				break;
			nPntMax--;
		}
		if ( i < nPntMax )
		{
			XLineParam  aLineParam;
			const Color	aLineColor2( pOut->GetLineColor() );
			const Color	aFillColor2( pOut->GetFillColor() );

			pOut->SetLineColor();
			pOut->SetFillColor( aLineColor2 );

			if( bLineStart )
			{
				aLineParam.Init(rPoly[i], rPoly[i+1], 1);
				DrawStartEndPoly(rPoly[i], aLineStartPoly, aLineParam);
			}
			if ( bLineEnd )
			{
				aLineParam.Init(rPoly[nPntMax], rPoly[nPntMax-1], 1);
				DrawStartEndPoly(rPoly[nPntMax], aLineEndPoly, aLineParam);
			}
			
			pOut->SetFillColor( aFillColor2 );
			pOut->SetLineColor( aLineColor2 );
		}
	}
}

/*************************************************************************
|*
|*    XOutputDevice::DrawFatLine()
|*
|*    Beschreibung      Dicke Linie mit oder ohne Linienstile zeichnen
|*    Ersterstellung    28.11.94
|*    Letzte Aenderung  09.10.95
|*
\************************************************************************/

void XOutputDevice::DrawFatLine(const Point& rStart, const Point& rEnd,
							const Point* pNext, XLineParam& rParam)
{
	Polygon aPoly(5);
	BOOL    bLineComplete = FALSE;

	long nLineDx = rParam.nLineDx;
	long nLineDy = rParam.nLineDy;
	double fLength = rParam.fLength;

	long nDxW = rParam.nDxW;
	long nDyW = rParam.nDyW;

	double  fDx = 0, fDy = 0;
	long    nDx, nDy;
	long    nSeg = rParam.nPatSeg;
	long    nPattern;

	// Linienmuster vorhanden?
	if ( !pLinePattern )
	{
		nPattern = -1;
		nSeg = 0;
	}
	else
	{
		// Angefangenes Segment zu Ende zeichnen?
		if ( rParam.nPatRemain )
			nPattern = rParam.nPatRemain;
		else    // sonst naechstes Segment
		{
			nSeg++;
			if ( pLinePattern[nSeg] == 0 )  nSeg = 0;
			nPattern = pLinePattern[nSeg];
		}
	}
	aPoly[0].X() = rStart.X() + nDxW / 2;
	aPoly[0].Y() = rStart.Y() + nDyW / 2;
	aPoly[1].X() = aPoly[0].X() - nDxW;
	aPoly[1].Y() = aPoly[0].Y() - nDyW;
	aPoly[2] = aPoly[1];
	aPoly[3] = aPoly[0];
	aPoly[4] = aPoly[0];
	// An vorheriges Segment anschliessen?
	if ( rParam.bHasJoin )
	{
		aPoly[0] = rParam.aJoin1;
		aPoly[1] = rParam.aJoin2;
		aPoly[4] = rParam.aJoin3;
	}
	// Punkte zum Testen auf erreichen des Linienendes
	Point SegStart = rStart;
	Point SegEnd   = rStart;

	// Anschlusspunkte zunaechst im rechten Winkel an das Linienende
	rParam.aJoin1.X() = rEnd.X() + nDxW / 2;
	rParam.aJoin1.Y() = rEnd.Y() + nDyW / 2;
	rParam.aJoin2 = rParam.aJoin1;
	rParam.aJoin2.X() -= nDxW;
	rParam.aJoin2.Y() -= nDyW;
	rParam.bHasJoin = FALSE;
	rParam.bUseJoin3 = FALSE;

	// Anschlusslinie vorhanden?
	if ( pNext )
		CalcFatLineJoin(rEnd, *pNext, rParam);

	while ( !bLineComplete )
	{
		double fSegLength;
		// nPattern < 0: durchgehende Linie
		if ( nPattern < 0 ) fSegLength = 1.0;
		else                fSegLength = (double) nPattern / fLength;
		fDx += fSegLength * nLineDx;
		fDy += fSegLength * nLineDy;
		nDx = (long) fDx;
		nDy = (long) fDy;
		fDx -= nDx;     // Rundungsfehler ausgleichen
		fDy -= nDy;
		aPoly[2].X() += nDx;
		aPoly[2].Y() += nDy;
		aPoly[3].X() += nDx;
		aPoly[3].Y() += nDy;
		SegEnd.X() += nDx;
		SegEnd.Y() += nDy;

		// wenn das rEnde ueberschritten wurde, hat das Vorzeichen
		// der Abstaende vom rEndpunkt gewechselt; durch Xor-Verknuepfung
		// wird dieser Wechsel festgestellt
		long nEndDiffX = (SegEnd.X() - rEnd.X());
		long nEndDiffY = (SegEnd.Y() - rEnd.Y());

		if ( (nEndDiffX ^ (SegStart.X() - rEnd.X())) < 0 ||
			 (nEndDiffY ^ (SegStart.Y() - rEnd.Y())) < 0 ||
			 (!nEndDiffX && !nEndDiffY) )
		{
			if ( nDx || nDy )
			{
				if ( Abs(nDx) >= Abs(nDy) )
				{
					long nDiffX = SegEnd.X() - rEnd.X();
					rParam.nPatRemain = nPattern * nDiffX / nDx;
				}
				else
				{
					long nDiffY = SegEnd.Y() - rEnd.Y();
					rParam.nPatRemain = nPattern * nDiffY / nDy;
				}
			}
			else
				rParam.nPatRemain = 0;

			rParam.nPatSeg = nSeg;
			if ( rParam.bUseJoin3 )
			{
				aPoly[2] = rParam.aJoin1;
				aPoly[3] = rParam.aJoin3;
			}
			else
			{
				aPoly[2] = rParam.aJoin2;
				aPoly[3] = rParam.aJoin1;
			}
			bLineComplete = TRUE;
		}
		if ( !(nSeg & 0x1) )
			pOut->DrawPolygon(aPoly);

		aPoly[0] = aPoly[3];
		aPoly[1] = aPoly[2];
		aPoly[4] = aPoly[0];
		SegStart = SegEnd;

		if ( pLinePattern )
		{
			nSeg++;
			if ( pLinePattern[nSeg] == 0 )
				nSeg = 0;
			nPattern = pLinePattern[nSeg];
		}
	}
}

/*************************************************************************
|*
|*    XOutputDevice::DrawPatternLine()
|*
|*    Beschreibung      Haarlinie mit Linienstil zeichnen
|*    Ersterstellung    13.08.95 ESO
|*    Letzte Aenderung  14.08.95 ESO
|*
\************************************************************************/

void XOutputDevice::DrawPatternLine(const Point& rStart, const Point& rEnd,
									XLineParam& rParam)
{
	Point   aP1, aP2;
	BOOL    bLineComplete = FALSE;

	long    nLineDx = rParam.nLineDx;
	long    nLineDy = rParam.nLineDy;
	double  fLength = rParam.fLength;

	double  fDx = 0, fDy = 0;
	long    nDx, nDy;
	long    nSeg = rParam.nPatSeg;
	long    nPattern;

	// Linienmuster vorhanden?
	if ( !pLinePattern )
	{
		nPattern = -1;
		nSeg = 0;
	}
	else
	{
		// Angefangenes Segment zu Ende zeichnen?
		if ( rParam.nPatRemain )
			nPattern = rParam.nPatRemain;
		else    // sonst naechstes Segment
		{
			nSeg++;
			if ( pLinePattern[nSeg] == 0 )  nSeg = 0;
			nPattern = pLinePattern[nSeg];
		}
	}
	// Punkte fuer DrawLine initialisieren
	aP1 = rStart;
	aP2 = aP1;

	// Punkte zum Testen auf erreichen des Linienendes
	Point SegStart = rStart;
	Point SegEnd   = rStart;

	while ( !bLineComplete )
	{
		double fSegLength;
		// nPattern < 0: durchgehende Linie
		if ( nPattern < 0 ) fSegLength = 1.0;
		else                fSegLength = (double) nPattern / fLength;
		fDx += fSegLength * nLineDx;
		fDy += fSegLength * nLineDy;
		nDx = (long) fDx;
		nDy = (long) fDy;
		fDx -= nDx;     // Rundungsfehler ausgleichen
		fDy -= nDy;
		aP2.X() += nDx;
		aP2.Y() += nDy;
		SegEnd.X() += nDx;
		SegEnd.Y() += nDy;

		// wenn das Ende ueberschritten wurde, hat das Vorzeichen
		// der Abstaende vom Endpunkt gewechselt; durch Xor-Verknuepfung
		// wird dieser Wechsel festgestellt
		long nEndDiffX = (SegEnd.X() - rEnd.X());
		long nEndDiffY = (SegEnd.Y() - rEnd.Y());

		if ( (nEndDiffX ^ (SegStart.X() - rEnd.X())) < 0 ||
			 (nEndDiffY ^ (SegStart.Y() - rEnd.Y())) < 0 ||
			 (!nEndDiffX && !nEndDiffY) )
		{
			if ( nDx || nDy )
			{
				if ( Abs(nDx) >= Abs(nDy) )
				{
					long nDiffX = SegEnd.X() - rEnd.X();
					rParam.nPatRemain = nPattern * nDiffX / nDx;
				}
				else
				{
					long nDiffY = SegEnd.Y() - rEnd.Y();
					rParam.nPatRemain = nPattern * nDiffY / nDy;
				}
			}
			else
				rParam.nPatRemain = 0;

			rParam.nPatSeg = nSeg;
			aP2 = rEnd;
			bLineComplete = TRUE;
		}
		if ( !(nSeg & 0x1) )
		{
			pOut->DrawLine(aP1, aP2);
		}

		aP1 = aP2;
		SegStart = SegEnd;

		if ( pLinePattern )
		{
			nSeg++;
			if ( pLinePattern[nSeg] == 0 )
				nSeg = 0;
			nPattern = pLinePattern[nSeg];
		}
	}
}

/*************************************************************************
|*
|*    XOutputDevice::DrawLinePolygon()
|*
|*    Beschreibung      Polygon-Linie (ggf. mit Linienmuster) zeichnen
|*    Ersterstellung    28.11.94
|*    Letzte Aenderung  09.10.95 ESO
|*
\************************************************************************/

void XOutputDevice::DrawLinePolygon( const Polygon& rPoly, BOOL bClosePoly )
{
	if( nLineTransparence )
	{
		GDIMetaFile		aMtf;
		VirtualDevice	aVDev;
		OutputDevice*	pOldOut = pOut;
		MapMode			aMap( pOldOut->GetMapMode() );
		const BYTE		cTrans = sal::static_int_cast< BYTE >(
            nLineTransparence * 255 / 100 );
		const Color		aTrans( cTrans, cTrans, cTrans );
		Gradient		aTransGradient( GRADIENT_LINEAR, aTrans, aTrans );

		pOut = &aVDev;
		aVDev.EnableOutput( FALSE );
		aVDev.SetMapMode( pOldOut->GetMapMode() );
		aMtf.Record( &aVDev );
		aVDev.SetLineColor( pOldOut->GetLineColor() );
		aVDev.SetFillColor( pOldOut->GetFillColor() );
		aVDev.SetFont( pOldOut->GetFont() );
		aVDev.SetDrawMode( pOldOut->GetDrawMode() );
		aVDev.SetRefPoint( pOldOut->GetRefPoint() );
		ImpDrawLinePolygon( rPoly, bClosePoly );
		aMtf.Stop();
		pOut = pOldOut;

		Rectangle aBound;

		for( MetaAction* pAct = aMtf.FirstAction(); pAct; pAct = aMtf.NextAction() )
		{
			if( pAct->GetType() == META_POLYGON_ACTION )
				aBound.Union( ( (MetaPolygonAction*) pAct )->GetPolygon().GetBoundRect() );
			else if( pAct->GetType() == META_POLYLINE_ACTION )
				aBound.Union( ( (MetaPolyLineAction*) pAct )->GetPolygon().GetBoundRect() );
			else if( pAct->GetType() == META_LINE_ACTION )
			{
				const Point aStart( ( (MetaLineAction*) pAct )->GetStartPoint() );
				const Point aEnd( ( (MetaLineAction*) pAct )->GetEndPoint() );
				aBound.Union( Rectangle( aStart, aEnd ) );
			}
		}

		if( aMtf.GetActionCount() )
		{
			Size		aSizeLog( aBound.GetSize() );
			const Size	aMinSizeLog( pOut->PixelToLogic( Size( 1, 1 ) ) );
			const Size	aSizePix( pOut->LogicToPixel( aSizeLog ) );

			// watch for minimum width
			if( !aSizePix.Width() )
				aSizeLog.Width() = aMinSizeLog.Width();

			// watch for minimum width
			if( !aSizePix.Height() )
				aSizeLog.Height() = aMinSizeLog.Height();

			aMap.SetOrigin( aBound.TopLeft() );
			aMtf.SetPrefMapMode( aMap );
			aMtf.SetPrefSize( aBound.GetSize() );
			aTransGradient.SetSteps(3);
			pOut->DrawTransparent( aMtf, aBound.TopLeft(), aSizeLog, aTransGradient );
		}
	}
	else
		ImpDrawLinePolygon( rPoly, bClosePoly );
}

// -----------------------------------------------------------------------------

void XOutputDevice::ImpDrawLinePolygon(const Polygon& rPoly, BOOL bClosePoly)
{
	Polygon         aPoly( rPoly );
	const Point*    pNextPoint;
	Point           aLineStartPos, aLineEndPos;
	XLineParam      aLParam, aStartParam, aEndParam;
	USHORT          nPntMax = aPoly.GetSize() - 1;

	if( nPntMax >= 1 )
	{
		if( bHair || ( ( XLINE_SOLID == eLineStyle ) && ( nLineWidth ==  0 ) ) )
		{
			// #107240#
			// Since this method is also used for XOR drawing it's not allowed
			// to optimize to line drawing here. DrawLine() does not draw the
			// last point, thus a cycle with XOR drawing with DrawPolyLine() and then
			// deleting the last part with DrawLine() results in one point not being deleted.
			// if( 1 == nPntMax )
			//	pOut->DrawLine( rPoly[ 0 ], rPoly[ 1 ] );
			// else
			pOut->DrawPolyLine( rPoly );

			DrawLineStartEnd( rPoly );
		}
		else if( XLINE_NONE != eLineStyle )
		{
			Color		aOldLineColor;
			Color		aOldFillColor;
			Point		aDiff;
			const ULONG	nOldDrawMode = pOut->GetDrawMode();
			USHORT		i = 0;

			if( !nLineWidth )
			{
				aOldLineColor = pOut->GetLineColor();
				pOut->SetLineColor( aLineColor );
			}

			aOldFillColor = pOut->GetFillColor();

			if( nOldDrawMode & DRAWMODE_WHITEFILL )
			{
				ULONG nNewDrawMode = nOldDrawMode;

				nNewDrawMode &= ~DRAWMODE_WHITEFILL;
				nNewDrawMode |= DRAWMODE_BLACKFILL;
				pOut->SetDrawMode( nNewDrawMode );
			}

            if( nOldDrawMode & DRAWMODE_BLACKLINE )
            {
                const Color aBlack( COL_BLACK );

                pOut->SetDrawMode( pOut->GetDrawMode() & (~DRAWMODE_SETTINGSFILL) );
                pOut->SetFillColor( aBlack );
            }
            else if( nOldDrawMode & DRAWMODE_SETTINGSLINE )
            {
                pOut->SetDrawMode( pOut->GetDrawMode() & (~DRAWMODE_SETTINGSFILL) );
				svtools::ColorConfig aColorConfig;
				Color aColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
                pOut->SetFillColor( aColor );
            }
            else
                pOut->SetFillColor( aLineColor );

			// bei einfachen Linien darf das Polygon nicht geschlossen sein (#24000)
			if ( aPoly[ nPntMax ] == aPoly[ 0 ] )
			{
				if ( nPntMax > 2 )
				{
					nPntMax--;
					bClosePoly = TRUE;
				}
				else if ( 2 == nPntMax )
					bClosePoly = FALSE;
			}

			// Linien mit Laenge 0 nicht beruecksichtigen
			while ( i < nPntMax )
			{
				aDiff = aPoly[i+1] - aPoly[0];

				if ( bLineStart && !bClosePoly )
				{
					long nSqLen = aDiff.X() * aDiff.X() + aDiff.Y() * aDiff.Y();
					if ( nSqLen > nLineStartSqLen || i == nPntMax-1 )
					{
						aLineStartPos = aPoly[0];
						aStartParam.Init(aPoly[0], aPoly[i+1], 1);
						double fLen = sqrt((double)nLineStartSqLen);
						if ( aStartParam.fLength )
							fLen /= aStartParam.fLength;
						aPoly[i].X() = aPoly[0].X() + (long) (fLen * aStartParam.nLineDx);
						aPoly[i].Y() = aPoly[0].Y() + (long) (fLen * aStartParam.nLineDy);
						break;
					}
				}
				else if ( aDiff.X() || aDiff.Y() )
					break;
				i++;
			}
			USHORT  nLastPnt = nPntMax;

			while ( nPntMax > i )
			{
				aDiff = aPoly[nPntMax-1] - aPoly[nLastPnt];
				if ( bLineEnd && !bClosePoly )
				{
					long nSqLen = aDiff.X() * aDiff.X() + aDiff.Y() * aDiff.Y();
					if ( nSqLen > nLineEndSqLen || nPntMax == i+1 )
					{
						aLineEndPos = aPoly[nLastPnt];
						aEndParam.Init(aPoly[nLastPnt], aPoly[nPntMax-1], 1);
						double fLen = sqrt((double)nLineEndSqLen);
						if ( aEndParam.fLength )
							fLen /= aEndParam.fLength;
						aPoly[nPntMax].X() = aPoly[nLastPnt].X() + (long) (fLen * aEndParam.nLineDx);
						aPoly[nPntMax].Y() = aPoly[nLastPnt].Y() + (long) (fLen * aEndParam.nLineDy);
						break;
					}
				}
				else if ( aDiff.X() || aDiff.Y() )
					break;
				nPntMax--;
			}

			if ( bClosePoly )
			{
				aDiff = aPoly[nPntMax] - aPoly[i];
				if ( !aDiff.X() && !aDiff.Y() )
					nPntMax--;
				aLParam.Init(aPoly[nPntMax], aPoly[i], nLineWidth);
				if ( nLineWidth > 0 )
					CalcFatLineJoin(aPoly[i], aPoly[i+1], aLParam);
			}
			else
				aLParam.Init(aPoly[i], aPoly[i+1], nLineWidth);

			while ( i < nPntMax )
			{
				USHORT nPos = i + 1;
				while ( nPos < nPntMax )
				{
					aDiff = aPoly[nPos+1] - aPoly[nPos];
					if ( aDiff.X() || aDiff.Y() )
						break;
					nPos++;
				}
				if ( nPos+1 <= nPntMax )    pNextPoint = &aPoly[nPos+1];
				else if ( bClosePoly )      pNextPoint = &aPoly[0];
				else                        pNextPoint = NULL;

				if ( nLineWidth > 0 )
					DrawFatLine(aPoly[i], aPoly[i+1], pNextPoint, aLParam);
				else
				{
					aLParam.nLineDx = aPoly[i+1].X() - aPoly[i].X();
					aLParam.nLineDy = aPoly[i+1].Y() - aPoly[i].Y();
					aLParam.fLength = sqrt((double) aLParam.nLineDx * aLParam.nLineDx +
										   (double) aLParam.nLineDy * aLParam.nLineDy);
					DrawPatternLine(aPoly[i], aPoly[i+1], aLParam);
				}
				i = nPos;
			}
			if ( bClosePoly )
			{
				if ( nLineWidth > 0 )
					DrawFatLine(aPoly[i], aPoly[0], &aPoly[1], aLParam);
				else
				{
					aLParam.nLineDx = aPoly[0].X() - aPoly[i].X();
					aLParam.nLineDy = aPoly[0].Y() - aPoly[i].Y();
					aLParam.fLength = sqrt((double) aLParam.nLineDx * aLParam.nLineDx +
										   (double) aLParam.nLineDy * aLParam.nLineDy);
					DrawPatternLine(aPoly[i], aPoly[0], aLParam);
				}
			}
			else
			{
				if ( bLineStart )
					DrawStartEndPoly(aLineStartPos, aLineStartPoly, aStartParam);
				if ( bLineEnd )
					DrawStartEndPoly(aLineEndPos, aLineEndPoly, aEndParam);
			}

			if( nLineWidth == 0 )
				pOut->SetLineColor( aOldLineColor );

			pOut->SetFillColor( aOldFillColor );
			pOut->SetDrawMode( nOldDrawMode );
		}
	}
}


