 /*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: txtnodenumattr.hxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: kz $ $Date: 2006/11/17 09:29:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _TXTNODENUMATTR_HXX
#define _TXTNODENUMATTR_HXX

#ifndef _SW_NUMBER_TREE_HXX
#include <SwNumberTree.hxx>
#endif

class SwTxtNode;

/** helper class to presave numbering attributes of a text node
    and applying these attributes at a text node

    OD 2006-11-14 #b6492987#

    @author OD
*/
class SwTxtNodeNumAttrs
{
    public:
        SwTxtNodeNumAttrs( const SwTxtNode& rTxtNode );
        ~SwTxtNodeNumAttrs()
        {
        };

        void ApplyPresavedNumAttrsAtTxtNode( SwTxtNode& rTxtNode );

    private:
        int mnLevel;
        SwNumberTreeNode::tSwNumTreeNumber mnStart;
        bool mbRestart;
};

#endif
