/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: w4wflt.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: vg $ $Date: 2006/09/25 12:57:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

#include <w4wfltlocal.hxx>

// Handler fuer die Prozentanzeige

#if defined( WNT )

int FNDisp W4WReadDisplayHandler( int nPercent )
{
	::SetProgressState( nPercent  / 3, 0 );
	return 0;		// -1 fuehrt zu Abbruch
}

int FNDisp W4WWriteDisplayHandler( int nPercent )
{
	::SetProgressState( 67 + nPercent  / 3, 0 );
	return 0;		// -1 fuehrt zu Abbruch
}

#endif

// W4W speichert beim Laden vom File rFileName die Ausgabe in aTmpFile.
// der Filter wird ueber nFilter bestimmt.

ULONG LoadFile( const String& rFileName, USHORT nFilter,
				const String& rVersion, String & rTmpFile )
{
	rTmpFile = utl::TempFile::CreateTempName( 0 );
	String sNativeFileName(rTmpFile);
	USHORT nError = 1;

	rtl_TextEncoding eEnc = ::gsl_getSystemTextEncoding();
	ByteString sFileName( rFileName, eEnc ), sVersion( rVersion, eEnc ),
				sTmpFile( rTmpFile, eEnc );

	{
		String sTmp;
		if( utl::LocalFileHelper::ConvertPhysicalNameToURL( rTmpFile, sTmp ))
			rTmpFile = sTmp;
	}

	String aFormat;

#if defined( WNT )
	aFormat += 'w';
	if( nFilter < 10 )
		aFormat += '0';
	if( nFilter < 100 )
		aFormat += '0';
	aFormat += String::CreateFromInt32( nFilter );
	aFormat += 'f';
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "32W" ));
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ".DLL" ));
#endif	// defined( WNT )

#ifdef UNX
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "w4w" ));
	if( nFilter < 10 )
		aFormat += '0';
	aFormat += String::CreateFromInt32( nFilter );
	aFormat += 'f';
#endif	// UNX

	SvtPathOptions aOpt;
	if( !aOpt.SearchFile( aFormat, SvtPathOptions::PATH_FILTER ) )
		return ERR_W4W_DLL_ERROR | ERROR_SW_READ_BASE;

	ByteString sFormat( aFormat, ::gsl_getSystemTextEncoding() );
#if defined( WNT )

	HANDLE hDLL = LoadLibrary( (LPSTR)sFormat.GetBuffer() );
	if( hDLL >= (HANDLE)HINSTANCE_ERROR )
	{
		FNw4wf fnRead = (FNw4wf)GetProcAddress( (HINSTANCE)hDLL, (LPSTR)"w4wf" );
		if( fnRead )
			nError = (*fnRead)( (LPSTR)sFileName.GetBuffer(),
								(LPSTR)sTmpFile.GetBuffer(),
								(LPSTR)sVersion.GetBuffer(),
								(LPSTR)aEmptyByteStr.GetBuffer(),
								(FNDisplay)&W4WReadDisplayHandler
								);

		FreeLibrary( (HINSTANCE)hDLL );
	}
	else
		nError = ERR_DLL;

#endif // WNT


#ifdef UNX

	String aParam( aFormat );
	aParam += ' ';
    // --> OD 2005-04-27 #122038# - quote the source filename
    aParam += '"';
    aParam += rFileName;
    aParam += '"';
    // <--
	aParam.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " -N -t=" ));
    // --> OD 2005-04-27 #122038# - quote the output filename
    aParam += '"';
	aParam += sNativeFileName;
    aParam += '"';
    // <--
	aParam.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " -v" ));
	aParam += rVersion;

	ByteString sParam( aParam, ::gsl_getSystemTextEncoding() );

	nError = system( sParam.GetBuffer() );
#endif  // UNX

static const ULONG nErrors[18]={
	0, ERR_SWG_READ_ERROR, ERR_SWG_READ_ERROR, ERR_W4W_WRITE_TMP_ERROR,
	ERR_W4W_WRITE_TMP_ERROR, ERR_SWG_FILE_FORMAT_ERROR,
	ERR_W4W_WRITE_TMP_ERROR, ERR_W4W_WRITE_TMP_ERROR,
	ERR_W4W_MEM | ERROR_SW_READ_BASE,
	ERR_SWG_FILE_FORMAT_ERROR, ERR_W4W_WRITE_FULL | ERROR_SW_READ_BASE,
	0, 0, 0,
	0, ERR_SW6_PASSWD, ERR_W4W_INTERNAL_ERROR | ERROR_SW_READ_BASE,
	0 };

	if ( nError != 12 )			// 12 ist nur Warning
	{
		if ( nError == ERR_DLL )
			return ERR_W4W_DLL_ERROR | ERROR_SW_READ_BASE;
		if ( nError>0 && nError<=17 )
			return nErrors[ nError ];
	}
	return 0;
}

// W4W liest beim Speichern vom File pFileName die Eingabe aus pTmpFile.
// der Filter wird ueber nFilter bestimmt.

ULONG SaveFile( const String& rFileName, const String& rTmpFile,
				USHORT nFilter, const String& rVersion )
{
	USHORT nError = 1;

	rtl_TextEncoding eEnc = ::gsl_getSystemTextEncoding();
	ByteString sFileName( rFileName, eEnc ), sVersion( rVersion, eEnc ),
			   sTmpFile( rTmpFile, eEnc );

	String aFormat;

#if defined( WNT )
	aFormat += 'w';
	if( nFilter < 10 )
		aFormat += '0';
	if( nFilter < 100 )
		aFormat += '0';
	aFormat += String::CreateFromInt32( nFilter );
	aFormat += 't';
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "32W" ));
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ".DLL" ));
#endif	// defined( WNT )


#ifdef UNX
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "w4w" ));
	if( nFilter < 10 )
		aFormat += '0';
	aFormat += String::CreateFromInt32( nFilter );
	aFormat += 't';
#endif	// UNX

	SvtPathOptions aOpt;
	if( !aOpt.SearchFile( aFormat, SvtPathOptions::PATH_FILTER ))
		return ERR_W4W_DLL_ERROR | ERROR_SW_WRITE_BASE;

	ByteString sFormat( aFormat, ::gsl_getSystemTextEncoding() );
#if defined( WNT )

	HANDLE hDLL = LoadLibrary( (LPSTR)sFormat.GetBuffer() );
	if( hDLL >= (HANDLE)HINSTANCE_ERROR )
	{
		FNw4wt fnSave = (FNw4wt)GetProcAddress( (HINSTANCE)hDLL, (LPSTR)"w4wt" );
		if( fnSave )
			nError = (*fnSave)( (LPSTR)sTmpFile.GetBuffer(),
								(LPSTR)sFileName.GetBuffer(),
								(LPSTR)sVersion.GetBuffer(),
								(LPSTR)aEmptyByteStr.GetBuffer(),
								(FNDisplay)&W4WWriteDisplayHandler );
		FreeLibrary( (HINSTANCE)hDLL );
	}
	else
		nError = ERR_DLL;

#endif WNT


#ifdef UNX

	String aParam( aFormat );
	aParam += ' ';
	aParam += rFileName;
	aParam.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " -N -t=" ));
	aParam += rTmpFile;
	aParam.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " -v" ));
	aParam += rVersion;

	ByteString sParam( aParam, ::gsl_getSystemTextEncoding() );
	nError = system( sParam.GetBuffer() );

#endif  // UNX

static const ULONG nErrors[18]={ 0,ERR_SWG_WRITE_ERROR,
	ERR_W4W_READ_TMP_ERROR, ERR_W4W_READ_TMP_ERROR, ERR_SWG_WRITE_ERROR,
	0, ERR_W4W_WRITE_TMP_ERROR, ERR_W4W_WRITE_TMP_ERROR,
	ERR_W4W_MEM | ERROR_SW_WRITE_BASE, 0,
	ERR_W4W_WRITE_FULL | ERROR_SW_WRITE_BASE,
	0, 0, 0,
	0, ERR_SW6_PASSWD, ERR_W4W_INTERNAL_ERROR | ERROR_SW_WRITE_BASE,
	0 };

	if ( nError != 12 )			// 12 ist nur Warning
	{
		if ( nError == ERR_DLL )
			return ERR_W4W_DLL_ERROR | ERROR_SW_WRITE_BASE;
		if ( nError>0 && nError<=17 )
			return nErrors[ nError ];
	}
	return 0;
}

FASTBOOL W4WDLLExist( W4WDLL_TYPE eType, USHORT nFilter )
{
	String aFormat;
	switch( eType )
	{
	case W4WDLL_EXPORT:
	case W4WDLL_IMPORT:
#if defined( UNX )
		aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "w4w" ));
		if( nFilter < 10 )
			aFormat += '0';
		aFormat += String::CreateFromInt32( nFilter );
		aFormat += W4WDLL_IMPORT ? 'f' : 't';
#endif // UNX

#if defined( WNT )
		aFormat += 'w';
		if( nFilter < 10 )
			aFormat += '0';
		if( nFilter < 100 )
			aFormat += '0';
		aFormat += String::CreateFromInt32( nFilter );
		aFormat += W4WDLL_IMPORT ? 'f' : 't';
		aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "32W" ));
#endif	// WNT
		break;

	case W4WDLL_AUTODETEC:
		aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "autorec" ));
		break;
	}

#ifndef UNX
	aFormat.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ".dll" ));
#endif  // UNX

	// Fehlerbehandlung oder fuer Systeme die keine W4W-Filter kennen
	SvtPathOptions aOpt;

	return aOpt.SearchFile( aFormat, SvtPathOptions::PATH_FILTER );
}

