/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ftpdownloadthread.cxx,v $
 *
 *  $Revision: 1.7.8.1 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/31 12:55:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_ucb.hxx"
/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#include "ftphandleprovider.hxx"
#include "ftpdownloadthread.hxx"
#include "ftpcontainer.hxx"
#include <rtl/ustring.hxx>
#include <rtl/ustrbuf.hxx>


using namespace ftp;



FTPDownloadThread::FTPDownloadThread(
    const rtl::OUString& url,
    FTPHandleProvider* pFCP
)
    throw(
        curl_exception,
        malformed_exception
    )
    : DownloadThread(0),
	  m_pFCP(pFCP),
      m_aUsername(rtl::OUString::createFromAscii("anonymous")),
      m_bShowPassword(false),
	  m_aPort(rtl::OUString::createFromAscii("21")),
      m_e(CURLE_OK)
{
	parse(url);  // can reset m_bShowPassword

    if(!m_aPathSegmentVec.size())
        m_e = curl_exception(CURLE_FTP_COULDNT_RETR_FILE);
}



curl_exception FTPDownloadThread::GetException()
{
    return m_e;
}

#define SET_CONTROL_CONTAINER \
	MemoryContainer control;                                      \
	curl_easy_setopt(curl,                                        \
					 CURLOPT_HEADERFUNCTION,                      \
					 memory_write);                               \
	curl_easy_setopt(curl,                                        \
					 CURLOPT_WRITEHEADER,                         \
					 &control)


#define SET_URL(url)                                              \
    rtl::OString urlParAscii(url.getStr(),                        \
                             url.getLength(),                     \
                             RTL_TEXTENCODING_UTF8);              \
    curl_easy_setopt(curl,                                        \
                     CURLOPT_URL,                                 \
                     urlParAscii.getStr());

void FTPDownloadThread::work()
{
    CURL *curl = m_pFCP->handle();
    SET_CONTROL_CONTAINER;
    rtl::OUString url(ident(false,true));
    SET_URL(url);

    curl_easy_setopt(curl,CURLOPT_WRITEFUNCTION,ucb::writeToDataSink);
	curl_easy_setopt(curl,CURLOPT_WRITEDATA,GetSink());

    curl_easy_setopt(curl,CURLOPT_POSTQUOTE,0);
	CURLcode err = curl_easy_perform(curl);

    if(err != CURLE_OK) {
        m_e = curl_exception(err);
        OnAbort();
    }
}


void FTPDownloadThread::parse(const rtl::OUString& url)
	throw(
		malformed_exception
	)
{
    rtl::OUString aPassword,aAccount;
	rtl::OString aIdent(url.getStr(),
                        url.getLength(),
                        RTL_TEXTENCODING_UTF8);
	char *buffer = new char[1+aIdent.getLength()];

	const char* p2 = aIdent.getStr();

	rtl::OString lower = aIdent.toAsciiLowerCase();
	if(lower.getLength() < 6 ||
	   strncmp("ftp://",lower.getStr(),6))
		throw malformed_exception();

	p2 += 6;

	char ch;
	char *p1 = buffer; 	// determine "username:password@host:port"
	while((ch = *p2++) != '/' && ch)
		*p1++ = ch;
	*p1 = 0;

	rtl::OUString aExpr(rtl::OUString(buffer,strlen(buffer),
									  RTL_TEXTENCODING_UTF8));

	sal_Int32 l = aExpr.indexOf(sal_Unicode('@'));
	m_aHost = aExpr.copy(1+l);

	if(l != -1) {
		// Now username and password.
		aExpr = aExpr.copy(0,l);
		l = aExpr.indexOf(sal_Unicode(':'));
		if(l != -1) {
			aPassword = aExpr.copy(1+l);
			if(aPassword.getLength())
				m_bShowPassword = true;
        }
		if(l > 0)
			// Overwritte only if the username is not empty.
			m_aUsername = aExpr.copy(0,l);
		else if(aExpr.getLength())
			m_aUsername = aExpr;
	}

    l = m_aHost.lastIndexOf(sal_Unicode(':'));
    sal_Int32 ipv6Back = m_aHost.lastIndexOf(sal_Unicode(']'));
    if((ipv6Back == -1 && l != -1) // not ipv6, but a port
       ||
       (ipv6Back != -1 && 1+ipv6Back == l) // ipv6, and a port
    )
    {
		if(1+l<m_aHost.getLength())
			m_aPort = m_aHost.copy(1+l);
		m_aHost = m_aHost.copy(0,l);
	}

	while(ch) {  // now determine the pathsegments ...
		p1 = buffer;
		while((ch = *p2++) != '/' && ch)
			*p1++ = ch;
		*p1 = 0;

		if(buffer[0]) {
			if(strcmp(buffer,"..") == 0 &&
			   m_aPathSegmentVec.size() &&
               ! m_aPathSegmentVec.back().equalsAscii(".."))
				m_aPathSegmentVec.pop_back();
			else if(strcmp(buffer,".") == 0)
				; // Ignore
			else
				// This is a legal name.
				m_aPathSegmentVec.push_back(
					rtl::OUString(buffer,
								  strlen(buffer),
								  RTL_TEXTENCODING_UTF8));
		}
	}

	delete[] buffer;

	if(m_bShowPassword)
		m_pFCP->setHost(m_aHost,
						m_aPort,
						m_aUsername,
						aPassword,
						aAccount);

	// now check for something like ";type=i" at end of url
	if(m_aPathSegmentVec.size() &&
	   (l = m_aPathSegmentVec.back().indexOf(sal_Unicode(';'))) != -1) {
		m_aType = m_aPathSegmentVec.back().copy(l);
		m_aPathSegmentVec.back() = m_aPathSegmentVec.back().copy(0,l);
	}
}


rtl::OUString FTPDownloadThread::ident(bool withslash,bool internal) const
{
	// rebuild the url as one without ellipses,
	// and more important, as one without username and
	// password. ( These are set together with the command. )

	rtl::OUStringBuffer bff;
	bff.appendAscii("ftp://");

	if(!m_aUsername.equalsAscii("anonymous")) {
		bff.append(m_aUsername);

		rtl::OUString aPassword,aAccount;
		m_pFCP->forHost(m_aHost,
						m_aPort,
						m_aUsername,
						aPassword,
						aAccount);

		if((m_bShowPassword || internal) &&
		   aPassword.getLength() )
			bff.append(sal_Unicode(':'))
				.append(aPassword);

		bff.append(sal_Unicode('@'));
	}
	bff.append(m_aHost);

    if(!m_aPort.equalsAscii("21"))
        bff.append(sal_Unicode(':'))
            .append(m_aPort)
            .append(sal_Unicode('/'));
    else
        bff.append(sal_Unicode('/'));

	for(unsigned i = 0; i < m_aPathSegmentVec.size(); ++i)
        if(i == 0)
            bff.append(m_aPathSegmentVec[i]);
        else
            bff.append(sal_Unicode('/')).append(m_aPathSegmentVec[i]);
    if(withslash)
        if(bff.getLength() && bff[bff.getLength()-1] != sal_Unicode('/'))
            bff.append(sal_Unicode('/'));

    bff.append(m_aType);
	return bff.makeStringAndClear();
}

