/*
 * Helper.java
 *
 * Created on 22. August 2002, 14:11
 */
package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.DefaultLogger;
import com.sun.star.wizards.tutorial.executer.util.XLogger;

/**
 * This class connects to StarOffice and handles the connections, besides this various
 * utility methods providing the additional status checks and the additional handling of
 * StarOffice management routines.
 *
 * @author $author$
 * @version $Revision: 1.4 $
 */
public class Helper {
    private XMultiServiceFactory m_xMSF = null;
    private String m_connectString = null;
    private static XLogger m_xlogger = (XLogger) DefaultLogger.createLoggerInstance(null);
    private static boolean m_logState = false;

    /**
     * Creates a new Helper object.
     *
     * @param connectString String. Example:
     *        "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager"
     */
    public Helper(String connectString) {
        try {
            m_connectString = connectString;

            if ((m_connectString != null) || !m_connectString.equals("")) {
                // Create a new xMSF
                m_xMSF = connect(m_connectString);
            }
        } catch (com.sun.star.connection.NoConnectException ex) {
        } catch (com.sun.star.uno.RuntimeException ex) {
        } catch (com.sun.star.uno.Exception ex) {
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Creates a new Helper object.
     *
     * @param xMSF
     */
    public Helper(XMultiServiceFactory xMSF) {
        if (xMSF != null) {
            m_xMSF = xMSF;
        }
    }

    /**
     * Connect status
     *
     * @return True if connected
     */
    public boolean isConnected() {
        if (m_xMSF != null) {
            return true;
        } else {

            return false;
        }
    }

    /**
     * Get XMultiServiceFactory
     *
     * @return MultiServiceFactory
     */
    public XMultiServiceFactory getxMSF() {
        return m_xMSF;
    }

    /**
     * Get the connection string
     *
     * @return the connection string
     */
    public String getConnectString() {
        return m_connectString;
    }

    /**
     * Get desktop of the active staroffice instance
     *
     * @return Desktop
     *
     * @throws com.sun.star.uno.Exception
     */
    public XDesktop getXDesktop() throws com.sun.star.uno.Exception {
        XDesktop desk = (XDesktop) UnoRuntime.queryInterface(XDesktop.class, m_xMSF.createInstance("com.sun.star.frame.Desktop"));

        return desk;
    }

    /**
     * Get toolkit
     *
     * @return Toolkit
     *
     * @throws com.sun.star.uno.Exception
     */
    public XToolkit getXToolkit() throws com.sun.star.uno.Exception {
        XToolkit tool = (XToolkit) UnoRuntime.queryInterface(XToolkit.class, m_xMSF.createInstance("com.sun.star.awt.Toolkit"));

        return tool;
    }

    /**
     * Get extendedToolkit
     *
     * @return XExtendedToolkit
     *
     * @throws com.sun.star.uno.Exception
     */
    public XExtendedToolkit getXExtendedToolkit() throws com.sun.star.uno.Exception {
        XToolkit tool = getXToolkit();
        XExtendedToolkit exTool = (XExtendedToolkit) UnoRuntime.queryInterface(XExtendedToolkit.class, tool);

        return exTool;
    }

    /**
     * Get top windows
     *
     * @return TopWindows
     *
     * @throws com.sun.star.uno.Exception
     */
    public XWindow[] getTopWindows() throws com.sun.star.uno.Exception {
        XExtendedToolkit exTool = getXExtendedToolkit();
        int count = exTool.getTopWindowCount();
        XWindow[] xWindow = new XWindow[count];

        for (int i = 0; i < count; i++) {
            xWindow[i] = (XWindow) UnoRuntime.queryInterface(XWindow.class, exTool.getTopWindow(i));
        }

        return xWindow;
    }

    /**
     * Get top windows
     *
     * @param exTool DOCUMENT ME!
     *
     * @return TopWindows
     *
     * @throws com.sun.star.uno.Exception
     */
    public static XWindow[] getTopWindows(XExtendedToolkit exTool) throws com.sun.star.uno.Exception {
        int count = exTool.getTopWindowCount();
        XWindow[] xWindow = new XWindow[count];

        for (int i = 0; i < count; i++) {
            xWindow[i] = (XWindow) UnoRuntime.queryInterface(XWindow.class, exTool.getTopWindow(i));
        }

        return xWindow;
    }

    /**
     * Get top window
     *
     * @param index index
     *
     * @return TopWindow
     *
     * @throws com.sun.star.uno.Exception
     */
    public XTopWindow getTopWindow(int index) throws com.sun.star.uno.Exception {
        XExtendedToolkit exTool = getXExtendedToolkit();
        XTopWindow xTopWindow = exTool.getTopWindow(index);

        return xTopWindow;
    }

    /**
     * Get active window
     *
     * @return Window
     *
     * @throws com.sun.star.uno.Exception
     */
    public XWindow getActiveTopWindow() throws com.sun.star.uno.Exception {
        XExtendedToolkit exTool = getXExtendedToolkit();
        XWindow xWindow = (XWindow) UnoRuntime.queryInterface(XWindow.class, exTool.getActiveTopWindow());

        return xWindow;
    }

    /**
     * Get component of the active staroffice instance
     *
     * @return Enumeration
     *
     * @throws com.sun.star.uno.Exception
     */
    public XComponent getXComponent() throws com.sun.star.uno.Exception {
        XDesktop xDesktop = getXDesktop();
        XComponent xcomp = xDesktop.getCurrentComponent();

        return xcomp;
    }

    /**
     * Get components of the active staroffice instance
     *
     * @return Enumeration
     *
     * @throws com.sun.star.uno.Exception
     */
    public XEnumerationAccess getXComponents() throws com.sun.star.uno.Exception {
        XDesktop xDesktop = getXDesktop();
        XEnumerationAccess xcomps = xDesktop.getComponents();

        return xcomps;
    }

    /**
     * Get model of the active staroffice instance
     *
     * @return Model
     *
     * @throws com.sun.star.uno.Exception
     */
    public XModel getXModel() throws com.sun.star.uno.Exception {
        XComponent xComponent = getXComponent();
        XModel xModel = xModel = (XModel) UnoRuntime.queryInterface(XModel.class, xComponent);

        return xModel;
    }

    /**
     * Get current document title.
     *
     * @return document title
     */
    public String getCurrentDocumentTitle() {
        String title = "";

        try {
            XPropertySet xps = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, getXFrame());

            if (xps != null) {
                title = (String) xps.getPropertyValue("Title");
            }
        } catch (com.sun.star.uno.Exception ex) {
        }

        return title;
    }

    /**
     * Get current document type. Possible types e.g. - TextDocument, DrawingDocument.
     *
     * @return document type
     *
     * @throws com.sun.star.uno.Exception
     */
    public String getCurrentDocumentTyp() throws com.sun.star.uno.Exception {
        XComponent xComponent = getXComponent();
        String[] docTypes = AccessibilityTools.getSupportedServiceNames(xComponent);
        String docType = null;

        if (docTypes != null) {
            for (int i = 0; i < docTypes.length; i++) {
                if (docTypes[i].equals("com.sun.star.text.TextDocument")) {
                    docType = "com.sun.star.text.TextDocument";
                } else if (docTypes[i].equals("com.sun.star.sheet.SpreadsheetDocument")) {
                    docType = "com.sun.star.sheet.SpreadsheetDocument";
                } else if (docTypes[i].equals("com.sun.star.drawing.DrawingDocument")) {
                    docType = "com.sun.star.drawing.DrawingDocument";
                } else if (docTypes[i].equals("com.sun.star.presentation.PresentationDocument")) {
                    docType = "com.sun.star.presentation.PresentationDocument";
                }
            }
        }

        return docType;
    }

    /**
     * Get frame of the active staroffice instance
     *
     * @return Frame
     *
     * @throws com.sun.star.uno.Exception
     */
    public XFrame getXFrame() throws com.sun.star.uno.Exception {
        XModel xModel = getXModel();
        XController xController = xModel.getCurrentController();
        XFrame xFrame = xController.getFrame();

        return xFrame;
    }

    /**
     * Get window of the active staroffice instance
     *
     * @return Active window
     *
     * @throws com.sun.star.uno.Exception
     */
    public XWindow getXWindow() throws com.sun.star.uno.Exception {
        XFrame xFrame = getXFrame();
        XWindow xWindow = xFrame.getComponentWindow();

        return xWindow;
    }

    /**
     * Connect to staroffice
     *
     * @param connectStr string
     *
     * @return Connect object
     *
     * @throws com.sun.star.uno.Exception DOCUMENT ME!
     * @throws com.sun.star.uno.RuntimeException DOCUMENT ME!
     * @throws com.sun.star.connection.NoConnectException DOCUMENT ME!
     * @throws java.lang.Exception DOCUMENT ME!
     */
    public XMultiServiceFactory connect(String connectStr) throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException, com.sun.star.connection.NoConnectException, java.lang.Exception {
        // Get component context
        XComponentContext xcomponentcontext = com.sun.star.comp.helper.Bootstrap.createInitialComponentContext(null);

        // create a connector, so that it can contact the office
        XUnoUrlResolver urlResolver = UnoUrlResolver.create(xcomponentcontext);
        Object rInitialObject = urlResolver.resolve(connectStr);
        XMultiServiceFactory xMSF = null;

        if (rInitialObject != null) {
            xMSF = (XMultiServiceFactory) UnoRuntime.queryInterface(XMultiServiceFactory.class, rInitialObject);
        }

        return (xMSF);
    }

    /**
     * DOCUMENT ME!
     *
     * @param state DOCUMENT ME!
     */
    public static void setLogState(boolean state) {
        m_logState = state;

        if (state) {
            m_xlogger = (XLogger) DefaultLogger.createLoggerInstance("BasicLogger");
        } else {
            m_xlogger = (XLogger) DefaultLogger.createLoggerInstance(null);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static boolean getLogState() {
        return m_logState;
    }

    /**
     * DOCUMENT ME!
     *
     * @param msg DOCUMENT ME!
     */
    public static void log(String msg) {
        m_xlogger.log(msg);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static String getLog() {
        return m_xlogger.getLog();
    }
}
