/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: warnings.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:08:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLSECURITY_WARNINGS_HXX
#define _XMLSECURITY_WARNINGS_HXX

#include <vcl/dialog.hxx>
#include <svtools/stdctrl.hxx>
#include <vcl/button.hxx>
#include <svx/simptabl.hxx>

namespace com {
namespace sun {
namespace star {
namespace security {
    class XCertificate; }
namespace xml { namespace crypto {
    class XSecurityEnvironment; }}
}}}

#include <com/sun/star/uno/Sequence.hxx>

#ifndef _SIGSTRUCT_HXX
#include <xmlsecurity/sigstruct.hxx>
#endif 

namespace css = com::sun::star;
namespace cssu = com::sun::star::uno;
namespace dcss = ::com::sun::star;

class HeaderBar;

class MacroWarning : public ModalDialog
{
private:
	// XSecurityEnvironment is needed for building the certification path
	cssu::Reference< dcss::xml::crypto::XSecurityEnvironment > mxSecurityEnvironment;

//	cssu::Sequence< cssu::Reference< dcss::security::XCertificate > > maCerts;
	cssu::Reference< dcss::security::XCertificate > mxCert;

//	FixedImage			maQuestionMarkFI;
	FixedInfo			maDocNameFI;
	FixedInfo			maDescr1aFI;
	FixedInfo			maDescr1bFI;
	FixedInfo			maSignsFI;
	PushButton			maViewSignsBtn;
	FixedInfo			maDescr2FI;
	CheckBox			maAlwaysTrustCB;
	FixedLine			maBottomSepFL;
	PushButton			maEnableBtn;
	CancelButton		maDisableBtn;
	HelpButton			maHelpBtn;

	const bool			mbSignedMode;			// modus of dialog (signed / unsigned macros)

	DECL_LINK(			ViewSignsBtnHdl, void* );
	DECL_LINK(			EnableBtnHdl, void* );
//	DECL_LINK(			DisableBtnHdl, void* );

public:
	MacroWarning( Window* pParent, cssu::Reference< dcss::xml::crypto::XSecurityEnvironment >& _rxSecurityEnvironment, cssu::Reference< dcss::security::XCertificate >& _rxCert );
	MacroWarning( Window* pParent );
	~MacroWarning();
};

#endif

