/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ifcc_df.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:36:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <store/ifcc_df.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/cpp/c_define.hxx>
#include <ary/cpp/c_define.hxx>
#include <ary/cpp/c_macro.hxx>
#include <nametree.hxx>
#include "sto_cpp.hxx"
#include "ti_storg.hxx"


namespace ary
{
namespace store
{
namespace cpp
{

//********************		CheshireCat		**************//

struct Defs_Ifc::CheshireCat
{
	typedef std::map< udmstri, CodeEntity * > CeIndex;

	ary::store::Cpp *	pStorageCpp;
    ary::NameTree       aNameIndex_Defines;
    ary::NameTree       aNameIndex_Macros;

						CheshireCat(
							ary::store::Cpp &	io_rStorageCpp );
						~CheshireCat();

    const ReStorage< ary::cpp::Define > &
                        TheDefines() const;
    const ReStorage< ary::cpp::Macro > &
                        TheMacros() const;
    ReStorage< ary::cpp::Define > &
                        TheDefines();
    ReStorage< ary::cpp::Macro > &
                        TheMacros();
};

inline const ReStorage< ary::cpp::Define > &
Defs_Ifc::
CheshireCat::TheDefines() const
    { return pStorageCpp->Defines(); }

inline const ReStorage< ary::cpp::Macro > &
Defs_Ifc::
CheshireCat::TheMacros() const
    { return pStorageCpp->Macros(); }
inline ReStorage< ary::cpp::Define > &
Defs_Ifc::
CheshireCat::TheDefines()
    { return pStorageCpp->Defines(); }

inline ReStorage< ary::cpp::Macro > &
Defs_Ifc::
CheshireCat::TheMacros()
    { return pStorageCpp->Macros(); }


Defs_Ifc::
CheshireCat::CheshireCat(ary::store::Cpp &	io_rStorageCpp)
	:	pStorageCpp(&io_rStorageCpp)
{
}

Defs_Ifc::
CheshireCat::~CheshireCat()
{
}



//********************		Defs_Ifc		**************//

Defs_Ifc::Defs_Ifc( ary::store::Cpp & io_rStorageCpp )
	:	pi( new CheshireCat(io_rStorageCpp) )
{
}

Defs_Ifc::~Defs_Ifc()
{
}

void
Defs_Ifc::Add_Define( DYN ary::cpp::Define & let_drDefine )
{
	pi->TheDefines().Add( let_drDefine.Id(), let_drDefine );
    pi->aNameIndex_Defines.insert( let_drDefine.DefinedName(), let_drDefine.Id() );
}

void
Defs_Ifc::Add_Macro( DYN ary::cpp::Macro & let_drMacro )
{
	pi->TheMacros().Add( let_drMacro.Id(), let_drMacro );
    pi->aNameIndex_Macros.insert( let_drMacro.DefinedName(), let_drMacro.Id() );
}

const ary::cpp::Define *
Defs_Ifc::Find_Define( ary::cpp::Did i_nId ) const
{
    return pi->TheDefines().Find( i_nId );
}

const ary::cpp::Macro *
Defs_Ifc::Find_Macro( ary::cpp::Did i_nId ) const
{
    return pi->TheMacros().Find( i_nId );
}

const InstanceList &
Defs_Ifc::Search_DefineName( const udmstri & i_sName ) const
{
 	return pi->aNameIndex_Defines[i_sName];
}

const InstanceList &
Defs_Ifc::Search_MacroName( const udmstri & i_sName ) const
{
 	return pi->aNameIndex_Macros[i_sName];
}

uintt
Defs_Ifc::Get_AllDefines( List_Rid & o_rResult ) const
{
    uintt ret = o_rResult.size();

    NameTree::const_iterator itEnd = pi->aNameIndex_Defines.end();
    for ( NameTree::const_iterator  it = pi->aNameIndex_Defines.begin();
          it != itEnd;
          ++it )
    {
        std::copy( (*it).second.begin(),
                   (*it).second.end(),
                   std::insert_iterator< List_Rid >(o_rResult, o_rResult.end()) );
    }

    return o_rResult.size() - ret;
}

uintt
Defs_Ifc::Get_AllMacros( List_Rid & o_rResult ) const
{
    uintt ret = o_rResult.size();

    NameTree::const_iterator itEnd = pi->aNameIndex_Macros.end();
    for ( NameTree::const_iterator  it = pi->aNameIndex_Macros.begin();
          it != itEnd;
          ++it )
    {
        std::copy( (*it).second.begin(),
                   (*it).second.end(),
                   std::insert_iterator< List_Rid >(o_rResult, o_rResult.end()) );
    }

    return o_rResult.size() - ret;
}

ary::NameTree::const_iterator
Defs_Ifc::LowerBound_Define( const char * i_sSearch ) const
{
    return pi->aNameIndex_Defines.lower_bound( udmstri(i_sSearch) );
}

ary::NameTree::const_iterator
Defs_Ifc::LowerBound_Macro( const char * i_sSearch ) const
{
    return pi->aNameIndex_Macros.lower_bound( udmstri(i_sSearch) );
}


} // namespace cpp
} // namespace store
} // namespace ary


