/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: storage.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:37:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <store/storage.hxx>


// NOT FULLY DEFINED SERVICES
#include "sto_grps.hxx"
#include "sto_locs.hxx"
#include "sto_cpp.hxx"


namespace ary
{
namespace store
{



//*************************     Storage::CheshireCat     *********************//

struct Storage::CheshireCat
{
    IndependentGroups   aIndependentGroups;
    Locations           aLocations;
    Cpp                 aCpp;
};





//*******************************     Storage     *****************************//

Storage::Storage()
    :   pi( new CheshireCat )
{
}

Storage::~Storage()
{
}

void
Storage::Open()
{
    // KORR_FUTURE
    // A different implementation opens the persistent storage here.
}

void
Storage::Close()
{
    // KORR_FUTURE
    // A different implementation saves changes to the persistent storage here.
}

IndependentGroups &
Storage::TheIndependentGroups()
{
    return pi->aIndependentGroups;
}

Locations &
Storage::TheLocations()
{
    return pi->aLocations;
}

Cpp &
Storage::TheCpp()
{
    return pi->aCpp;
}



}   // namespace store
}   // namespace ary

