/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TransformationHelper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:34:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "TransformationHelper.hxx"
#include "CommonConverters.hxx"


//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;
using namespace ::com::sun::star::chart2;

drawing::Direction3D TransformationHelper::transformSize( const drawing::Direction3D& rSize, const drawing::Position3D& rPos
                 , uno::Reference< XTransformation > xTransformation )
{
    drawing::Position3D aLogicPos1( rPos - rSize/2 );
    drawing::Position3D aLogicPos2( rPos + rSize/2 );

    drawing::Position3D aTransformedPos1( SequenceToPosition3D( xTransformation->transform( Position3DToSequence(aLogicPos1) ) ) );
    drawing::Position3D aTransformedPos2( SequenceToPosition3D( xTransformation->transform( Position3DToSequence(aLogicPos2) ) ) );

    drawing::Direction3D aSize = aTransformedPos2 - aTransformedPos1;
    return aSize;
}

DataPointGeometry TransformationHelper::transformLogicGeom(
    const DataPointGeometry& rGeom
    , uno::Reference< XTransformation > xTransformation )
{
    //@transform logic coordinates to target coordinates
    return DataPointGeometry(
          SequenceToPosition3D( xTransformation->transform( Position3DToSequence(rGeom.m_aPosition) ) )
        , transformSize(rGeom.m_aSize,rGeom.m_aPosition,xTransformation)
        , transformSize(rGeom.m_aSize2,rGeom.m_aPosition,xTransformation)
        );
}
//.............................................................................
} //namespace chart
//.............................................................................
