/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AppSwapWindow.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/31 18:41:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_APPSWAPWINDOW_HXX
#define DBAUI_APPSWAPWINDOW_HXX

#ifndef DBACCESS_TABLEDESIGN_ICLIPBOARDTEST_HXX
#include "IClipBoardTest.hxx"
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef DBAUI_APPICONCONTROL_HXX
#include "AppIconControl.hxx"
#endif
#ifndef DBAUI_APPELEMENTTYPE_HXX
#include "AppElementType.hxx"
#endif

namespace dbaui
{
	class OAppBorderWindow;
	//==================================================================
	class OApplicationSwapWindow :  public Window, 
									public IClipboardTest
	{
		OApplicationIconControl				m_aIconControl;
		ElementType							m_eLastType;
		OAppBorderWindow*					m_pBorderWin;

		void ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );

		DECL_LINK( OnContainerSelectHdl,	SvtIconChoiceCtrl* );
		DECL_LINK( ChangeToLastSelected, void* );
	protected:
		virtual void DataChanged(const DataChangedEvent& rDCEvt);
	public:
		OApplicationSwapWindow(Window* _pParent,OAppBorderWindow* _pBorderWindow);
		virtual ~OApplicationSwapWindow();
		// window overloads
		virtual void Resize();


		inline sal_Bool isCutAllowed()		{ return sal_False; }
		inline sal_Bool isCopyAllowed()		{ return sal_False; }
		inline sal_Bool isPasteAllowed()	{ return sal_False; }
		virtual sal_Bool hasChildPathFocus() { return HasChildPathFocus(); }
		inline void copy()	{ }
		inline void cut()	{ }
		inline void paste()	{ }

		inline ULONG					GetEntryCount() const { return m_aIconControl.GetEntryCount(); }
		inline SvxIconChoiceCtrlEntry*	GetEntry( ULONG nPos ) const { return m_aIconControl.GetEntry(nPos); }
		inline Rectangle				GetBoundingBox( SvxIconChoiceCtrlEntry* pEntry ) const { return m_aIconControl.GetBoundingBox(pEntry); }

        /** automatically creates mnemonics for the icon/texts in our left hand side panel
        */
        void    createIconAutoMnemonics();

        /** called to give the window the chance to intercept key events, while it has not
            the focus

            @return <TRUE/> if and only if the event has been handled, and should not
                not be further processed
        */
        bool    interceptKeyInput( const KeyEvent& _rEvent );

		/// return the element of currently select entry
		ElementType getElementType() const;


		/** clears the selection in the icon choice control and calls the handler
		*/
		void clearSelection();

		/** changes the container which should be displayed. The select handler will also be called.
			@param	_eType
				Which container to show.
		*/
		void changeContainer(ElementType _eType);
	};
// .............................................................
} // namespace dbaui
// .............................................................
#endif // DBAUI_APPSWAPWINDOW_HXX

