/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: filterfactory.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:30:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_SERVICES_FILTERFACTORY_HXX_
#define __FRAMEWORK_SERVICES_FILTERFACTORY_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XSERVICEINFO_HXX_
#include <macros/xserviceinfo.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONBASE_HXX_
#include <threadhelp/transactionbase.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_ELEMENTEXISTEXCEPTION_HPP_
#include <com/sun/star/container/ElementExistException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_
#include <com/sun/star/util/XFlushable.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINERQUERY_HPP_
#include <com/sun/star/container/XContainerQuery.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/// @HTML
/** @short      factory to create external filter components and initialize it in the right way.

    @descr      This class can be used to create new filter components for specified contents.
                It uses cached values of the configuration to lay down, which filter match
                a given name. Further this class provides full access to the configuration data
                of such services and following implementations will support some special
                query modes.

    @author     as96863

    @docdate    10.03.2003 by as96863

    @todo       <ul>
                    <li>implementation of query mode</li>
                    <li>simple restore mechanism of last consistent cache state,
                        if flush failed</li>
                </ul>
 */
/// @NOHTML

class FilterFactory	:	// interfaces
						public	css::lang::XTypeProvider			,
						public	css::lang::XServiceInfo				,
						public	css::lang::XMultiServiceFactory		,
						public	css::container::XNameContainer		,		// => XNameReplace => XNameAccess => XElementAccess
                        public  css::container::XContainerQuery     ,
						public	css::util::XFlushable				,
						// base classes
						// Order is neccessary for right initialization of it!
                        private ThreadHelpBase                      ,
                        private TransactionBase                     ,
						public	::cppu::OWeakObject
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------

	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		standard constructor
			@descr		Initialize a new instance and fill our cache with values.

			@seealso	class FilterCache
			@seealso	member m_aCache

			@param		"xFactory", factory which has created us.
			@return		-

			@onerror	An ASSERTION is thrown in debug version, if xFactory is invalid or cache can't filled.
		*//*-*****************************************************************************************************/

	 	FilterFactory( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory );

		/*-****************************************************************************************************//**
			@short		standard destructor to delete instance
			@descr		-

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual ~FilterFactory();

		//---------------------------------------------------------------------------------------------------------
		//	XInterface, XTypeProvider, XServiceInfo
		//---------------------------------------------------------------------------------------------------------

		DECLARE_XINTERFACE
		DECLARE_XTYPEPROVIDER
		DECLARE_XSERVICEINFO

		//---------------------------------------------------------------------------------------------------------
		//	XMultiServiceFactory
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		create a new filter (without arguments!)
			@descr		We search for an agreement between given type name and our cache-content.
						If we found some information, we create the registered filter for these type.
						Otherwise - we return NULL.
						We search from begin to end of internal list!

			@seealso	method createInstanceWithArguments()

			@param		"sTypeName", type name of a document to filter, open or save.
			@return		A reference to a new created filter.

			@onerror	A null reference is returned.
		*//*-*****************************************************************************************************/

		virtual css::uno::Reference< css::uno::XInterface > SAL_CALL createInstance( const ::rtl::OUString& sTypeName ) throw(	css::uno::Exception		,
																												  				css::uno::RuntimeException);

		/*-****************************************************************************************************//**
			@short		create a new filter
			@descr		We search for an agreement between given type name and our cache-content.
						If we found some information, we create the registered filter for these type.
						Otherwise - we return NULL.
						You can give us some optional arguments to influence our search!

			@seealso	method createInstance()

			@param		"sTypeName", type name of a document to filter, open or save.
			@param		"lArguments", list of optional arguments for initializing of new filter.
			@return		A reference to a new created filter.

			@onerror	A null reference is returned.
		*//*-*****************************************************************************************************/

    	virtual css::uno::Reference< css::uno::XInterface > SAL_CALL createInstanceWithArguments(	const	::rtl::OUString&						sTypeName	,
																									const	css::uno::Sequence< css::uno::Any >&	lArguments	) throw(	css::uno::Exception			,
																																											css::uno::RuntimeException	);

		/*-****************************************************************************************************//**
			@short		not implemented
			@descr		Please use XNameAcces instead of these!

			@attention	At createInstance/WithArguments() you must give me a TypeName ... and not a filter name!
						Thats the reason for NON-IMPLEMENTING of these method!

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

    	virtual css::uno::Sequence< ::rtl::OUString > SAL_CALL getAvailableServiceNames() throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XNameContainer
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		register new filter in configuration
			@descr		Use this method to register a new filter. We will write given information in our configuration
						file "org.openoffice.Office.TypeDetection.xml" and use it from follow office startup.

			@seealso	-

			@param		"sFilterName"		, internal name of new filter
			@param		"aFilterProperties"	, properties of new filter with follow structure:

							[0].Name	=	"Type"
							[0].Value	=	supported type of these filter as [string]

							[1].Name	=	"UIName"
							[1].Value	=	localized names of filter as [stringlist]!

								structure of these stringlist:
								[..].Name	=	<locale>
								[..].Value	=	<uiname>

								zB.
								[0].Name	=	"de"
								[0].Value	=	"UIName fuer Deutsch"

								[1].Name	=	"en-US"
								[1].Value	=	"UIName for english/us"

								If you wish to use current locale use special identifier:
								[0].Name	=	"current_locale"
								[0].Value	=	"UIName fuer gerade aktive Sprache"

							[2].Name	=	"DocumentService"
							[2].Value	=	servicename of target/source document implementation as [string]

							[3].Name	=	"FilterService"
							[3].Value	=	servicename of filter implementation as [string]

							[4].Name	=	"Flags"
							[4].Value	=	additional flags as [integer]

							[5].Name	=	"UserData"
							[5].Value	=	additional user specified data as [stringlist]

							[6].Name	=	"FileFormatVersion"
							[6].Value	=	version number of supported file format as [integer]

							[7].Name	=	"TemplateName"
							[7].Value	=	name of suitable template as [string]
			@return		-

			@onerror	Exceptions are thrown.
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL insertByName(	const	::rtl::OUString&	sFilterName			,
											const	css::uno::Any&		aFilterProperties	) throw(	css::lang::IllegalArgumentException		,
																										css::container::ElementExistException	,
																										css::lang::WrappedTargetException		,
																										css::uno::RuntimeException				);

		/*-****************************************************************************************************//**
			@short		not supported yet
			@descr		-

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL removeByName( const ::rtl::OUString& sFilterName ) throw(	css::container::NoSuchElementException	,
																						css::lang::WrappedTargetException		,
																						css::uno::RuntimeException				);

		//---------------------------------------------------------------------------------------------------------
		//	XNameReplace
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		not supported yet
			@descr		-

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL replaceByName(	const	::rtl::OUString&	sFilterName			,
												const	css::uno::Any&		aFilterProperties	) throw(	css::lang::IllegalArgumentException		,
																											css::container::NoSuchElementException	,
																											css::lang::WrappedTargetException		,
																											css::uno::RuntimeException				);

		//---------------------------------------------------------------------------------------------------------
		//	XNameAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		return properties of registered filter specified by his implementation name
			@descr		Use these method to get all informations about our internal filter cache.
						We return a Sequence< PropertyValue > in an Any packed as result.

						structure of return value:
							[0].Name	=	"Type"
							[0].Value	=	supported type of these filter as [string]

							[1].Name	=	"UIName"
							[1].Value	=	localized name of filter as [string]

							[2].Name	=	"DocumentService"
							[2].Value	=	servicename of target/source document implementation as [string]

							[3].Name	=	"FilterService"
							[3].Value	=	servicename of filter implementation as [string]

							[4].Name	=	"Flags"
							[4].Value	=	additional flags as [integer]

							[5].Name	=	"UserData"
							[5].Value	=	additional user specified data as [stringlist]

							[6].Name	=	"FileFormatVersion"
							[6].Value	=	version number of supported file format as [integer]

							[7].Name	=	"TemplateName"
							[7].Value	=	name of suitable template as [string]

			@seealso	method getElementNames()
			@seealso	method hasByName()

			@param		"sName", the name of searched filter (use getElementNames() to get it!)
			@return		A Sequence< PropertyValue > packed in an Any.

			@onerror	If given name not exist a NoSuchElementException is thrown.
		*//*-*****************************************************************************************************/

    	virtual css::uno::Any SAL_CALL getByName( const ::rtl::OUString& sName ) throw(	css::container::NoSuchElementException	,
																						css::lang::WrappedTargetException		,
																						css::uno::RuntimeException				);

		/*-****************************************************************************************************//**
			@short		return list of all well known filter names from configuration
			@descr		Use these method to get all names of well known filter.
						You can use it to get the properties of a filter by calling getByName()!

			@seealso	method getByName()
			@seealso	method hasByName()

			@param		-
			@return		A list of well known filter. Is static at runtime!

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual css::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		check if searched frame filter exist in configuration
			@descr		Normaly nobody need these method realy (use getElementNames() in combination with getByName()).
						We guarantee correctness of these mechanism. There is no reason to check for existing elements then ...
						but if you have an unknwon name and has no fun to search it in returned luence ...
						you can call these ...

			@seealso	method getByName()
			@seealso	method getElementNames()

			@param		"sName", implementation name of searched frame filter
			@return		sal_True if filter exist, sal_False otherwise.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& sName ) throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XElementAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		return the type of retrun value of method XNameAccess::getByName()
			@descr		In these implementation its a Sequence< PropertyValue > everytime!

			@seealso	description of interface XNameAccess

			@param		-
			@return		Type of Sequence< PropertyValue >.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual css::uno::Type SAL_CALL getElementType() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		return state if informations about frame filter available
			@descr		If these method return false - no information could'nt read from configuration ...
						I think nothing will work then. Normaly we return TRUE!

			@seealso	class FilterCache!

			@param		-
			@return		sal_True if information available, sal_False otherwise.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual sal_Bool SAL_CALL hasElements() throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XFlushable
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		support of saving changed data if user need it
			@descr		We support a name container at this implementation. User can read AND write filters.
						We don't write all changes directly to disk ... We change ou internal structures only.
						If these services released all changes are written automaticly ... but if user whish
						to do that erliear - he should use this method.

			@seealso	class FilterCache
			@seealso	method insertByName()
			@seealso	method replaceByName()

			@param		-
			@return		-

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual void SAL_CALL flush() throw ( css::uno::RuntimeException);

		/*-****************************************************************************************************//**
			@short		add listener for flush calls
			@descr		If you whish to get information about changed data, you should add your implementation
						as a listener.

			@seealso	method flush()
			@seealso	method removeFlushListener()

			@param		"xListener", reference to listener
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

    	virtual void SAL_CALL addFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener ) throw ( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		remove listener for flush calls
			@descr		If you don't need any further informations about cache changes - you must
						remove your listener.

			@seealso	method flush()
			@seealso	method addFlushListener()

			@param		"xListener", reference to listener
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

    	virtual void SAL_CALL removeFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener ) throw ( css::uno::RuntimeException );

        virtual css::uno::Reference< css::container::XEnumeration > SAL_CALL createSubSetEnumerationByQuery( const ::rtl::OUString& sQuery ) throw(css::uno::RuntimeException);
        virtual css::uno::Reference< css::container::XEnumeration > SAL_CALL createSubSetEnumerationByProperties( const css::uno::Sequence< css::beans::NamedValue >& lProperties ) throw(css::uno::RuntimeException);

	//-------------------------------------------------------------------------------------------------------------
	//	protected methods
	//-------------------------------------------------------------------------------------------------------------

	protected:

	//-------------------------------------------------------------------------------------------------------------
	//	debug methods
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		debug-method to check incoming parameter of some other mehods of this class
			@descr		The following methods are used to check parameters for other methods
						of this class. The return value is used directly for an ASSERT(...).

			@seealso	ASSERTs in implementation!

			@param		references to checking variables
			@return		sal_False ,on invalid parameter
			@return		sal_True  ,otherwise

			@onerror	-
		*//*-*****************************************************************************************************/


	#ifdef ENABLE_ASSERTIONS

	private:

	 	static sal_Bool implcp_FilterFactory				(	const	css::uno::Reference< css::lang::XMultiServiceFactory >&	xFactory			);
    	static sal_Bool implcp_createInstanceWithArguments	(	const	::rtl::OUString&										sTypeName			,
							  									const	css::uno::Sequence< css::uno::Any >&					lArguments			);
    	static sal_Bool implcp_getByName					(	const	::rtl::OUString&										sName				);
    	static sal_Bool implcp_hasByName					(	const	::rtl::OUString&										sName				);
		static sal_Bool implcp_removeByName					(	const	::rtl::OUString&										sFilterName			);

	#endif	//	#ifdef ENABLE_ASSERTIONS

	//-------------------------------------------------------------------------------------------------------------
	//	private variables
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

	private:

		css::uno::Reference< css::lang::XMultiServiceFactory >		m_xFactory				;
		FilterCache													m_aCache				;
        ::cppu::OMultiTypeInterfaceContainerHelper                  m_aListenerContainer    ;

};		//	class FilterFactory

}		//	namespace framework

#endif	//	#ifndef __FRAMEWORK_SERVICES_FILTERFACTORY_HXX_
