/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chwindow.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:31:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_SDWINDOW_HXX
#define _SCH_SDWINDOW_HXX


#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen wg. SdrObject
#include <svx/svdobj.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif

class SchViewShell;
class ChartModel;

namespace com { namespace sun { namespace star {
	namespace accessibility {
		class XAccessible;
	}
}}}

namespace accessibility 
{
	class AccessibleDocumentView;
}

/*************************************************************************
|*
|* SchWindow beinhaltet den eigentlichen Arbeitsbereich von
|* SchViewShell
|*
\************************************************************************/
class SchWindow : public Window, public DropTargetHelper
{
protected:
	Point	aWinPos;
	Point	aViewOrigin;
	Size	aViewSize;

	SchViewShell* pViewShell;

	virtual void Paint(const Rectangle& rRect);
	virtual void KeyInput(const KeyEvent& rKEvt);
	virtual void MouseMove(const MouseEvent& rMEvt);
	virtual void MouseButtonUp(const MouseEvent& rMEvt);
	virtual void MouseButtonDown(const MouseEvent& rMEvt);
	virtual void Command(const CommandEvent& rCEvt);

	// for quick help
	virtual void RequestHelp( const HelpEvent& );

    /** Create an accessibility object that makes this window accessible.
        
        @return
            The returned reference is empty if no accessible object could be
            created.
    */
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible > 
        CreateAccessible( void );

private:
    // for quick help
	SdrObject *GetHitObject( SdrObjList*, Point& );
	String GetQuickHelpText( SdrObject*, ChartModel*, BOOL bVerbose=FALSE );

    /// attention: this pointer is only valid, if the weak reference below is valid
    ::accessibility::AccessibleDocumentView * m_pAccDocumentView;
    ::com::sun::star::uno::WeakReference< ::com::sun::star::accessibility::XAccessible >
        m_xAccDocumentView;

public:
	SchWindow(Window* pParent);
	virtual ~SchWindow();

	void SetViewShell(SchViewShell* pViewSh) { pViewShell=pViewSh; };

	void ShareViewArea(const SchWindow* pOtherWin);

	void SetZoom(long nZoom);
	long SetZoomRect(const Rectangle& rZoomRect);
	long SetZoomFactor(long nZoom);

	long GetZoom() const
		{ return GetMapMode().GetScaleX().GetNumerator() * 100L /
				 GetMapMode().GetScaleX().GetDenominator(); }

	void SetWinPos(const Point& rPos) { aWinPos = rPos; }
	const Point& GetWinPos() { return aWinPos; }
	void SetViewOrigin(const Point& rPos) { aViewOrigin = rPos; }
	const Point& GetViewOrigin() { return aViewOrigin; }
	void SetViewSize(const Size& rSize) { aViewSize = rSize; }
	const Size& GetViewSize() { return aViewSize; }

	void UpdateMapOrigin();
	virtual void DataChanged( const DataChangedEvent& rDCEvt );

	// DropTargetHelper
	virtual sal_Int8 AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8 ExecuteDrop( const ExecuteDropEvent& rEvt );

    String GetQuickHelpText( UINT16 nObjId, ChartModel* pModel, BOOL bVerbose,
                             UINT16 nSeriesIndex = 0, UINT16 nDataPointIndex = 0 );

    SchViewShell * GetViewShell();

    ::accessibility::AccessibleDocumentView * GetAccessibleDocumentView() const;
};

#endif		// _SCH_SDWINDOW_HXX
