/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlggraut.cxx,v $
 *
 *  $Revision: 1.21 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:05:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#define OFFSET_PYRAMID 1000
#define OFFSET_ROUND   2000
#define OFFSET_CONE    3000
// TOOLS
#include <sfx2/sfxsids.hrc>
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXNEW_HXX //autogen
#include <sfx2/new.hxx>
#endif


#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#define ITEMID_CHARTTEXTORDER	SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_DOUBLE			0
#define ITEMID_CHARTSTYLE   CHATTR_DIAGRAM_STYLE
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif
#include "memchrt.hxx"

#include "strings.hrc"
#include "res_bmp.hrc"
#include "schresid.hxx"
#include "docshell.hxx"
#include "glob.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "dlggraut.hrc"
#include "dlggraut.hxx"
#include "chmod3d.hxx"
#include "chaxis.hxx"

// for high contrast images
#include "res_hc_bmp.hrc"

#define	CHARTTYPE_PAGE			0
#define	CHARTVARIANT_PAGE		1
#define	CHARTDETAILS_PAGE		2

DBG_NAME( SchDiagramAutoPilotDlg );

DECLARE_LIST( SchControlList, Control* );


// macro for selecting a normal or high contrast bitmap the stack variable
// bIsHighContrast must exist and reflect the correct state

#define SELECT_BITMAP(name) Bitmap( SchResId( bIsHighContrast ? name ## _HC : name ))

//------------------------------------------------------------------------------

SchDiagramAutoPilotDlg::SchDiagramAutoPilotDlg( Window* pParent,
												SchMemChart& rData,
												const SfxItemSet& rInAttrs,
												SfxItemSet& rOutAttrs,
												BOOL bPrePage )

		: ModalDialog( pParent, SchResId( DLG_CHART_WIZ ) ),

          pButtonList( NULL ),
          pDocSh( NULL ),
		  pOutSet( &rOutAttrs ),
          pDoc( NULL ),
		  bStored( FALSE ),
          eLegendPos( CHLEGEND_RIGHT ),
          pOriginalData( NULL ),
          pReducedData( NULL ),
		  nCurPageNr( 0 ),
		  bHasPrePage( bPrePage ),
          bNoText( TRUE ),
//           bXAxisChanged( FALSE ),
//           bYAxisChanged( FALSE ),
          bReducedData( FALSE ),
          bShowMainTitle( FALSE ),
          bShowSubTitle( FALSE ),
          bShowXAxisTitle( FALSE ),
          bShowYAxisTitle( FALSE ),
          bShowZAxisTitle( FALSE ),
          bShowXDescr( FALSE ),
          bShowYDescr( FALSE ),
          bShowZDescr( FALSE ),
          bShowLegend( FALSE ),

          nShapeType( CHART_SHAPE3D_ANY ),
		  bYAutoOrigin( FALSE ),

          // page 1
		  pFT_1_CHARTTYPE( NULL ),
          pCT_1_CHARTTYPE( NULL ),

          // page 2
          pFT_2_CHARTVARIANT( NULL ),
          pCT_2_CHARTVARIANT( NULL ),
          pCB_2_XGRID( NULL ),
          pCB_2_YGRID( NULL ),
          pCB_2_ZGRID( NULL ),
          pFL_2_GRID( NULL ),

          // page 3
          pFL_3_DISPLAY( NULL ),  
          pCB_3_TEXTTITLE( NULL ),
          pET_3_TEXTTITLE( NULL ),
          pCB_3_LEGEND( NULL ),
          pFT_3_AXES( NULL ),
          pCB_3_XTEXT( NULL ),
          pET_3_TEXTRUBRIK( NULL ),
          pCB_3_YTEXT( NULL ),
          pET_3_TEXTSIZE( NULL ),
          pCB_3_ZTEXT( NULL ),
          pET_3_TEXTSECOND( NULL ),

          // all pages
          pCT_PREVIEW   ( NULL ),
          aFL_HORZLINE	( this, ResId( FL_HORZLINE ) ),
		  aCB_NOTEXT    ( this, ResId( CB_DONTSHOW ) ),
		  aFT_DATAROWS	( this, ResId( FT_DATAROWS ) ),
		  aRB_DATAROWS	( this, ResId( RB_DATAROWS ) ),
		  aRB_DATACOLS	( this, ResId( RB_DATACOLS ) ),
		  aPB_HELP		( this, ResId( PB_HELP ) ),
		  aPB_CANCEL	( this, ResId( PB_CANCEL ) ),
		  aPB_PREV		( this, ResId( PB_PREV ) ),
		  aPB_NEXT		( this, ResId( PB_NEXT ) ),
		  aPB_EXECUTE	( this, ResId( PB_EXECUTE ) )
{
	//Dieser ctor: Calc->Einfuegen

	DBG_CTOR( SchDiagramAutoPilotDlg, NULL );

	pDocSh = new SchChartDocShell(SFX_CREATE_MODE_PREVIEW);
	pDocSh->DoInitNew(NULL);

	//	pTmp->SetVisArea(Rectangle(Point(0, 0), ));

	SchChartDocShell &rMyDoc = (SchChartDocShell &)*pDocSh;
	pDoc = &rMyDoc.GetDoc();

	pDoc->SetChartStatusFlag( CHS_USER_NOQUERY );	// #56439#

	if (pDoc->GetPageCount() == 0L)//#49318#
	{
		// Seite einfuegen
		BOOL bChanged = pDoc->IsChanged();
		SdrPage* pPage = pDoc->AllocPage(FALSE);
		pPage->SetSize(Size(8000, 7000));
		pDoc->InsertPage(pPage);
		StoreTextSettings();
		pDoc->SetSwitchData(TRUE);//default des Piloten
		SetTextSettings(FALSE); //Alle Beschriftungen aus ist der default
		pDoc->BuildChart(FALSE);
		pDoc->SetChanged(bChanged);
	}
	else
	{
		StoreTextSettings();
		SetTextSettings(FALSE); //Alle Beschriftungen aus ist der default
		pDoc->BuildChart(FALSE);
	}

	if (!rData.GetMainTitle ().Len ()) rData.SetMainTitle (String (SchResId (STR_TITLE_MAIN)));
	if (!rData.GetSubTitle ().Len ())  rData.SetSubTitle (String (SchResId (STR_TITLE_SUB)));
	if (!rData.GetXAxisTitle ().Len ())rData.SetXAxisTitle (String (SchResId (STR_DIAGRAM_TITLE_X_AXIS)));
	if (!rData.GetYAxisTitle ().Len ())rData.SetYAxisTitle (String (SchResId (STR_DIAGRAM_TITLE_Y_AXIS)));
	if (!rData.GetZAxisTitle ().Len ())rData.SetZAxisTitle (String (SchResId (STR_DIAGRAM_TITLE_Z_AXIS)));


	//MemChart muss evtl. reduziert werden
	pDoc->SetChartData (*(ReduceData(rData)));

	pDoc->PutAttr(rInAttrs);

	pCT_PREVIEW = new SfxPreviewWin( this, ResId( CT_PREVIEW ), pDocSh );

	//	Switch from 3D border to a flat black lined border.
	pCT_PREVIEW->SetBorderStyle (WINDOW_BORDER_MONO);

	pCT_PREVIEW->Hide();

	construct( !pDoc->IsSwitchData());

}

//------------------------------------------------------------------------------

SchDiagramAutoPilotDlg::SchDiagramAutoPilotDlg( Window * pParent,
												SfxObjectShellLock& rDocShellRef )

		: ModalDialog( pParent, SchResId( DLG_CHART_WIZ ) ),

          pButtonList( NULL ),
          pDocSh( NULL ),
		  pOutSet( NULL ),
          pDoc( NULL ),
		  bStored( FALSE ),
          eLegendPos( CHLEGEND_RIGHT ),
          pOriginalData( NULL ),
          pReducedData( NULL ),
		  nCurPageNr( 0 ),
		  bHasPrePage( FALSE ),
          bNoText( TRUE ),
//           bXAxisChanged( FALSE ),
//           bYAxisChanged( FALSE ),
          bReducedData( FALSE ),
          bShowMainTitle( FALSE ),
          bShowSubTitle( FALSE ),
          bShowXAxisTitle( FALSE ),
          bShowYAxisTitle( FALSE ),
          bShowZAxisTitle( FALSE ),
          bShowXDescr( FALSE ),
          bShowYDescr( FALSE ),
          bShowZDescr( FALSE ),
          bShowLegend( FALSE ),

          nShapeType( CHART_SHAPE3D_ANY ),
		  bYAutoOrigin( FALSE ),

          // page 1
		  pFT_1_CHARTTYPE( NULL ),
          pCT_1_CHARTTYPE( NULL ),

          // page 2
          pFT_2_CHARTVARIANT( NULL ),
          pCT_2_CHARTVARIANT( NULL ),
          pCB_2_XGRID( NULL ),
          pCB_2_YGRID( NULL ),
          pCB_2_ZGRID( NULL ),
          pFL_2_GRID( NULL ),

          // page 3
          pFL_3_DISPLAY( NULL ),  
          pCB_3_TEXTTITLE( NULL ),
          pET_3_TEXTTITLE( NULL ),
          pCB_3_LEGEND( NULL ),
          pFT_3_AXES( NULL ),
          pCB_3_XTEXT( NULL ),
          pET_3_TEXTRUBRIK( NULL ),
          pCB_3_YTEXT( NULL ),
          pET_3_TEXTSIZE( NULL ),
          pCB_3_ZTEXT( NULL ),
          pET_3_TEXTSECOND( NULL ),

          // all pages
          pCT_PREVIEW   ( NULL ),
          aFL_HORZLINE	( this, ResId( FL_HORZLINE ) ),
		  aCB_NOTEXT    ( this, ResId( CB_DONTSHOW ) ),
		  aFT_DATAROWS	( this, ResId( FT_DATAROWS ) ),
		  aRB_DATAROWS	( this, ResId( RB_DATAROWS ) ),
		  aRB_DATACOLS	( this, ResId( RB_DATACOLS ) ),
		  aPB_HELP		( this, ResId( PB_HELP ) ),
		  aPB_CANCEL	( this, ResId( PB_CANCEL ) ),
		  aPB_PREV		( this, ResId( PB_PREV ) ),
		  aPB_NEXT		( this, ResId( PB_NEXT ) ),
		  aPB_EXECUTE	( this, ResId( PB_EXECUTE ) )
{
	DBG_CTOR( SchDiagramAutoPilotDlg, NULL );

	//Dieser ctor wenn APilot aus Chart heraus aufgerufen (Fehler in Textgroesse)

	pDocSh = rDocShellRef;
	SchChartDocShell &rMyDoc = (SchChartDocShell &)*pDocSh;
	pDoc = &rMyDoc.GetDoc();

	StoreTextSettings();
	SetTextSettings(FALSE);

	pDoc->SetChartStatusFlag( CHS_USER_NOQUERY );	// #56439#

    // Daten aus dem Document holen und evtl. reduzieren
	if(!pDoc->ChangeChartData(*ReduceData(*pDoc->GetChartData()),FALSE))
		BuildChart();

	pCT_PREVIEW = new SfxPreviewWin( this, ResId( CT_PREVIEW ), rDocShellRef ),
	pCT_PREVIEW->Hide();

	construct( !pDoc->IsSwitchData() );
}

// ================================================================================

void SchDiagramAutoPilotDlg::construct(BOOL bDataInRows)
{
	if(pDoc)
	{
		pDoc->SetAutoPilot(this);						// #46895#
	}

	eLegendPos=CHLEGEND_RIGHT;

	MapMode aMap(MAP_100TH_MM);

	pCT_PREVIEW->SetMapMode(aMap);

	ScalePreview();

	aStrTitle = GetText();

	int		i=0;
  	SchControlList*	pControlList=0;

	for( i=0 ; i<SCH_MAX_PAGES ; i++ )
		arrPage[i] = new SchControlList;

	//----- Page 1 ---------------
	pControlList = arrPage[CHARTTYPE_PAGE];
	pControlList->Insert(
		pFT_1_CHARTTYPE = new FixedText( this, ResId( FT_1_CHARTTYPE ) ), LIST_APPEND );
	pControlList->Insert(
		pCT_1_CHARTTYPE = new ValueSet( this, ResId( CT_1_CHARTTYPE ) ), LIST_APPEND );

	//----- Page 2 ---------------
	pControlList = arrPage[CHARTVARIANT_PAGE];
	pControlList->Insert(
		pFT_2_CHARTVARIANT = new FixedText( this, ResId( FT_2_CHARTVARIANT ) ), LIST_APPEND );
	pControlList->Insert(
		pCT_2_CHARTVARIANT = new ValueSet( this, ResId( CT_2_CHARTVARIANT ) ), LIST_APPEND );
	pControlList->Insert(
		pCB_2_XGRID = new CheckBox( this, ResId( CB_2_XGRID ) ), LIST_APPEND );
	pControlList->Insert(
		pCB_2_YGRID = new CheckBox( this, ResId( CB_2_YGRID ) ), LIST_APPEND );
	pControlList->Insert(
		pCB_2_ZGRID = new CheckBox( this, ResId( CB_2_ZGRID ) ), LIST_APPEND );
	pControlList->Insert(
		pFL_2_GRID = new FixedLine( this, ResId( FL_2_GRID ) ), LIST_APPEND );

	//----- Page 3 ---------------
	pControlList = arrPage[CHARTDETAILS_PAGE];
	pControlList->Insert(
		pFL_3_DISPLAY = new FixedLine( this, ResId( FL_3_DISPLAY ) ), LIST_APPEND );
	pControlList->Insert(
		pCB_3_TEXTTITLE = new CheckBox( this, ResId( CB_3_TEXTTITLE ) ), LIST_APPEND );
	pControlList->Insert(
		pET_3_TEXTTITLE = new Edit( this, ResId( ET_3_TEXTTITLE ) ), LIST_APPEND );
	pControlList->Insert(
        pCB_3_LEGEND = new CheckBox( this, ResId( CB_3_LEGEND ) ), LIST_APPEND );
	pControlList->Insert(
		pFT_3_AXES = new FixedText( this, ResId( FT_3_AXES ) ), LIST_APPEND );

	pControlList->Insert(
		pCB_3_XTEXT = new CheckBox( this, ResId( CB_3_XTEXT ) ), LIST_APPEND );
	pControlList->Insert(
		pET_3_TEXTRUBRIK = new Edit( this, ResId( ET_3_TEXTRUBRIK ) ), LIST_APPEND );

	pControlList->Insert(
		pCB_3_YTEXT = new CheckBox( this, ResId( CB_3_YTEXT ) ), LIST_APPEND );
	pControlList->Insert(
		pET_3_TEXTSIZE = new Edit( this, ResId( ET_3_TEXTSIZE ) ), LIST_APPEND );

	pControlList->Insert(
		pCB_3_ZTEXT = new CheckBox( this, ResId( CB_3_ZTEXT ) ), LIST_APPEND );
	pControlList->Insert(
		pET_3_TEXTSECOND = new Edit( this, ResId( ET_3_TEXTSECOND ) ), LIST_APPEND );

	SetCurrentPage( CHARTTYPE_PAGE );

	//---------------------------------------------------------------------------------
	pCB_3_TEXTTITLE->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
	pET_3_TEXTTITLE->SetLoseFocusHdl(LINK(this,SchDiagramAutoPilotDlg,EditLoseFocusHdl));
	pET_3_TEXTRUBRIK->SetLoseFocusHdl(LINK(this,SchDiagramAutoPilotDlg,EditLoseFocusHdl));
	pET_3_TEXTSIZE->SetLoseFocusHdl(LINK(this,SchDiagramAutoPilotDlg,EditLoseFocusHdl));
	pET_3_TEXTSECOND->SetLoseFocusHdl(LINK(this,SchDiagramAutoPilotDlg,EditLoseFocusHdl));

	aRB_DATAROWS.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,RadioButtonClickHdl) );
	aRB_DATACOLS.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,RadioButtonClickHdl) );
	aRB_DATAROWS.Check( bDataInRows );
	aRB_DATACOLS.Check(!bDataInRows );

    pCB_3_LEGEND->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
    pCB_3_LEGEND->Check( FALSE );

	pCB_3_XTEXT->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
	pCB_3_YTEXT->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
	pCB_3_ZTEXT->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );

	//----------- Chart Haupgruppe-----------------------------------------------------
	pCT_1_CHARTTYPE->SetStyle(pCT_1_CHARTTYPE->GetStyle() |
		WB_ITEMBORDER | WB_DOUBLEBORDER | WB_NAMEFIELD | WB_VSCROLL | WB_FLATVALUESET | WB_3DLOOK);
	pCT_1_CHARTTYPE->SetColCount(4);
	pCT_1_CHARTTYPE->SetLineCount(2);
	pCT_1_CHARTTYPE->SetExtraSpacing(2);
	pCT_1_CHARTTYPE->SetSelectHdl(LINK(this, SchDiagramAutoPilotDlg, SelectChartTypeHdl));

    FillValueSets();
    
    pCT_2_CHARTVARIANT->SetStyle(pCT_2_CHARTVARIANT->GetStyle() |
		WB_ITEMBORDER | WB_DOUBLEBORDER | WB_NAMEFIELD | WB_VSCROLL | WB_FLATVALUESET | WB_3DLOOK);
	pCT_2_CHARTVARIANT->SetColCount(4);
	pCT_2_CHARTVARIANT->SetLineCount(1);
	pCT_2_CHARTVARIANT->SetExtraSpacing(2);
	pCT_2_CHARTVARIANT->SetSelectHdl(LINK(this, SchDiagramAutoPilotDlg, SelectChartVariantHdl ));

	InitFromModel();


	pCB_2_XGRID->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
	pCB_2_YGRID->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );
	pCB_2_ZGRID->SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,CheckBoxClickHdl) );

	//----------- Allgemein--------------------------------------------------------
	aPB_EXECUTE.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,ExecuteClickHdl) );
	aPB_PREV.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,PagerClickHdl) );
	aPB_NEXT.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,PagerClickHdl) );
	aCB_NOTEXT.SetClickHdl( LINK(this,SchDiagramAutoPilotDlg,NoTextClickHdl) );

    pET_3_TEXTRUBRIK->SetText( pDoc->XAxisTitle() );
    pET_3_TEXTSIZE->SetText( pDoc->YAxisTitle() );

    FreeResource();
	SetTextSettings(FALSE);
	pCT_PREVIEW->Show();
	aCB_NOTEXT.Check (FALSE);
}

// ----------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::CopyLegendText(SchMemChart *pTarget,SchMemChart *pSource,BOOL bCopyCols)
{
	// Fuer die Legende wird der Text der nicht reduzierten Daten benoetigt
	short nCnt,nMax;
	if(bCopyCols)
	{
	   nMax= pTarget->GetColCount();
	   for(nCnt=0;nCnt<nMax;nCnt++)
	   {
		   pTarget->SetColText(nCnt,pSource->GetColText(nCnt));
	   }
	}
	else
	{
	   nMax= pTarget->GetRowCount();
	   for(nCnt=0;nCnt<nMax;nCnt++)
	   {
		   pTarget->SetRowText(nCnt,pSource->GetRowText(nCnt));
	   }
	}
}

void SchDiagramAutoPilotDlg::CopyDataText(SchMemChart *pTarget,SchMemChart *pSource)
{
	if(pTarget && pSource)
	{
		pTarget->SetMainTitle (pSource->GetMainTitle());
		pTarget->SetXAxisTitle(pSource->GetXAxisTitle());
		pTarget->SetYAxisTitle(pSource->GetYAxisTitle());
		pTarget->SetZAxisTitle(pSource->GetZAxisTitle());
		pTarget->SetSubTitle  (pSource->GetSubTitle());
	}
}
void SchDiagramAutoPilotDlg::SetDataToOrigin()
{
	if(pOriginalData)
	{
		// Kopiere die Texte der reduzierten Daten in das Original
		CopyDataText(pOriginalData,pDoc->GetChartData());

		// Originaldaten wieder in das Document setzen
		pDoc->ChangeChartData(*pOriginalData,FALSE);
		// Original freigeben (SetData setzt RefCount hoch)
		pOriginalData->DecreaseRefCount();
		pOriginalData=NULL;
	}
}

//------------------------------------------------------------------------------
SchDiagramAutoPilotDlg::~SchDiagramAutoPilotDlg()
{
	// restoring data is not necessary as the document is a copy of the original
	// SetDataToOrigin();

	// this is necessary, becaue these attributes are copied to the original
	RestoreTextSettings();

	DBG_DTOR( SchDiagramAutoPilotDlg, NULL );

	for( int i=0 ; i<SCH_MAX_PAGES ; i++ )
	{
		SchControlList*	pControlList=arrPage[i];

		for( ULONG j=0 ; j<pControlList->Count(); j++ )
		{
			delete pControlList->GetObject( j );
		}
		delete arrPage[i];
	}

	delete pCT_PREVIEW;
}
//------------------------------------------------------------------------------
// Reduzierung der Datenpunkte, wenn Darstellung der Preview zu viel Zeit kosten
// kosten wuerde, ohne dass sich die Darstellungsqualitaet ernsthaft verbessert.
//------------------------------------------------------------------------------
BOOL SchDiagramAutoPilotDlg::GetReduceStyle(SvxChartStyle eStyle)
{
	BOOL bRetVal;

	switch(eStyle)
	{

		case CHSTYLE_2D_PIE :
		case CHSTYLE_3D_PIE :
		case CHSTYLE_2D_DONUT1 :
		case CHSTYLE_2D_DONUT2 :
		case CHSTYLE_2D_PIE_SEGOF1 :
		case CHSTYLE_2D_PIE_SEGOFALL :

			bRetVal=!(pDoc->IsSwitchData());
			break;

		case CHSTYLE_3D_AREA :
		case CHSTYLE_3D_STACKEDAREA :
		case CHSTYLE_3D_PERCENTAREA :
		case CHSTYLE_3D_SURFACE :
		case CHSTYLE_3D_XYZ :
		case CHSTYLE_3D_XYZSYMBOLS :
		case CHSTYLE_3D_BAR :
		case CHSTYLE_3D_FLATBAR :
		case CHSTYLE_3D_STACKEDFLATBAR :
		case CHSTYLE_3D_PERCENTFLATBAR :
		case CHSTYLE_2D_NET :
		case CHSTYLE_2D_NET_SYMBOLS :
		case CHSTYLE_2D_NET_STACK :
		case CHSTYLE_2D_NET_SYMBOLS_STACK :
		case CHSTYLE_2D_NET_PERCENT :
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT :

			// Ab hier getestet:

		case CHSTYLE_3D_STRIPE :
		case CHSTYLE_3D_STACKEDFLATCOLUMN :
		case CHSTYLE_3D_PERCENTFLATCOLUMN :
		case CHSTYLE_3D_COLUMN :
		case CHSTYLE_3D_FLATCOLUMN :
		default:

			bRetVal=pDoc->IsSwitchData();
			break;

	}
	return bRetVal;
}

//Das sind die max. Datenpunkte pro Reihe, dieim Autopiloten dargestellt werden
//gibt es mehr so wird gemittelt.
#define NMAX_DATAPOINTS 10

// Und soviele Datenreihen (Reihe!=Zeile!!!) darf es maximal dort geben
// Reihe sind die Daten, fuer die in der Legende ein Symbol erscheint
//gibt es mehr, so wird abgeschnitten
#define NMAX_DATAROWS   20

#define MIN(a,b) ( ((a)<(b))? (a) : (b) )

void SchDiagramAutoPilotDlg::ReduceDataAgain(BOOL bDontBuild)
{
	// Diese Routine wird bei ChangeColRow oder Aenderung des Charttypen benutzt
	// da dann statt der Zeilen die Spalten u.Umg. reduziert werden muessen

	DBG_ASSERT( ! bReducedData || pOriginalData, "original data lost?" );

	if(pOriginalData)
	{
		//Es wurde schon reduziert, also Original-Daten nehmen
		ChangeChartData( *pOriginalData );
	}
	else
	{
		//sonst aus dem Doc holen
		pDoc->ChangeChartData(
            *ReduceData( *pDoc->GetChartData() ), FALSE, bDontBuild );

	}
}

SchMemChart* SchDiagramAutoPilotDlg::ReduceData(SchMemChart& rData)
{
	/*
	Aufrufe:

	ChangeColRow:   (indirekt)

		if(pOriginalData)
		{
			//Es wurde schon reduziert, also Original-Daten nehmen
			ChangeChartData(*pOriginalData);
		}
		else
		{
			//sonst aus dem Doc holen
			SchMemChart &rReducedData=ReduceData(*pDoc->GetChartData());
			pDoc->ChangeChartData(rReducedData);
		}


	ChangeChartData( SchMemChart& rData ):

	   SchMemChart& rReducedData=ReduceData(rData );
	   pDoc->SetChartData( rReducedData );

	Konstruktor 1:

	   SchMemChart& rReducedData=ReduceData(rData);
	   pDoc->SetChartData (rReducedData);

	Konstruktor 2:

	   SchMemChart &rReducedData=ReduceData(*pDoc->GetChartData());
	   pDoc->SetChartData(rReducedData,FALSE);

	Beim Verlassen des AutoPiloten muss folgendes getan werden:

	   SetDataToOrigin();
	   if(pReducedData)delete pReducedData; // Kopie des SchMemchart loeschen


	*/

	short nDataCount,nDatarowsCount,nCols,nRows;
	BOOL  bCollectRows;

	bReducedData=FALSE;

	// Originalkopie freigeben
	if(pOriginalData)
		pOriginalData->DecreaseRefCount();
	pOriginalData=NULL;

	// Reduzierung der Spalten oder der Reihen ?:
	bCollectRows=GetReduceStyle(pDoc->ChartStyle());

	if(bCollectRows)
	{
		nDataCount     = rData.GetRowCount();
		nDatarowsCount = rData.GetColCount();
		nCols=MIN(NMAX_DATAROWS,nDatarowsCount);
		nRows=MIN(NMAX_DATAPOINTS,nDataCount);
	}
	else
	{
		nDataCount     = rData.GetColCount();
		nDatarowsCount = rData.GetRowCount();
		nRows=MIN(NMAX_DATAROWS,nDatarowsCount);
		nCols=MIN(NMAX_DATAPOINTS,nDataCount);
	}

	if((nDataCount > NMAX_DATAPOINTS) || (nDatarowsCount > NMAX_DATAROWS))
	{
		pReducedData=new SchMemChart(nCols,nRows);
		// wird vom Model geloescht, daher kein delete des alten
		// pReducedData und kein festhalten noetig:

        // copy col/row descriptions and titles
        pReducedData->SetNonNumericData( rData );

		if(pReducedData)
		{
			short nRowCnt,nColCnt,nCollect,nCollectCnt,nTmp;
			double dCollected;

			pOriginalData=&rData;
			pOriginalData->IncreaseRefCount();   //festhalten

			//In reduziertes Object die Original-Texte kopieren:
			CopyDataText(pReducedData,pOriginalData);
			CopyLegendText(pReducedData,pOriginalData,bCollectRows);

			//nCollect Elemente zusammenfassen, z.B. MinMax oder Mittelwert etc.
			nCollect=nDataCount/NMAX_DATAPOINTS;

			if(bCollectRows)
			{
				for(nColCnt=0;nColCnt<nCols;nColCnt++)
				{
					for(nRowCnt=0;nRowCnt<nRows;nRowCnt++)
					{
						if(nDataCount > NMAX_DATAPOINTS)
						{
							dCollected=0.0;
							for(nCollectCnt=0;nCollectCnt<nCollect;nCollectCnt++)
							{
								nTmp=nRowCnt*nCollect+nCollectCnt;
								dCollected+=(pOriginalData->GetData(nColCnt,nTmp));
							}
							//Wir benutzen Mittelwert der Daten
							dCollected=dCollected/(double)nCollectCnt;
							pReducedData->SetData(nColCnt,nRowCnt,dCollected);
						}
						else  //Nur abschneiden
						{
							 pReducedData->SetData(nColCnt,nRowCnt,pOriginalData->GetData(nColCnt,nRowCnt));
						}
					}
				}

			}
			else
			{
				for(nRowCnt=0;nRowCnt<nRows;nRowCnt++)
				{
					for(nColCnt=0;nColCnt<nCols;nColCnt++)
					{
						if(nDataCount > NMAX_DATAPOINTS)
						{

							dCollected=0.0;
							for(nCollectCnt=0;nCollectCnt<nCollect;nCollectCnt++)
							{
								nTmp=nColCnt*nCollect+nCollectCnt;
								dCollected+=(pOriginalData->GetData(nTmp,nRowCnt));
							}
							//Wir benutzen Mittelwert der Daten
							dCollected=dCollected/(double)nCollectCnt;
							pReducedData->SetData(nColCnt,nRowCnt,dCollected);
						}
						else
						{
							pReducedData->SetData(nColCnt,nRowCnt,pOriginalData->GetData(nColCnt,nRowCnt));
						}
					}
				}
			}
			bReducedData=TRUE;
			return pReducedData;
		}
	}
	return &rData;
}
//Texte abschalten, darf erst nach InitFromModel passieren:
void SchDiagramAutoPilotDlg::SetTextSettings(BOOL bON)
{
	pDoc->ShowMainTitle()=bON;
	pDoc->ShowSubTitle()=bON;
	pDoc->ShowXAxisTitle()=bON;
	pDoc->ShowYAxisTitle()=bON;
	pDoc->ShowZAxisTitle()=bON;
	pDoc->ShowXDescr(bON);
	pDoc->ShowYDescr(bON);
	pDoc->ShowZDescr(bON);
	pDoc->SetShowLegend (bON);

/*    Das hier war doch eh Unsinn, oder ?
pDoc->ValFo rmat()         = bON ? nValFo rmat:CHDESCR_NONE;
	pDoc->Percent ValFo rmat()  = bON ? nPerce ntValFo rmat:CHDESCR_NONE;
	pDoc->Percent Descr Format()= bON ? nPerce ntDescr Format:CHDESCR_NONE;
	pDoc->DescrFo rmat()       = bON ? nDescr Format:CHDESCR_NONE;
	*/
}


void SchDiagramAutoPilotDlg::RestoreTextSettings()
 {
	pDoc->ShowSubTitle()=bShowSubTitle;
	pDoc->ShowMainTitle()=bShowMainTitle;
	pDoc->ShowXAxisTitle()=bShowXAxisTitle;
	pDoc->ShowYAxisTitle()=bShowYAxisTitle;
	pDoc->ShowZAxisTitle()=bShowZAxisTitle;
	pDoc->ShowXDescr(bShowXDescr);
	pDoc->ShowYDescr(bShowYDescr);
	pDoc->ShowZDescr(bShowZDescr);
	pDoc->SetShowLegend (bShowLegend);
 }
void SchDiagramAutoPilotDlg::BuildChart()
{
	if(!bNoText)
	{
		RestoreTextSettings();
	}
	else
	{
		SetTextSettings(FALSE);

	}

	pDoc->BuildChart(FALSE);
}

void SchDiagramAutoPilotDlg::ChangeChartData( SchMemChart& rData )
{
	pDoc->SetChartData( * ReduceData( rData ), FALSE );
	BuildChart(); //lokales BuildChart
	pCT_PREVIEW->Invalidate();
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::SetCurrentPage( USHORT nNewPageNr )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );
	DBG_ASSERT( nNewPageNr<SCH_MAX_PAGES , "range error" );

	for( USHORT nPagNr=0 ; nPagNr<SCH_MAX_PAGES ; nPagNr++ )
	{
		SchControlList*	pControlList=arrPage[nPagNr];

		for( ULONG i=0 ; i<pControlList->Count() ; i++ )
		{
			Control*	pControl = pControlList->GetObject( i );

			if( nNewPageNr == nPagNr )
				pControl->Show();
			else
				pControl->Hide();
		}
	}

	nCurPageNr = nNewPageNr;

	if( nCurPageNr > CHARTTYPE_PAGE )
		aPB_PREV.Enable(TRUE);
	else if( ! bHasPrePage )
		aPB_PREV.Enable (FALSE);

	if(pDoc->GetMemChart()->GetTranslation()!=TRANS_NONE)
	{
		aRB_DATAROWS.Enable(FALSE);
		aRB_DATACOLS.Enable(FALSE);
	}

	BOOL bNextEnabled = (nCurPageNr < CHARTDETAILS_PAGE);

	// toggle correct Defaultbutton
	if( bNextEnabled )
	{
		aPB_EXECUTE.SetStyle( aPB_EXECUTE.GetStyle() & (~ WB_DEFBUTTON) );
		aPB_NEXT.SetStyle( aPB_NEXT.GetStyle() | WB_DEFBUTTON );
		aPB_NEXT.GrabFocus();
	}
	else if( aPB_EXECUTE.IsEnabled() )
	{
		aPB_NEXT.SetStyle( aPB_NEXT.GetStyle() & (~ WB_DEFBUTTON) );
		aPB_EXECUTE.SetStyle( aPB_EXECUTE.GetStyle() | WB_DEFBUTTON );
		aPB_EXECUTE.GrabFocus();
	}
	aPB_NEXT.Enable( bNextEnabled );

	switch( nCurPageNr )
	{
		case CHARTTYPE_PAGE:
		pCT_1_CHARTTYPE->GrabFocus();
		break;

		case CHARTVARIANT_PAGE:
		pCT_2_CHARTVARIANT->GrabFocus();
		break;

		case CHARTDETAILS_PAGE:
			if( pET_3_TEXTTITLE->IsEnabled() )
				pET_3_TEXTTITLE->GrabFocus();
			else
				pCB_3_TEXTTITLE->GrabFocus();
		break;
	}
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, PagerClickHdl, Button *, pButton )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	if( pButton == &aPB_PREV )
	{
		if( nCurPageNr>CHARTTYPE_PAGE )
		{
			SetCurrentPage( nCurPageNr - 1 );
		}
		else
		{
			FillOutputItemSet();
			EndDialog( 100 );
		}
	}
	else if( pButton == &aPB_NEXT && nCurPageNr<CHARTDETAILS_PAGE )
	{
		SetCurrentPage( nCurPageNr + 1 );
	}
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, ExecuteClickHdl, Button *, pButton )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	if( pButton == &aPB_EXECUTE )
	{
        // #i4158# grab the focus.  If the focus has been on a text field
        // before, the EditLoseFocusHdl Link is called, which applies the
        // entered text.
        aPB_EXECUTE.GrabFocus();
		FillOutputItemSet();
		EndDialog( RET_OK );
	}
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, SelectChartTypeHdl, void *, EMPTYARG )
{
    ChType eOldType = GetTypeFromStyle( pDoc->ChartStyle() );
	ChType eNewType = static_cast< ChType >( pCT_1_CHARTTYPE->GetSelectItemId() );
    NewAxisText( eOldType, eNewType );

	SelectVariantSet( eNewType, CHVARIANT_INVALID );
	ExecuteVariant();
	pCT_PREVIEW->Invalidate();
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, SelectChartVariantHdl, void *, EMPTYARG )
{
	ExecuteVariant();
	EnableOverlap ();
	pCT_PREVIEW->Invalidate();
	return 0;
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::SelectVariantSet( USHORT nNewId, ChVariant eVariant )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	pCT_2_CHARTVARIANT->Clear();

	long nOffset=0;

	switch(pDoc->GetChartShapeType())
	{
		case CHART_SHAPE3D_CONE:
			nOffset=OFFSET_CONE;
			break;
		case CHART_SHAPE3D_PYRAMID:
			nOffset=OFFSET_PYRAMID;
			break;
		case CHART_SHAPE3D_CYLINDER:
			nOffset=OFFSET_ROUND;
			break;
	}

    bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );

	switch( nNewId )
	{
		case CHTYPE_2D_LINE:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINE,
										   SELECT_BITMAP( BMP_LINES_2D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINE_STACKED,
										   SELECT_BITMAP( BMP_LINES_2D_2 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINE_PERCENT,
										   SELECT_BITMAP( BMP_LINES_2D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINESYMB,
										   SELECT_BITMAP( BMP_LINESYMB_2D_1 ),
										   String(SchResId(STR_SYMBOL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINESYMB_STACKED,
										   SELECT_BITMAP( BMP_LINESYMB_2D_2 ),
										   String(SchResId(STR_SYMBOL_STACK)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINESYMB_PERCENT,
										   SELECT_BITMAP( BMP_LINESYMB_2D_3 ),
										   String(SchResId(STR_SYMBOL_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_CUBIC_SPLINE,
										   SELECT_BITMAP( BMP_SPLINE_CUBIC ),
										   String(SchResId(STR_SPLINE_CUBIC)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_CUBIC_SPLINE_SYMBOL,
										   SELECT_BITMAP( BMP_SPLINE_CUBIC_SYMBOL ),
										   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_B_SPLINE,
										   SELECT_BITMAP( BMP_SPLINE_B ),
										   String(SchResId(STR_SPLINE_B)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_B_SPLINE_SYMBOL,
										   SELECT_BITMAP( BMP_SPLINE_B_SYMBOL ),
										   String(SchResId(STR_SPLINE_B_SYMBOL)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_LINE);
			break;

		case CHTYPE_2D_AREA:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_AREA,
										   SELECT_BITMAP( BMP_AREAS_2D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_AREA_STACKED,
										   SELECT_BITMAP( BMP_AREAS_2D ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_AREA_PERCENT,
										   SELECT_BITMAP( BMP_AREAS_2D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_AREA_STACKED);
			break;

		case CHTYPE_2D_COLUMN:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_COLUMN,
										   SELECT_BITMAP( BMP_COLUMNS_2D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_COLUMN_STACKED,
										   SELECT_BITMAP( BMP_COLUMNS_2D_2 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_COLUMN_PERCENT,
										   SELECT_BITMAP( BMP_COLUMNS_2D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINE_COLUMN,
										   SELECT_BITMAP( BMP_COLUMNS_2D_4 ),
										   String(SchResId(STR_LINE_COLUMN)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_LINE_STACKEDCOLUMN,
										   SELECT_BITMAP( BMP_COLUMNS_2D_5 ),
										   String(SchResId(STR_LINE_STACKEDCOLUMN)));

			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_COLUMN);
			break;

		case CHTYPE_2D_BAR:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_BAR,
										   SELECT_BITMAP( BMP_BARS_2D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_BAR_STACKED,
										   SELECT_BITMAP( BMP_BARS_2D_2 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_BAR_PERCENT,
										   SELECT_BITMAP( BMP_BARS_2D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_BAR);
			break;

		case CHTYPE_2D_PIE:
			{
				pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_PIE,
											   SELECT_BITMAP( BMP_CIRCLES_2D ),
											   String(SchResId(STR_NORMAL)));
				pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_DONUT1,
											   SELECT_BITMAP( BMP_DONUT1_2D ),
											   String(SchResId(STR_DONUT1)));
				String aResStr( SchResId( STR_OFS ));
				String aOfsStr = aResStr;

				xub_StrLen nFound = aResStr.SearchAscii( "$(N)" );
				if( nFound != STRING_NOTFOUND )
					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 1 ));

				pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_PIE_SEGOFS_1,
											   SELECT_BITMAP( BMP_CIRCLES_2D_1 ),
											   aOfsStr);

				aOfsStr = aResStr;
				if( nFound != STRING_NOTFOUND )
					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 2 ));

				pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_PIE_SEGOFS_ALL,
											   SELECT_BITMAP( BMP_CIRCLES_2D_2 ),
											   aOfsStr);
				pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
											   ? eVariant
											   : CHVARIANT_2D_PIE);
				break;
			}

		case CHTYPE_2D_XY:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_XY_SYMB,
										   SELECT_BITMAP( BMP_XYSYMB_2D ),
										   String(SchResId(STR_ONLY_SYMBOLS)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_XY,
										   SELECT_BITMAP( BMP_XY_2D ),
										   String(SchResId(STR_LINE_SYMBOLS)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_XY_LINE,
										   SELECT_BITMAP( BMP_LINES_2D_1 ),
										   String(SchResId(STR_ONLY_LINES)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_CUBIC_SPLINE_XY,
										   SELECT_BITMAP( BMP_SPLINE_CUBIC ),
										   String(SchResId(STR_SPLINE_CUBIC)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_CUBIC_SPLINE_SYMBOL_XY,
										   SELECT_BITMAP( BMP_SPLINE_CUBIC_SYMBOL ),
										   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_B_SPLINE_XY,
										   SELECT_BITMAP( BMP_SPLINE_B ),
										   String(SchResId(STR_SPLINE_B)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_B_SPLINE_SYMBOL_XY,
										   SELECT_BITMAP( BMP_SPLINE_B_SYMBOL ),
										   String(SchResId(STR_SPLINE_B_SYMBOL)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_XY_SYMB);
			break;

		case CHTYPE_2D_NET:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NET,
										   SELECT_BITMAP( BMP_NET_2D ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NET_STACK,
										   SELECT_BITMAP( BMP_NET_2D_STACK ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NET_PERCENT,
										   SELECT_BITMAP( BMP_NET_2D_PERCENT ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NETSYMB,
										   SELECT_BITMAP( BMP_NETSYMB_2D ),
										   String(SchResId(STR_SYMBOL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NETSYMB_STACK,
										   SELECT_BITMAP( BMP_NETSYMB_2D_STACK ),
										   String(SchResId(STR_SYMBOL_STACK)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_NETSYMB_PERCENT,
										   SELECT_BITMAP( BMP_NETSYMB_2D_PERCENT ),
										   String(SchResId(STR_SYMBOL_PERCENT)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_NET);
			break;

		case CHTYPE_3D_STRIPE:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_STRIPE,
										   SELECT_BITMAP( BMP_LINES_3D ),
										   String(SchResId(STR_DEEP)));
			pCT_2_CHARTVARIANT->SelectItem(CHVARIANT_3D_STRIPE);
			break;

		case CHTYPE_3D_AREA:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_AREA_STACKED,
										   SELECT_BITMAP( BMP_AREAS_3D_1 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_AREA_PERCENT,
										   SELECT_BITMAP( BMP_AREAS_3D_2 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_AREA,
										   SELECT_BITMAP( BMP_AREAS_3D ),
										   String(SchResId(STR_DEEP)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_3D_AREA_STACKED);
			break;

		case CHTYPE_3D_COLUMN:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT,
										   SELECT_BITMAP( BMP_COLUMNS_3D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_STACKED,
										   SELECT_BITMAP( BMP_COLUMNS_3D_2 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_PERCENT,
										   SELECT_BITMAP( BMP_COLUMNS_3D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN,
										   SELECT_BITMAP( BMP_COLUMNS_3D ),
										   String(SchResId(STR_DEEP)));

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_SAEULE_3D_1 ),
										   String(SchResId(STR_SAEULE_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_STACKED + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_SAEULE_3D_2 ),
										   String(SchResId(STR_SAEULE_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_PERCENT + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_SAEULE_3D_3 ),
										   String(SchResId(STR_SAEULE_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_SAEULE_3D_4 ),
										   String(SchResId(STR_SAEULE_3D_4)));

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMID_3D_1 ),
										   String(SchResId(STR_PYRAMID_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_STACKED + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMID_3D_2 ),
										   String(SchResId(STR_PYRAMID_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_PERCENT + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMID_3D_3 ),
										   String(SchResId(STR_PYRAMID_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMID_3D_4 ),
										   String(SchResId(STR_PYRAMID_3D_4)));

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGEL_3D_1 ),
										   String(SchResId(STR_KEGEL_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_STACKED + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGEL_3D_2 ),
										   String(SchResId(STR_KEGEL_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN_FLAT_PERCENT + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGEL_3D_3 ),
										   String(SchResId(STR_KEGEL_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_COLUMN + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGEL_3D_4 ),
										   String(SchResId(STR_KEGEL_3D_4)));



			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant + nOffset
										   : CHVARIANT_3D_COLUMN_FLAT);
			break;

		case CHTYPE_3D_PIE:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_PIE,
										   SELECT_BITMAP( BMP_CIRCLES_3D ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->SelectItem(CHVARIANT_3D_PIE);
			break;

		case CHTYPE_3D_BAR:
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT,
										   SELECT_BITMAP( BMP_BARS_3D_1 ),
										   String(SchResId(STR_NORMAL)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_STACKED,
										   SELECT_BITMAP( BMP_BARS_3D_2 ),
										   String(SchResId(STR_STACKED)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_PERCENT,
										   SELECT_BITMAP( BMP_BARS_3D_3 ),
										   String(SchResId(STR_PERCENT)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR,
										   SELECT_BITMAP( BMP_BARS_3D ),
										   String(SchResId(STR_DEEP)));


			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_ROEHRE_3D_1 ),
										   String(SchResId(STR_ROEHRE_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_STACKED + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_ROEHRE_3D_2 ),
										   String(SchResId(STR_ROEHRE_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_PERCENT + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_ROEHRE_3D_3 ),
										   String(SchResId(STR_ROEHRE_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR + OFFSET_ROUND,
										   SELECT_BITMAP( BMP_ROEHRE_3D_4 ),
										   String(SchResId(STR_ROEHRE_3D_4)));

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMIDQ_3D_1 ),
										   String(SchResId(STR_PYRAMIDQ_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_STACKED + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMIDQ_3D_2 ),
										   String(SchResId(STR_PYRAMIDQ_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_PERCENT + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMIDQ_3D_3 ),
										   String(SchResId(STR_PYRAMIDQ_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR + OFFSET_PYRAMID,
										   SELECT_BITMAP( BMP_PYRAMIDQ_3D_4 ),
										   String(SchResId(STR_PYRAMIDQ_3D_4)));

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGELQ_3D_1 ),
										   String(SchResId(STR_KEGELQ_3D_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_STACKED + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGELQ_3D_2 ),
										   String(SchResId(STR_KEGELQ_3D_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR_FLAT_PERCENT + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGELQ_3D_3 ),
										   String(SchResId(STR_KEGELQ_3D_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_3D_BAR + OFFSET_CONE,
										   SELECT_BITMAP( BMP_KEGELQ_3D_4 ),
										   String(SchResId(STR_KEGELQ_3D_4)));


			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant + nOffset
										   : CHVARIANT_3D_BAR_FLAT);
			break;


		case CHTYPE_2D_STOCK:

			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_STOCK_1,
										   SELECT_BITMAP( BMP_STOCK_1 ),
										   String(SchResId(STR_STOCK_1)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_STOCK_2,
										   SELECT_BITMAP( BMP_STOCK_2 ),
										   String(SchResId(STR_STOCK_2)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_STOCK_3,
										   SELECT_BITMAP( BMP_STOCK_3 ),
										   String(SchResId(STR_STOCK_3)));
			pCT_2_CHARTVARIANT->InsertItem(CHVARIANT_2D_STOCK_4,
										   SELECT_BITMAP( BMP_STOCK_4 ),
										   String(SchResId(STR_STOCK_4)));
			pCT_2_CHARTVARIANT->SelectItem((eVariant != CHVARIANT_INVALID)
										   ? eVariant
										   : CHVARIANT_2D_STOCK_2);
			break;

	}

	// make selected Item visible
	pCT_2_CHARTVARIANT->SetFirstLine( pCT_2_CHARTVARIANT->GetItemPos( pCT_2_CHARTVARIANT->GetSelectItemId() )
									  / pCT_2_CHARTVARIANT->GetColCount() );

	EnableOverlap ();
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, EditLoseFocusHdl, Control *, pControl )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	Edit*	pEdit = (Edit*)pControl;

	if(pEdit->IsModified())
	{
		String *pDocText=NULL, aOldText, aNewText;
		aNewText = pEdit->GetText();

		if(pEdit==pET_3_TEXTTITLE) pDocText = &pDoc->MainTitle();
		if(pEdit==pET_3_TEXTRUBRIK)pDocText = &pDoc->XAxisTitle();
		if(pEdit==pET_3_TEXTSIZE)  pDocText = &pDoc->YAxisTitle();
		if(pEdit==pET_3_TEXTSECOND)pDocText = &pDoc->ZAxisTitle();

		if(pDocText)
		{
			aOldText=*pDocText;

			if( aNewText != aOldText )
			{
				*pDocText = aNewText;
				if(!bNoText)BuildChart(); //lokales BuildChart
			}
			pCT_PREVIEW->Invalidate();
			pEdit->ClearModifyFlag();
		}
	}

	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, RadioButtonClickHdl, Button *, pButton )
{
	bool bOldSwitch = ( pDoc->IsSwitchData() == TRUE );
    bool bNewSwitch = ( pButton == &aRB_DATACOLS );
    bool bChanges = ( bOldSwitch != bNewSwitch );

	ChType eType = static_cast< ChType >( pCT_1_CHARTTYPE->GetSelectItemId() );

    // must be called before BuildChart()
    NewAxisText( eType, eType, bChanges );

    // may perform a BuildChart()
    pDoc->ChangeSwitchData( bNewSwitch );

	if( bChanges )
		ReduceDataAgain();

    BuildChart();   // method of this class
	pCT_PREVIEW->Invalidate();
	return 0;
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::StoreTextSettings()
{

	if(bStored)
		return;

	bStored=TRUE;
	bShowLegend    = pDoc->GetShowLegend();
	bShowSubTitle  = pDoc->ShowSubTitle();
	bShowMainTitle = pDoc->ShowMainTitle();
	bShowXAxisTitle= pDoc->ShowXAxisTitle();
	bShowYAxisTitle= pDoc->ShowYAxisTitle();
	bShowZAxisTitle= pDoc->ShowZAxisTitle();
	bShowXDescr    = pDoc->ShowXDescr();
	bShowYDescr    = pDoc->ShowYDescr();
	bShowZDescr    = pDoc->ShowZDescr();

}
void SchDiagramAutoPilotDlg::InitFromModel()
{
	SvxChartStyle eStyle = pDoc->ChartStyle();
	ChType eType = GetTypeFromStyle( eStyle );

	pCT_1_CHARTTYPE->SelectItem( eType );

	// make selected Item visible
	USHORT nSelLine = pCT_1_CHARTTYPE->GetItemPos( pCT_1_CHARTTYPE->GetSelectItemId() )
		/ pCT_1_CHARTTYPE->GetColCount();

	// move upward until item is visible in last line shown
	if( nSelLine >= pCT_1_CHARTTYPE->GetLineCount() )
		pCT_1_CHARTTYPE->SetFirstLine( nSelLine - pCT_1_CHARTTYPE->GetLineCount() + 1 );

	BOOL bIs3D = FALSE;

	switch (eType)
	{
		case CHSTYLE_3D_STRIPE :
		case CHSTYLE_3D_COLUMN :
		case CHSTYLE_3D_FLATCOLUMN :
		case CHSTYLE_3D_STACKEDFLATCOLUMN :
		case CHSTYLE_3D_PERCENTFLATCOLUMN :
		case CHSTYLE_3D_AREA :
		case CHSTYLE_3D_STACKEDAREA :
		case CHSTYLE_3D_PERCENTAREA :
		case CHSTYLE_3D_SURFACE :
		case CHSTYLE_3D_XYZ :
		case CHSTYLE_3D_XYZSYMBOLS :
		case CHSTYLE_3D_BAR :
		case CHSTYLE_3D_FLATBAR :
		case CHSTYLE_3D_STACKEDFLATBAR :
		case CHSTYLE_3D_PERCENTFLATBAR :
			pCB_2_ZGRID->Enable(TRUE);
			pET_3_TEXTSECOND->Enable(TRUE);
			bIs3D = TRUE;
			break;

		case CHSTYLE_2D_PIE :
		case CHSTYLE_3D_PIE :
		case CHSTYLE_2D_DONUT1 :
		case CHSTYLE_2D_DONUT2 :
		case CHSTYLE_2D_PIE_SEGOF1 :
		case CHSTYLE_2D_PIE_SEGOFALL :
			pCB_2_XGRID->Enable (FALSE);
			pCB_2_YGRID->Enable (FALSE);
			pCB_2_ZGRID->Enable (FALSE);
			pET_3_TEXTRUBRIK->Enable (FALSE);
			pET_3_TEXTSIZE->Enable (FALSE);
			pET_3_TEXTSECOND->Enable (FALSE);

			if (eStyle == CHSTYLE_3D_PIE) bIs3D = TRUE;
			break;

		case CHSTYLE_2D_NET :
		case CHSTYLE_2D_NET_SYMBOLS :
		case CHSTYLE_2D_NET_STACK :
		case CHSTYLE_2D_NET_SYMBOLS_STACK :
		case CHSTYLE_2D_NET_PERCENT :
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT :
			pET_3_TEXTRUBRIK->Enable (FALSE);
			break;

		default :
			;
	}

	if (!bIs3D)
	{
		pCB_2_ZGRID->Enable (FALSE);
		pET_3_TEXTSECOND->Enable (FALSE);
	}

	SelectVariantSet( eType, TranslateFromModel (eStyle));
	StoreTextSettings();

	pET_3_TEXTTITLE->SetText( pDoc->MainTitle() );
	pET_3_TEXTSECOND->SetText( pDoc->ZAxisTitle() );

	pET_3_TEXTTITLE->ClearModifyFlag();
	pET_3_TEXTRUBRIK->ClearModifyFlag();
	pET_3_TEXTSIZE->ClearModifyFlag();
	pET_3_TEXTSECOND->ClearModifyFlag();

	pCB_2_XGRID->Check( pDoc->ShowYGridMain() );
	pCB_2_YGRID->Check( pDoc->ShowXGridMain() );
	pCB_2_ZGRID->Check( pDoc->ShowZGridMain() );

    pCB_3_LEGEND->Check( bShowLegend );
	pCB_3_XTEXT->Check( bShowXAxisTitle);
	pCB_3_YTEXT->Check( bShowYAxisTitle);
	pCB_3_ZTEXT->Check( bShowZAxisTitle);
	pCB_3_TEXTTITLE->Check( bShowMainTitle  );

	pET_3_TEXTTITLE->Enable(bShowMainTitle);

	EnableOverlap();
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::SetupModel()
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

}


//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::ScalePreview()
{
	SchChartDocShell &rMyDoc = (SchChartDocShell &)*pDocSh;

	static Point aDefPoint;
	Rectangle rRect( aDefPoint, pCT_PREVIEW->GetSizePixel());
	rRect = PixelToLogic( rRect, pCT_PREVIEW->GetMapMode() );
	rMyDoc.SetVisArea( rRect );
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::ExecuteVariant()
{
	short i;
	short nPieSegCnt = pDoc->PieSegCount();

	for (i = 0; i < nPieSegCnt; i++)
		pDoc->SetPieSegOfs( i, 0 );

	long nId = pCT_2_CHARTVARIANT->GetSelectItemId();
	nShapeType = CHART_SHAPE3D_SQUARE;
	if(nId > OFFSET_CONE)
	{
		nId -= OFFSET_CONE;
		nShapeType = CHART_SHAPE3D_CONE;
	}
	if(nId>OFFSET_ROUND)
	{
		nId -= OFFSET_ROUND;
		nShapeType = CHART_SHAPE3D_CYLINDER;
	}
	if(nId>OFFSET_PYRAMID)
	{
		nId -= OFFSET_PYRAMID;
		nShapeType = CHART_SHAPE3D_PYRAMID;
	}

	ChVariant eVariant = (ChVariant)nId;

	SvxChartStyle eStyle,eOldStyle;

	switch( eVariant )
	{
		case CHVARIANT_2D_LINE:
			eStyle = CHSTYLE_2D_LINE;
			break;

		case CHVARIANT_2D_LINE_STACKED:
			eStyle = CHSTYLE_2D_STACKEDLINE;
			break;

		case CHVARIANT_2D_LINE_PERCENT:
			eStyle = CHSTYLE_2D_PERCENTLINE;
			break;

		case CHVARIANT_2D_LINESYMB:
			eStyle = CHSTYLE_2D_LINESYMBOLS;
			break;

		case CHVARIANT_2D_LINESYMB_STACKED:
			eStyle = CHSTYLE_2D_STACKEDLINESYM;
			break;

		case CHVARIANT_2D_LINESYMB_PERCENT:
			eStyle = CHSTYLE_2D_PERCENTLINESYM;
			break;

		case CHVARIANT_2D_COLUMN:
			eStyle = CHSTYLE_2D_COLUMN;
			break;

		case CHVARIANT_2D_COLUMN_STACKED:
			eStyle = CHSTYLE_2D_STACKEDCOLUMN;
			break;

		case CHVARIANT_2D_COLUMN_PERCENT:
			eStyle = CHSTYLE_2D_PERCENTCOLUMN;
			break;

		case CHVARIANT_2D_LINE_COLUMN:
			eStyle = CHSTYLE_2D_LINE_COLUMN;
			break;

		case CHVARIANT_2D_LINE_STACKEDCOLUMN:
			eStyle = CHSTYLE_2D_LINE_STACKEDCOLUMN;
			break;

		case CHVARIANT_2D_BAR:
			eStyle = CHSTYLE_2D_BAR;
			break;

		case CHVARIANT_2D_BAR_STACKED:
			eStyle = CHSTYLE_2D_STACKEDBAR;
			break;

		case CHVARIANT_2D_BAR_PERCENT:
			eStyle = CHSTYLE_2D_PERCENTBAR;
			break;

		case CHVARIANT_2D_AREA:
			eStyle = CHSTYLE_2D_AREA;
			break;

		case CHVARIANT_2D_AREA_STACKED:
			eStyle = CHSTYLE_2D_STACKEDAREA;
			break;

		case CHVARIANT_2D_AREA_PERCENT:
			eStyle = CHSTYLE_2D_PERCENTAREA;
			break;

		case CHVARIANT_2D_PIE:
			eStyle = CHSTYLE_2D_PIE;
			break;

		case CHVARIANT_2D_PIE_SEGOFS_1:
			eStyle = CHSTYLE_2D_PIE_SEGOF1;
			pDoc->SetPieSegOfs( 0, 10 );
			break;

		case CHVARIANT_2D_PIE_SEGOFS_ALL:
			eStyle = CHSTYLE_2D_PIE_SEGOFALL;
			for (i = 0; i < nPieSegCnt; i++)
				pDoc->SetPieSegOfs( i, 10 );
			break;

		case CHVARIANT_2D_XY_SYMB:
			eStyle = CHSTYLE_2D_XYSYMBOLS;
			break;

		case CHVARIANT_2D_XY:
			eStyle = CHSTYLE_2D_XY;
			break;

		case CHVARIANT_2D_XY_LINE:
			eStyle = CHSTYLE_2D_XY_LINE;
			break;

		case CHVARIANT_2D_NET:
			eStyle = CHSTYLE_2D_NET;
			break;

		case CHVARIANT_2D_NETSYMB:
			eStyle = CHSTYLE_2D_NET_SYMBOLS;
			break;

		case CHVARIANT_2D_NET_STACK:
			eStyle = CHSTYLE_2D_NET_STACK;
			break;

		case CHVARIANT_2D_NETSYMB_STACK:
			eStyle = CHSTYLE_2D_NET_SYMBOLS_STACK;
			break;

		case CHVARIANT_2D_NET_PERCENT:
			eStyle = CHSTYLE_2D_NET_PERCENT;
			break;

		case CHVARIANT_2D_NETSYMB_PERCENT:
			eStyle = CHSTYLE_2D_NET_SYMBOLS_PERCENT;
			break;

		case CHVARIANT_3D_STRIPE:
			eStyle = CHSTYLE_3D_STRIPE;
			break;

		case CHVARIANT_3D_COLUMN:
			eStyle = CHSTYLE_3D_COLUMN;
			break;

		case CHVARIANT_3D_COLUMN_FLAT:
			eStyle = CHSTYLE_3D_FLATCOLUMN;
			break;

		case CHVARIANT_3D_COLUMN_FLAT_STACKED:
			eStyle = CHSTYLE_3D_STACKEDFLATCOLUMN;
			break;

		case CHVARIANT_3D_COLUMN_FLAT_PERCENT:
			eStyle = CHSTYLE_3D_PERCENTFLATCOLUMN;
			break;

		case CHVARIANT_3D_AREA:
			eStyle = CHSTYLE_3D_AREA;
			break;

		case CHVARIANT_3D_AREA_STACKED:
			eStyle = CHSTYLE_3D_STACKEDAREA;
			break;

		case CHVARIANT_3D_AREA_PERCENT:
			eStyle = CHSTYLE_3D_PERCENTAREA;
			break;

		case CHVARIANT_3D_PIE:
			eStyle = CHSTYLE_3D_PIE;
			break;

		case CHVARIANT_2D_DONUT1 :
			eStyle = CHSTYLE_2D_DONUT1;
			break;

		case CHVARIANT_2D_DONUT2 :
			eStyle = CHSTYLE_2D_DONUT2;
			break;

		case CHVARIANT_3D_BAR :
			eStyle = CHSTYLE_3D_BAR;
			break;

		case CHVARIANT_3D_BAR_FLAT :
			eStyle = CHSTYLE_3D_FLATBAR;
			break;

		case CHVARIANT_3D_BAR_FLAT_STACKED :
			eStyle = CHSTYLE_3D_STACKEDFLATBAR;
			break;

		case CHVARIANT_3D_BAR_FLAT_PERCENT :
			eStyle = CHSTYLE_3D_PERCENTFLATBAR;
			break;

		case CHVARIANT_2D_CUBIC_SPLINE :
			eStyle = CHSTYLE_2D_CUBIC_SPLINE;
			break;

		case CHVARIANT_2D_CUBIC_SPLINE_SYMBOL :
			eStyle = CHSTYLE_2D_CUBIC_SPLINE_SYMBOL;
			break;

		case CHVARIANT_2D_B_SPLINE :
			eStyle = CHSTYLE_2D_B_SPLINE;
			break;

		case CHVARIANT_2D_B_SPLINE_SYMBOL :
			eStyle = CHSTYLE_2D_B_SPLINE_SYMBOL;
			break;

		case CHVARIANT_2D_CUBIC_SPLINE_XY :
			eStyle = CHSTYLE_2D_CUBIC_SPLINE_XY;
			break;

		case CHVARIANT_2D_CUBIC_SPLINE_SYMBOL_XY :
			eStyle = CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY;
			break;

		case CHVARIANT_2D_B_SPLINE_XY :
			eStyle = CHSTYLE_2D_B_SPLINE_XY;
			break;

		case CHVARIANT_2D_B_SPLINE_SYMBOL_XY :
			eStyle = CHSTYLE_2D_B_SPLINE_SYMBOL_XY;
			break;

		case CHVARIANT_2D_STOCK_1:
			eStyle = CHSTYLE_2D_STOCK_1;
			break;

		case CHVARIANT_2D_STOCK_2:
			eStyle = CHSTYLE_2D_STOCK_2;
			break;

		case CHVARIANT_2D_STOCK_3:
			eStyle = CHSTYLE_2D_STOCK_3;
			break;

		case CHVARIANT_2D_STOCK_4:
			eStyle = CHSTYLE_2D_STOCK_4;
			break;

		default:
			eStyle = CHSTYLE_2D_COLUMN;
			break;
	}

	eOldStyle			= pDoc->ChartStyle();
	long nOldShapeType	= pDoc->GetChartShapeType();

	if(nShapeType != nOldShapeType)
	{
		SfxItemSet aSet( pDoc->GetPool(), SCHATTR_STYLE_SHAPE, SCHATTR_STYLE_SHAPE );
		aSet.Put( SfxInt32Item( SCHATTR_STYLE_SHAPE, nShapeType ) );
		pDoc->PutDataRowAttrAll(aSet);
	}
	if(eStyle!=eOldStyle)
	{
//		The following is done now in ChangeChart because XML loading needs to
//		do it too and already calls ChangeChart.
/*		// BM #67923#
		if( pOutSet )	// means we have a new chart
		{
			bYAutoOrigin = (pDoc->IsXYChart( &eStyle ) ||
							eVariant == CHVARIANT_2D_STOCK_1 ||
							eVariant == CHVARIANT_2D_STOCK_2 );

			SfxItemSet aAttr( pDoc->GetPool(), SCHATTR_AXIS_AUTO_ORIGIN, SCHATTR_AXIS_AUTO_ORIGIN );
			aAttr.Put( SfxBoolItem( SCHATTR_AXIS_AUTO_ORIGIN, bYAutoOrigin ));
			ChartAxis* pYAxis = pDoc->GetAxis( CHOBJID_DIAGRAM_Y_AXIS );
			if( pYAxis )
			{
				pYAxis->SetAttributes( aAttr );
			}
		}
*/
		if( GetReduceStyle(eOldStyle) != GetReduceStyle(eStyle) )
			ReduceDataAgain(TRUE);
		pDoc->ChangeChart(eStyle);
	}

	BuildChart();

	pCT_PREVIEW->Invalidate();
}

//------------------------------------------------------------------------------
ChType SchDiagramAutoPilotDlg::GetTypeFromStyle( SvxChartStyle eStyle )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	ChType eResult = CHTYPE_2D_LINE;

	switch( eStyle )
	{
		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_LINESYMBOLS:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
			eResult = CHTYPE_2D_LINE;
			break;

		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
        case CHSTYLE_2D_LINE_COLUMN:
        case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			eResult = CHTYPE_2D_COLUMN;
			break;

		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
			eResult = CHTYPE_2D_BAR;
			break;

		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
			eResult = CHTYPE_2D_AREA;
			break;

		case CHSTYLE_2D_PIE:
		case CHSTYLE_2D_DONUT1:
		case CHSTYLE_2D_DONUT2:
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
			eResult = CHTYPE_2D_PIE;
			break;

		case CHSTYLE_2D_XYSYMBOLS:
		case CHSTYLE_2D_XY:
		case CHSTYLE_2D_XY_LINE:
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			eResult  = CHTYPE_2D_XY;
			break;

		case CHSTYLE_2D_NET :
		case CHSTYLE_2D_NET_SYMBOLS :
		case CHSTYLE_2D_NET_STACK :
		case CHSTYLE_2D_NET_SYMBOLS_STACK :
		case CHSTYLE_2D_NET_PERCENT :
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT :
			eResult =  CHTYPE_2D_NET;
			break;

		case CHSTYLE_3D_STRIPE:
			eResult = CHTYPE_3D_STRIPE;
			break;

		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			eResult = CHTYPE_3D_COLUMN;
			break;

		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
			eResult = CHTYPE_3D_AREA;
			break;

		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			eResult = CHTYPE_3D_BAR;
			break;

//		case CHSTYLE_3D_SURFACE:
		case CHSTYLE_3D_PIE:
			eResult = CHTYPE_3D_PIE;
			break;

		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			eResult = CHTYPE_2D_STOCK;
			break;

		default:
			eResult = CHTYPE_2D_LINE;
			break;
	}

	return eResult;
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, CheckBoxClickHdl, CheckBox*, pCheck )
{
	BOOL bUpdate = (! bNoText);

	if( pCheck == pCB_2_YGRID )
	{
		pDoc->ShowXGridMain() = pCB_2_YGRID->IsChecked ();
		bUpdate = TRUE;
	}
	else if( pCheck == pCB_2_XGRID )
	{
		pDoc->ShowYGridMain() = pCB_2_XGRID->IsChecked ();
		bUpdate = TRUE;
	}
	else if( pCheck == pCB_2_ZGRID )
	{
		pDoc->ShowZGridMain() = pCB_2_ZGRID->IsChecked ();
		bUpdate = TRUE;
	}
	else if( pCheck == pCB_3_XTEXT )
		bShowXAxisTitle = pCB_3_XTEXT->IsChecked();
	else if( pCheck == pCB_3_YTEXT )
		bShowYAxisTitle = pCB_3_YTEXT->IsChecked();
	else if( pCheck == pCB_3_ZTEXT )
		bShowZAxisTitle = pCB_3_ZTEXT->IsChecked();
	else if( pCheck == pCB_3_TEXTTITLE )
		bShowMainTitle = pCB_3_TEXTTITLE->IsChecked();
    else if( pCheck == pCB_3_LEGEND )
        bShowLegend = pCB_3_LEGEND->IsChecked();

	pET_3_TEXTRUBRIK->Enable( pCB_3_XTEXT->IsEnabled() && bShowXAxisTitle );
	pET_3_TEXTSIZE->Enable(	pCB_3_YTEXT->IsEnabled() && bShowYAxisTitle );
	pET_3_TEXTSECOND->Enable( pCB_3_ZTEXT->IsEnabled() && bShowZAxisTitle );
	pET_3_TEXTTITLE->Enable( pCB_3_TEXTTITLE->IsEnabled() && bShowMainTitle );

	if( bUpdate )
	{
		BuildChart();
		pCT_PREVIEW->Invalidate();
	}

	return 0;
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::EnableOverlap()
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	SvxChartStyle eStyle =
		(SvxChartStyle)(pCT_2_CHARTVARIANT->GetSelectItemId()-1);
	ChVariant eVariant = (ChVariant)(pCT_2_CHARTVARIANT->GetSelectItemId());

	pET_3_TEXTSECOND->Enable (FALSE);
	pCB_2_XGRID->Enable(TRUE);
	pCB_2_YGRID->Enable(TRUE);
	pCB_2_ZGRID->Enable (FALSE);
	pET_3_TEXTRUBRIK->Enable(TRUE);
	pET_3_TEXTSIZE->Enable(TRUE);
	pET_3_TEXTSECOND->Enable(TRUE);
	pCB_3_XTEXT->Enable(TRUE);
	pCB_3_YTEXT->Enable(TRUE);
	pCB_3_ZTEXT->Enable (FALSE);

	BOOL bIs3D = FALSE;

	switch (eVariant)
	{
		case CHVARIANT_3D_STRIPE :
		case CHVARIANT_3D_COLUMN :
		case CHVARIANT_3D_COLUMN_FLAT :
		case CHVARIANT_3D_COLUMN_FLAT_STACKED :
		case CHVARIANT_3D_COLUMN_FLAT_PERCENT :
		case CHVARIANT_3D_AREA :
		case CHVARIANT_3D_AREA_STACKED :
		case CHVARIANT_3D_AREA_PERCENT :
		case CHVARIANT_3D_SURFACE :
		case CHVARIANT_3D_XYZ :
		case CHVARIANT_3D_XYZ_SYMB :
		case CHVARIANT_3D_BAR :
		case CHVARIANT_3D_BAR_FLAT :
		case CHVARIANT_3D_BAR_FLAT_STACKED :
		case CHVARIANT_3D_BAR_FLAT_PERCENT :
			pCB_2_ZGRID->Enable(TRUE);
			pCB_3_ZTEXT->Enable(TRUE);
			pET_3_TEXTSECOND->Enable(TRUE);
			bIs3D = TRUE;
			break;

		case CHVARIANT_2D_PIE :
		case CHVARIANT_3D_PIE :
		case CHVARIANT_2D_DONUT1 :
		case CHVARIANT_2D_DONUT2 :
		case CHVARIANT_2D_PIE_SEGOFS_1 :
		case CHVARIANT_2D_PIE_SEGOFS_ALL :
			pCB_2_XGRID->Enable (FALSE);
			pCB_2_YGRID->Enable (FALSE);
			pCB_2_ZGRID->Enable (FALSE);
			pET_3_TEXTRUBRIK->Enable (FALSE);
			pET_3_TEXTSIZE->Enable (FALSE);
			pET_3_TEXTSECOND->Enable (FALSE);
			pCB_3_XTEXT->Enable (FALSE);
			pCB_3_YTEXT->Enable (FALSE);
			pCB_3_ZTEXT->Enable (FALSE);

			if (eStyle == CHVARIANT_3D_PIE) bIs3D = TRUE;
			break;

		case CHVARIANT_2D_NET :
		case CHVARIANT_2D_NETSYMB :
		case CHVARIANT_2D_NET_STACK :
		case CHVARIANT_2D_NETSYMB_STACK :
		case CHVARIANT_2D_NET_PERCENT :
		case CHVARIANT_2D_NETSYMB_PERCENT :
			pCB_2_XGRID->Enable (FALSE);
			pCB_2_ZGRID->Enable (FALSE);
			pET_3_TEXTRUBRIK->Enable (FALSE);
			pET_3_TEXTSIZE->Enable (FALSE);
			pET_3_TEXTSECOND->Enable (FALSE);
			pCB_3_XTEXT->Enable (FALSE);
			pCB_3_YTEXT->Enable (FALSE);
			pCB_3_ZTEXT->Enable (FALSE);
			break;

		case CHVARIANT_2D_COLUMN :
		case CHVARIANT_2D_BAR :
			break;

		default :
			;
	}

	if (!bIs3D)
	{
		pCB_2_ZGRID->Enable (FALSE);
		pET_3_TEXTSECOND->Enable (FALSE);
	}

	 // [FG] Hier soll beim ersten Klick entschieden werden, wie die Daten eines XY-Charts interpretiert
	 // werden sollen. (Sollen die Daten Spalten oder Zeilenweise interpretiert werden?)
	 // Der Wechsel bei jedem weiterem Click wurde deaktiviert, da es fuer den Benutzer nicht
	 // einsichtig ist warum ein
	 // Klick auf das XY-Diagramm Symbol die Interpretation der Anordnung der Daten aendern soll.
	 // Dieser Effekt ist nur bei XY-Charts mit 2 Spalten und bei 3D-BalkenCharts mit mehreren
	 // Datenreihen wichtig.

	 CheckBoxClickHdl( 0 );
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, PreviewDelayHdl, Timer *, pTimer )
{
	DBG_CHKTHIS( SchDiagramAutoPilotDlg, NULL );

	pCT_PREVIEW->Show();
	ScalePreview();
	return 0;
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::FillOutputItemSet()
{
	if( pOutSet )
	{
		if( nShapeType != CHART_SHAPE3D_ANY )
		{
			pOutSet->Put(SfxInt32Item( SCHATTR_STYLE_SHAPE, nShapeType) );
			pOutSet->Put(SfxInt32Item(  CHATTR_STYLE_SHAPE, nShapeType) );
			CHART_TRACE(" SchDiagramAutoPilotDlg::FillOutputItemSet 3D shape Set");
		}
		else
		{
			pOutSet->ClearItem(SCHATTR_STYLE_SHAPE);
			pOutSet->ClearItem(CHATTR_STYLE_SHAPE);
		}
		pOutSet->Put( SvxChartStyleItem( pDoc->ChartStyle(), CHATTR_DIAGRAM_STYLE ) );
		pOutSet->Put( SvxChartLegendPosItem( bShowLegend
												 ? eLegendPos
												 : CHLEGEND_NONE,
											 CHATTR_LEGEND_POS));
		pOutSet->Put( SfxBoolItem( CHATTR_TITLE_SHOW_MAIN, bShowMainTitle ) );
		pOutSet->Put( SfxStringItem( CHATTR_TITLE_MAIN, pDoc->MainTitle() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_TITLE_SHOW_SUB, bShowSubTitle ) );
		pOutSet->Put( SfxStringItem( CHATTR_TITLE_SUB, pDoc->SubTitle() ) );

		pOutSet->Put( SfxBoolItem( CHATTR_TITLE_SHOW_X_AXIS, bShowXAxisTitle ) );
		pOutSet->Put( SfxStringItem( CHATTR_TITLE_X_AXIS, pDoc->XAxisTitle() ) );

		pOutSet->Put( SfxBoolItem( CHATTR_TITLE_SHOW_Y_AXIS, bShowYAxisTitle ) );
		pOutSet->Put( SfxStringItem( CHATTR_TITLE_Y_AXIS, pDoc->YAxisTitle() ) );

		pOutSet->Put( SfxBoolItem( CHATTR_TITLE_SHOW_Z_AXIS, bShowZAxisTitle ) );
		pOutSet->Put( SfxStringItem( CHATTR_TITLE_Z_AXIS, pDoc->ZAxisTitle() ) );

		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_AXIS, pDoc->ShowXAxis() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_MAIN, pDoc->ShowXGridMain() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_HELP, pDoc->ShowXGridHelp() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_DESCR, bShowXDescr ) );

		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_AXIS, pDoc->ShowYAxis() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_MAIN, pDoc->ShowYGridMain() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_HELP, pDoc->ShowYGridHelp() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_DESCR, bShowYDescr ) );

		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_AXIS, pDoc->ShowZAxis() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_MAIN, pDoc->ShowZGridMain() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_HELP, pDoc->ShowZGridHelp() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_DESCR, bShowZDescr ) );

		pOutSet->Put( SfxBoolItem( CHATTR_DATA_SWITCH, pDoc->IsSwitchData() ) );
		pOutSet->Put( SfxBoolItem( CHATTR_AXIS_AUTO_ORIGIN, bYAutoOrigin ) );
	}
}

//------------------------------------------------------------------------------
ChVariant SchDiagramAutoPilotDlg::TranslateFromModel (SvxChartStyle eStyle)
{
	switch( eStyle )
	{
		case CHSTYLE_2D_LINE:
			return CHVARIANT_2D_LINE;

		case CHSTYLE_2D_STACKEDLINE:
			return CHVARIANT_2D_LINE_STACKED;

		case CHSTYLE_2D_PERCENTLINE:
			return CHVARIANT_2D_LINE_PERCENT;

		case CHSTYLE_2D_LINESYMBOLS:
			return CHVARIANT_2D_LINESYMB;

		case CHSTYLE_2D_STACKEDLINESYM:
			return CHVARIANT_2D_LINESYMB_STACKED;

		case CHSTYLE_2D_PERCENTLINESYM:
			return CHVARIANT_2D_LINESYMB_PERCENT;

		case CHSTYLE_2D_COLUMN:
			return CHVARIANT_2D_COLUMN;

        case CHSTYLE_2D_LINE_COLUMN:
            return CHVARIANT_2D_LINE_COLUMN;

        case CHSTYLE_2D_LINE_STACKEDCOLUMN:
            return CHVARIANT_2D_LINE_STACKEDCOLUMN;

		case CHSTYLE_2D_STACKEDCOLUMN:
			return CHVARIANT_2D_COLUMN_STACKED;

		case CHSTYLE_2D_PERCENTCOLUMN:
			return CHVARIANT_2D_COLUMN_PERCENT;

		case CHSTYLE_2D_BAR:
			return CHVARIANT_2D_BAR;

		case CHSTYLE_2D_STACKEDBAR:
			return CHVARIANT_2D_BAR_STACKED;

		case CHSTYLE_2D_PERCENTBAR:
			return CHVARIANT_2D_BAR_PERCENT;

		case CHSTYLE_2D_AREA:
			return CHVARIANT_2D_AREA;

		case CHSTYLE_2D_STACKEDAREA:
			return CHVARIANT_2D_AREA_STACKED;

		case CHSTYLE_2D_PERCENTAREA:
			return CHVARIANT_2D_AREA_PERCENT;

		case CHSTYLE_2D_PIE:
			return CHVARIANT_2D_PIE;

		case CHSTYLE_2D_PIE_SEGOF1:
			return CHVARIANT_2D_PIE_SEGOFS_1;

		case CHSTYLE_2D_PIE_SEGOFALL:
			return CHVARIANT_2D_PIE_SEGOFS_ALL;

		case CHSTYLE_2D_XYSYMBOLS:
			return CHVARIANT_2D_XY_SYMB;

		case CHSTYLE_2D_XY:
			return CHVARIANT_2D_XY;

		case CHSTYLE_2D_XY_LINE:
			return CHVARIANT_2D_XY_LINE;

		case CHSTYLE_2D_NET:
			return CHVARIANT_2D_NET;

		case CHSTYLE_2D_NET_SYMBOLS:
			return CHVARIANT_2D_NETSYMB;

		case CHSTYLE_2D_NET_STACK:
			return CHVARIANT_2D_NET_STACK;

		case CHSTYLE_2D_NET_SYMBOLS_STACK:
			return CHVARIANT_2D_NETSYMB_STACK;

		case CHSTYLE_2D_NET_PERCENT:
			return CHVARIANT_2D_NET_PERCENT;

		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			return CHVARIANT_2D_NETSYMB_PERCENT;

		case CHSTYLE_3D_STRIPE:
			return CHVARIANT_3D_STRIPE;

		case CHSTYLE_3D_COLUMN:
			return CHVARIANT_3D_COLUMN;

		case CHSTYLE_3D_FLATCOLUMN:
			return CHVARIANT_3D_COLUMN_FLAT;

		case CHSTYLE_3D_STACKEDFLATCOLUMN:
			return CHVARIANT_3D_COLUMN_FLAT_STACKED;

		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			return CHVARIANT_3D_COLUMN_FLAT_PERCENT;

		case CHSTYLE_3D_AREA:
			return CHVARIANT_3D_AREA;

		case CHSTYLE_3D_STACKEDAREA:
			return CHVARIANT_3D_AREA_STACKED;
			break;

		case CHSTYLE_3D_PERCENTAREA:
			return CHVARIANT_3D_AREA_PERCENT;

		case CHSTYLE_3D_PIE:
			return CHVARIANT_3D_PIE;

		case CHSTYLE_2D_DONUT1:
			return CHVARIANT_2D_DONUT1;

		case CHSTYLE_2D_DONUT2:
			return CHVARIANT_2D_DONUT2;

		case CHSTYLE_3D_BAR:
			return CHVARIANT_3D_BAR;

		case CHSTYLE_3D_FLATBAR:
			return CHVARIANT_3D_BAR_FLAT;

		case CHSTYLE_3D_STACKEDFLATBAR:
			return CHVARIANT_3D_BAR_FLAT_STACKED;

		case CHSTYLE_3D_PERCENTFLATBAR:
			return CHVARIANT_3D_BAR_FLAT_PERCENT;

		case CHSTYLE_2D_CUBIC_SPLINE :
			return CHVARIANT_2D_CUBIC_SPLINE;

		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
			return CHVARIANT_2D_CUBIC_SPLINE_SYMBOL;

		case CHSTYLE_2D_B_SPLINE :
			return CHVARIANT_2D_B_SPLINE;

		case CHSTYLE_2D_B_SPLINE_SYMBOL :
			return CHVARIANT_2D_B_SPLINE_SYMBOL;

		case CHSTYLE_2D_CUBIC_SPLINE_XY :
			return CHVARIANT_2D_CUBIC_SPLINE_XY;

		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
			return CHVARIANT_2D_CUBIC_SPLINE_SYMBOL_XY;

		case CHSTYLE_2D_B_SPLINE_XY :
			return CHVARIANT_2D_B_SPLINE_XY;

		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			return CHVARIANT_2D_B_SPLINE_SYMBOL_XY;

		case CHSTYLE_2D_STOCK_1:
			return CHVARIANT_2D_STOCK_1;
		case CHSTYLE_2D_STOCK_2:
			return CHVARIANT_2D_STOCK_2;
		case CHSTYLE_2D_STOCK_3:
			return CHVARIANT_2D_STOCK_3;
		case CHSTYLE_2D_STOCK_4:
			return CHVARIANT_2D_STOCK_4;

		default :
			return CHVARIANT_2D_COLUMN;
	}
}

//------------------------------------------------------------------------------
IMPL_LINK( SchDiagramAutoPilotDlg, NoTextClickHdl, Button *, pButton )
{
	bNoText = !aCB_NOTEXT.IsChecked ();
	BuildChart();
	pCT_PREVIEW->Invalidate();
	return 0;
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::NewAxisText( const ChType & eOldType,
                                          const ChType & eNewType,
                                          bool bChangeRowCol )
{
    // change x-axis title for scatter charts (XY)
    if( IsXAxisTitleDefault( eOldType == CHTYPE_2D_XY ))
    {
        String aTitle;

        if( eNewType == CHTYPE_2D_XY )
        {
            if( bChangeRowCol )
                aTitle = pDoc->ColText( 0 );
            else
                aTitle = pDoc->RowText( 0 );
        }
        else
            aTitle = String( SchResId( STR_DIAGRAM_TITLE_X_AXIS ) );

        pET_3_TEXTRUBRIK->SetText( aTitle );
        pET_3_TEXTRUBRIK->ClearModifyFlag();
        pDoc->XAxisTitle() = aTitle;
    }
}

//------------------------------------------------------------------------------
void SchDiagramAutoPilotDlg::ChangeColRow ()
{
	BOOL bVal = pDoc->IsSwitchData();

	BOOL bOldVal=bVal;

	int number_of_columns = pDoc->GetColCount();
	int number_of_rows    = pDoc->GetRowCount();

// [FG] SwitchData ist eine Funktion, die nur ein BOOLEAN gleich TRUE oder FALSE setzt
//      In diesem Fall werden die Daten nicht kopiert, sondern die Fuktionen liefern in Abhaengigkeit dieses
//      Schalters Daten zurueck. Mit anderen Worten falls, SwitchData=TRUE dann werden die Daten nur
//      "geswitched" interpretiert und nicht wirklich geswitched. Eine einmal getroffene Einstellung muss
//      beibehalten werden.

	//   [TVM] Kommentar und Code bleiben mir ein absolutes Raetsel....

   if (pDoc->GetColCount () == 1)
	{
		bVal = FALSE;
		pDoc->SetSwitchData (FALSE);
	}
	else if ((pDoc->GetRowCount () == 1) || ((pDoc->GetColCount () == 2) && (pDoc->GetRowCount () >= 4)))
		 {
			 bVal = TRUE;
			 pDoc->SetSwitchData (TRUE);
		 }


	aRB_DATAROWS.Check( ! bVal );
	aRB_DATACOLS.Check( bVal );

	//eventuell muss nun anders reduziert werden,siehe ChangeChartData()
	if(bVal != bOldVal)
		ReduceDataAgain();
}

void SchDiagramAutoPilotDlg::FillValueSets()
{
    bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );

    // primary chart type
    if( pCT_1_CHARTTYPE->GetItemCount() == 0 )
    {
        // 2D
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_LINE, SELECT_BITMAP( BMP_LINES_2D ),
                                     String( SchResId( STR_LINES )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_AREA, SELECT_BITMAP( BMP_AREAS_2D ),
                                     String(SchResId(STR_AREAS)));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_COLUMN, SELECT_BITMAP( BMP_COLUMNS_2D ),
                                     String( SchResId( STR_COLUMNS )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_BAR, SELECT_BITMAP( BMP_BARS_2D ),
                                     String( SchResId( STR_BARS )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_PIE, SELECT_BITMAP( BMP_CIRCLES_2D ),
                                     String( SchResId( STR_CIRCLES )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_XY, SELECT_BITMAP( BMP_XYSYMB_2D ),
                                     String( SchResId( STR_XY )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_NET, SELECT_BITMAP( BMP_NET_2D ),
                                     String( SchResId( STR_NET )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_2D_STOCK, SELECT_BITMAP( BMP_STOCK_2 ),
                                     String( SchResId( STR_STOCK )));
	    // 3D
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_3D_STRIPE, SELECT_BITMAP( BMP_LINES_3D ),
                                     String( SchResId( STR_LINES )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_3D_AREA, SELECT_BITMAP( BMP_AREAS_3D_1 ),
                                     String( SchResId( STR_AREAS )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_3D_BAR, SELECT_BITMAP( BMP_BARS_3D_1 ),
                                     String( SchResId( STR_BARS )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_3D_COLUMN, SELECT_BITMAP( BMP_COLUMNS_3D_1 ),
                                     String( SchResId( STR_COLUMNS )));
	    pCT_1_CHARTTYPE->InsertItem( CHTYPE_3D_PIE, SELECT_BITMAP( BMP_CIRCLES_3D ),
                                     String( SchResId( STR_CIRCLES )));
    }
    else
    {
        // 2D
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_LINE, SELECT_BITMAP( BMP_LINES_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_AREA, SELECT_BITMAP( BMP_AREAS_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_COLUMN, SELECT_BITMAP( BMP_COLUMNS_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_BAR, SELECT_BITMAP( BMP_BARS_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_PIE, SELECT_BITMAP( BMP_CIRCLES_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_XY, SELECT_BITMAP( BMP_XYSYMB_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_NET, SELECT_BITMAP( BMP_NET_2D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_2D_STOCK, SELECT_BITMAP( BMP_STOCK_2 ));
	    // 3D
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_3D_STRIPE, SELECT_BITMAP( BMP_LINES_3D ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_3D_AREA, SELECT_BITMAP( BMP_AREAS_3D_1 ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_3D_BAR, SELECT_BITMAP( BMP_BARS_3D_1 ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_3D_COLUMN, SELECT_BITMAP( BMP_COLUMNS_3D_1 ));
	    pCT_1_CHARTTYPE->SetItemImage( CHTYPE_3D_PIE, SELECT_BITMAP( BMP_CIRCLES_3D ));
    }

    // sub-type
    USHORT nId = pCT_1_CHARTTYPE->GetSelectItemId();
    if( nId != 0 )
    {
        SelectVariantSet( static_cast< ChType >( nId ), CHVARIANT_INVALID );
    }
}

void SchDiagramAutoPilotDlg::DataChanged( const DataChangedEvent& rDCEvt )
{
    ModalDialog::DataChanged( rDCEvt );

    if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
        FillValueSets();
}

bool SchDiagramAutoPilotDlg::IsXAxisTitleDefault( bool bIsXYChart ) const
{
    return bIsXYChart
        ? ( pDoc->RowText( 0 ) == pET_3_TEXTRUBRIK->GetText() )
        : ( String( SchResId( STR_DIAGRAM_TITLE_X_AXIS )) == pET_3_TEXTRUBRIK->GetText() );
}
