/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: title.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:06:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif


#include "title.hrc"
#include "axisgrid.hrc"

#include "schresid.hxx"
#include "schdll.hxx"
#include "title.hxx"
#include <sfx2/sfx.hrc>


/*************************************************************************
|*
|* Dialog zum Aendern des Titels
|*
\************************************************************************/

SchTitleDlg::SchTitleDlg(Window* pWindow, const SfxItemSet& rInAttrs,
						 BOOL bAxis, BOOL b3D) :
	ModalDialog(pWindow, SchResId(DLG_TITLE)),
	aCbxMain(this, ResId(CBX_MAINTITLE)),
	aEdtMain(this, ResId(EDT_MAINTITLE)),
	aCbxSub(this, ResId(CBX_SUBTITLE)),
	aEdtSub(this, ResId(EDT_SUBTITLE)),
	aCbxXAxis(this, ResId(CBX_TITLE_X_AXIS)),
	aEdtXAxis(this, ResId(EDT_X_AXIS)),
	aCbxYAxis(this, ResId(CBX_TITLE_Y_AXIS)),
	aEdtYAxis(this, ResId(EDT_Y_AXIS)),
	aCbxZAxis(this, ResId(CBX_TITLE_Z_AXIS)),
	aEdtZAxis(this, ResId(EDT_Z_AXIS)),
	aBtnOK(this, ResId(BTN_OK)),
	aBtnCancel(this, ResId(BTN_CANCEL)),
	aBtnHelp(this, ResId(BTN_HELP)),
	rOutAttrs(rInAttrs)
{
	FreeResource();

	aCbxMain.SetClickHdl(LINK(this, SchTitleDlg, EnableTitleHdl));
	aCbxSub.SetClickHdl(LINK(this, SchTitleDlg, EnableTitleHdl));

	if (bAxis)
	{
		aCbxXAxis.SetClickHdl(LINK(this, SchTitleDlg, EnableTitleHdl));
		aCbxYAxis.SetClickHdl(LINK(this, SchTitleDlg, EnableTitleHdl));

		if (b3D)
			aCbxZAxis.SetClickHdl(LINK(this, SchTitleDlg, EnableTitleHdl));
		else
		{
			aCbxZAxis.Disable();
			aEdtZAxis.Disable();
		}
	}
	else
	{
		aCbxXAxis.Disable();
		aEdtXAxis.Disable();
		aCbxYAxis.Disable();
		aEdtYAxis.Disable();
		aCbxZAxis.Disable();
		aEdtZAxis.Disable();
	}

	Reset();
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SchTitleDlg::~SchTitleDlg()
{
}

/*************************************************************************
|*
|*	Titel-Editierfelder je nach Checkbox-Markierung enablen/disablen
|*
*************************************************************************/

IMPL_LINK( SchTitleDlg, EnableTitleHdl, CheckBox *, pCbx )
{
	if (pCbx == &aCbxMain)
	{
		aEdtMain.Enable(aCbxMain.IsChecked());
	}
	else if (pCbx == &aCbxSub)
	{
		aEdtSub.Enable(aCbxSub.IsChecked());
	}
	else if (pCbx == &aCbxXAxis)
	{
		aEdtXAxis.Enable(aCbxXAxis.IsChecked());
	}
	else if (pCbx == &aCbxYAxis)
	{
		aEdtYAxis.Enable(aCbxYAxis.IsChecked());
	}
	else if (pCbx == &aCbxZAxis)
	{
		aEdtZAxis.Enable(aCbxZAxis.IsChecked());
	}
	return 0;
}

/*************************************************************************
|*
|*	Initialisierung
|*
*************************************************************************/

void SchTitleDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if (rOutAttrs.GetItemState(CHATTR_TITLE_SHOW_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxMain.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
	if (rOutAttrs.GetItemState(CHATTR_TITLE_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aEdtMain.SetText(((const SfxStringItem*) pPoolItem)->GetValue());
	EnableTitleHdl(&aCbxMain);

	if (rOutAttrs.GetItemState(CHATTR_TITLE_SHOW_SUB, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxSub.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
	if (rOutAttrs.GetItemState(CHATTR_TITLE_SUB, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aEdtSub.SetText(((const SfxStringItem*) pPoolItem)->GetValue());
	EnableTitleHdl(&aCbxSub);

	if (aCbxXAxis.IsEnabled())
	{
		if (rOutAttrs.GetItemState(CHATTR_TITLE_SHOW_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aCbxXAxis.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
		if (rOutAttrs.GetItemState(CHATTR_TITLE_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aEdtXAxis.SetText(((const SfxStringItem*) pPoolItem)->GetValue());
		EnableTitleHdl(&aCbxXAxis);
	}

	if (aCbxYAxis.IsEnabled())
	{
		if (rOutAttrs.GetItemState(CHATTR_TITLE_SHOW_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aCbxYAxis.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
		if (rOutAttrs.GetItemState(CHATTR_TITLE_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aEdtYAxis.SetText(((const SfxStringItem*) pPoolItem)->GetValue());
		EnableTitleHdl(&aCbxYAxis);
	}

	if (aCbxZAxis.IsEnabled())
	{
		if (rOutAttrs.GetItemState(CHATTR_TITLE_SHOW_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aCbxZAxis.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
		if (rOutAttrs.GetItemState(CHATTR_TITLE_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
			aEdtZAxis.SetText(((const SfxStringItem*) pPoolItem)->GetValue());
		EnableTitleHdl(&aCbxZAxis);
	}
}

/*************************************************************************
|*
|*    Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
*************************************************************************/

void SchTitleDlg::GetAttr(SfxItemSet& rOutAttrs)
{
	rOutAttrs.Put(SfxBoolItem(CHATTR_TITLE_SHOW_MAIN, aCbxMain.IsChecked()));
	rOutAttrs.Put(SfxStringItem(CHATTR_TITLE_MAIN, aEdtMain.GetText()));
	rOutAttrs.Put(SfxBoolItem(CHATTR_TITLE_SHOW_SUB, aCbxSub.IsChecked()));
	rOutAttrs.Put(SfxStringItem(CHATTR_TITLE_SUB, aEdtSub.GetText()));

	if (aCbxXAxis.IsEnabled())
	{
		rOutAttrs.Put(SfxBoolItem(CHATTR_TITLE_SHOW_X_AXIS, aCbxXAxis.IsChecked()));
		rOutAttrs.Put(SfxStringItem(CHATTR_TITLE_X_AXIS, aEdtXAxis.GetText()));
	}

	if (aCbxYAxis.IsEnabled())
	{
		rOutAttrs.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Y_AXIS, aCbxYAxis.IsChecked()));
		rOutAttrs.Put(SfxStringItem(CHATTR_TITLE_Y_AXIS, aEdtYAxis.GetText()));
	}

	if (aCbxZAxis.IsEnabled())
	{
		rOutAttrs.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Z_AXIS, aCbxZAxis.IsChecked()));
		rOutAttrs.Put(SfxStringItem(CHATTR_TITLE_Z_AXIS, aEdtZAxis.GetText()));
	}
}



