/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: untitle.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:04:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UNTITLE_HXX
#define _SCH_UNTITLE_HXX

#include "undoattr.hxx"

/*************************************************************************
|*
|* Undo fuer Titel
|*
\************************************************************************/

class SchUndoTitle : public SchUndoAttr
{
private:
	UINT16 nTitleId;
	SfxItemSet *pOldMainTitleAttr;
	SfxItemSet *pOldSubTitleAttr;
	SfxItemSet *pOldXAxisTitleAttr;
	SfxItemSet *pOldYAxisTitleAttr;
	SfxItemSet *pOldZAxisTitleAttr;

public:
	TYPEINFO();

	SchUndoTitle(ChartModel& rChDoc, UINT16 nId,
				 const SfxItemSet& rOldMainAttr,
				 const SfxItemSet& rOldSubAttr,
				 const SfxItemSet& rOldXAxisAttr,
				 const SfxItemSet& rOldYAxisAttr,
				 const SfxItemSet& rOldZAxisAttr,
				 const SfxItemSet& rOldAttr,
				 const SfxItemSet& rNewAttr);
	virtual ~SchUndoTitle();

	virtual void Undo();
	virtual void Redo();

	virtual void Repeat(SfxRepeatTarget& rView);
	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;
};

#endif	// _SCH_UNTITLE_HXX

