/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshel.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 15:04:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#ifndef _B3D_BASE3D_HXX
#include <goodies/base3d.hxx>
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>

#include <svtools/style.hrc>
#include <svx/dialogs.hrc>

#include "res_bmp.hrc"
#include "viewshel.hxx"
#include "chwindow.hxx"
#include "schview.hxx"
#include "docshell.hxx"
#include "fupoor.hxx"
#include "eetext.hxx"

#include "AccessibleDocumentView.hxx"

/*************************************************************************
|*
|* Diese Methode deaktiviert und loescht die aktuelle Funktion. Falls es
|* eine alte Funktion gibt, wird sie als aktuelle Funktion eingesetzt und
|* aktiviert.
|*
\************************************************************************/

void SchViewShell::Cancel()
{
	if (pFuActual)
	{
		SchFuPoor* pTemp = pFuActual;
		pFuActual	  = NULL;
		pTemp->Deactivate();
		delete pTemp;
	}

	if (pFuOld)
	{
		pFuActual = pFuOld;
		pFuActual->Activate();
	}
}

/*************************************************************************
|*
|* Aktivierung: Arbeitsfenster den Fokus zuweisen
|*
\************************************************************************/

void SchViewShell::Activate(BOOL bIsMDIActivate)
{
    SfxViewShell::Activate(bIsMDIActivate);
	bFirstStart = FALSE;

	if (pFuActual)
		pFuActual->Activate();

	pChView->UpdateSelectionClipboard( FALSE );

    // notify accessible document view
    SchWindow* pWin = GetWindow();
    if( pWin )
    {
        ::accessibility::AccessibleDocumentView * pAccDocView =
              pWin->GetAccessibleDocumentView();

        if( pAccDocView )
        {
            pAccDocView->GainFocus();
        }
    }
}

/*************************************************************************
|*
|* Deaktivierung
|*
\************************************************************************/

void SchViewShell::Deactivate(BOOL bIsMDIActivate)
{
    if (pFuActual)
		pFuActual->Deactivate();

	if (bIsMDIActivate) GetView()->SdrEndTextEdit(sal_True);

	SfxViewShell::Deactivate(bIsMDIActivate);

    // notify accessible document view
    SchWindow* pWin = GetWindow();
    if( pWin )
    {
        ::accessibility::AccessibleDocumentView * pAccDocView =
              pWin->GetAccessibleDocumentView();

        if( pAccDocView )
        {
            pAccDocView->LoseFocus();
        }
    }
}

/*************************************************************************
|*
|* innere Groessenanpassung
|*
\************************************************************************/

void SchViewShell::InnerResizePixel(const Point &rOfs, const Size &rSize)
{
    if( ! (rSize.Width()>1 && rSize.Height()>1) ) //#i36001#
        return;

	SchWindow* pWin = GetWindow();
    Size aObjSize = GetObjectShell()->GetVisArea().GetSize();
    if ( aObjSize.Width() > 0 && aObjSize.Height() > 0 )
    {
        Size aObjSizePixel = GetWindow()->LogicToPixel( aObjSize, MAP_100TH_MM );
        SfxViewShell::SetZoomFactor( Fraction( rSize.Width(), aObjSizePixel.Width() ),
                        Fraction( rSize.Height(), aObjSizePixel.Height() ) );
    }

    Size aViewSize( pWin->PixelToLogic(rSize) );
    pWin->SetViewSize( aViewSize );
	SetBorderPixel(SvBorder());
	GetView()->SetWorkArea(GetWindow()->PixelToLogic(Rectangle(Point(0,0), rSize)));
}

/*************************************************************************
|*
|* aeussere Groessenanpassung
|*
\************************************************************************/

void SchViewShell::OuterResizePixel(const Point &rOfs, const Size &rSize)
{
	SchWindow* pWin = GetWindow();
	pWin->SetViewSize(pWin->PixelToLogic(rSize));

	SetBorderPixel(SvBorder());

	Rectangle aLogicRect = GetWindow()->PixelToLogic(Rectangle(rOfs, rSize));
	Size aSize           = GetWindow ()->GetSizePixel ();
	Size aOutputSize     = GetWindow ()->GetOutputSizePixel ();

	if (aSize.Width () <= 50 && aSize.Height () <= 50 ||
	aOutputSize.Width () <= 50 && aOutputSize.Height () <= 50) aLogicRect = Rectangle ();

	((SchChartDocShell*)GetViewFrame()->GetObjectShell())->SetVisArea(aLogicRect);
	GetView()->SetWorkArea(aLogicRect);
}

/*************************************************************************
|*
|* Nur fuer MAC !?
|*
\************************************************************************/

Size SchViewShell::GetOptimalSizePixel() const
{
	return Size(560, 320);
}

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

FASTBOOL SchViewShell::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = SfxViewShell::KeyInput(rKEvt);


	if (!bReturn)
	{
		if (pFuActual)
			bReturn = pFuActual->KeyInput(rKEvt);

		if (!bReturn && GetWindow())
		{
			KeyCode aKeyCode = rKEvt.GetKeyCode();

			if (aKeyCode.IsMod1() && aKeyCode.IsShift()
				&& aKeyCode.GetCode() == KEY_R)
			{
				 // 3D-Kontext wieder zerstoeren
				Base3D* pBase3D = (Base3D*) GetWindow()->Get3DContext();

				if (pBase3D)
				{
					pBase3D->Destroy(GetWindow());
				}
				GetWindow()->Invalidate();
				bReturn = TRUE;
			}
		}
	}

	return bReturn;
}

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

FASTBOOL SchViewShell::MouseButtonDown(const MouseEvent& rMEvt)
{
	if ( MOUSE_LEFT == rMEvt.GetButtons() )
		GetWindow()->GrabFocus();
	if (pFuActual)
	{
		pFuActual->SetWindow(GetWindow());
		return pFuActual->MouseButtonDown(rMEvt);
	}

	return FALSE;
}

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

FASTBOOL SchViewShell::MouseMove(const MouseEvent& rMEvt)
{
	if (pFuActual)
	{
		pFuActual->SetWindow(GetWindow());
		return pFuActual->MouseMove(rMEvt);
	}

	return FALSE;
}

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

FASTBOOL SchViewShell::MouseButtonUp(const MouseEvent& rMEvt)
{
	if (pFuActual)
	{
		pFuActual->SetWindow(GetWindow());
		return pFuActual->MouseButtonUp(rMEvt);
	}

	return FALSE;
}

/*************************************************************************
|*
|* Den Zoomfaktor setzen
|*
\************************************************************************/

void SchViewShell::SetZoom(long nZoom)
{
	GetWindow()->SetZoom(nZoom);
}

/*************************************************************************
|*
|* ObjectBar umschalten, ResourceID der alten ObjectBar-ID zurueckgeben
|*
\************************************************************************/

USHORT SchViewShell::SwitchObjectBar(USHORT nResId)
{
	USHORT nReturn = nCurrentObjectBar;

	// muss Object Bar gewechselt werden?
	if (nCurrentObjectBar != nResId && bObjectBarSwitchEnabled)
	{
		// SfxDispatcher* pDispatcher = GetViewFrame()->GetDispatcher();

		if (nCurrentObjectBar)
		{
			// pDispatcher->Pop(*(SfxShell*)aShellTable.Get(nCurrentObjectBar));
			SetSubShell( NULL );
		}

		nCurrentObjectBar = nResId;

		if (nCurrentObjectBar)
		{
			// pDispatcher->Push(*(SfxShell*)aShellTable.Get(nCurrentObjectBar));
			SetSubShell( (SfxShell*) aShellTable.Get( nCurrentObjectBar ) );
		}
	}
	return nReturn;
}

/*************************************************************************
|*
|* Auf allen Split-Windows ein Markierungsrechteck zeichnen
|*
\************************************************************************/

//void SchViewShell::DrawMarkRect(const Rectangle& rRect, const Color& rColor )
//{
//	SchWindow* pWin = GetWindow();
//
//	RasterOp aROp = pWin->GetRasterOp();
//	pWin->SetRasterOp(ROP_INVERT);
//
//	Color aOldLineColor( pWin->GetLineColor() );
//	pWin->SetLineColor( rColor );
//	Color aOldFillColor( pWin->GetFillColor() );
//	pWin->SetFillColor();
//	pWin->DrawRect(rRect);
//	pWin->SetRasterOp(aROp);
//	pWin->SetLineColor( aOldLineColor );
//	pWin->SetFillColor( aOldFillColor );
//}

/*************************************************************************
|*
|* Auf allen Split-Windows ein Rechteck zeichnen.
|*
\************************************************************************/

void SchViewShell::DrawFilledRect(const Rectangle& rRect, const Color& rColor,
								 const Color& rFillColor ) const
{
	SchWindow* pWin = GetWindow();

	Color aOldLineColor( pWin->GetLineColor() );
	Color aOldFillColor( pWin->GetFillColor() );
	pWin->SetLineColor( rColor );
	pWin->SetFillColor( rFillColor );

	pWin->DrawRect(rRect);

	pWin->SetLineColor( aOldLineColor );
	pWin->SetFillColor( aOldFillColor );
}

/*************************************************************************
|*
|* Zoom-Faktor fuer InPlace einstellen
|*
\************************************************************************/

void SchViewShell::SetZoomFactor(const Fraction& rZoomX,
								 const Fraction& rZoomY)
{
    SfxViewShell::SetZoomFactor( rZoomX, rZoomY );
    //long nZoom = (long)((double) rZoomX * 100);
    //SetZoom(nZoom);
}


// ========================================
// DropTargetHelper for drag and drop
// ========================================

sal_Int8 SchViewShell::AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin )
{
	if( pChView )
		return pChView->AcceptDrop( rEvt, pWin );

	return DND_ACTION_NONE;
}

sal_Int8 SchViewShell::ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin )
{
	if( pChView )
		return pChView->ExecuteDrop( rEvt, pWin );

	return DND_ACTION_NONE;
}
