/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shapeeventbroadcaster.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 16:01:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#if ! defined(INCLUDED_SLIDESHOW_SHAPEEVENTBROADCASTER_HXX)
#define INCLUDED_SLIDESHOW_SHAPEEVENTBROADCASTER_HXX

#include <osl/mutex.hxx>
#include <cppuhelper/interfacecontainer.h>
#include <com/sun/star/presentation/XShapeEventListener.hpp>

#include "shape.hxx"
#include "eventmultiplexer.hxx"
#include "mouseeventhandler.hxx"

#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>
#include <set>
#include <map>

namespace slideshow {
namespace internal {

/** Listener class for shape events
    
    This helper class registers itself on each view, and 
    broadcasts the XShapeEventListener events. The mouse motion
    events are needed for setting the shape cursor.
*/
class ShapeEventBroadcaster : public MouseEventHandler,
                              public boost::enable_shared_from_this<ShapeEventBroadcaster>
{
public:
    /** Create a shape event broadcaster
        
        @param rEventMultiplexer
        The slideshow-global event source, where this class
        registeres its event handlers.
    */
    ShapeEventBroadcaster( EventMultiplexer & rMultiplexer );

    void addHyperlinkShape( ShapeSharedPtr const& pShape );
    void removeHyperlinkShape( ShapeSharedPtr const& pShape );
    
    void addShapeEventListener(
        ::com::sun::star::uno::Reference< 
        ::com::sun::star::presentation::XShapeEventListener > const& xListener, 
        const ShapeSharedPtr&                                        rShape );
    
    void removeShapeEventListener(
        ::com::sun::star::uno::Reference< 
        ::com::sun::star::presentation::XShapeEventListener > const& xListener, 
        const ShapeSharedPtr&                                        rShape );
    
    void setShapeCursor( const ShapeSharedPtr&  rShape, 
                         sal_Int16              nPointerShape );
    
    /** Set a new current slide index.
        
        The slide index is used when notifying shape clicks,
        as a parameter of the XShapeEventListener::click() call.
    */
    void setSlideIndex( sal_Int32 nNewIndex );

    /** Enables event broadcasting.
     */
    void enable();
    
    /** Disables event broadcasting.
     */
    void disable();
    
    /** Dispose necessary to release the whole object, thus I would favour
        declaring shared_ptr a friend of this class and making the dtor private,
        BUT templates are still somehow problematic these days...
    */
    virtual void dispose();
    
private:
    virtual bool handleMousePressed(
        ::com::sun::star::awt::MouseEvent const& evt );
    virtual bool handleMouseReleased(
        ::com::sun::star::awt::MouseEvent const& evt );
    virtual bool handleMouseEntered(
        ::com::sun::star::awt::MouseEvent const& evt );
    virtual bool handleMouseExited(
        ::com::sun::star::awt::MouseEvent const& evt );
    virtual bool handleMouseDragged(
        ::com::sun::star::awt::MouseEvent const& evt );
    virtual bool handleMouseMoved(
        ::com::sun::star::awt::MouseEvent const& evt );

    ::rtl::OUString checkForHyperlink( ::basegfx::B2DPoint const& hitPos )const;
    
    
    typedef std::map<ShapeSharedPtr,
                     boost::shared_ptr< ::cppu::OInterfaceContainerHelper >,
                     Shape::lessThanShape> ShapeToListenersMap;
    typedef ::std::map<ShapeSharedPtr, sal_Int16,
                       Shape::lessThanShape> ShapeToCursorMap;
    typedef ::std::set<ShapeSharedPtr, Shape::lessThanShape> ShapeSet;

    mutable ::osl::Mutex m_mutex;
    EventMultiplexer&    m_rMultiplexer;
    ShapeToListenersMap  m_shapeToListeners;
    ShapeToCursorMap     m_shapeToCursor;
    ShapeSet             m_hyperlinkShapes;
    bool                 m_bEnabled;
};

} // namespace internal
} // namespace presentation

#endif /* INCLUDED_SLIDESHOW_SHAPEEVENTBROADCASTER_HXX */
