/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: optionsdrawinglayer.hxx,v $
 *
 *  $Revision: 1.2.60.1 $
 *
 *  last change: $Author: obo $ $Date: 2007/02/08 13:01:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SVTOOLS_OPTIONSDRAWINGLAYER_HXX
#define INCLUDED_SVTOOLS_OPTIONSDRAWINGLAYER_HXX

//_________________________________________________________________________________________________________________
//	includes
//_________________________________________________________________________________________________________________

#ifndef INCLUDED_SVLDLLAPI_H
#include "svtools/svldllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif

//_________________________________________________________________________________________________________________
//	forward declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short			forward declaration to our private date container implementation
	@descr			We use these class as internal member to support small memory requirements.
					You can create the container if it is neccessary. The class which use these mechanism
					is faster and smaller then a complete implementation!
*//*-*************************************************************************************************************/

class SvtOptionsDrawinglayer_Impl;

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short			collect informations about startup features
	@descr          -

	@implements		-
	@base			-

	@devstatus		ready to use
*//*-*************************************************************************************************************/

class SVL_DLLPUBLIC SvtOptionsDrawinglayer
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------

	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		standard constructor and destructor
			@descr		This will initialize an instance with default values.
						We implement these class with a refcount mechanism! Every instance of this class increase it
						at create and decrease it at delete time - but all instances use the same data container!
						He is implemented as a static member ...

			@seealso	member m_nRefCount
			@seealso	member m_pDataContainer

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

         SvtOptionsDrawinglayer();
        ~SvtOptionsDrawinglayer();

		//---------------------------------------------------------------------------------------------------------
		//	interface
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		interface methods to get and set value of config key "org.openoffice.Office.Common/Drawinglayer/..."
			@descr      These options describe internal states to enable/disable features of installed office.

						IsOverlayBuffer()
						SetOverlayBuffer()		=>	Activate this field for letting Overlay use a buffer

						IsPaintBuffer()
						SetPaintBuffer()		=>	Activate this field for letting Paint use a prerender buffer

						GetStripeColorA()
						SetStripeColorA()		=>	Set first of two colors which overlay uses to draw stripes

						GetStripeColorB()
						SetStripeColorB()		=>	Set second of two colors which overlay uses to draw stripes

						GetStripeLength()
						SetStripeLength()		=>	Set length of a single stripe in pixels

			@seealso	configuration package "org.openoffice.Office.Common/Drawinglayer"
		*//*-*****************************************************************************************************/

		sal_Bool	IsOverlayBuffer() const;
		sal_Bool	IsPaintBuffer() const;
		Color		GetStripeColorA() const;
		Color		GetStripeColorB() const;
		sal_uInt16	GetStripeLength() const;

		// #i73602#
		sal_Bool	IsOverlayBuffer_Calc() const;
		sal_Bool	IsOverlayBuffer_Writer() const;
		sal_Bool	IsOverlayBuffer_DrawImpress() const;

		void		SetOverlayBuffer( sal_Bool bState );
		void		SetPaintBuffer( sal_Bool bState );
		void		SetStripeColorA( Color aColor );
		void		SetStripeColorB( Color aColor );
		void		SetStripeLength( sal_uInt16 nLength );

		// #i73602#
		void		SetOverlayBuffer_Calc( sal_Bool bState );
		void		SetOverlayBuffer_Writer( sal_Bool bState );
		void		SetOverlayBuffer_DrawImpress( sal_Bool bState );

	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------

    private:

		/*-****************************************************************************************************//**
			@short		return a reference to a static mutex
			@descr		These class use his own static mutex to be threadsafe.
						We create a static mutex only for one ime and use at different times.

			@seealso	-

			@param		-
			@return		A reference to a static mutex member.

			@onerror	-
		*//*-*****************************************************************************************************/
		SVL_DLLPRIVATE static ::osl::Mutex& GetOwnStaticMutex();

	//-------------------------------------------------------------------------------------------------------------
	//	private member
	//-------------------------------------------------------------------------------------------------------------

	private:

		/*Attention

			Don't initialize these static member in these header!
			a) Double dfined symbols will be detected ...
			b) and unresolved externals exist at linking time.
			Do it in your source only.
		 */

    	static SvtOptionsDrawinglayer_Impl*		m_pDataContainer	;	/// impl. data container as dynamic pointer for smaller memory requirements!
		static sal_Int32						m_nRefCount			;	/// internal ref count mechanism

};		// class SvtOptionsDrawinglayer

#endif	// #ifndef INCLUDED_SVTOOLS_OPTIONSDRAWINGLAYER_HXX
