/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ainfoscrolltext.hxx,v $
 *
 *  $Revision: 1.5.70.1 $
 *
 *  last change: $Author: kz $ $Date: 2007/01/24 13:33:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_AINFOSCROLLTEXT_HXX
#define _SDR_ANIMATION_AINFOSCROLLTEXT_HXX

#ifndef _SDR_ANIMATION_AINFOTEXT_HXX
#include <svx/sdr/animation/ainfotext.hxx>
#endif

#ifndef _SDTADITM_HXX
#include <sdtaditm.hxx>
#endif

#include <vector>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class GDIMetaFile;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// #i38135# Reorganisation of AInfoScrollText
		class ScrollTextAnimNode
		{
			sal_uInt32						mnDuration; // single duration
			sal_uInt32						mnRepeat; // 0 -> endless
			double							mfStart;
			double							mfStop;
			sal_uInt32						mnFrequency; // in ms
			bool							mbAlternate; // forth and back change at mnRepeat%2

		public:
			// #i71035# moved implementation to cxx
			ScrollTextAnimNode(sal_uInt32 nDuration, sal_uInt32 nRepeat, double fStart, double fStop, sal_uInt32 nFrequency, bool bAlternate);
			
			sal_uInt32 GetDuration() const { return mnDuration; }
			sal_uInt32 GetRepeat() const { return mnRepeat; }
			sal_uInt32 GetFullTime() const { return mnDuration * mnRepeat; }
			double GetStart() const { return mfStart; }
			double GetStop() const { return mfStop; }
			sal_uInt32 GetFrequency() const { return mnFrequency; }
			bool DoAlternate() const { return mbAlternate; }

			double GetStateAtRelativeTime(sal_uInt32 nRelativeTime) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// #i38135# Reorganisation of AInfoScrollText
		class AInfoScrollText : public AInfoBlinkText
		{
		private:
			// The single anim steps
			::std::vector< ScrollTextAnimNode >		maVector;

			// The AnimationDirection
			SdrTextAniDirection						meDirection;

			// Get width per Step. Negative means pixel, positive logical units
			sal_Int32								mnStepWidth;

			// the scroll rectangle
			Rectangle								maScrollRectangleLogic;

			// the paint rectangle
			Rectangle								maPaintRectangleLogic;

			// The text MetaFile
			GDIMetaFile*							mpMetaFile;

			// scaling value for internal ToLogic and ToPixel. Inited to 1.0
			double									mfPixelToLogic;

			// start time for this animation
			sal_uInt32								mnStartTime;

			// bitfield
			// Flag decides if TextScroll alternates. Default is sal_False.
			unsigned								mbAlternate : 1;

			// Flag to remember if mfPixelToLogic is set
			unsigned								mbPixelToLogicIsSet : 1;

			// Flag to remember if this is a simple scrollin text
			unsigned								mbScrollIn : 1;

			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer*			CreateBasicMixer();

		protected:
			// local initializations
			void ImplInit();

			// Scroll helper methods
			void ImpForceScrollTextAnimNodes();
			ScrollTextAnimNode* ImpGetScrollTextAnimNode(sal_uInt32 nTime, sal_uInt32& rRelativeTime);
			double ImpGetScrollTextMixerState(sal_uInt32 nTime);
			sal_uInt32 ImpRegisterAgainScrollTextMixerState(sal_uInt32 nTime);

			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const;

		public:
			// basic constructor.
			AInfoScrollText(SdrObject& rObject, sal_uInt32 nDefaultFrequency = 50L);

			// destructor
			virtual ~AInfoScrollText();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;

			// React on changes of the object of this AnimationInfo.
			virtual void ActionChanged();

			// access to rectangles
			const Rectangle& GetScrollRectangleLogic() const;
			const Rectangle& GetPaintRectangleLogic() const;

			// access to MetaFile
			GDIMetaFile* GetTextMetaFile() const;

			// scroll horizontal? if sal_False, scroll is vertical.
			sal_Bool ScrollHorizontal() const;

			// Access to StepWidth in logical units
			// #i71337# changing interface to allow handover of minimum return value
			sal_uInt32 GetStepWidthLogic(sal_uInt32 nMinimum) const;

			// is the animation direction opposite?
			sal_Bool DoScrollForward() const;

			// do alternate text directions?
			sal_Bool DoAlternate() const;

			// do scroll in?
			sal_Bool DoScrollIn() const;

			// set the scaling value
			void InitScaling(sdr::contact::DisplayInfo& rDisplayInfo) const;

			// is scale value set?
			sal_Bool IsScalingInitialized() const;

			// convert Logic->Pixel
			sal_Int32 ToPixel(sal_Int32 nValue) const;

			// convert Pixel->Logic
			sal_Int32 ToLogic(sal_Int32 nValue) const;

			// #i71337#
			// overload to react on a scroll text which
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_AINFOSCROLLTEXT_HXX

// eof
