/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vnew.cxx,v $
 *
 *  $Revision: 1.25.136.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 14:10:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _VIEWSH_HXX
#include <viewsh.hxx>
#endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>
#endif
#ifndef _VIEWIMP_HXX
#include <viewimp.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
#ifndef _TXTFRM_HXX
#include <txtfrm.hxx>		// Zugriff auf TxtCache
#endif
#ifndef _NOTXTFRM_HXX
#include <notxtfrm.hxx>
#endif
#ifndef _FNTCACHE_HXX
#include <fntcache.hxx>
#endif
#ifndef _DOCUFLD_HXX
#include <docufld.hxx>
#endif
#ifndef _PTQUEUE_HXX
#include <ptqueue.hxx>
#endif
#ifndef _DVIEW_HXX
#include <dview.hxx>		// SdrView
#endif
#ifndef _NDGRF_HXX
#include <ndgrf.hxx>
#endif
#ifndef _NDINDEX_HXX
#include <ndindex.hxx>
#endif
#ifndef _ACCESSIBILITYOPTIONS_HXX
#include <accessibilityoptions.hxx>
#endif


/*************************************************************************
|*
|*	ViewShell::Init()
|*
|*	Letzte Aenderung	MA 14. Jun. 96
|*
|*************************************************************************/

void ViewShell::Init( const SwViewOption *pNewOpt )
{
	RTL_LOGFILE_CONTEXT_AUTHOR( aLog, "SW", "JP93722",  "ViewShell::Init" );

	bDocSizeChgd = FALSE;

	// Wir gehen auf Nummer sicher:
	// Wir muessen die alten Fontinformationen wegschmeissen,
	// wenn die Druckeraufloesung oder der Zoomfaktor sich aendert.
	// Init() und Reformat() sind die sichersten Stellen.
	pFntCache->Flush( );

	// ViewOptions werden dynamisch angelegt
	if( !pOpt )
	{
		pOpt = new SwViewOption;

		// Ein ApplyViewOptions braucht nicht gerufen zu werden
		if( pNewOpt )
		{
			*pOpt = *pNewOpt;
			// Der Zoomfaktor muss eingestellt werden, weil in der CTOR-
			// phase aus Performancegruenden kein ApplyViewOptions gerufen wird.
			if( GetWin() && 100 != pOpt->GetZoom() )
			{
				MapMode aMode( pWin->GetMapMode() );
				const Fraction aNewFactor( pOpt->GetZoom(), 100 );
				aMode.SetScaleX( aNewFactor );
				aMode.SetScaleY( aNewFactor );
				pWin->SetMapMode( aMode );
			}
		}
	}

	SwDocShell* pDShell = pDoc->GetDocShell();
	pDoc->set(IDocumentSettingAccess::HTML_MODE, 0 != ::GetHtmlMode( pDShell ) );

	// JP 02.02.99: Bug 61335 - Readonly-Flag an den ViewOptions setzen,
	//				bevor das Layout angelegt wird. Ansonsten muesste man
	//				nochmals durchformatieren!!
	if( pDShell && pDShell->IsReadOnly() )
		pOpt->SetReadonly( TRUE );

	RTL_LOGFILE_CONTEXT_TRACE( aLog, "View::Init - before InitPrt" );

    // --> FME 2005-01-21 #i41075#
    // Only setup the printer if we need one:
    const IDocumentSettingAccess* pIDSA = getIDocumentSettingAccess();
    const bool bBrowseMode = pIDSA->get(IDocumentSettingAccess::BROWSE_MODE);
    const bool bCreatePrinter = !bBrowseMode &&
                                !pIDSA->get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE);
    SfxPrinter* pPrinter = getIDocumentDeviceAccess()->getPrinter( bCreatePrinter );
    if( pPrinter )
        InitPrt( pPrinter );
    // <--

    // --> FME 2005-03-16 #i44963# Good occasion to check if page sizes in
    // page descriptions are still set to (LONG_MAX, LONG_MAX) (html import)
    if ( !bBrowseMode )
    {
        pDoc->CheckDefaultPageFmt();
    }
    // <--

	RTL_LOGFILE_CONTEXT_TRACE( aLog, "View::Init - after InitPrt" );

	if( GetWin() )
	{
		pOpt->Init( GetWin() );
		GetWin()->SetFillColor();
		GetWin()->SetBackground();
		GetWin()->SetLineColor();
	}

	//Layout erzeugen wenn es noch nicht vorhanden ist.
	SwRootFrm* pRoot = GetDoc()->GetRootFrm();
	if( !pRoot )
		GetDoc()->SetRootFrm( pRoot = new SwRootFrm( pDoc->GetDfltFrmFmt(), this ) );

	SizeChgNotify( pRoot->Frm().SSize() );

    // --> #i31958#
    // XForms mode: initialize XForms mode, based on design mode (draw view)
    //   MakeDrawView() requires layout
    if( GetDoc()->isXForms() )
    {
        if( ! HasDrawView() )
            MakeDrawView();
        pOpt->SetFormView( ! GetDrawView()->IsDesignMode() );
    }
    // <-- #i31958#
}

/*************************************************************************
|*
|*	ViewShell::ViewShell()	CTor fuer die erste Shell.
|*
|*	Letzte Aenderung	MA 29. Aug. 95
|*
|*************************************************************************/

ViewShell::ViewShell( SwDoc& rDocument, Window *pWindow,
						const SwViewOption *pNewOpt, OutputDevice *pOutput,
						long nFlags )
	: pDoc( &rDocument ),
	pOpt( 0 ),
    pAccOptions( new SwAccessibilityOptions ),
	pWin( pWindow ),
	pOut( pOutput ? pOutput
				  : pWindow ? (OutputDevice*)pWindow
                            : (OutputDevice*)rDocument.getPrinter( true )),
    mpTmpRef( 0 ),
	nStartAction( 0 ),
	nLockPaint( 0 ),
	mnPrePostPaintCount(0L), // #i72754#
	mpPrePostOutDev(0), // #i72754#
	pSfxViewShell( 0 ),
	pImp( new SwViewImp( this ) ),
	aBrowseBorder()
{
	RTL_LOGFILE_CONTEXT_AUTHOR( aLog, "SW", "JP93722",  "ViewShell::SwViewShell" );

    // OD 2004-06-01 #i26791# - in order to suppress event handling in
    // <SwDrawContact::Changed> during contruction of <ViewShell> instance
    mbInConstructor = true;

	bPaintInProgress = bViewLocked = bInEndAction = bFrameView =
	bEndActionByVirDev = FALSE;
	bPaintWorks = bEnableSmooth = TRUE;
	bPreView = 0 !=( VSHELLFLAG_ISPREVIEW & nFlags );

    // --> OD 2005-02-11 #i38810# - Do not reset modified state of document,
    // if it's already been modified.
    const bool bIsDocModified( pDoc->IsModified() );
    // <--
	pDoc->acquire();
	pOutput = pOut;
	Init( pNewOpt );	//verstellt ggf. das Outdev (InitPrt())
	pOut = pOutput;

    // OD 28.03.2003 #108470# - initialize print preview layout after layout
    // is created in <ViewShell::Init(..)> - called above.
    if ( bPreView )
    {
        // OD 12.12.2002 #103492# - init page preview layout
        pImp->InitPagePreviewLayout();
    }

	SET_CURR_SHELL( this );

	((SwHiddenTxtFieldType*)pDoc->GetSysFldType( RES_HIDDENTXTFLD ))->
        SetHiddenFlag( !pOpt->IsShowHiddenField() );

	//In Init wird ein Standard-FrmFmt angelegt.
    // --> OD 2005-02-11 #i38810#
    if ( !pDoc->IsUndoNoResetModified() && !bIsDocModified )
    // <--
    {
		pDoc->ResetModified();
    }

	//Format-Cache erweitern.
	if ( SwTxtFrm::GetTxtCache()->GetCurMax() < 2550 )
		SwTxtFrm::GetTxtCache()->IncreaseMax( 100 );
    if( pOpt->IsGridVisible() || getIDocumentDrawModelAccess()->GetDrawModel() )
		Imp()->MakeDrawView();

    // OD 2004-06-01 #i26791#
    mbInConstructor = false;
}

/*************************************************************************
|*
|*	ViewShell::ViewShell()	CTor fuer weitere Shells auf ein Dokument.
|*
|*	Letzte Aenderung	MA 29. Aug. 95
|*
|*************************************************************************/

ViewShell::ViewShell( ViewShell& rShell, Window *pWindow,
						OutputDevice *pOutput, long nFlags ) :
	Ring( &rShell ),
	pDoc( rShell.GetDoc() ),
	pWin( pWindow ),
	pOut( pOutput ? pOutput
				  : pWindow ? (OutputDevice*)pWindow
                            : (OutputDevice*)rShell.GetDoc()->getPrinter( true )),
    mpTmpRef( 0 ),
	pOpt( 0 ),
    pAccOptions( new SwAccessibilityOptions ),
    nStartAction( 0 ),
	nLockPaint( 0 ),
	mnPrePostPaintCount(0L), // #i72754#
	mpPrePostOutDev(0), // #i72754#
	pSfxViewShell( 0 ),
	pImp( new SwViewImp( this ) ),
	aBrowseBorder( rShell.GetBrowseBorder() )
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLog, "SW", "JP93722",  "ViewShell::SwViewShell" );

    // OD 2004-06-01 #i26791# - in order to suppress event handling in
    // <SwDrawContact::Changed> during contruction of <ViewShell> instance
    mbInConstructor = true;

    bPaintWorks = bEnableSmooth = TRUE;
	bPaintInProgress = bViewLocked = bInEndAction = bFrameView =
	bEndActionByVirDev = FALSE;
	bPreView = 0 !=( VSHELLFLAG_ISPREVIEW & nFlags );
    // OD 12.12.2002 #103492#
    if ( bPreView )
        pImp->InitPagePreviewLayout();

	SET_CURR_SHELL( this );

	pDoc->acquire();
	BOOL bModified = pDoc->IsModified();

	pOutput = pOut;
	Init( rShell.GetViewOptions() );	//verstellt ggf. das Outdev (InitPrt())
	pOut = pOutput;

	((SwHiddenTxtFieldType*)pDoc->GetSysFldType( RES_HIDDENTXTFLD ))->
            SetHiddenFlag( !pOpt->IsShowHiddenField() );

	// in Init wird ein Standard-FrmFmt angelegt
	if( !bModified && !pDoc->IsUndoNoResetModified() )
		pDoc->ResetModified();

	//Format-Cache erweitern.
	if ( SwTxtFrm::GetTxtCache()->GetCurMax() < 2550 )
		SwTxtFrm::GetTxtCache()->IncreaseMax( 100 );
    if( pOpt->IsGridVisible() || getIDocumentDrawModelAccess()->GetDrawModel() )
        Imp()->MakeDrawView();

    // OD 2004-06-01 #i26791#
    mbInConstructor = false;

}

/******************************************************************************
|*
|*	ViewShell::~ViewShell()
|*
|*	Ersterstellung		MA ??
|*	Letzte Aenderung	MA 10. May. 95
|*
******************************************************************************/

ViewShell::~ViewShell()
{
	{
		SET_CURR_SHELL( this );
		bPaintWorks = FALSE;

        // FME 2004-06-21 #i9684# Stopping the animated graphics is not
        // necessary during printing or pdf export, because the animation
        // has not been started in this case.
        if( pDoc && GetWin() )
		{
			SwNodes& rNds = pDoc->GetNodes();
			SwGrfNode *pGNd;

			SwStartNode *pStNd;
			SwNodeIndex aIdx( *rNds.GetEndOfAutotext().StartOfSectionNode(), 1 );
			while ( 0 != (pStNd = aIdx.GetNode().GetStartNode()) )
			{
				aIdx++;
				if ( 0 != ( pGNd = aIdx.GetNode().GetGrfNode() ) )
				{
					if( pGNd->IsAnimated() )
					{
						SwClientIter aIter( *pGNd );
						for( SwFrm* pFrm = (SwFrm*)aIter.First( TYPE(SwFrm) );
							pFrm; pFrm = (SwFrm*)aIter.Next() )
						{
							ASSERT( pFrm->IsNoTxtFrm(), "GraphicNode with Text?" );
							((SwNoTxtFrm*)pFrm)->StopAnimation( pOut );
						}
					}
				}
				aIdx.Assign( *pStNd->EndOfSectionNode(), +1 );
			}

			GetDoc()->StopNumRuleAnimations( pOut );
		}

		delete pImp; //Erst loeschen, damit die LayoutViews vernichtet werden.
		pImp = 0;	// Set to zero, because ~SwFrm relies on it.

		if ( pDoc )
		{
			if( !pDoc->release() )
				delete pDoc, pDoc = 0;
			else
				pDoc->GetRootFrm()->ResetNewLayout();
		}

		delete pOpt;

		//Format-Cache zurueckschrauben.
		if ( SwTxtFrm::GetTxtCache()->GetCurMax() > 250 )
			SwTxtFrm::GetTxtCache()->DecreaseMax( 100 );

		//Ggf. aus der PaintQueue entfernen lassen
		SwPaintQueue::Remove( this );

		ASSERT( !nStartAction, "EndAction() pending." );
	}

	if ( pDoc )
		GetLayout()->DeRegisterShell( this );

    delete mpTmpRef;
    delete pAccOptions;
}

const BOOL ViewShell::HasDrawView() const
{
	return Imp()->HasDrawView();
}

void ViewShell::MakeDrawView()
{
	Imp()->MakeDrawView( );
}

SdrView* ViewShell::GetDrawView()
{
	return Imp()->GetDrawView();
}

SdrView* ViewShell::GetDrawViewWithValidMarkList()
{
	SwDrawView* pDView = Imp()->GetDrawView();
	pDView->ValidateMarkList();
	return pDView;
}
