/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shidl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 01:08:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_tools.hxx"

#ifndef _SHUTIL_H_
#include "shutil.h"
#endif

// FastFSys nicht includen !!!

#define VIRTUAL_URL_OPENBRACKET		'{'
#define VIRTUAL_URL_CLOSEBRACKET	'}'

#define VIRTUAL_DESKTOP_TOKEN		"desktop"
#define VIRTUAL_WORKPLACE_TOKEN		"workplace"
#define VIRTUAL_BOOKMARKS_TOKEN		"bookmarks"
#define VIRTUAL_DOCUMENTS_TOKEN		"documents"
#define VIRTUAL_SETTINGS_TOKEN		"settings"


#define VIRTUAL_CONTROLS_TOKEN		"controls"
#define VIRTUAL_PRINTERS_TOKEN		"printers"
#define VIRTUAL_NETWORK_TOKEN		"network"
#define VIRTUAL_PROGRAMS_TOKEN		"programs"
#define VIRTUAL_COMMON_PROGS_TOKEN	"common-programs"

#ifndef SHUTIL_TO_DELIVER
#error Was sucht der alte Mist hier noch!!!
#endif

extern "C" {

//--------------------------------------------------------------------------
//	SHGetIDListSize
//--------------------------------------------------------------------------

ULONG WINAPI WIN_SHGetIDListSize( LPCITEMIDLIST pidl )
{
	ULONG	cbAll = 0;

	if ( pidl )
	{
		ULONG	cb;

		while ( (cb = pidl->mkid.cb) != 0 )
		{
			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + cb);
			cbAll += cb;
		}

		cbAll += sizeof(USHORT);
	}

	return cbAll;
}

//--------------------------------------------------------------------------
//	SHCloneIDList
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHCloneIDList( LPCITEMIDLIST pidl, LPITEMIDLIST *ppidl )
{
	BOOL	fSuccess = FALSE;

	if ( ppidl )
	{
		if ( pidl )
		{
			ULONG	cb = WIN_SHGetIDListSize( pidl );

			*ppidl = (LPITEMIDLIST)WIN_SHAlloc( cb );
			
			if ( *ppidl )
			{
				if ( pidl )
					CopyMemory( *ppidl, pidl, cb );
				else
					(*ppidl)->mkid.cb = 0;

				fSuccess = TRUE;
			}
		}
		else
			*ppidl = NULL;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHAppendIDList
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHAppendIDList( LPCITEMIDLIST pidl, LPITEMIDLIST *ppidl )
{
	BOOL	fSuccess = FALSE;

	if ( ppidl )
	{
		if ( *ppidl == NULL )
			return WIN_SHCloneIDList( pidl, ppidl );

		if ( pidl )
		{
			ULONG	cbSource = WIN_SHGetIDListSize( pidl );
			ULONG	cbTarget = WIN_SHGetIDListSize( *ppidl ) - sizeof(USHORT);

			void *	pNew = WIN_SHRealloc( *ppidl, cbTarget + cbSource );
			
			if ( pNew )
			{
				if ( pidl )
					CopyMemory( (LPBYTE)pNew + cbTarget, pidl, cbSource );
				else
					*(LPWORD)((LPBYTE)pNew + cbTarget) = 0;

				*ppidl = (LPITEMIDLIST)pNew;

				fSuccess = TRUE;
			}
		}
		else
			*ppidl = NULL;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHCompareIDList
//--------------------------------------------------------------------------

LONG WINAPI WIN_SHCompareIDList( LPCITEMIDLIST pidl1, LPCITEMIDLIST pidl2 )
{
	if ( pidl1 == NULL || pidl2 == NULL )
		return -1L;

	if ( pidl1 == pidl2 )
		return 0L;

	ULONG	cb1 = WIN_SHGetIDListSize( pidl1 );
	ULONG   cb2 = WIN_SHGetIDListSize( pidl2 );

	if ( cb1 != cb2 )
		return -1L;

	LONG	nDiff = memcmp( pidl1, pidl2, cb1 );

	// Sie koennen trotzdem noch gleich sein, jetzt kommt die langsamme Methode 

	if ( nDiff )
	{
		LPSHELLFOLDER	pRootFolder = NULL;
		HRESULT			hResult = SHGetDesktopFolder( &pRootFolder );

		if ( SUCCEEDED(hResult) )
		{
			hResult = pRootFolder->CompareIDs( 0, pidl1, pidl2 );
			if ( SUCCEEDED(hResult) )
				nDiff = GetScode(hResult);
			pRootFolder->Release();
		}
	}

	return nDiff;
}

//--------------------------------------------------------------------------
//	SHGetIDListFromPath
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetIDListFromPath( LPCSTR pszPath, LPITEMIDLIST *ppidl )
{
	LPSHELLFOLDER	pshf;
	ULONG			chEaten = 0;
	DWORD			dwAttributes = 0; // Die Attribute SFGAO_... interessieren uns nicht
	BOOL			fSuccess = FALSE;

	if ( NOERROR == SHGetDesktopFolder( &pshf ) )
	{
		WCHAR	wszPath[MAX_PATH];

		MultiByteToWideChar( CP_ACP, 0, pszPath, -1, wszPath, MAX_PATH );
		if ( NOERROR == pshf->ParseDisplayName( NULL, NULL, wszPath, &chEaten, ppidl, &dwAttributes ) )
			fSuccess = TRUE;

		pshf->Release();
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHGetIDListTokenCount
//--------------------------------------------------------------------------

LONG WINAPI WIN_SHGetIDListTokenCount( LPCITEMIDLIST pidl )
{
	LONG	nCount = 0;

	if ( pidl )
	{
		while ( pidl->mkid.cb > sizeof(USHORT) )
		{
			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb );
			nCount++;
		}
	}

	return nCount;
}


//--------------------------------------------------------------------------
//	SHGetIDListToken
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetIDListToken( LPCITEMIDLIST pidl, ULONG nToken, LPITEMIDLIST *ppidl )
{
	BOOL	fSuccess = FALSE;

	if ( pidl )
	{
		while ( nToken-- && pidl->mkid.cb )
			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb );
		
		*ppidl = (LPITEMIDLIST)WIN_SHAlloc( pidl->mkid.cb + sizeof(USHORT) );

		if ( *ppidl )
		{
			CopyMemory( *ppidl, pidl, pidl->mkid.cb );
			*(LPWORD)((LPBYTE)*ppidl + pidl->mkid.cb) = 0;
			fSuccess = TRUE;
		}
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHSplitIDList
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHSplitIDList( LPCITEMIDLIST pidl, LPITEMIDLIST *ppidlFolder, LPITEMIDLIST *ppidlItem )
{
	BOOL	fSuccess = FALSE;

	if ( pidl )
	{
		ULONG			cbSize = 0;
		ULONG			cbLast = 0;
		LPCITEMIDLIST	pidlLast = pidl, pidlFirst = pidl;

		while ( pidl->mkid.cb )
		{
			pidlLast = pidl;
			cbLast = pidl->mkid.cb;
			cbSize += cbLast;

			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb);
		}

		ULONG	cbFolder = cbSize - cbLast + sizeof(USHORT);

		if ( ppidlFolder )
		{
			*ppidlFolder = (LPITEMIDLIST)WIN_SHAlloc( cbFolder );
			if ( *ppidlFolder )
			{
				CopyMemory( *ppidlFolder, pidlFirst, cbSize - cbLast );
				*(LPWORD)((LPBYTE)*ppidlFolder + cbSize - cbLast) = 0;
			}
		}

		ULONG cbItem = cbLast + sizeof(USHORT);

		if ( ppidlItem )
		{
			*ppidlItem = (LPITEMIDLIST)WIN_SHAlloc( cbItem );
			if ( *ppidlItem )
			{
				CopyMemory( *ppidlItem, pidlLast, cbLast );
				*(LPWORD)((LPBYTE)*ppidlItem + cbLast) = 0;
			}
		}

		fSuccess = TRUE;
	}

	return fSuccess;
}


BOOL WINAPI WIN_SHSplitIDListEx( LPCITEMIDLIST pidl, LPITEMIDLIST *ppidlFolder, LPITEMIDLIST *ppidlItem, ULONG nLevel )
{
	BOOL	fSuccess = FALSE;

	if ( pidl )
	{
		ULONG			cbSize = 0;
		ULONG			nToken = 0;
		LPCITEMIDLIST	pidlChild = pidl, pidlParent = pidl;

		while ( pidl->mkid.cb && nToken++ < nLevel )
		{
			cbSize += pidl->mkid.cb;
			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb);
			pidlChild = pidl;
		}

		ULONG	cbFolder = cbSize + sizeof(USHORT);

		if ( ppidlFolder )
		{
			*ppidlFolder = (LPITEMIDLIST)WIN_SHAlloc( cbFolder );
			if ( *ppidlFolder )
			{
				CopyMemory( *ppidlFolder, pidlParent, cbSize );
				*(LPWORD)((LPBYTE)*ppidlFolder + cbSize) = 0;
			}
		}

		if ( ppidlItem )
			WIN_SHCloneIDList( pidlChild, ppidlItem );

		fSuccess = TRUE;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHGetDataFromIDList
//--------------------------------------------------------------------------

typedef HRESULT (WINAPI *SHGETDATAFROMIDLISTPROC)(LPSHELLFOLDER,LPCITEMIDLIST,int,PVOID,int);

HRESULT	WINAPI WIN_SHGetDataFromIDList(
    LPSHELLFOLDER psf,
    LPCITEMIDLIST pidl,
    int nFormat,
    PVOID pv,
    int cb
   )
{
	static SHGETDATAFROMIDLISTPROC	pfnSHGetDataFromIDList = NULL;

	HRESULT	hResult = E_NOTIMPL;

	if ( pfnSHGetDataFromIDList == NULL )
	{
		HINSTANCE	hInstShell = LoadLibrary("SHELL32.DLL");

		if ( hInstShell )
		{
#ifdef UNICODE
			pfnSHGetDataFromIDList = (SHGETDATAFROMIDLISTPROC)GetProcAddress( hInstShell, "SHGetDataFromIDListW" );
#else
			pfnSHGetDataFromIDList = (SHGETDATAFROMIDLISTPROC)GetProcAddress( hInstShell, "SHGetDataFromIDListA" );
#endif

			if ( pfnSHGetDataFromIDList != NULL )
				hResult = NOERROR;
			else
				FreeLibrary( hInstShell );
		}
	}
	else
		return pfnSHGetDataFromIDList( psf, pidl, nFormat, pv, cb );

	if ( hResult == NOERROR )
		return pfnSHGetDataFromIDList( psf, pidl, nFormat, pv, cb );
	else
		return hResult;
}

//--------------------------------------------------------------------------

}	// extern "C"

