/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpURLParameter.java,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:40:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.io.*;
import java.util.HashMap;
import java.net.URL;
import com.sleepycat.db.*;
import java.util.jar.*;
import com.jclark.xsl.sax.XSLProcessor;
import com.sun.star.ucb.*;

public class HelpURLParameter
{
	private boolean m_bBerkeleyRead = false;
	private URL m_URL;

 	private boolean _isStart = false;
  	private String _tag = "";
	private String _id = "";                      // Must be input from the URL
	private String _path = "";                    // From the database
	private String _module = "";                  // Input from the URL
	private String _title = "";                   // From the database
	private String _jar = "";                     // From the database
	private String _eid = "";
	
	private String _defaultLanguage = "";         // Special parameter
	private String _language = "";

 	private String _prefix = "";
 	private String _device = "";
  	private String _program = "";
	private String _query = "";
 	private String _scope = "";
  	private String _system = "";
	private String _active = "";
	private    int _hitCount = 100;              // The default maximum hitcount

	
 	public HelpURLParameter( URL _URL )
		throws
		IllegalIdentifierException
  	{
 		m_URL = _URL;
		parse3();
   	}
	
	
	public HelpURLParameter( URL _URL,String _lang )
		throws
		IllegalIdentifierException
	{
		this( _URL );
		_defaultLanguage = _lang;
	}
	
	
	public boolean isPicture() 		  { return _module.equals("picture"); }
	public boolean isActive()         { return _active.equals( "true" ); }
	public boolean isQuery()          { return _id.equals("") && !_query.equals(""); }
	public boolean isEntryForModule() { return _id.equals("start") || _isStart; };
	public boolean isFile()           { return !_id.equals(""); }
 	public boolean isModule()         { return _id.equals("") && !_module.equals(""); }
	public boolean isRoot()           { return _module.equals(""); }
	
	public String get_id()
 	{
  		if( _id.equals( "start" ) )
    	{   // module is set
     		HelpDatabases.StaticModuleInformation inf = HelpDatabases.getStaticInformationForModule( get_module(),get_language() );
       		_id = inf.get_id();
         	_isStart = true;
     	}
		
   		return _id;
    }
	
    public String get_tag()
    {
     	if( isFile() )
      		return get_the_tag();
        else
        	return _tag;
    }

	//  Not called for an directory
	public String get_path()     { return get_the_path(); }     // BerkeleyDb
	
	public String get_eid()      { return _eid; } 
	
 	public String get_title()
  	{
     	if( isFile() )     // Parses
     		return get_the_title();
       	else if( ! _module.equals("") )
        {
     		HelpDatabases.StaticModuleInformation inf = HelpDatabases.getStaticInformationForModule( get_module(),get_language() );
			_title = inf.get_title();
        }
        else   // This must be the root
        	_title = new String( "root" );
		
        return _title;
  	}
	
	
 	public String get_jar()      { return get_the_jar(); }      // BerkeleyDb
	public String get_module()   { return _module; }
	public String get_prefix()   { return _prefix; }

	
    public String get_language()
    {
     	if( _language.equals( "" ) )
    		_language = _defaultLanguage;
      	return _language;
	}

    public String get_device()   { return _device; }

    public String get_program()
    {
    	if( _program.equals( "" ) )
     	{
     		HelpDatabases.StaticModuleInformation inf = HelpDatabases.getStaticInformationForModule( get_module(),get_language() );
			_program = inf.get_program();
      	}
    	return _program;
    }

    public String get_query()    { return _query; }
    public String get_scope()    { return _scope; }
	public String get_system()   { return _system; }
 	public    int get_hitCount() { return _hitCount; }
	
	
	public InputStream getInputFromJarFile()
	{
		try
		{
		    JarFile jarFile = HelpDatabases.getJarFileForLanguage( get_jar(),get_language() );   // For module and language
 			String path = get_path();
        	int idx;
        	if( ( idx = path.indexOf( '#' ) ) != -1 )
         		path = path.substring(0,idx);
			
		    JarEntry jarEntry = jarFile.getJarEntry( path );
  			if( jarEntry != null )
				return jarFile.getInputStream( jarEntry );
    		else
      		{
        		// System.out.println( "File not found in jar: " + get_jar() + " " + path );
				return HelpDatabases.errorFile( get_language() );
    		}
		}
		catch( Exception e )
		{
		    return HelpDatabases.errorFile( get_language() );
		}
	}

	
	
	
	public InputStream getInputFromDisk()
	{
		try
		{
  			String fileName = HelpDatabases.getInstallDirectory()
				+ HelpDatabases.lang(get_language())
				+ File.separator
				+ get_path();

        	int idx;
        	if( ( idx = fileName.indexOf( '#' ) ) != -1 )
         		fileName = fileName.substring(0,idx);

    		File aFile = new File( fileName );
      		if( aFile.exists() )
        	{
     			return new FileInputStream( aFile );
       		}
         	else
        	{
        		System.out.println( "File not found from disk: " + get_path() );
				return HelpDatabases.errorFile( get_language() );
     		}
       	}
		catch( Exception e )
		{
		    return HelpDatabases.errorFile( get_language() );
		}
	}


 	public byte[] getByteArrayText()
  	{
 		try
		{
			Db db = HelpDatabases.getHelptextDbForLanguage( get_module(),get_language() );

   			StringDbt key = new StringDbt( _id );
      		StringDbt data = new StringDbt();

			int err = db.get(null,key,data,0);
			if( data != null )
				try
				{
					return data.getString().getBytes( "UTF8" );
				}
				catch( UnsupportedEncodingException e )
				{
					return data.getString().getBytes();
				}
       		else
         		return new byte[0];
		}
		catch( DbException err )
		{
      		System.out.println( "No database for language: HelpURLParameter._readBerkeley" );
        	return new byte[0];
	    }
   	}


 	private String get_the_tag()
  	{
 		if( ! m_bBerkeleyRead )
			_readBerkeley();
		m_bBerkeleyRead = true;
		
		return _tag;
   	}



	private String get_the_path()
	{
		if( ! m_bBerkeleyRead )
			_readBerkeley();
		m_bBerkeleyRead = true;

		return _path;
	}

	
	
	private String get_the_title()
	{
	    if( ! m_bBerkeleyRead )
			_readBerkeley();
		m_bBerkeleyRead = true;
		
		return _title;
	}


	private String get_the_jar()
	{
	    if( ! m_bBerkeleyRead )
			_readBerkeley();
		m_bBerkeleyRead = true;
		
		return _jar;
	}



    public int isEqualTo( HelpURLParameter p )
    {
    	// Not yet implemented very robust, doesn't matter by now
		return ( get_module().equals( p.get_module() )      && 
				 get_id().equals( p.get_id() )              &&
				 get_language().equals( p.get_language() )  &&
				 get_device().equals( p.get_device() )      &&
				 get_program().equals( p.get_program() )    &&
				 get_query().equals( p.get_query() )        &&        // Must accept different strings
				 get_scope().equals( p.get_scope() )        &&
				 get_system().equals( p.get_system() )      &&
				 get_hitCount() == p.get_hitCount()   ) ? 1 : 0;
    }



	private void _readBerkeley()
	{
		if( !get_id().equals("") )
		{
		    try
		    {
			    Db db = HelpDatabases.getDatabaseForLanguage( get_module(),get_language() );

   			    StringDbt key = new StringDbt( _id );
      		    StringDbt data = new StringDbt();

			    int err = db.get(null,key,data,0);
			    if( data != null )
				{
				    _title = data.getTitle();
			        _path = data.getFile();
				    _jar = data.getDatabase();
        			_tag = data.getHash();
				}

		    }
		    catch( DbException err )
		    {
      			System.out.println( "No database for language: HelpURLParameter._readBerkeley" );
	        }
		}
	}
	

	
	String _expr;
	
	void parse3() throws IllegalIdentifierException
	{
		_expr = m_URL.toExternalForm();
		
		int lstIdx = _expr.lastIndexOf( '#' );
		if( lstIdx != -1 )
			_expr = _expr.substring( 0,lstIdx );
		
		if( ! scheme() || ! name( module() ) || ! query() )
			throw new IllegalIdentifierException( m_URL.toExternalForm() );
	}
	

	
	boolean scheme()
	{
		boolean unzero = ( _expr != null );
		if( unzero && _expr.startsWith( "vnd.sun.star.help://" ) )
		{
			_expr = _expr.substring( "vnd.sun.star.help://".length() );
			return true;
		}
		else if( unzero && _expr.startsWith( "vnd.sun.star.help:/" ) )
		{
			_expr = _expr.substring( "vnd.sun.star.help:/".length() );
			return true;
		}
		else if( unzero && _expr.startsWith( "vnd.sun.star.help:" ) )
		{
			_expr = _expr.substring( "vnd.sun.star.help:".length() );
			return true;
		}
		else
			return false;
	}
	
	

	boolean module()
	{
		char ch;
		int idx = 0,length = _expr.length();
		
		while( idx < length && Character.isLetterOrDigit( _expr.charAt(idx) ) ) 
			++idx;
		
		if( idx != 0 )
		{
			_module = _expr.substring( 0,idx );
			_expr = _expr.substring( idx );
			return true;
		}
		else
			return false;
	}
	
	
	
	boolean name( boolean modulePresent )
	{
		// if modulepresent, a name may be present, but must not

		int length = _expr.length();


		if( length != 0 && _expr.charAt( 0 ) == '/' )
		{
			int idx = 1;
			while( idx < length && Character.isLetterOrDigit( _expr.charAt(idx) ) ) 
				++idx;
			
			if( idx != 1 && ! modulePresent )
				return false;
			else
			{
				_id = _expr.substring(1,idx);
				_expr = _expr.substring( idx );
			}
		}
		
		return true;
	}
	
	
	boolean query()
	{
		String query = "";
		
		if( _expr == null || _expr.length() == 0 )
			return true;
		else if( _expr.charAt( 0 ) == '?' )
			query = _expr.substring( 1 ).trim();
		else
			return false;
		
		
		boolean ret = true;
		int delimIdx, equalIdx;
		String parameter,value;
		
		while( query.length() != 0 )
		{
		    delimIdx = query.indexOf( '&' );
			equalIdx = query.indexOf( '=' );
			parameter = query.substring( 0,equalIdx ).trim();
			if( delimIdx == -1 )
			{
			    value = query.substring( equalIdx + 1 ).trim();
				query = new String();
			}
			else
			{
			    value = query.substring( equalIdx+1,delimIdx ).trim();
				query = query.substring( delimIdx+1 ).trim();
			}

   			if( "Language".equals( parameter ) )
			{
//  				int idx;
//  				if( ( idx = value.indexOf( '-' ) ) != -1 )
//  					value = value.substring( 0,idx );
//  				if( ( idx = value.indexOf( '_' ) ) != -1 )
//  					value = value.substring( 0,idx );
      			_language = value;
			}
         	else if( "Device".equals( parameter ) )
          		_device = value;
            else if( "Program".equals( parameter ) )
            	_program = value;
			else if( "Eid".equals( parameter ) )
				_eid = value;
            else if( "Language".equals( parameter ) )
            	_language = value;
            else if( "Query".equals( parameter ) )
            {	
				if( _query == null )
					_query = value;
				else
					_query += ( " " + value );
            }
            else if( "Scope".equals( parameter ) )
            	_scope = value;
			else if( "System".equals( parameter ) )
   				_system = value;
			else if( "HelpPrefix".equals( parameter ) )
   				_prefix = value;
     		else if( "HitCount".equals( parameter ) )
      			_hitCount = (Integer.decode( value )).intValue();
			else if( "Active".equals( parameter ) )
				_active = value;
			else
				ret = false;
		}
		
		return ret;
	}
	
}   // end class HelpURLParameter






	// A way to parse a URL
	
	/*
	  
	  private void parse2()
	  {
	  System.out.println( "ext:  " + m_URL.toExternalForm() );
	  try
	  {
	  parse3();
	  return;
	  }
	  catch( IllegalIdentifierException e )
	  {
	  System.out.println( e.getMessage() );
	  }
		

			
	  _module = m_URL.getHost();     // In fact the "authority"
				
	  String query = m_URL.getFile();
				
	  if( query != null && query.length() > 0 )
	  query = query.substring(1);
	  else
	  return;
				
	  int delimIdx = query.indexOf( '?' );
	  if( delimIdx == -1 )
	  {
	  if( query == null || query.length() == 0 )
	  _id = "";                   // This is not an xmlfile
	  else
	  _id = query;
	  query = "";                     // No query present
	  }
	  else
	  {
	  _id = query.substring(0,delimIdx);
	  if( _id == null ) _id = "";
	  query = query.substring(delimIdx+1).trim();
	  if( query == null ) query = "";
	  }

	  // Now determine the parameters

	  int equalIdx;
	  String parameter,value;

	  while( query.length() != 0 )
	  {
	  delimIdx = query.indexOf( '&' );
	  equalIdx = query.indexOf( '=' );
	  parameter = query.substring( 0,equalIdx ).trim();
	  if( delimIdx == -1 )
	  {
	  value = query.substring( equalIdx + 1 ).trim();
	  query = new String();
	  }
	  else
	  {
	  value = query.substring( equalIdx+1,delimIdx ).trim();
	  query = query.substring( delimIdx+1 ).trim();
	  }

	  if( "Language".equals( parameter ) )
	  _language = value;
	  else if( "Device".equals( parameter ) )
	  _device = value;
	  else if( "Program".equals( parameter ) )
	  _program = value;
	  else if( "Eid".equals( parameter ) )
	  _eid = value;
	  else if( "Language".equals( parameter ) )
	  _language = value;
	  else if( "Query".equals( parameter ) )
	  {	
	  if( _query == null )
	  _query = value;
	  else
	  _query += ( " " + value );
	  }
	  else if( "Scope".equals( parameter ) )
	  _scope = value;
	  else if( "System".equals( parameter ) )
	  _system = value;
	  else if( "HelpPrefix".equals( parameter ) )
	  _prefix = value;
	  else if( "HitCount".equals( parameter ) )
	  _hitCount = (Integer.decode( value )).intValue();
	  }
	  }
	*/
