/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultPieDataset;
import com.jrefinery.data.DomainInfo;
import com.jrefinery.data.Function2D;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.Range;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import java.util.Iterator;
import java.util.List;

public class DatasetUtilities {
    public static Number[] createNumberArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            numberArray[n] = new Double(dArray[n]);
            ++n;
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Number[][] numberArray = new Number[n][n2];
        int n3 = 0;
        while (n3 < n) {
            numberArray[n3] = DatasetUtilities.createNumberArray(dArray[n3]);
            ++n3;
        }
        return numberArray;
    }

    public static Range getDomainExtent(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue: null dataset not allowed.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getDomainRange();
        }
        if (dataset instanceof XYDataset) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            XYDataset xYDataset = (XYDataset)dataset;
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    Number number = null;
                    Number number2 = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getStartXValue(n2, n4);
                        number2 = intervalXYDataset.getEndXValue(n2, n4);
                    } else {
                        number2 = number = xYDataset.getXValue(n2, n4);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number2 != null) {
                        d2 = Math.max(d2, number2.doubleValue());
                    }
                    ++n4;
                }
                ++n2;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d2);
        }
        return null;
    }

    public static Range getRangeExtent(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getValueRange();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            int n = categoryDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                Iterator iterator = categoryDataset.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Number number = null;
                    Number number2 = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getStartValue(n2, e);
                        number2 = intervalCategoryDataset.getEndValue(n2, e);
                    } else {
                        number2 = number = categoryDataset.getValue(n2, e);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number2 == null) continue;
                    d2 = Math.max(d2, number2.doubleValue());
                }
                ++n2;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d2);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = xYDataset.getItemCount(n3);
                int n5 = 0;
                while (n5 < n4) {
                    XYDataset xYDataset2;
                    Number number = null;
                    Number number3 = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getStartYValue(n3, n5);
                        number3 = xYDataset2.getEndYValue(n3, n5);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getLowValue(n3, n5);
                        number3 = xYDataset2.getHighValue(n3, n5);
                    } else {
                        number3 = number = xYDataset.getYValue(n3, n5);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number3 != null) {
                        d3 = Math.max(d3, number3.doubleValue());
                    }
                    ++n5;
                }
                ++n3;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d3);
        }
        return null;
    }

    public static Number getMinimumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue: null dataset not allowed.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMinimumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            double d = Double.POSITIVE_INFINITY;
            XYDataset xYDataset = (XYDataset)dataset;
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getStartXValue(n2, n4);
                    } else {
                        number = xYDataset.getXValue(n2, n4);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    ++n4;
                }
                ++n2;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMaximumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue: null dataset not allowed.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMaximumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getEndXValue(n2, n4);
                    } else {
                        number = xYDataset.getXValue(n2, n4);
                    }
                    if (number != null) {
                        d = Math.max(d, number.doubleValue());
                    }
                    ++n4;
                }
                ++n2;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMinimumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMinimumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = categoryDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                Iterator iterator = categoryDataset.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Number number = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getStartValue(n2, e);
                    } else {
                        number = categoryDataset.getValue(n2, e);
                    }
                    if (number == null) continue;
                    d = Math.min(d, number.doubleValue());
                }
                ++n2;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = xYDataset.getItemCount(n3);
                int n5 = 0;
                while (n5 < n4) {
                    XYDataset xYDataset2;
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getStartYValue(n3, n5);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getLowValue(n3, n5);
                    } else {
                        number = xYDataset.getYValue(n3, n5);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    ++n5;
                }
                ++n3;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMaximumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMaximumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = categoryDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                Iterator iterator = categoryDataset.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Number number = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getEndValue(n2, e);
                    } else {
                        number = categoryDataset.getValue(n2, e);
                    }
                    if (number == null) continue;
                    d = Math.max(d, number.doubleValue());
                }
                ++n2;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = xYDataset.getItemCount(n3);
                int n5 = 0;
                while (n5 < n4) {
                    XYDataset xYDataset2;
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getEndYValue(n3, n5);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getHighValue(n3, n5);
                    } else {
                        number = xYDataset.getYValue(n3, n5);
                    }
                    if (number != null) {
                        d = Math.max(d, number.doubleValue());
                    }
                    ++n5;
                }
                ++n3;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static PieDataset createPieDataset(CategoryDataset categoryDataset, Object object) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n = categoryDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            String string = categoryDataset.getSeriesName(n2);
            defaultPieDataset.setValue(string, categoryDataset.getValue(n2, object));
            ++n2;
        }
        return defaultPieDataset;
    }

    public static PieDataset createPieDataset(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        List list = categoryDataset.getCategories();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            defaultPieDataset.setValue(e, categoryDataset.getValue(n, e));
        }
        return defaultPieDataset;
    }

    public static double getPieDatasetTotal(PieDataset pieDataset) {
        List list = pieDataset.getCategories();
        double d = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            Number number = pieDataset.getValue(e);
            double d2 = 0.0;
            if (number != null) {
                d2 = number.doubleValue();
            }
            if (!(d2 > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    public static Range getStackedRangeExtent(CategoryDataset categoryDataset) {
        Range range = null;
        if (categoryDataset != null) {
            double d = 0.0;
            double d2 = 0.0;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                double d3 = 0.0;
                double d4 = 0.0;
                int n = categoryDataset.getSeriesCount();
                int n2 = 0;
                while (n2 < n) {
                    Number number = categoryDataset.getValue(n2, e);
                    if (number != null) {
                        double d5 = number.doubleValue();
                        if (d5 > 0.0) {
                            d3 += d5;
                        }
                        if (d5 < 0.0) {
                            d4 += d5;
                        }
                    }
                    ++n2;
                }
                d = Math.min(d, d4);
                d2 = Math.max(d2, d3);
            }
            range = new Range(d, d2);
        }
        return range;
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                double d3 = 0.0;
                int n = categoryDataset.getSeriesCount();
                int n2 = 0;
                while (n2 < n) {
                    double d4;
                    Number number = categoryDataset.getValue(n2, e);
                    if (number != null && (d4 = number.doubleValue()) < 0.0) {
                        d3 += d4;
                    }
                    ++n2;
                }
                d2 = Math.min(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                double d3 = 0.0;
                int n = categoryDataset.getSeriesCount();
                int n2 = 0;
                while (n2 < n) {
                    double d4;
                    Number number = categoryDataset.getValue(n2, e);
                    if (number != null && (d4 = number.doubleValue()) > 0.0) {
                        d3 += d4;
                    }
                    ++n2;
                }
                d2 = Math.max(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static XYDataset sampleFunction2D(Function2D function2D, double d, double d2, int n, String string) {
        if (d >= d2) {
            throw new IllegalArgumentException("DatasetUtilities.createXYDataset(...): start must be before end.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("DatasetUtilities.createXYDataset(...): samples must be at least 2.");
        }
        XYSeries xYSeries = new XYSeries(string);
        double d3 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 <= n) {
            double d4 = d + d3 * (double)n2;
            xYSeries.add(d4, function2D.getValue(d4));
            ++n2;
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }
}

