/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlnamespaces.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:10:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_CLASSES_XMLNAMESPACES_HXX_
#define __FRAMEWORK_CLASSES_XMLNAMESPACES_HXX_

#ifndef _COM_SUN_STAR_XML_SAX_SAXEXCEPTION_HPP_
#include <com/sun/star/xml/sax/SAXException.hpp>
#endif

#include <map>

namespace framework
{

class XMLNamespaces
{
	public:
		XMLNamespaces();
		XMLNamespaces( const XMLNamespaces& );
		virtual ~XMLNamespaces();

		void addNamespace( const ::rtl::OUString& aName, const ::rtl::OUString& aValue ) 
			throw(	::com::sun::star::xml::sax::SAXException );

		::rtl::OUString applyNSToAttributeName( const ::rtl::OUString& ) const 
			throw(	::com::sun::star::xml::sax::SAXException );
		::rtl::OUString applyNSToElementName( const ::rtl::OUString& ) const
			throw(	::com::sun::star::xml::sax::SAXException );
	
	private:
		typedef ::std::map< ::rtl::OUString, ::rtl::OUString > NamespaceMap;

		::rtl::OUString getNamespaceValue( const ::rtl::OUString& aNamespace ) const
			throw( ::com::sun::star::xml::sax::SAXException );

		::rtl::OUString m_aDefaultNamespace;
		NamespaceMap	m_aNamespaceMap;
};

}

#endif // __FRAMEWORK_XMLNAMESPACES_HXX_
