/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DrawSubController.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/03/21 17:20:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_DRAW_SUB_CONTROLLER_HXX
#define SD_DRAW_SUB_CONTROLLER_HXX

#ifndef _COM_SUN_STAR_DRAW_XDRAWPAGE_HPP_
#include <com/sun/star/drawing/XDrawPage.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif

#include <vector>

namespace sd {

class View;
class ViewShell;

/** Abstract interface class that lets the DrawController delegate view
    shell specific tasks to a sub controller.
*/
class DrawSubController
{
public:
    virtual ~DrawSubController (void) {};

    /** Convert the value rValue and return the result in rConvertedValue
        and the old value in rOldValue. After this call the vetoable
        listeners are notified.
        
        @param rConvertedValue the converted value. Only set if return is true.
        @param rOldValue the old value. Only set if return is true.
        @param nHandle the handle of the proberty.
        @return true if the value converted.
        @throws A IllegalArgumentException is thrown.
	 */
	virtual sal_Bool SAL_CALL convertFastPropertyValue(
		::com::sun::star::uno::Any & rConvertedValue,
		::com::sun::star::uno::Any & rOldValue,
		sal_Int32 nHandle,
		const ::com::sun::star::uno::Any& rValue )
		throw (::com::sun::star::lang::IllegalArgumentException) = 0;

	/** The same as setFastProperyValue, but no exception is thrown and
        nHandle is always valid. You must not broadcast the changes in this
        method.
	 */
	virtual void SAL_CALL setFastPropertyValue_NoBroadcast(
		sal_Int32 nHandle,
		const ::com::sun::star::uno::Any& rValue )
		throw (::com::sun::star::uno::Exception) = 0;

	/** The same as getFastProperyValue, but return the value through rValue
        and nHandle is always valid.
	 */
	virtual void SAL_CALL getFastPropertyValue(
		::com::sun::star::uno::Any& rValue,
		sal_Int32 nHandle ) const = 0;

	// XSelectionSupplier
    virtual sal_Bool SAL_CALL select (const ::com::sun::star::uno::Any& aSelection)
        throw(::com::sun::star::lang::IllegalArgumentException,
            ::com::sun::star::uno::RuntimeException) = 0;
    
    virtual ::com::sun::star::uno::Any SAL_CALL getSelection (void)
        throw(::com::sun::star::uno::RuntimeException) = 0;

    
	// XDrawView
    virtual void SAL_CALL setCurrentPage (
        const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& xPage)
        throw(::com::sun::star::uno::RuntimeException) = 0;
    
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage > SAL_CALL
        getCurrentPage (void)
        throw(::com::sun::star::uno::RuntimeException) = 0;
};

} // end of namespace sd

#endif

