
      
/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OOXMLresources.cxx,v $
 *
 *  $Revision: 1.73 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/06/27 13:19:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
/*      

  THIS FILE IS GENERATED AUTOMATICALLY! DO NOT EDIT!

*/

#include <iostream>
#include <doctok/resourceids.hxx>
#include <ooxml/resourceids.hxx>
#include <resourcemodel/sprmids.hxx>
#include "OOXMLresources.hxx"
#include "OOXMLPropertySetImpl.hxx"
#include "TokenMap.hxx"

namespace ooxml {
using namespace ::std;

static const sal_uInt8 sCR[] = { 0xd, 0x0 };
static const sal_uInt8 sFtnEdnRef[] = { 0x2, 0x0 };
static const sal_uInt8 sFtnEdnSep[] = { 0x3, 0x0 }; 
static const sal_uInt8 sFtnEdnCont[] = { 0x4, 0x0 }; 
static const sal_uInt8 sTab[] = { 0x9, 0x0 }; 
static const sal_uInt8 sPgNum[] = { 0x0, 0x0 }; 

      
      
Sprm::Kind SprmKind(sal_uInt32 nSprmCode)
{
    Sprm::Kind nResult = Sprm::UNKNOWN;

    switch (nSprmCode)
    {
     case NS_sprm::LN_PDxaWidth: //CT_FramePr, w
     case NS_sprm::LN_PWHeightAbs: //CT_FramePr, h
     case NS_sprm::LN_PDyaFromText: //CT_FramePr, vSpace
     case NS_sprm::LN_PDxaFromText: //CT_FramePr, hSpace
     case NS_sprm::LN_PWr: //CT_FramePr, wrap
     case NS_sprm::LN_PFLocked: //CT_FramePr, anchorLock
     case NS_sprm::LN_PIlvl: //CT_NumPr, ilvl
     case NS_sprm::LN_PIlfo: //CT_NumPr, numId
     case NS_sprm::LN_PBrcTop: //CT_PBdr, top
     case NS_sprm::LN_PBrcLeft: //CT_PBdr, left
     case NS_sprm::LN_PBrcBottom: //CT_PBdr, bottom
     case NS_sprm::LN_PBrcRight: //CT_PBdr, right
     case NS_sprm::LN_PBrcBetween: //CT_PBdr, between
     case NS_sprm::LN_PBrcBar: //CT_PBdr, bar
     case NS_ooxml::LN_CT_PPrBase_pStyle: //CT_PPrBase, pStyle
     case NS_sprm::LN_PFKeepFollow: //CT_PPrBase, keepNext
     case NS_sprm::LN_PFKeep: //CT_PPrBase, keepLines
     case NS_sprm::LN_PFPageBreakBefore: //CT_PPrBase, pageBreakBefore
     case NS_ooxml::LN_CT_PPrBase_framePr: //CT_PPrBase, framePr
     case NS_ooxml::LN_CT_PPrBase_windowControl: //CT_PPrBase, widowControl
     case NS_ooxml::LN_CT_PPrBase_numPr: //CT_PPrBase, numPr
     case NS_sprm::LN_PFNoLineNumb: //CT_PPrBase, suppressLineNumbers
     case NS_ooxml::LN_CT_PrBase_pBdr: //CT_PPrBase, pBdr
     case NS_sprm::LN_PShd: //CT_PPrBase, shd
     case NS_sprm::LN_PFNoAutoHyph: //CT_PPrBase, suppressAutoHyphens
     case NS_ooxml::LN_CT_PPrBase_kinsoku: //CT_PPrBase, kinsoku
     case NS_ooxml::LN_CT_PPrBase_wordWrap: //CT_PPrBase, wordWrap
     case NS_sprm::LN_PFOverflowPunct: //CT_PPrBase, overflowPunct
     case NS_sprm::LN_PFTopLinePunct: //CT_PPrBase, topLinePunct
     case NS_sprm::LN_PFAutoSpaceDE: //CT_PPrBase, autoSpaceDE
     case NS_sprm::LN_PFAutoSpaceDN: //CT_PPrBase, autoSpaceDN
     case NS_sprm::LN_PFBiDi: //CT_PPrBase, bidi
     case NS_ooxml::LN_CT_PPrBase_adjustRightInd: //CT_PPrBase, adjustRightInd
     case NS_ooxml::LN_CT_PPrBase_snapToGrid: //CT_PPrBase, snapToGrid
     case NS_ooxml::LN_CT_PPrBase_spacing: //CT_PPrBase, spacing
     case NS_ooxml::LN_CT_PPrBase_ind: //CT_PPrBase, ind
     case 0x246d: //CT_PPrBase, contextualSpacing
     case 0x2470: //CT_PPrBase, mirrorIndents
     case 0x2462: //CT_PPrBase, suppressOverlap
     case NS_sprm::LN_PJc: //CT_PPrBase, jc
     case NS_sprm::LN_PFrameTextFlow: //CT_PPrBase, textDirection
     case NS_sprm::LN_PWAlignFont: //CT_PPrBase, textAlignment
     case NS_sprm::LN_PTightWrap: //CT_PPrBase, textboxTightWrap
     case NS_sprm::LN_POutLvl: //CT_PPrBase, outlineLvl
     case NS_ooxml::LN_CT_PPrBase_divId: //CT_PPrBase, divId
     case NS_ooxml::LN_CT_PPrBase_cnfStyle: //CT_PPrBase, cnfStyle
     case NS_ooxml::LN_EG_RPrBase_rStyle: //EG_RPrBase, rStyle
     case NS_ooxml::LN_EG_RPrBase_rFonts: //EG_RPrBase, rFonts
     case NS_sprm::LN_CFBold: //EG_RPrBase, b
     case NS_sprm::LN_CFBoldBi: //EG_RPrBase, bCs
     case NS_sprm::LN_CFItalic: //EG_RPrBase, i
     case NS_sprm::LN_CFItalicBi: //EG_RPrBase, iCs
     case NS_sprm::LN_CFCaps: //EG_RPrBase, caps
     case NS_sprm::LN_CFSmallCaps: //EG_RPrBase, smallCaps
     case NS_sprm::LN_CFStrike: //EG_RPrBase, strike
     case NS_sprm::LN_CFDStrike: //EG_RPrBase, dstrike
     case NS_sprm::LN_CFOutline: //EG_RPrBase, outline
     case NS_sprm::LN_CFShadow: //EG_RPrBase, shadow
     case NS_sprm::LN_CFEmboss: //EG_RPrBase, emboss
     case NS_sprm::LN_CFImprint: //EG_RPrBase, imprint
     case NS_sprm::LN_CFNoProof: //EG_RPrBase, noProof
     case NS_ooxml::LN_EG_RPrBase_snapToGrid: //EG_RPrBase, snapToGrid
     case NS_sprm::LN_CFVanish: //EG_RPrBase, vanish
     case NS_ooxml::LN_EG_RPrBase_color: //EG_RPrBase, color
     case NS_sprm::LN_CDxaSpace: //EG_RPrBase, spacing
     case NS_sprm::LN_CCharScale: //EG_RPrBase, w
     case NS_sprm::LN_CHpsKern: //EG_RPrBase, kern
     case NS_sprm::LN_CHpsPos: //EG_RPrBase, position
     case NS_sprm::LN_CHps: //EG_RPrBase, sz
     case NS_sprm::LN_CHpsBi: //EG_RPrBase, szCs
     case NS_sprm::LN_CHighlight: //EG_RPrBase, highlight
     case NS_ooxml::LN_EG_RPrBase_u: //EG_RPrBase, u
     case NS_sprm::LN_CSfxText: //EG_RPrBase, effect
     case NS_ooxml::LN_EG_RPrBase_bdr: //EG_RPrBase, bdr
     case NS_ooxml::LN_EG_RPrBase_shd: //EG_RPrBase, shd
     case NS_ooxml::LN_EG_RPrBase_fitText: //EG_RPrBase, fitText
     case NS_ooxml::LN_EG_RPrBase_vertAlign: //EG_RPrBase, vertAlign
     case NS_ooxml::LN_EG_RPrBase_rtl: //EG_RPrBase, rtl
     case NS_sprm::LN_CComplexScript: //EG_RPrBase, cs
     case NS_sprm::LN_CKcd: //EG_RPrBase, em
     case NS_ooxml::LN_EG_RPrBase_lang: //EG_RPrBase, lang
     case NS_ooxml::LN_EG_RPrBase_eastAsianLayout: //EG_RPrBase, eastAsianLayout
     case 0x818: //EG_RPrBase, specVanish
     case NS_ooxml::LN_EG_RPrBase_oMath: //EG_RPrBase, oMath
     case NS_rtf::LN_ISTARTAT: //CT_Lvl, start
     case NS_rtf::LN_NFC: //CT_Lvl, numFmt
     case NS_ooxml::LN_CT_Lvl_lvlRestart: //CT_Lvl, lvlRestart
     case NS_ooxml::LN_CT_Lvl_pStyle: //CT_Lvl, pStyle
     case NS_rtf::LN_FLEGAL: //CT_Lvl, isLgl
     case NS_ooxml::LN_CT_Lvl_suff: //CT_Lvl, suff
     case NS_ooxml::LN_CT_Lvl_lvlText: //CT_Lvl, lvlText
     case NS_ooxml::LN_CT_Lvl_lvlPicBulletId: //CT_Lvl, lvlPicBulletId
     case NS_rtf::LN_FWORD6: //CT_Lvl, legacy
     case NS_ooxml::LN_CT_Lvl_lvlJc: //CT_Lvl, lvlJc
     case NS_ooxml::LN_CT_Lvl_pPr: //CT_Lvl, pPr
     case NS_ooxml::LN_CT_Lvl_rPr: //CT_Lvl, rPr
     case NS_rtf::LN_LSID: //CT_AbstractNum, nsid
     case NS_ooxml::LN_CT_AbstractNum_multiLevelType: //CT_AbstractNum, multiLevelType
     case NS_rtf::LN_TPLC: //CT_AbstractNum, tmpl
     case NS_ooxml::LN_CT_AbstractNum_name: //CT_AbstractNum, name
     case NS_ooxml::LN_CT_AbstractNum_styleLink: //CT_AbstractNum, styleLink
     case NS_ooxml::LN_CT_AbstractNum_numStyleLink: //CT_AbstractNum, numStyleLink
     case NS_ooxml::LN_CT_AbstractNum_lvl: //CT_AbstractNum, lvl
     case NS_ooxml::LN_CT_NumLvl_startOverride: //CT_NumLvl, startOverride
     case NS_ooxml::LN_CT_NumLvl_lvl: //CT_NumLvl, lvl
     case NS_ooxml::LN_CT_Num_abstractNumId: //CT_Num, abstractNumId
     case NS_ooxml::LN_CT_Num_lvlOverride: //CT_Num, lvlOverride
     case NS_ooxml::LN_CT_Numbering_numPicBullet: //CT_Numbering, numPicBullet
     case NS_ooxml::LN_CT_Numbering_abstractNum: //CT_Numbering, abstractNum
     case NS_ooxml::LN_CT_Numbering_num: //CT_Numbering, num
     case NS_ooxml::LN_CT_Numbering_numIdMacAtCleanup: //CT_Numbering, numIdMacAtCleanup
      nResult = Sprm::PARAGRAPH;
      break;
     case NS_ooxml::LN_CT_Font_altName: //CT_Font, altName
     case NS_ooxml::LN_CT_Font_panose1: //CT_Font, panose1
     case NS_ooxml::LN_CT_Font_charset: //CT_Font, charset
     case NS_ooxml::LN_CT_Font_family: //CT_Font, family
     case NS_ooxml::LN_CT_Font_notTrueType: //CT_Font, notTrueType
     case NS_ooxml::LN_CT_Font_pitch: //CT_Font, pitch
     case NS_ooxml::LN_CT_Font_sig: //CT_Font, sig
     case NS_ooxml::LN_CT_Font_embedRegular: //CT_Font, embedRegular
     case NS_ooxml::LN_CT_Font_embedBold: //CT_Font, embedBold
     case NS_ooxml::LN_CT_Font_embedItalic: //CT_Font, embedItalic
     case NS_ooxml::LN_CT_Font_embedBoldItalic: //CT_Font, embedBoldItalic
      nResult = Sprm::CHARACTER;
      break;
     case NS_ooxml::LN_CT_TcBorders_top: //CT_TcBorders, top
     case NS_ooxml::LN_CT_TcBorders_left: //CT_TcBorders, left
     case NS_ooxml::LN_CT_TcBorders_bottom: //CT_TcBorders, bottom
     case NS_ooxml::LN_CT_TcBorders_right: //CT_TcBorders, right
     case NS_ooxml::LN_CT_TcBorders_insideH: //CT_TcBorders, insideH
     case NS_ooxml::LN_CT_TcBorders_insideV: //CT_TcBorders, insideV
     case NS_ooxml::LN_CT_TcBorders_tl2br: //CT_TcBorders, tl2br
     case NS_ooxml::LN_CT_TcBorders_tr2bl: //CT_TcBorders, tr2bl
     case NS_ooxml::LN_CT_TcMar_top: //CT_TcMar, top
     case NS_ooxml::LN_CT_TcMar_left: //CT_TcMar, left
     case NS_ooxml::LN_CT_TcMar_bottom: //CT_TcMar, bottom
     case NS_ooxml::LN_CT_TcMar_right: //CT_TcMar, right
     case NS_ooxml::LN_CT_TcPrBase_cnfStyle: //CT_TcPrBase, cnfStyle
     case NS_ooxml::LN_CT_TcPrBase_tcW: //CT_TcPrBase, tcW
     case NS_ooxml::LN_CT_TcPrBase_gridSpan: //CT_TcPrBase, gridSpan
     case NS_ooxml::LN_CT_TcPrBase_hMerge: //CT_TcPrBase, hMerge
     case NS_ooxml::LN_CT_TcPrBase_vMerge: //CT_TcPrBase, vMerge
     case NS_ooxml::LN_CT_TcPrBase_tcBorders: //CT_TcPrBase, tcBorders
     case NS_ooxml::LN_CT_TcPrBase_shd: //CT_TcPrBase, shd
     case NS_ooxml::LN_CT_TcPrBase_noWrap: //CT_TcPrBase, noWrap
     case NS_ooxml::LN_CT_TcPrBase_tcMar: //CT_TcPrBase, tcMar
     case NS_ooxml::LN_CT_TcPrBase_textDirection: //CT_TcPrBase, textDirection
     case NS_ooxml::LN_CT_TcPrBase_tcFitText: //CT_TcPrBase, tcFitText
     case NS_ooxml::LN_CT_TcPrBase_vAlign: //CT_TcPrBase, vAlign
     case NS_ooxml::LN_CT_TcPrBase_hideMark: //CT_TcPrBase, hideMark
     case NS_ooxml::LN_CT_TrPrBase_cnfStyle: //CT_TrPrBase, cnfStyle
     case NS_ooxml::LN_CT_TrPrBase_divId: //CT_TrPrBase, divId
     case NS_ooxml::LN_CT_TrPrBase_gridBefore: //CT_TrPrBase, gridBefore
     case NS_ooxml::LN_CT_TrPrBase_gridAfter: //CT_TrPrBase, gridAfter
     case NS_ooxml::LN_CT_TrPrBase_wBefore: //CT_TrPrBase, wBefore
     case NS_ooxml::LN_CT_TrPrBase_wAfter: //CT_TrPrBase, wAfter
     case NS_sprm::LN_TCantSplit: //CT_TrPrBase, cantSplit
     case NS_ooxml::LN_CT_TrPrBase_trHeight: //CT_TrPrBase, trHeight
     case NS_ooxml::LN_CT_TrPrBase_tblHeader: //CT_TrPrBase, tblHeader
     case NS_ooxml::LN_CT_TrPrBase_tblCellSpacing: //CT_TrPrBase, tblCellSpacing
     case NS_ooxml::LN_CT_TrPrBase_jc: //CT_TrPrBase, jc
     case NS_ooxml::LN_CT_TrPrBase_hidden: //CT_TrPrBase, hidden
     case NS_ooxml::LN_CT_TblBorders_top: //CT_TblBorders, top
     case NS_ooxml::LN_CT_TblBorders_left: //CT_TblBorders, left
     case NS_ooxml::LN_CT_TblBorders_bottom: //CT_TblBorders, bottom
     case NS_ooxml::LN_CT_TblBorders_right: //CT_TblBorders, right
     case NS_ooxml::LN_CT_TblBorders_insideH: //CT_TblBorders, insideH
     case NS_ooxml::LN_CT_TblBorders_insideV: //CT_TblBorders, insideV
     case NS_ooxml::LN_CT_TblPrBase_tblStyle: //CT_TblPrBase, tblStyle
     case NS_ooxml::LN_CT_TblPrBase_tblpPr: //CT_TblPrBase, tblpPr
     case NS_ooxml::LN_CT_TblPrBase_tblOverlap: //CT_TblPrBase, tblOverlap
     case NS_ooxml::LN_CT_TblPrBase_bidiVisual: //CT_TblPrBase, bidiVisual
     case NS_ooxml::LN_CT_TblPrBase_tblStyleRowBandSize: //CT_TblPrBase, tblStyleRowBandSize
     case NS_ooxml::LN_CT_TblPrBase_tblStyleColBandSize: //CT_TblPrBase, tblStyleColBandSize
     case NS_ooxml::LN_CT_TblPrBase_tblW: //CT_TblPrBase, tblW
     case NS_ooxml::LN_CT_TblPrBase_jc: //CT_TblPrBase, jc
     case NS_ooxml::LN_CT_TblPrBase_tblCellSpacing: //CT_TblPrBase, tblCellSpacing
     case NS_ooxml::LN_CT_TblPrBase_tblInd: //CT_TblPrBase, tblInd
     case NS_ooxml::LN_CT_TblPrBase_tblBorders: //CT_TblPrBase, tblBorders
     case NS_ooxml::LN_CT_TblPrBase_shd: //CT_TblPrBase, shd
     case NS_ooxml::LN_CT_TblPrBase_tblLayout: //CT_TblPrBase, tblLayout
     case NS_ooxml::LN_CT_TblPrBase_tblCellMar: //CT_TblPrBase, tblCellMar
     case NS_ooxml::LN_CT_TblPrBase_tblLook: //CT_TblPrBase, tblLook
     case NS_ooxml::LN_CT_TblPr_tblPrChange: //CT_TblPr, tblPrChange
      nResult = Sprm::TABLE;
      break;
    default:
      break;
    }

    return nResult;
}
      
OOXMLContext::Pointer_t OOXMLContext::elementFromRefs(TokenEnum_t nToken)
{
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_drawingml_blip(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_drawingml_graphic(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingDrawing_inline(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingDrawing_anchor(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_schemaLibrary_schemaLibrary(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_math_oMathPara(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_math_oMath(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_picture_pic(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_recipients(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_txbxContent(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_comments(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_footnotes(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_endnotes(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_hdr(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_ftr(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_settings(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_webSettings(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_fonts(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_numbering(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_styles(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_document(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            ( new OOXMLContext_wordprocessingml_glossaryDocument(*this));
        OOXMLContext::Pointer_t pContext(pTopContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
    }
        

    return OOXMLContext::Pointer_t();
}
    
doctok::Id OOXMLContext::getIdFromRefs(TokenEnum_t nToken)
{
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_drawingml_blip(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_drawingml_graphic(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingDrawing_inline(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingDrawing_anchor(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_schemaLibrary_schemaLibrary(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_math_oMathPara(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_math_oMath(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_picture_pic(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_recipients(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_txbxContent(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_comments(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_footnotes(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_endnotes(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_hdr(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_ftr(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_settings(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_webSettings(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_fonts(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_numbering(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_styles(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_document(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        
    {
        OOXMLContext::Pointer_t pTopContext
            (  new OOXMLContext_wordprocessingml_glossaryDocument(*this));
        doctok::Id nId = pTopContext->getId(nToken);

        if (nId != 0x0)
            return nId;
    }
        

    return 0x0;
}
    
/* 
    class: OOXMLContext_drawingml_CT_AlphaBiLevelEffect*/
OOXMLContext_drawingml_CT_AlphaBiLevelEffect::OOXMLContext_drawingml_CT_AlphaBiLevelEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaBiLevelEffect::~OOXMLContext_drawingml_CT_AlphaBiLevelEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaBiLevelEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaBiLevelEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaBiLevelEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaBiLevelEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaBiLevelEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaBiLevelEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaBiLevelEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaBiLevelEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaCeilingEffect*/
OOXMLContext_drawingml_CT_AlphaCeilingEffect::OOXMLContext_drawingml_CT_AlphaCeilingEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaCeilingEffect::~OOXMLContext_drawingml_CT_AlphaCeilingEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaCeilingEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaCeilingEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaCeilingEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaCeilingEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaCeilingEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaCeilingEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaCeilingEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaCeilingEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaFloorEffect*/
OOXMLContext_drawingml_CT_AlphaFloorEffect::OOXMLContext_drawingml_CT_AlphaFloorEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaFloorEffect::~OOXMLContext_drawingml_CT_AlphaFloorEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaFloorEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaFloorEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaFloorEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaFloorEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaFloorEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaFloorEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaFloorEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaFloorEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaInverseEffect*/
OOXMLContext_drawingml_CT_AlphaInverseEffect::OOXMLContext_drawingml_CT_AlphaInverseEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaInverseEffect::~OOXMLContext_drawingml_CT_AlphaInverseEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaInverseEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaInverseEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaInverseEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaInverseEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaInverseEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaInverseEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaInverseEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaInverseEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaModulateFixedEffect*/
OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::OOXMLContext_drawingml_CT_AlphaModulateFixedEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::~OOXMLContext_drawingml_CT_AlphaModulateFixedEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaModulateFixedEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaOutsetEffect*/
OOXMLContext_drawingml_CT_AlphaOutsetEffect::OOXMLContext_drawingml_CT_AlphaOutsetEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaOutsetEffect::~OOXMLContext_drawingml_CT_AlphaOutsetEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaOutsetEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaOutsetEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaOutsetEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaOutsetEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaOutsetEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaOutsetEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaOutsetEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaOutsetEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaReplaceEffect*/
OOXMLContext_drawingml_CT_AlphaReplaceEffect::OOXMLContext_drawingml_CT_AlphaReplaceEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaReplaceEffect::~OOXMLContext_drawingml_CT_AlphaReplaceEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaReplaceEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaReplaceEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaReplaceEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaReplaceEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaReplaceEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaReplaceEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaReplaceEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaReplaceEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_BiLevelEffect*/
OOXMLContext_drawingml_CT_BiLevelEffect::OOXMLContext_drawingml_CT_BiLevelEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_BiLevelEffect::~OOXMLContext_drawingml_CT_BiLevelEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_BiLevelEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_BiLevelEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_BiLevelEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_BiLevelEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_BiLevelEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_BiLevelEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_BiLevelEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_BiLevelEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_BlurEffect*/
OOXMLContext_drawingml_CT_BlurEffect::OOXMLContext_drawingml_CT_BlurEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_BlurEffect::~OOXMLContext_drawingml_CT_BlurEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_BlurEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_BlurEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_BlurEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_BlurEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_BlurEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_BlurEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_BlurEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_BlurEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ColorChangeEffect*/
OOXMLContext_drawingml_CT_ColorChangeEffect::OOXMLContext_drawingml_CT_ColorChangeEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ColorChangeEffect::~OOXMLContext_drawingml_CT_ColorChangeEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ColorChangeEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ColorChangeEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_clrFrom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Color(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_clrTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Color(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ColorChangeEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ColorChangeEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ColorChangeEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ColorChangeEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ColorChangeEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_ColorChangeEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ColorReplaceEffect*/
OOXMLContext_drawingml_CT_ColorReplaceEffect::OOXMLContext_drawingml_CT_ColorReplaceEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ColorReplaceEffect::~OOXMLContext_drawingml_CT_ColorReplaceEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ColorReplaceEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ColorReplaceEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ColorReplaceEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ColorReplaceEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ColorReplaceEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ColorReplaceEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ColorReplaceEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_ColorReplaceEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_DuotoneEffect*/
OOXMLContext_drawingml_CT_DuotoneEffect::OOXMLContext_drawingml_CT_DuotoneEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_DuotoneEffect::~OOXMLContext_drawingml_CT_DuotoneEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_DuotoneEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_DuotoneEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_DuotoneEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_DuotoneEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_DuotoneEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_DuotoneEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_DuotoneEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_DuotoneEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GlowEffect*/
OOXMLContext_drawingml_CT_GlowEffect::OOXMLContext_drawingml_CT_GlowEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GlowEffect::~OOXMLContext_drawingml_CT_GlowEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GlowEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GlowEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GlowEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GlowEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GlowEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GlowEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GlowEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_GlowEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GrayscaleEffect*/
OOXMLContext_drawingml_CT_GrayscaleEffect::OOXMLContext_drawingml_CT_GrayscaleEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GrayscaleEffect::~OOXMLContext_drawingml_CT_GrayscaleEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GrayscaleEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GrayscaleEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GrayscaleEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GrayscaleEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GrayscaleEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GrayscaleEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GrayscaleEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_GrayscaleEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_HSLEffect*/
OOXMLContext_drawingml_CT_HSLEffect::OOXMLContext_drawingml_CT_HSLEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_HSLEffect::~OOXMLContext_drawingml_CT_HSLEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_HSLEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_HSLEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_HSLEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_HSLEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_HSLEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_HSLEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_HSLEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_HSLEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_InnerShadowEffect*/
OOXMLContext_drawingml_CT_InnerShadowEffect::OOXMLContext_drawingml_CT_InnerShadowEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_InnerShadowEffect::~OOXMLContext_drawingml_CT_InnerShadowEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_InnerShadowEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_InnerShadowEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_InnerShadowEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_InnerShadowEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_InnerShadowEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_InnerShadowEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_InnerShadowEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_InnerShadowEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_LuminanceEffect*/
OOXMLContext_drawingml_CT_LuminanceEffect::OOXMLContext_drawingml_CT_LuminanceEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_LuminanceEffect::~OOXMLContext_drawingml_CT_LuminanceEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_LuminanceEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_LuminanceEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_LuminanceEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_LuminanceEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_LuminanceEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_LuminanceEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_LuminanceEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_LuminanceEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_OuterShadowEffect*/
OOXMLContext_drawingml_CT_OuterShadowEffect::OOXMLContext_drawingml_CT_OuterShadowEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_OuterShadowEffect::~OOXMLContext_drawingml_CT_OuterShadowEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_OuterShadowEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_OuterShadowEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_OuterShadowEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_OuterShadowEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_OuterShadowEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_OuterShadowEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_OuterShadowEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_OuterShadowEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PresetShadowEffect*/
OOXMLContext_drawingml_CT_PresetShadowEffect::OOXMLContext_drawingml_CT_PresetShadowEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PresetShadowEffect::~OOXMLContext_drawingml_CT_PresetShadowEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PresetShadowEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PresetShadowEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PresetShadowEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PresetShadowEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PresetShadowEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PresetShadowEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PresetShadowEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_PresetShadowEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ReflectionEffect*/
OOXMLContext_drawingml_CT_ReflectionEffect::OOXMLContext_drawingml_CT_ReflectionEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ReflectionEffect::~OOXMLContext_drawingml_CT_ReflectionEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ReflectionEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ReflectionEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ReflectionEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ReflectionEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ReflectionEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ReflectionEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ReflectionEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_ReflectionEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_RelativeOffsetEffect*/
OOXMLContext_drawingml_CT_RelativeOffsetEffect::OOXMLContext_drawingml_CT_RelativeOffsetEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_RelativeOffsetEffect::~OOXMLContext_drawingml_CT_RelativeOffsetEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_RelativeOffsetEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_RelativeOffsetEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_RelativeOffsetEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_RelativeOffsetEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_RelativeOffsetEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_RelativeOffsetEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_RelativeOffsetEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_RelativeOffsetEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SoftEdgesEffect*/
OOXMLContext_drawingml_CT_SoftEdgesEffect::OOXMLContext_drawingml_CT_SoftEdgesEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_SoftEdgesEffect::~OOXMLContext_drawingml_CT_SoftEdgesEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SoftEdgesEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SoftEdgesEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SoftEdgesEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SoftEdgesEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SoftEdgesEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SoftEdgesEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SoftEdgesEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_SoftEdgesEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_TintEffect*/
OOXMLContext_drawingml_CT_TintEffect::OOXMLContext_drawingml_CT_TintEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_TintEffect::~OOXMLContext_drawingml_CT_TintEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_TintEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_TintEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_TintEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_TintEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_TintEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_TintEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_TintEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_TintEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_TransformEffect*/
OOXMLContext_drawingml_CT_TransformEffect::OOXMLContext_drawingml_CT_TransformEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_TransformEffect::~OOXMLContext_drawingml_CT_TransformEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_TransformEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_TransformEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_TransformEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_TransformEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_TransformEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_TransformEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_TransformEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_TransformEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NoFillProperties*/
OOXMLContext_drawingml_CT_NoFillProperties::OOXMLContext_drawingml_CT_NoFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NoFillProperties::~OOXMLContext_drawingml_CT_NoFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NoFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NoFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NoFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NoFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NoFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NoFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NoFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_NoFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SolidColorFillProperties*/
OOXMLContext_drawingml_CT_SolidColorFillProperties::OOXMLContext_drawingml_CT_SolidColorFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_SolidColorFillProperties::~OOXMLContext_drawingml_CT_SolidColorFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SolidColorFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SolidColorFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SolidColorFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SolidColorFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SolidColorFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SolidColorFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SolidColorFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_SolidColorFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_LinearShadeProperties*/
OOXMLContext_drawingml_CT_LinearShadeProperties::OOXMLContext_drawingml_CT_LinearShadeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_LinearShadeProperties::~OOXMLContext_drawingml_CT_LinearShadeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_LinearShadeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_LinearShadeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_LinearShadeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_LinearShadeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_LinearShadeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_LinearShadeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_LinearShadeProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_LinearShadeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PathShadeProperties*/
OOXMLContext_drawingml_CT_PathShadeProperties::OOXMLContext_drawingml_CT_PathShadeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PathShadeProperties::~OOXMLContext_drawingml_CT_PathShadeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PathShadeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PathShadeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_fillToRect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_RelativeRect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PathShadeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PathShadeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PathShadeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PathShadeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PathShadeProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_PathShadeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_ShadeProperties*/
OOXMLContext_drawingml_EG_ShadeProperties::OOXMLContext_drawingml_EG_ShadeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_ShadeProperties::~OOXMLContext_drawingml_EG_ShadeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_ShadeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_ShadeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_lin:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_LinearShadeProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_path:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PathShadeProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_ShadeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_ShadeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_ShadeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_ShadeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_ShadeProperties::startAction()
{
}
void OOXMLContext_drawingml_EG_ShadeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GradientStop*/
OOXMLContext_drawingml_CT_GradientStop::OOXMLContext_drawingml_CT_GradientStop(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GradientStop::~OOXMLContext_drawingml_CT_GradientStop()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GradientStop::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GradientStop::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GradientStop::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GradientStop::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GradientStop::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GradientStop::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GradientStop::startAction()
{
}
void OOXMLContext_drawingml_CT_GradientStop::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GradientStopList*/
OOXMLContext_drawingml_CT_GradientStopList::OOXMLContext_drawingml_CT_GradientStopList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GradientStopList::~OOXMLContext_drawingml_CT_GradientStopList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GradientStopList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GradientStopList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_gs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GradientStop(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GradientStopList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GradientStopList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GradientStopList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GradientStopList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GradientStopList::startAction()
{
}
void OOXMLContext_drawingml_CT_GradientStopList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GradientFillProperties*/
OOXMLContext_drawingml_CT_GradientFillProperties::OOXMLContext_drawingml_CT_GradientFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GradientFillProperties::~OOXMLContext_drawingml_CT_GradientFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GradientFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ShadeProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GradientFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_gsLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GradientStopList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_tileRect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_RelativeRect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GradientFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GradientFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GradientFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ShadeProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GradientFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GradientFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_GradientFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_TileInfoProperties*/
OOXMLContext_drawingml_CT_TileInfoProperties::OOXMLContext_drawingml_CT_TileInfoProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_TileInfoProperties::~OOXMLContext_drawingml_CT_TileInfoProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_TileInfoProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_TileInfoProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_TileInfoProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_TileInfoProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_TileInfoProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_TileInfoProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_TileInfoProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_TileInfoProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_StretchInfoProperties*/
OOXMLContext_drawingml_CT_StretchInfoProperties::OOXMLContext_drawingml_CT_StretchInfoProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_StretchInfoProperties::~OOXMLContext_drawingml_CT_StretchInfoProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_StretchInfoProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_StretchInfoProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_fillRect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_RelativeRect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_StretchInfoProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_StretchInfoProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_StretchInfoProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_StretchInfoProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_StretchInfoProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_StretchInfoProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_FillModeProperties*/
OOXMLContext_drawingml_EG_FillModeProperties::OOXMLContext_drawingml_EG_FillModeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_FillModeProperties::~OOXMLContext_drawingml_EG_FillModeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_FillModeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_FillModeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_tile:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_TileInfoProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_stretch:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_StretchInfoProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_FillModeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_FillModeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_FillModeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_FillModeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_FillModeProperties::startAction()
{
}
void OOXMLContext_drawingml_EG_FillModeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Blip*/
OOXMLContext_drawingml_CT_Blip::OOXMLContext_drawingml_CT_Blip(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Blip::~OOXMLContext_drawingml_CT_Blip()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Blip::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Blip::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_alphaBiLevel:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaBiLevelEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaCeiling:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaCeilingEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaFloor:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaFloorEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaInv:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaInverseEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaModulateEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaModFix:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaModulateFixedEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaRepl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaReplaceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_biLevel:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BiLevelEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blur:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlurEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_clrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ColorChangeEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_clrRepl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ColorReplaceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_duotone:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_DuotoneEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_fillOverlay:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_FillOverlayEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_grayscl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GrayscaleEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hsl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_HSLEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lum:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_LuminanceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_tint:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_TintEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Blip::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Blip::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Blip::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Blip::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Blip::startAction()
{
}
void OOXMLContext_drawingml_CT_Blip::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_BlipFillProperties*/
OOXMLContext_drawingml_CT_BlipFillProperties::OOXMLContext_drawingml_CT_BlipFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_BlipFillProperties::~OOXMLContext_drawingml_CT_BlipFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_BlipFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillModeProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_BlipFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_blip:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Blip(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_srcRect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_RelativeRect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_BlipFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_BlipFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_BlipFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillModeProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_BlipFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_BlipFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_BlipFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PatternFillProperties*/
OOXMLContext_drawingml_CT_PatternFillProperties::OOXMLContext_drawingml_CT_PatternFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PatternFillProperties::~OOXMLContext_drawingml_CT_PatternFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PatternFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PatternFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_fgClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Color(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_bgClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Color(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PatternFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PatternFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PatternFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PatternFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PatternFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_PatternFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GroupFillProperties*/
OOXMLContext_drawingml_CT_GroupFillProperties::OOXMLContext_drawingml_CT_GroupFillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GroupFillProperties::~OOXMLContext_drawingml_CT_GroupFillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GroupFillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GroupFillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GroupFillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GroupFillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GroupFillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GroupFillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GroupFillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_GroupFillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_FillProperties*/
OOXMLContext_drawingml_EG_FillProperties::OOXMLContext_drawingml_EG_FillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_FillProperties::~OOXMLContext_drawingml_EG_FillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_FillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_FillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_noFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NoFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_solidFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SolidColorFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_gradFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GradientFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blipFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlipFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_pattFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PatternFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_grpFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GroupFillProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_FillProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_FillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_FillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_FillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_FillProperties::startAction()
{
}
void OOXMLContext_drawingml_EG_FillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_FillProperties*/
OOXMLContext_drawingml_CT_FillProperties::OOXMLContext_drawingml_CT_FillProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_FillProperties::~OOXMLContext_drawingml_CT_FillProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_FillProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_FillProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_FillProperties::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_FillProperties(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_FillProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_FillProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_FillProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_FillProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_FillProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_FillEffect*/
OOXMLContext_drawingml_CT_FillEffect::OOXMLContext_drawingml_CT_FillEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_FillEffect::~OOXMLContext_drawingml_CT_FillEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_FillEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_FillEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_FillEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_FillProperties(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_FillEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_FillEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_FillEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_FillEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_FillEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_FillOverlayEffect*/
OOXMLContext_drawingml_CT_FillOverlayEffect::OOXMLContext_drawingml_CT_FillOverlayEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_FillOverlayEffect::~OOXMLContext_drawingml_CT_FillOverlayEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_FillOverlayEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_FillOverlayEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_FillOverlayEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_FillProperties(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_FillOverlayEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_FillOverlayEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_FillOverlayEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_FillOverlayEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_FillOverlayEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_EffectReference*/
OOXMLContext_drawingml_CT_EffectReference::OOXMLContext_drawingml_CT_EffectReference(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_EffectReference::~OOXMLContext_drawingml_CT_EffectReference()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_EffectReference::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_EffectReference::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_EffectReference::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_EffectReference::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_EffectReference::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_EffectReference::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_EffectReference::startAction()
{
}
void OOXMLContext_drawingml_CT_EffectReference::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_Effect*/
OOXMLContext_drawingml_EG_Effect::OOXMLContext_drawingml_EG_Effect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_Effect::~OOXMLContext_drawingml_EG_Effect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_Effect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_Effect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_cont:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectContainer(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_effect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectReference(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaBiLevel:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaBiLevelEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaCeiling:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaCeilingEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaFloor:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaFloorEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaInv:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaInverseEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaModulateEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaModFix:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaModulateFixedEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaOutset:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaOutsetEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaRepl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AlphaReplaceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_biLevel:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BiLevelEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blend:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlendEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blur:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlurEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_clrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ColorChangeEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_clrRepl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ColorReplaceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_duotone:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_DuotoneEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_fill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_FillEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_fillOverlay:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_FillOverlayEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_glow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GlowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_grayscl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GrayscaleEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hsl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_HSLEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_innerShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_InnerShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lum:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_LuminanceEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_outerShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OuterShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_prstShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PresetShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_reflection:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ReflectionEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_relOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_RelativeOffsetEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_softEdge:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SoftEdgesEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_tint:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_TintEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_xfrm:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_TransformEffect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_Effect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_Effect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_Effect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_Effect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_Effect::startAction()
{
}
void OOXMLContext_drawingml_EG_Effect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_EffectContainer*/
OOXMLContext_drawingml_CT_EffectContainer::OOXMLContext_drawingml_CT_EffectContainer(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_EffectContainer::~OOXMLContext_drawingml_CT_EffectContainer()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_EffectContainer::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_Effect(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_EffectContainer::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_EffectContainer::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_EffectContainer::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_EffectContainer::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_Effect(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_EffectContainer::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_EffectContainer::startAction()
{
}
void OOXMLContext_drawingml_CT_EffectContainer::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AlphaModulateEffect*/
OOXMLContext_drawingml_CT_AlphaModulateEffect::OOXMLContext_drawingml_CT_AlphaModulateEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AlphaModulateEffect::~OOXMLContext_drawingml_CT_AlphaModulateEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AlphaModulateEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AlphaModulateEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_cont:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectContainer(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AlphaModulateEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AlphaModulateEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AlphaModulateEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AlphaModulateEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AlphaModulateEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_AlphaModulateEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_BlendEffect*/
OOXMLContext_drawingml_CT_BlendEffect::OOXMLContext_drawingml_CT_BlendEffect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_BlendEffect::~OOXMLContext_drawingml_CT_BlendEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_BlendEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_BlendEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_cont:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectContainer(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_BlendEffect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_BlendEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_BlendEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_BlendEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_BlendEffect::startAction()
{
}
void OOXMLContext_drawingml_CT_BlendEffect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_EffectList*/
OOXMLContext_drawingml_CT_EffectList::OOXMLContext_drawingml_CT_EffectList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_EffectList::~OOXMLContext_drawingml_CT_EffectList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_EffectList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_EffectList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_blur:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlurEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_fillOverlay:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_FillOverlayEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_glow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GlowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_innerShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_InnerShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_outerShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OuterShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_prstShdw:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PresetShadowEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_reflection:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ReflectionEffect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_softEdge:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SoftEdgesEffect(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_EffectList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_EffectList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_EffectList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_EffectList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_EffectList::startAction()
{
}
void OOXMLContext_drawingml_CT_EffectList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_EffectProperties*/
OOXMLContext_drawingml_EG_EffectProperties::OOXMLContext_drawingml_EG_EffectProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_EffectProperties::~OOXMLContext_drawingml_EG_EffectProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_EffectProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_EffectProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_effectLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_effectDag:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EffectContainer(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_EffectProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_EffectProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_EffectProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_EffectProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_EffectProperties::startAction()
{
}
void OOXMLContext_drawingml_EG_EffectProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_EffectProperties*/
OOXMLContext_drawingml_CT_EffectProperties::OOXMLContext_drawingml_CT_EffectProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_EffectProperties::~OOXMLContext_drawingml_CT_EffectProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_EffectProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_EffectProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_EffectProperties::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_EffectProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_EffectProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_EffectProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_EffectProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_EffectProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_blip*/
OOXMLContext_drawingml_blip::OOXMLContext_drawingml_blip(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_blip::~OOXMLContext_drawingml_blip()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_blip::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_blip::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_blip:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Blip(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_blip::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_blip::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_blip::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_blip::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_blip::startAction()
{
}
void OOXMLContext_drawingml_blip::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ShapeProperties*/
OOXMLContext_drawingml_CT_ShapeProperties::OOXMLContext_drawingml_CT_ShapeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ShapeProperties::~OOXMLContext_drawingml_CT_ShapeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ShapeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_Geometry(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ShapeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_xfrm:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Transform2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ShapeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ShapeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ShapeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_Geometry(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ShapeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ShapeProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_ShapeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GroupShapeProperties*/
OOXMLContext_drawingml_CT_GroupShapeProperties::OOXMLContext_drawingml_CT_GroupShapeProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GroupShapeProperties::~OOXMLContext_drawingml_CT_GroupShapeProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GroupShapeProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GroupShapeProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_xfrm:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GroupTransform2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GroupShapeProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GroupShapeProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GroupShapeProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_FillProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_EffectProperties(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GroupShapeProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GroupShapeProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_GroupShapeProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_OfficeArtExtension*/
OOXMLContext_drawingml_CT_OfficeArtExtension::OOXMLContext_drawingml_CT_OfficeArtExtension(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_OfficeArtExtension::~OOXMLContext_drawingml_CT_OfficeArtExtension()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_OfficeArtExtension::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_OfficeArtExtension::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_OfficeArtExtension::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_OfficeArtExtension::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_OfficeArtExtension::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_OfficeArtExtension::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_OfficeArtExtension::startAction()
{
}
void OOXMLContext_drawingml_CT_OfficeArtExtension::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Angle*/
OOXMLContext_drawingml_CT_Angle::OOXMLContext_drawingml_CT_Angle(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_Angle::~OOXMLContext_drawingml_CT_Angle()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Angle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Angle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Angle::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Angle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Angle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Angle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Angle::startAction()
{
}
void OOXMLContext_drawingml_CT_Angle::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PositiveFixedAngle*/
OOXMLContext_drawingml_CT_PositiveFixedAngle::OOXMLContext_drawingml_CT_PositiveFixedAngle(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_PositiveFixedAngle::~OOXMLContext_drawingml_CT_PositiveFixedAngle()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PositiveFixedAngle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PositiveFixedAngle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PositiveFixedAngle::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PositiveFixedAngle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PositiveFixedAngle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PositiveFixedAngle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PositiveFixedAngle::startAction()
{
}
void OOXMLContext_drawingml_CT_PositiveFixedAngle::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Percentage*/
OOXMLContext_drawingml_CT_Percentage::OOXMLContext_drawingml_CT_Percentage(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_Percentage::~OOXMLContext_drawingml_CT_Percentage()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Percentage::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Percentage::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Percentage::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Percentage::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Percentage::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Percentage::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Percentage::startAction()
{
}
void OOXMLContext_drawingml_CT_Percentage::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PositivePercentage*/
OOXMLContext_drawingml_CT_PositivePercentage::OOXMLContext_drawingml_CT_PositivePercentage(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_PositivePercentage::~OOXMLContext_drawingml_CT_PositivePercentage()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PositivePercentage::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PositivePercentage::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PositivePercentage::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PositivePercentage::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PositivePercentage::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PositivePercentage::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PositivePercentage::startAction()
{
}
void OOXMLContext_drawingml_CT_PositivePercentage::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_FixedPercentage*/
OOXMLContext_drawingml_CT_FixedPercentage::OOXMLContext_drawingml_CT_FixedPercentage(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_FixedPercentage::~OOXMLContext_drawingml_CT_FixedPercentage()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_FixedPercentage::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_FixedPercentage::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_FixedPercentage::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_FixedPercentage::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_FixedPercentage::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_FixedPercentage::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_FixedPercentage::startAction()
{
}
void OOXMLContext_drawingml_CT_FixedPercentage::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PositiveFixedPercentage*/
OOXMLContext_drawingml_CT_PositiveFixedPercentage::OOXMLContext_drawingml_CT_PositiveFixedPercentage(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_PositiveFixedPercentage::~OOXMLContext_drawingml_CT_PositiveFixedPercentage()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PositiveFixedPercentage::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PositiveFixedPercentage::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PositiveFixedPercentage::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PositiveFixedPercentage::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PositiveFixedPercentage::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PositiveFixedPercentage::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PositiveFixedPercentage::startAction()
{
}
void OOXMLContext_drawingml_CT_PositiveFixedPercentage::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Ratio*/
OOXMLContext_drawingml_CT_Ratio::OOXMLContext_drawingml_CT_Ratio(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Ratio::~OOXMLContext_drawingml_CT_Ratio()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Ratio::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Ratio::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Ratio::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Ratio::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Ratio::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Ratio::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Ratio::startAction()
{
}
void OOXMLContext_drawingml_CT_Ratio::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Point2D*/
OOXMLContext_drawingml_CT_Point2D::OOXMLContext_drawingml_CT_Point2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Point2D::~OOXMLContext_drawingml_CT_Point2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Point2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Point2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Point2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Point2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Point2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Point2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Point2D::startAction()
{
}
void OOXMLContext_drawingml_CT_Point2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PositiveSize2D*/
OOXMLContext_drawingml_CT_PositiveSize2D::OOXMLContext_drawingml_CT_PositiveSize2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PositiveSize2D::~OOXMLContext_drawingml_CT_PositiveSize2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PositiveSize2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PositiveSize2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PositiveSize2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PositiveSize2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PositiveSize2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PositiveSize2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PositiveSize2D::startAction()
{
}
void OOXMLContext_drawingml_CT_PositiveSize2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ComplementTransform*/
OOXMLContext_drawingml_CT_ComplementTransform::OOXMLContext_drawingml_CT_ComplementTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ComplementTransform::~OOXMLContext_drawingml_CT_ComplementTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ComplementTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ComplementTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ComplementTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ComplementTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ComplementTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ComplementTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ComplementTransform::startAction()
{
}
void OOXMLContext_drawingml_CT_ComplementTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_InverseTransform*/
OOXMLContext_drawingml_CT_InverseTransform::OOXMLContext_drawingml_CT_InverseTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_InverseTransform::~OOXMLContext_drawingml_CT_InverseTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_InverseTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_InverseTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_InverseTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_InverseTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_InverseTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_InverseTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_InverseTransform::startAction()
{
}
void OOXMLContext_drawingml_CT_InverseTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GrayscaleTransform*/
OOXMLContext_drawingml_CT_GrayscaleTransform::OOXMLContext_drawingml_CT_GrayscaleTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GrayscaleTransform::~OOXMLContext_drawingml_CT_GrayscaleTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GrayscaleTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GrayscaleTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GrayscaleTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GrayscaleTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GrayscaleTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GrayscaleTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GrayscaleTransform::startAction()
{
}
void OOXMLContext_drawingml_CT_GrayscaleTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GammaTransform*/
OOXMLContext_drawingml_CT_GammaTransform::OOXMLContext_drawingml_CT_GammaTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GammaTransform::~OOXMLContext_drawingml_CT_GammaTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GammaTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GammaTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GammaTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GammaTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GammaTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GammaTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GammaTransform::startAction()
{
}
void OOXMLContext_drawingml_CT_GammaTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_InverseGammaTransform*/
OOXMLContext_drawingml_CT_InverseGammaTransform::OOXMLContext_drawingml_CT_InverseGammaTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_InverseGammaTransform::~OOXMLContext_drawingml_CT_InverseGammaTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_InverseGammaTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_InverseGammaTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_InverseGammaTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_InverseGammaTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_InverseGammaTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_InverseGammaTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_InverseGammaTransform::startAction()
{
}
void OOXMLContext_drawingml_CT_InverseGammaTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_ColorTransform*/
OOXMLContext_drawingml_EG_ColorTransform::OOXMLContext_drawingml_EG_ColorTransform(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_ColorTransform::~OOXMLContext_drawingml_EG_ColorTransform()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_ColorTransform::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_ColorTransform::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_tint:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveFixedPercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_shade:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveFixedPercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_comp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ComplementTransform(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_inv:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_InverseTransform(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_gray:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GrayscaleTransform(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alpha:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveFixedPercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_FixedPercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_alphaMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositivePercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hue:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveFixedAngle(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hueOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Angle(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hueMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositivePercentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_sat:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_satOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_satMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lum:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lumOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lumMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_red:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_redOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_redMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_green:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_greenOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_greenMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blue:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blueOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_blueMod:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Percentage(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_gamma:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GammaTransform(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_invGamma:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_InverseGammaTransform(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_ColorTransform::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_ColorTransform::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_ColorTransform::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_ColorTransform::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_ColorTransform::startAction()
{
}
void OOXMLContext_drawingml_EG_ColorTransform::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ScRgbColor*/
OOXMLContext_drawingml_CT_ScRgbColor::OOXMLContext_drawingml_CT_ScRgbColor(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ScRgbColor::~OOXMLContext_drawingml_CT_ScRgbColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ScRgbColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ScRgbColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ScRgbColor::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ScRgbColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ScRgbColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ScRgbColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ScRgbColor::startAction()
{
}
void OOXMLContext_drawingml_CT_ScRgbColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SRgbColor*/
OOXMLContext_drawingml_CT_SRgbColor::OOXMLContext_drawingml_CT_SRgbColor(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_SRgbColor::~OOXMLContext_drawingml_CT_SRgbColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SRgbColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SRgbColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SRgbColor::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SRgbColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SRgbColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SRgbColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SRgbColor::startAction()
{
}
void OOXMLContext_drawingml_CT_SRgbColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_HslColor*/
OOXMLContext_drawingml_CT_HslColor::OOXMLContext_drawingml_CT_HslColor(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_HslColor::~OOXMLContext_drawingml_CT_HslColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_HslColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_HslColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_HslColor::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_HslColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_HslColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_HslColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_HslColor::startAction()
{
}
void OOXMLContext_drawingml_CT_HslColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SystemColor*/
OOXMLContext_drawingml_CT_SystemColor::OOXMLContext_drawingml_CT_SystemColor(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_SystemColor::~OOXMLContext_drawingml_CT_SystemColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SystemColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SystemColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SystemColor::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_drawingml_lastClr:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SystemColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SystemColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SystemColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SystemColor::startAction()
{
}
void OOXMLContext_drawingml_CT_SystemColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SchemeColor*/
OOXMLContext_drawingml_CT_SchemeColor::OOXMLContext_drawingml_CT_SchemeColor(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_SchemeColor::~OOXMLContext_drawingml_CT_SchemeColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SchemeColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SchemeColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SchemeColor::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SchemeColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SchemeColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SchemeColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SchemeColor::startAction()
{
}
void OOXMLContext_drawingml_CT_SchemeColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PresetColor*/
OOXMLContext_drawingml_CT_PresetColor::OOXMLContext_drawingml_CT_PresetColor(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_drawingml_CT_PresetColor::~OOXMLContext_drawingml_CT_PresetColor()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PresetColor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PresetColor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PresetColor::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_drawingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PresetColor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PresetColor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorTransform(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PresetColor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PresetColor::startAction()
{
}
void OOXMLContext_drawingml_CT_PresetColor::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_OfficeArtExtensionList*/
OOXMLContext_drawingml_EG_OfficeArtExtensionList::OOXMLContext_drawingml_EG_OfficeArtExtensionList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_OfficeArtExtensionList::~OOXMLContext_drawingml_EG_OfficeArtExtensionList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_OfficeArtExtensionList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_OfficeArtExtensionList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_ext:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtension(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_OfficeArtExtensionList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_OfficeArtExtensionList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_OfficeArtExtensionList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_OfficeArtExtensionList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_OfficeArtExtensionList::startAction()
{
}
void OOXMLContext_drawingml_EG_OfficeArtExtensionList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_OfficeArtExtensionList*/
OOXMLContext_drawingml_CT_OfficeArtExtensionList::OOXMLContext_drawingml_CT_OfficeArtExtensionList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_OfficeArtExtensionList::~OOXMLContext_drawingml_CT_OfficeArtExtensionList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_OfficeArtExtensionList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_OfficeArtExtensionList(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_OfficeArtExtensionList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_OfficeArtExtensionList::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_OfficeArtExtensionList(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_OfficeArtExtensionList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_OfficeArtExtensionList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_OfficeArtExtensionList(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_OfficeArtExtensionList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_OfficeArtExtensionList::startAction()
{
}
void OOXMLContext_drawingml_CT_OfficeArtExtensionList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Scale2D*/
OOXMLContext_drawingml_CT_Scale2D::OOXMLContext_drawingml_CT_Scale2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Scale2D::~OOXMLContext_drawingml_CT_Scale2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Scale2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Scale2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_sx:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Ratio(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_sy:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Ratio(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Scale2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Scale2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Scale2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Scale2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Scale2D::startAction()
{
}
void OOXMLContext_drawingml_CT_Scale2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Transform2D*/
OOXMLContext_drawingml_CT_Transform2D::OOXMLContext_drawingml_CT_Transform2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Transform2D::~OOXMLContext_drawingml_CT_Transform2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Transform2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Transform2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_off:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_ext:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveSize2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Transform2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Transform2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Transform2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Transform2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Transform2D::startAction()
{
}
void OOXMLContext_drawingml_CT_Transform2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GroupTransform2D*/
OOXMLContext_drawingml_CT_GroupTransform2D::OOXMLContext_drawingml_CT_GroupTransform2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GroupTransform2D::~OOXMLContext_drawingml_CT_GroupTransform2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GroupTransform2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GroupTransform2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_off:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_ext:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveSize2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_chOff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_chExt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveSize2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GroupTransform2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GroupTransform2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GroupTransform2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GroupTransform2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GroupTransform2D::startAction()
{
}
void OOXMLContext_drawingml_CT_GroupTransform2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Point3D*/
OOXMLContext_drawingml_CT_Point3D::OOXMLContext_drawingml_CT_Point3D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Point3D::~OOXMLContext_drawingml_CT_Point3D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Point3D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Point3D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Point3D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Point3D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Point3D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Point3D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Point3D::startAction()
{
}
void OOXMLContext_drawingml_CT_Point3D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Vector3D*/
OOXMLContext_drawingml_CT_Vector3D::OOXMLContext_drawingml_CT_Vector3D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Vector3D::~OOXMLContext_drawingml_CT_Vector3D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Vector3D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Vector3D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Vector3D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Vector3D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Vector3D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Vector3D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Vector3D::startAction()
{
}
void OOXMLContext_drawingml_CT_Vector3D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_SphereCoords*/
OOXMLContext_drawingml_CT_SphereCoords::OOXMLContext_drawingml_CT_SphereCoords(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_SphereCoords::~OOXMLContext_drawingml_CT_SphereCoords()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_SphereCoords::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_SphereCoords::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_SphereCoords::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_SphereCoords::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_SphereCoords::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_SphereCoords::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_SphereCoords::startAction()
{
}
void OOXMLContext_drawingml_CT_SphereCoords::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_RelativeRect*/
OOXMLContext_drawingml_CT_RelativeRect::OOXMLContext_drawingml_CT_RelativeRect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_RelativeRect::~OOXMLContext_drawingml_CT_RelativeRect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_RelativeRect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_RelativeRect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_RelativeRect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_RelativeRect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_RelativeRect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_RelativeRect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_RelativeRect::startAction()
{
}
void OOXMLContext_drawingml_CT_RelativeRect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_ColorChoice*/
OOXMLContext_drawingml_EG_ColorChoice::OOXMLContext_drawingml_EG_ColorChoice(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_ColorChoice::~OOXMLContext_drawingml_EG_ColorChoice()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_ColorChoice::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_ColorChoice::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_scrgbClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ScRgbColor(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_srgbClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SRgbColor(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hslClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_HslColor(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_sysClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SystemColor(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_schemeClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_SchemeColor(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_prstClr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PresetColor(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_ColorChoice::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_ColorChoice::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_ColorChoice::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_ColorChoice::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_ColorChoice::startAction()
{
}
void OOXMLContext_drawingml_EG_ColorChoice::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Color*/
OOXMLContext_drawingml_CT_Color::OOXMLContext_drawingml_CT_Color(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Color::~OOXMLContext_drawingml_CT_Color()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Color::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Color::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Color::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Color::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Color::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Color::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Color::startAction()
{
}
void OOXMLContext_drawingml_CT_Color::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ColorMRU*/
OOXMLContext_drawingml_CT_ColorMRU::OOXMLContext_drawingml_CT_ColorMRU(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ColorMRU::~OOXMLContext_drawingml_CT_ColorMRU()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ColorMRU::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ColorMRU::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ColorMRU::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ColorMRU::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ColorMRU::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_drawingml_EG_ColorChoice(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ColorMRU::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ColorMRU::startAction()
{
}
void OOXMLContext_drawingml_CT_ColorMRU::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile*/
OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::~OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::startAction()
{
}
void OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Hyperlink*/
OOXMLContext_drawingml_CT_Hyperlink::OOXMLContext_drawingml_CT_Hyperlink(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Hyperlink::~OOXMLContext_drawingml_CT_Hyperlink()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Hyperlink::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Hyperlink::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_snd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_EmbeddedWAVAudioFile(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Hyperlink::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Hyperlink::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Hyperlink::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Hyperlink::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Hyperlink::startAction()
{
}
void OOXMLContext_drawingml_CT_Hyperlink::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ConnectorLocking*/
OOXMLContext_drawingml_CT_ConnectorLocking::OOXMLContext_drawingml_CT_ConnectorLocking(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ConnectorLocking::~OOXMLContext_drawingml_CT_ConnectorLocking()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ConnectorLocking::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ConnectorLocking::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ConnectorLocking::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ConnectorLocking::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ConnectorLocking::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ConnectorLocking::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ConnectorLocking::startAction()
{
}
void OOXMLContext_drawingml_CT_ConnectorLocking::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ShapeLocking*/
OOXMLContext_drawingml_CT_ShapeLocking::OOXMLContext_drawingml_CT_ShapeLocking(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ShapeLocking::~OOXMLContext_drawingml_CT_ShapeLocking()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ShapeLocking::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ShapeLocking::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ShapeLocking::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ShapeLocking::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ShapeLocking::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ShapeLocking::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ShapeLocking::startAction()
{
}
void OOXMLContext_drawingml_CT_ShapeLocking::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PictureLocking*/
OOXMLContext_drawingml_CT_PictureLocking::OOXMLContext_drawingml_CT_PictureLocking(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PictureLocking::~OOXMLContext_drawingml_CT_PictureLocking()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PictureLocking::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PictureLocking::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PictureLocking::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PictureLocking::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PictureLocking::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PictureLocking::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PictureLocking::startAction()
{
}
void OOXMLContext_drawingml_CT_PictureLocking::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GroupLocking*/
OOXMLContext_drawingml_CT_GroupLocking::OOXMLContext_drawingml_CT_GroupLocking(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GroupLocking::~OOXMLContext_drawingml_CT_GroupLocking()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GroupLocking::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GroupLocking::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GroupLocking::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GroupLocking::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GroupLocking::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GroupLocking::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GroupLocking::startAction()
{
}
void OOXMLContext_drawingml_CT_GroupLocking::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking*/
OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::~OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::startAction()
{
}
void OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualDrawingProps*/
OOXMLContext_drawingml_CT_NonVisualDrawingProps::OOXMLContext_drawingml_CT_NonVisualDrawingProps(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualDrawingProps::~OOXMLContext_drawingml_CT_NonVisualDrawingProps()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualDrawingProps::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualDrawingProps::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_hlinkClick:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Hyperlink(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_hlinkHover:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Hyperlink(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualDrawingProps::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualDrawingProps::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualDrawingProps::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualDrawingProps::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualDrawingProps::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualDrawingProps::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps*/
OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::~OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_spLocks:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ShapeLocking(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualDrawingShapeProps::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualConnectorProperties*/
OOXMLContext_drawingml_CT_NonVisualConnectorProperties::OOXMLContext_drawingml_CT_NonVisualConnectorProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualConnectorProperties::~OOXMLContext_drawingml_CT_NonVisualConnectorProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualConnectorProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualConnectorProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_cxnSpLocks:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ConnectorLocking(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_stCxn:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Connection(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_endCxn:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Connection(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualConnectorProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualConnectorProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualConnectorProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualConnectorProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualConnectorProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualConnectorProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualPictureProperties*/
OOXMLContext_drawingml_CT_NonVisualPictureProperties::OOXMLContext_drawingml_CT_NonVisualPictureProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualPictureProperties::~OOXMLContext_drawingml_CT_NonVisualPictureProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualPictureProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualPictureProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_picLocks:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PictureLocking(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualPictureProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualPictureProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualPictureProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualPictureProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualPictureProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualPictureProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps*/
OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::~OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_grpSpLocks:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GroupLocking(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualGroupDrawingShapeProps::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties*/
OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::~OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_graphicFrameLocks:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GraphicalObjectFrameLocking(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_extLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_OfficeArtExtensionList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::startAction()
{
}
void OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GraphicalObjectData*/
OOXMLContext_drawingml_CT_GraphicalObjectData::OOXMLContext_drawingml_CT_GraphicalObjectData(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GraphicalObjectData::~OOXMLContext_drawingml_CT_GraphicalObjectData()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GraphicalObjectData::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_picture_pic(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GraphicalObjectData::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GraphicalObjectData::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GraphicalObjectData::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GraphicalObjectData::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_picture_pic(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GraphicalObjectData::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GraphicalObjectData::startAction()
{
}
void OOXMLContext_drawingml_CT_GraphicalObjectData::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GraphicalObject*/
OOXMLContext_drawingml_CT_GraphicalObject::OOXMLContext_drawingml_CT_GraphicalObject(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GraphicalObject::~OOXMLContext_drawingml_CT_GraphicalObject()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GraphicalObject::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GraphicalObject::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_graphicData:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GraphicalObjectData(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GraphicalObject::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GraphicalObject::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GraphicalObject::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GraphicalObject::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GraphicalObject::startAction()
{
}
void OOXMLContext_drawingml_CT_GraphicalObject::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_graphic*/
OOXMLContext_drawingml_graphic::OOXMLContext_drawingml_graphic(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_graphic::~OOXMLContext_drawingml_graphic()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_graphic::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_graphic::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_graphic:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GraphicalObject(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_graphic::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_graphic::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_graphic::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_graphic::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_graphic::startAction()
{
}
void OOXMLContext_drawingml_graphic::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GeomGuide*/
OOXMLContext_drawingml_CT_GeomGuide::OOXMLContext_drawingml_CT_GeomGuide(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GeomGuide::~OOXMLContext_drawingml_CT_GeomGuide()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GeomGuide::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GeomGuide::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GeomGuide::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GeomGuide::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GeomGuide::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GeomGuide::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GeomGuide::startAction()
{
}
void OOXMLContext_drawingml_CT_GeomGuide::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GeomGuideList*/
OOXMLContext_drawingml_CT_GeomGuideList::OOXMLContext_drawingml_CT_GeomGuideList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GeomGuideList::~OOXMLContext_drawingml_CT_GeomGuideList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GeomGuideList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GeomGuideList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_gd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomGuide(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GeomGuideList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GeomGuideList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GeomGuideList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GeomGuideList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GeomGuideList::startAction()
{
}
void OOXMLContext_drawingml_CT_GeomGuideList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AdjPoint2D*/
OOXMLContext_drawingml_CT_AdjPoint2D::OOXMLContext_drawingml_CT_AdjPoint2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AdjPoint2D::~OOXMLContext_drawingml_CT_AdjPoint2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AdjPoint2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AdjPoint2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AdjPoint2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AdjPoint2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AdjPoint2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AdjPoint2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AdjPoint2D::startAction()
{
}
void OOXMLContext_drawingml_CT_AdjPoint2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_GeomRect*/
OOXMLContext_drawingml_CT_GeomRect::OOXMLContext_drawingml_CT_GeomRect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_GeomRect::~OOXMLContext_drawingml_CT_GeomRect()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_GeomRect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_GeomRect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_GeomRect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_GeomRect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_GeomRect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_GeomRect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_GeomRect::startAction()
{
}
void OOXMLContext_drawingml_CT_GeomRect::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_XYAdjustHandle*/
OOXMLContext_drawingml_CT_XYAdjustHandle::OOXMLContext_drawingml_CT_XYAdjustHandle(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_XYAdjustHandle::~OOXMLContext_drawingml_CT_XYAdjustHandle()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_XYAdjustHandle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_XYAdjustHandle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_XYAdjustHandle::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_XYAdjustHandle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_XYAdjustHandle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_XYAdjustHandle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_XYAdjustHandle::startAction()
{
}
void OOXMLContext_drawingml_CT_XYAdjustHandle::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PolarAdjustHandle*/
OOXMLContext_drawingml_CT_PolarAdjustHandle::OOXMLContext_drawingml_CT_PolarAdjustHandle(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PolarAdjustHandle::~OOXMLContext_drawingml_CT_PolarAdjustHandle()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PolarAdjustHandle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PolarAdjustHandle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PolarAdjustHandle::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PolarAdjustHandle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PolarAdjustHandle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PolarAdjustHandle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PolarAdjustHandle::startAction()
{
}
void OOXMLContext_drawingml_CT_PolarAdjustHandle::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ConnectionSite*/
OOXMLContext_drawingml_CT_ConnectionSite::OOXMLContext_drawingml_CT_ConnectionSite(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ConnectionSite::~OOXMLContext_drawingml_CT_ConnectionSite()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ConnectionSite::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ConnectionSite::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ConnectionSite::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ConnectionSite::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ConnectionSite::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ConnectionSite::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ConnectionSite::startAction()
{
}
void OOXMLContext_drawingml_CT_ConnectionSite::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_AdjustHandleList*/
OOXMLContext_drawingml_CT_AdjustHandleList::OOXMLContext_drawingml_CT_AdjustHandleList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_AdjustHandleList::~OOXMLContext_drawingml_CT_AdjustHandleList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_AdjustHandleList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_AdjustHandleList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_ahXY:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_XYAdjustHandle(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_ahPolar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PolarAdjustHandle(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_AdjustHandleList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_AdjustHandleList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_AdjustHandleList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_AdjustHandleList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_AdjustHandleList::startAction()
{
}
void OOXMLContext_drawingml_CT_AdjustHandleList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_ConnectionSiteList*/
OOXMLContext_drawingml_CT_ConnectionSiteList::OOXMLContext_drawingml_CT_ConnectionSiteList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_ConnectionSiteList::~OOXMLContext_drawingml_CT_ConnectionSiteList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_ConnectionSiteList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_ConnectionSiteList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_cxn:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ConnectionSite(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_ConnectionSiteList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_ConnectionSiteList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_ConnectionSiteList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_ConnectionSiteList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_ConnectionSiteList::startAction()
{
}
void OOXMLContext_drawingml_CT_ConnectionSiteList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Connection*/
OOXMLContext_drawingml_CT_Connection::OOXMLContext_drawingml_CT_Connection(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Connection::~OOXMLContext_drawingml_CT_Connection()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Connection::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Connection::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Connection::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Connection::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Connection::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Connection::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Connection::startAction()
{
}
void OOXMLContext_drawingml_CT_Connection::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DMoveTo*/
OOXMLContext_drawingml_CT_Path2DMoveTo::OOXMLContext_drawingml_CT_Path2DMoveTo(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DMoveTo::~OOXMLContext_drawingml_CT_Path2DMoveTo()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DMoveTo::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DMoveTo::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DMoveTo::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DMoveTo::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DMoveTo::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DMoveTo::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DMoveTo::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DMoveTo::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DLineTo*/
OOXMLContext_drawingml_CT_Path2DLineTo::OOXMLContext_drawingml_CT_Path2DLineTo(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DLineTo::~OOXMLContext_drawingml_CT_Path2DLineTo()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DLineTo::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DLineTo::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DLineTo::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DLineTo::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DLineTo::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DLineTo::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DLineTo::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DLineTo::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DArcTo*/
OOXMLContext_drawingml_CT_Path2DArcTo::OOXMLContext_drawingml_CT_Path2DArcTo(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DArcTo::~OOXMLContext_drawingml_CT_Path2DArcTo()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DArcTo::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DArcTo::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DArcTo::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DArcTo::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DArcTo::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DArcTo::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DArcTo::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DArcTo::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DQuadBezierTo*/
OOXMLContext_drawingml_CT_Path2DQuadBezierTo::OOXMLContext_drawingml_CT_Path2DQuadBezierTo(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DQuadBezierTo::~OOXMLContext_drawingml_CT_Path2DQuadBezierTo()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DQuadBezierTo::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DQuadBezierTo::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DQuadBezierTo::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DQuadBezierTo::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DQuadBezierTo::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DQuadBezierTo::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DQuadBezierTo::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DQuadBezierTo::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DCubicBezierTo*/
OOXMLContext_drawingml_CT_Path2DCubicBezierTo::OOXMLContext_drawingml_CT_Path2DCubicBezierTo(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DCubicBezierTo::~OOXMLContext_drawingml_CT_Path2DCubicBezierTo()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DCubicBezierTo::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DCubicBezierTo::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_pt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjPoint2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DCubicBezierTo::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DCubicBezierTo::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DCubicBezierTo::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DCubicBezierTo::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DCubicBezierTo::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DCubicBezierTo::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DClose*/
OOXMLContext_drawingml_CT_Path2DClose::OOXMLContext_drawingml_CT_Path2DClose(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DClose::~OOXMLContext_drawingml_CT_Path2DClose()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DClose::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DClose::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DClose::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DClose::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DClose::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DClose::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DClose::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DClose::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2D*/
OOXMLContext_drawingml_CT_Path2D::OOXMLContext_drawingml_CT_Path2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2D::~OOXMLContext_drawingml_CT_Path2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_close:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DClose(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_moveTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DMoveTo(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_lnTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DLineTo(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_arcTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DArcTo(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_quadBezTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DQuadBezierTo(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_cubicBezTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DCubicBezierTo(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2D::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_Path2DList*/
OOXMLContext_drawingml_CT_Path2DList::OOXMLContext_drawingml_CT_Path2DList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_Path2DList::~OOXMLContext_drawingml_CT_Path2DList()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_Path2DList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_Path2DList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_path:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_Path2DList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_Path2DList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_Path2DList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_Path2DList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_Path2DList::startAction()
{
}
void OOXMLContext_drawingml_CT_Path2DList::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PresetGeometry2D*/
OOXMLContext_drawingml_CT_PresetGeometry2D::OOXMLContext_drawingml_CT_PresetGeometry2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PresetGeometry2D::~OOXMLContext_drawingml_CT_PresetGeometry2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PresetGeometry2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PresetGeometry2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_avLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomGuideList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PresetGeometry2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PresetGeometry2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PresetGeometry2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PresetGeometry2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PresetGeometry2D::startAction()
{
}
void OOXMLContext_drawingml_CT_PresetGeometry2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_PresetTextShape*/
OOXMLContext_drawingml_CT_PresetTextShape::OOXMLContext_drawingml_CT_PresetTextShape(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_PresetTextShape::~OOXMLContext_drawingml_CT_PresetTextShape()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_PresetTextShape::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_PresetTextShape::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_avLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomGuideList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_PresetTextShape::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_PresetTextShape::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_PresetTextShape::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_PresetTextShape::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_PresetTextShape::startAction()
{
}
void OOXMLContext_drawingml_CT_PresetTextShape::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_CT_CustomGeometry2D*/
OOXMLContext_drawingml_CT_CustomGeometry2D::OOXMLContext_drawingml_CT_CustomGeometry2D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_CT_CustomGeometry2D::~OOXMLContext_drawingml_CT_CustomGeometry2D()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_CT_CustomGeometry2D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_CT_CustomGeometry2D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_avLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomGuideList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_gdLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomGuideList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_ahLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_AdjustHandleList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_cxnLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ConnectionSiteList(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_rect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_GeomRect(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_pathLst:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Path2DList(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_CT_CustomGeometry2D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_CT_CustomGeometry2D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_CT_CustomGeometry2D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_CT_CustomGeometry2D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_CT_CustomGeometry2D::startAction()
{
}
void OOXMLContext_drawingml_CT_CustomGeometry2D::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_Geometry*/
OOXMLContext_drawingml_EG_Geometry::OOXMLContext_drawingml_EG_Geometry(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_Geometry::~OOXMLContext_drawingml_EG_Geometry()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_Geometry::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_Geometry::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_custGeom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_CustomGeometry2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_prstGeom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PresetGeometry2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_Geometry::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_Geometry::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_Geometry::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_Geometry::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_Geometry::startAction()
{
}
void OOXMLContext_drawingml_EG_Geometry::endAction()
{
}
/* 
    class: OOXMLContext_drawingml_EG_TextGeometry*/
OOXMLContext_drawingml_EG_TextGeometry::OOXMLContext_drawingml_EG_TextGeometry(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_drawingml_EG_TextGeometry::~OOXMLContext_drawingml_EG_TextGeometry()
{
}

OOXMLContext::Pointer_t OOXMLContext_drawingml_EG_TextGeometry::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_drawingml_EG_TextGeometry::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_drawingml_custGeom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_CustomGeometry2D(*this));
         }
             break;
     case OOXML_ELEMENT_drawingml_prstTxWarp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PresetTextShape(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_drawingml_EG_TextGeometry::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_drawingml_EG_TextGeometry::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_drawingml_EG_TextGeometry::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_drawingml_EG_TextGeometry::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_drawingml_EG_TextGeometry::startAction()
{
}
void OOXMLContext_drawingml_EG_TextGeometry::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_EffectExtent*/
OOXMLContext_wordprocessingDrawing_CT_EffectExtent::OOXMLContext_wordprocessingDrawing_CT_EffectExtent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_EffectExtent::~OOXMLContext_wordprocessingDrawing_CT_EffectExtent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_EffectExtent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_EffectExtent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_EffectExtent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_EffectExtent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_EffectExtent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_EffectExtent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_EffectExtent::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_EffectExtent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_Inline*/
OOXMLContext_wordprocessingDrawing_CT_Inline::OOXMLContext_wordprocessingDrawing_CT_Inline(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_Inline::~OOXMLContext_wordprocessingDrawing_CT_Inline()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_Inline::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_Inline::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_extent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveSize2D(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_effectExtent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_EffectExtent(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_docPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualDrawingProps(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_cNvGraphicFramePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_Inline::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_Inline::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_Inline::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_Inline::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_Inline::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_Inline::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapPath*/
OOXMLContext_wordprocessingDrawing_CT_WrapPath::OOXMLContext_wordprocessingDrawing_CT_WrapPath(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapPath::~OOXMLContext_wordprocessingDrawing_CT_WrapPath()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapPath::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapPath::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_start:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_lineTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapPath::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapPath::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapPath::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapPath::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapPath::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapPath::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapNone*/
OOXMLContext_wordprocessingDrawing_CT_WrapNone::OOXMLContext_wordprocessingDrawing_CT_WrapNone(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapNone::~OOXMLContext_wordprocessingDrawing_CT_WrapNone()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapNone::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapNone::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapNone::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapNone::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapNone::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapNone::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapNone::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapNone::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapSquare*/
OOXMLContext_wordprocessingDrawing_CT_WrapSquare::OOXMLContext_wordprocessingDrawing_CT_WrapSquare(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapSquare::~OOXMLContext_wordprocessingDrawing_CT_WrapSquare()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapSquare::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapSquare::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_effectExtent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_EffectExtent(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapSquare::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapSquare::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapSquare::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapSquare::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapSquare::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapSquare::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapTight*/
OOXMLContext_wordprocessingDrawing_CT_WrapTight::OOXMLContext_wordprocessingDrawing_CT_WrapTight(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapTight::~OOXMLContext_wordprocessingDrawing_CT_WrapTight()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapTight::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapTight::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_wrapPolygon:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapPath(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapTight::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapTight::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapTight::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapTight::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapTight::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapTight::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapThrough*/
OOXMLContext_wordprocessingDrawing_CT_WrapThrough::OOXMLContext_wordprocessingDrawing_CT_WrapThrough(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapThrough::~OOXMLContext_wordprocessingDrawing_CT_WrapThrough()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapThrough::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapThrough::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_wrapPolygon:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapPath(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapThrough::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapThrough::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapThrough::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapThrough::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapThrough::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapThrough::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom*/
OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::~OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_effectExtent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_EffectExtent(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_EG_WrapType*/
OOXMLContext_wordprocessingDrawing_EG_WrapType::OOXMLContext_wordprocessingDrawing_EG_WrapType(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_EG_WrapType::~OOXMLContext_wordprocessingDrawing_EG_WrapType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_EG_WrapType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_EG_WrapType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_wrapNone:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapNone(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_wrapSquare:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapSquare(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_wrapTight:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapTight(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_wrapThrough:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapThrough(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_wrapTopAndBottom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_WrapTopBottom(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_EG_WrapType::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_EG_WrapType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_EG_WrapType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_EG_WrapType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_EG_WrapType::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_EG_WrapType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_PosH*/
OOXMLContext_wordprocessingDrawing_CT_PosH::OOXMLContext_wordprocessingDrawing_CT_PosH(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_PosH::~OOXMLContext_wordprocessingDrawing_CT_PosH()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_PosH::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_PosH::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_PosH::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_PosH::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_PosH::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_PosH::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_PosH::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_PosH::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_PosV*/
OOXMLContext_wordprocessingDrawing_CT_PosV::OOXMLContext_wordprocessingDrawing_CT_PosV(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_PosV::~OOXMLContext_wordprocessingDrawing_CT_PosV()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_PosV::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_PosV::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_PosV::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_PosV::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_PosV::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_PosV::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_PosV::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_PosV::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_CT_Anchor*/
OOXMLContext_wordprocessingDrawing_CT_Anchor::OOXMLContext_wordprocessingDrawing_CT_Anchor(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_CT_Anchor::~OOXMLContext_wordprocessingDrawing_CT_Anchor()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_CT_Anchor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_EG_WrapType(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_CT_Anchor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_simplePos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_Point2D(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_positionH:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_PosH(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_positionV:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_PosV(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_extent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_PositiveSize2D(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_effectExtent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_EffectExtent(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_docPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualDrawingProps(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingDrawing_cNvGraphicFramePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualGraphicFrameProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_CT_Anchor::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_CT_Anchor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_CT_Anchor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_EG_WrapType(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_CT_Anchor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_CT_Anchor::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_CT_Anchor::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_inline*/
OOXMLContext_wordprocessingDrawing_inline::OOXMLContext_wordprocessingDrawing_inline(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_inline::~OOXMLContext_wordprocessingDrawing_inline()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_inline::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_inline::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_inline:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_Inline(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_inline::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_inline::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_inline::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_inline::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_inline::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_inline::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingDrawing_anchor*/
OOXMLContext_wordprocessingDrawing_anchor::OOXMLContext_wordprocessingDrawing_anchor(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingDrawing_anchor::~OOXMLContext_wordprocessingDrawing_anchor()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingDrawing_anchor::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingDrawing_anchor::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingDrawing_anchor:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingDrawing_CT_Anchor(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingDrawing_anchor::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingDrawing_anchor::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingDrawing_anchor::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingDrawing_anchor::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingDrawing_anchor::startAction()
{
}
void OOXMLContext_wordprocessingDrawing_anchor::endAction()
{
}
/* 
    class: OOXMLContext_schemaLibrary_CT_Schema*/
OOXMLContext_schemaLibrary_CT_Schema::OOXMLContext_schemaLibrary_CT_Schema(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_schemaLibrary_CT_Schema::~OOXMLContext_schemaLibrary_CT_Schema()
{
}

OOXMLContext::Pointer_t OOXMLContext_schemaLibrary_CT_Schema::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_schemaLibrary_CT_Schema::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_schemaLibrary_CT_Schema::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_schemaLibrary_CT_Schema::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_schemaLibrary_CT_Schema::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_schemaLibrary_CT_Schema::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_schemaLibrary_CT_Schema::startAction()
{
}
void OOXMLContext_schemaLibrary_CT_Schema::endAction()
{
}
/* 
    class: OOXMLContext_schemaLibrary_CT_SchemaLibrary*/
OOXMLContext_schemaLibrary_CT_SchemaLibrary::OOXMLContext_schemaLibrary_CT_SchemaLibrary(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_schemaLibrary_CT_SchemaLibrary::~OOXMLContext_schemaLibrary_CT_SchemaLibrary()
{
}

OOXMLContext::Pointer_t OOXMLContext_schemaLibrary_CT_SchemaLibrary::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_schemaLibrary_CT_SchemaLibrary::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_schemaLibrary_schema:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_schemaLibrary_CT_Schema(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_schemaLibrary_CT_SchemaLibrary::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_schemaLibrary_CT_SchemaLibrary::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_schemaLibrary_CT_SchemaLibrary::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_schemaLibrary_CT_SchemaLibrary::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_schemaLibrary_CT_SchemaLibrary::startAction()
{
}
void OOXMLContext_schemaLibrary_CT_SchemaLibrary::endAction()
{
}
/* 
    class: OOXMLContext_schemaLibrary_schemaLibrary*/
OOXMLContext_schemaLibrary_schemaLibrary::OOXMLContext_schemaLibrary_schemaLibrary(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_schemaLibrary_schemaLibrary::~OOXMLContext_schemaLibrary_schemaLibrary()
{
}

OOXMLContext::Pointer_t OOXMLContext_schemaLibrary_schemaLibrary::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_schemaLibrary_schemaLibrary::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_schemaLibrary_schemaLibrary:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_schemaLibrary_CT_SchemaLibrary(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_schemaLibrary_schemaLibrary::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_schemaLibrary_schemaLibrary::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_schemaLibrary_schemaLibrary::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_schemaLibrary_schemaLibrary::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_schemaLibrary_schemaLibrary::startAction()
{
}
void OOXMLContext_schemaLibrary_schemaLibrary::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Integer255*/
OOXMLContext_math_CT_Integer255::OOXMLContext_math_CT_Integer255(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_Integer255::~OOXMLContext_math_CT_Integer255()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Integer255::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Integer255::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Integer255::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Integer255::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Integer255::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Integer255::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Integer255::startAction()
{
}
void OOXMLContext_math_CT_Integer255::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Integer2*/
OOXMLContext_math_CT_Integer2::OOXMLContext_math_CT_Integer2(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_Integer2::~OOXMLContext_math_CT_Integer2()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Integer2::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Integer2::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Integer2::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Integer2::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Integer2::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Integer2::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Integer2::startAction()
{
}
void OOXMLContext_math_CT_Integer2::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SpacingRule*/
OOXMLContext_math_CT_SpacingRule::OOXMLContext_math_CT_SpacingRule(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_SpacingRule::~OOXMLContext_math_CT_SpacingRule()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SpacingRule::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SpacingRule::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SpacingRule::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SpacingRule::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SpacingRule::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SpacingRule::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_SpacingRule::startAction()
{
}
void OOXMLContext_math_CT_SpacingRule::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_UnSignedInteger*/
OOXMLContext_math_CT_UnSignedInteger::OOXMLContext_math_CT_UnSignedInteger(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_UnSignedInteger::~OOXMLContext_math_CT_UnSignedInteger()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_UnSignedInteger::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_UnSignedInteger::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_UnSignedInteger::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_UnSignedInteger::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_UnSignedInteger::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_UnSignedInteger::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_UnSignedInteger::startAction()
{
}
void OOXMLContext_math_CT_UnSignedInteger::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Char*/
OOXMLContext_math_CT_Char::OOXMLContext_math_CT_Char(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_Char::~OOXMLContext_math_CT_Char()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Char::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Char::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Char::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Char::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Char::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Char::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Char::startAction()
{
}
void OOXMLContext_math_CT_Char::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OnOff*/
OOXMLContext_math_CT_OnOff::OOXMLContext_math_CT_OnOff(const OOXMLContext & rContext)
: OOXMLContextBooleanValue(rContext)
{
}
OOXMLContext_math_CT_OnOff::~OOXMLContext_math_CT_OnOff()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OnOff::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OnOff::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OnOff::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
      {
          mbValue = OOXMLValue_math_ST_OnOff(rValue).getBool();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OnOff::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OnOff::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_OnOff::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextBooleanValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_OnOff::startAction()
{
}
void OOXMLContext_math_CT_OnOff::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_String*/
OOXMLContext_math_CT_String::OOXMLContext_math_CT_String(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_String::~OOXMLContext_math_CT_String()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_String::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_String::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_String::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_String::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_String::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_String::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_String::startAction()
{
}
void OOXMLContext_math_CT_String::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_XAlign*/
OOXMLContext_math_CT_XAlign::OOXMLContext_math_CT_XAlign(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_XAlign::~OOXMLContext_math_CT_XAlign()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_XAlign::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_XAlign::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_XAlign::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_XAlign::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_XAlign::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_XAlign::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_XAlign::startAction()
{
}
void OOXMLContext_math_CT_XAlign::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_YAlign*/
OOXMLContext_math_CT_YAlign::OOXMLContext_math_CT_YAlign(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_YAlign::~OOXMLContext_math_CT_YAlign()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_YAlign::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_YAlign::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_YAlign::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_YAlign::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_YAlign::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_YAlign::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_YAlign::startAction()
{
}
void OOXMLContext_math_CT_YAlign::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Shp*/
OOXMLContext_math_CT_Shp::OOXMLContext_math_CT_Shp(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_Shp::~OOXMLContext_math_CT_Shp()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Shp::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Shp::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Shp::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Shp::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Shp::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Shp::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Shp::startAction()
{
}
void OOXMLContext_math_CT_Shp::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_FType*/
OOXMLContext_math_CT_FType::OOXMLContext_math_CT_FType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_FType::~OOXMLContext_math_CT_FType()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_FType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_FType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_FType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_FType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_FType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_FType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_FType::startAction()
{
}
void OOXMLContext_math_CT_FType::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_LimLoc*/
OOXMLContext_math_CT_LimLoc::OOXMLContext_math_CT_LimLoc(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_LimLoc::~OOXMLContext_math_CT_LimLoc()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_LimLoc::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_LimLoc::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_LimLoc::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_LimLoc::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_LimLoc::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_LimLoc::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_LimLoc::startAction()
{
}
void OOXMLContext_math_CT_LimLoc::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_TopBot*/
OOXMLContext_math_CT_TopBot::OOXMLContext_math_CT_TopBot(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_TopBot::~OOXMLContext_math_CT_TopBot()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_TopBot::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_TopBot::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_TopBot::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_TopBot::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_TopBot::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_TopBot::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_TopBot::startAction()
{
}
void OOXMLContext_math_CT_TopBot::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Script*/
OOXMLContext_math_CT_Script::OOXMLContext_math_CT_Script(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_Script::~OOXMLContext_math_CT_Script()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Script::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Script::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Script::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Script::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Script::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Script::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Script::startAction()
{
}
void OOXMLContext_math_CT_Script::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Style*/
OOXMLContext_math_CT_Style::OOXMLContext_math_CT_Style(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_math_CT_Style::~OOXMLContext_math_CT_Style()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Style::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Style::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Style::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
      {
          mnValue = OOXMLValue_math_ST_Style(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Style::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Style::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Style::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_Style::startAction()
{
}
void OOXMLContext_math_CT_Style::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_ManualBreak*/
OOXMLContext_math_CT_ManualBreak::OOXMLContext_math_CT_ManualBreak(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_ManualBreak::~OOXMLContext_math_CT_ManualBreak()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_ManualBreak::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_ManualBreak::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_ManualBreak::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_ManualBreak::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_ManualBreak::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_ManualBreak::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_ManualBreak::startAction()
{
}
void OOXMLContext_math_CT_ManualBreak::endAction()
{
}
/* 
    class: OOXMLContext_math_EG_ScriptStyle*/
OOXMLContext_math_EG_ScriptStyle::OOXMLContext_math_EG_ScriptStyle(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_EG_ScriptStyle::~OOXMLContext_math_EG_ScriptStyle()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_EG_ScriptStyle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_EG_ScriptStyle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_scr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Script(*this));
         }
             break;
     case OOXML_ELEMENT_math_sty:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Style(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_EG_ScriptStyle::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_EG_ScriptStyle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_EG_ScriptStyle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_EG_ScriptStyle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_EG_ScriptStyle::startAction()
{
}
void OOXMLContext_math_EG_ScriptStyle::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_RPR*/
OOXMLContext_math_CT_RPR::OOXMLContext_math_CT_RPR(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_RPR::~OOXMLContext_math_CT_RPR()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_RPR::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_ScriptStyle(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_RPR::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_lit:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_nor:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_brk:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_ManualBreak(*this));
         }
             break;
     case OOXML_ELEMENT_math_aln:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_RPR::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_RPR::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_RPR::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_ScriptStyle(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_CT_RPR::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_RPR::startAction()
{
}
void OOXMLContext_math_CT_RPR::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Text*/
OOXMLContext_math_CT_Text::OOXMLContext_math_CT_Text(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Text::~OOXMLContext_math_CT_Text()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Text::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Text::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Text::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Text::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Text::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Text::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Text::startAction()
{
}
void OOXMLContext_math_CT_Text::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_R*/
OOXMLContext_math_CT_R::OOXMLContext_math_CT_R(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_R::~OOXMLContext_math_CT_R()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_R::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunInnerContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_R::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_RPR(*this));
         }
             break;
     case OOXML_ELEMENT_math_t:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Text(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_R::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_R::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_R::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunInnerContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_CT_R::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_R::startAction()
{
    startCharacterGroup();
}
void OOXMLContext_math_CT_R::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_CtrlPr*/
OOXMLContext_math_CT_CtrlPr::OOXMLContext_math_CT_CtrlPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_CtrlPr::~OOXMLContext_math_CT_CtrlPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_CtrlPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrMath(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_CtrlPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_CtrlPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_CtrlPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_CtrlPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrMath(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_CT_CtrlPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_CtrlPr::startAction()
{
}
void OOXMLContext_math_CT_CtrlPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_AccPr*/
OOXMLContext_math_CT_AccPr::OOXMLContext_math_CT_AccPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_AccPr::~OOXMLContext_math_CT_AccPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_AccPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_AccPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_chr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_AccPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_AccPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_AccPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_AccPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_AccPr::startAction()
{
}
void OOXMLContext_math_CT_AccPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Acc*/
OOXMLContext_math_CT_Acc::OOXMLContext_math_CT_Acc(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Acc::~OOXMLContext_math_CT_Acc()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Acc::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Acc::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_accPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_AccPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Acc::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Acc::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Acc::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Acc::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Acc::startAction()
{
}
void OOXMLContext_math_CT_Acc::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BarPr*/
OOXMLContext_math_CT_BarPr::OOXMLContext_math_CT_BarPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_BarPr::~OOXMLContext_math_CT_BarPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BarPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BarPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_pos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TopBot(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BarPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BarPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BarPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BarPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_BarPr::startAction()
{
}
void OOXMLContext_math_CT_BarPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Bar*/
OOXMLContext_math_CT_Bar::OOXMLContext_math_CT_Bar(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Bar::~OOXMLContext_math_CT_Bar()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Bar::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Bar::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_barPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BarPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Bar::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Bar::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Bar::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Bar::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Bar::startAction()
{
}
void OOXMLContext_math_CT_Bar::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BoxPr*/
OOXMLContext_math_CT_BoxPr::OOXMLContext_math_CT_BoxPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_BoxPr::~OOXMLContext_math_CT_BoxPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BoxPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BoxPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_opEmu:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_noBreak:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_diff:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_brk:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_ManualBreak(*this));
         }
             break;
     case OOXML_ELEMENT_math_aln:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BoxPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BoxPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BoxPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BoxPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_BoxPr::startAction()
{
}
void OOXMLContext_math_CT_BoxPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Box*/
OOXMLContext_math_CT_Box::OOXMLContext_math_CT_Box(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Box::~OOXMLContext_math_CT_Box()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Box::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Box::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_boxPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BoxPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Box::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Box::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Box::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Box::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Box::startAction()
{
}
void OOXMLContext_math_CT_Box::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BorderBoxPr*/
OOXMLContext_math_CT_BorderBoxPr::OOXMLContext_math_CT_BorderBoxPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_BorderBoxPr::~OOXMLContext_math_CT_BorderBoxPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BorderBoxPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BorderBoxPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_hideTop:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_hideBot:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_hideLeft:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_hideRight:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_strikeH:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_strikeV:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_strikeBLTR:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_strikeTLBR:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BorderBoxPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BorderBoxPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BorderBoxPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BorderBoxPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_BorderBoxPr::startAction()
{
}
void OOXMLContext_math_CT_BorderBoxPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BorderBox*/
OOXMLContext_math_CT_BorderBox::OOXMLContext_math_CT_BorderBox(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_BorderBox::~OOXMLContext_math_CT_BorderBox()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BorderBox::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BorderBox::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_borderBoxPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BorderBoxPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BorderBox::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BorderBox::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BorderBox::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BorderBox::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_BorderBox::startAction()
{
}
void OOXMLContext_math_CT_BorderBox::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_DPr*/
OOXMLContext_math_CT_DPr::OOXMLContext_math_CT_DPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_DPr::~OOXMLContext_math_CT_DPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_DPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_DPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_begChr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_sepChr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_endChr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_grow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_shp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Shp(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_DPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_DPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_DPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_DPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_DPr::startAction()
{
}
void OOXMLContext_math_CT_DPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_D*/
OOXMLContext_math_CT_D::OOXMLContext_math_CT_D(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_D::~OOXMLContext_math_CT_D()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_D::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_D::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_dPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_DPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_D::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_D::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_D::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_D::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_D::startAction()
{
}
void OOXMLContext_math_CT_D::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_EqArrPr*/
OOXMLContext_math_CT_EqArrPr::OOXMLContext_math_CT_EqArrPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_EqArrPr::~OOXMLContext_math_CT_EqArrPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_EqArrPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_EqArrPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_baseJc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_YAlign(*this));
         }
             break;
     case OOXML_ELEMENT_math_maxDist:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_objDist:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_rSpRule:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SpacingRule(*this));
         }
             break;
     case OOXML_ELEMENT_math_rSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_UnSignedInteger(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_EqArrPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_EqArrPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_EqArrPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_EqArrPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_EqArrPr::startAction()
{
}
void OOXMLContext_math_CT_EqArrPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_EqArr*/
OOXMLContext_math_CT_EqArr::OOXMLContext_math_CT_EqArr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_EqArr::~OOXMLContext_math_CT_EqArr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_EqArr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_EqArr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_eqArrPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_EqArrPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_EqArr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_EqArr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_EqArr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_EqArr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_EqArr::startAction()
{
}
void OOXMLContext_math_CT_EqArr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_FPr*/
OOXMLContext_math_CT_FPr::OOXMLContext_math_CT_FPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_FPr::~OOXMLContext_math_CT_FPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_FPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_FPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_type:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_FType(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_FPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_FPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_FPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_FPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_FPr::startAction()
{
}
void OOXMLContext_math_CT_FPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_F*/
OOXMLContext_math_CT_F::OOXMLContext_math_CT_F(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_F::~OOXMLContext_math_CT_F()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_F::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_F::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_fPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_FPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_num:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_den:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_F::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_F::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_F::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_F::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_F::startAction()
{
}
void OOXMLContext_math_CT_F::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_FuncPr*/
OOXMLContext_math_CT_FuncPr::OOXMLContext_math_CT_FuncPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_FuncPr::~OOXMLContext_math_CT_FuncPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_FuncPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_FuncPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_FuncPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_FuncPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_FuncPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_FuncPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_FuncPr::startAction()
{
}
void OOXMLContext_math_CT_FuncPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Func*/
OOXMLContext_math_CT_Func::OOXMLContext_math_CT_Func(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Func::~OOXMLContext_math_CT_Func()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Func::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Func::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_funcPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_FuncPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_fName:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Func::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Func::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Func::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Func::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Func::startAction()
{
}
void OOXMLContext_math_CT_Func::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_GroupChrPr*/
OOXMLContext_math_CT_GroupChrPr::OOXMLContext_math_CT_GroupChrPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_GroupChrPr::~OOXMLContext_math_CT_GroupChrPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_GroupChrPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_GroupChrPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_chr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_pos:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TopBot(*this));
         }
             break;
     case OOXML_ELEMENT_math_vertJc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TopBot(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_GroupChrPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_GroupChrPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_GroupChrPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_GroupChrPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_GroupChrPr::startAction()
{
}
void OOXMLContext_math_CT_GroupChrPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_GroupChr*/
OOXMLContext_math_CT_GroupChr::OOXMLContext_math_CT_GroupChr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_GroupChr::~OOXMLContext_math_CT_GroupChr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_GroupChr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_GroupChr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_groupChrPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_GroupChrPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_GroupChr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_GroupChr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_GroupChr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_GroupChr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_GroupChr::startAction()
{
}
void OOXMLContext_math_CT_GroupChr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_LimLowPr*/
OOXMLContext_math_CT_LimLowPr::OOXMLContext_math_CT_LimLowPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_LimLowPr::~OOXMLContext_math_CT_LimLowPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_LimLowPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_LimLowPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_LimLowPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_LimLowPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_LimLowPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_LimLowPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_LimLowPr::startAction()
{
}
void OOXMLContext_math_CT_LimLowPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_LimLow*/
OOXMLContext_math_CT_LimLow::OOXMLContext_math_CT_LimLow(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_LimLow::~OOXMLContext_math_CT_LimLow()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_LimLow::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_LimLow::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_limLowPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimLowPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_lim:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_LimLow::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_LimLow::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_LimLow::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_LimLow::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_LimLow::startAction()
{
}
void OOXMLContext_math_CT_LimLow::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_LimUppPr*/
OOXMLContext_math_CT_LimUppPr::OOXMLContext_math_CT_LimUppPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_LimUppPr::~OOXMLContext_math_CT_LimUppPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_LimUppPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_LimUppPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_LimUppPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_LimUppPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_LimUppPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_LimUppPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_LimUppPr::startAction()
{
}
void OOXMLContext_math_CT_LimUppPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_LimUpp*/
OOXMLContext_math_CT_LimUpp::OOXMLContext_math_CT_LimUpp(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_LimUpp::~OOXMLContext_math_CT_LimUpp()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_LimUpp::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_LimUpp::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_limUppPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimUppPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_lim:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_LimUpp::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_LimUpp::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_LimUpp::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_LimUpp::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_LimUpp::startAction()
{
}
void OOXMLContext_math_CT_LimUpp::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MCPr*/
OOXMLContext_math_CT_MCPr::OOXMLContext_math_CT_MCPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MCPr::~OOXMLContext_math_CT_MCPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MCPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MCPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_count:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Integer255(*this));
         }
             break;
     case OOXML_ELEMENT_math_mcJc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_XAlign(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MCPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MCPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MCPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MCPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MCPr::startAction()
{
}
void OOXMLContext_math_CT_MCPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MC*/
OOXMLContext_math_CT_MC::OOXMLContext_math_CT_MC(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MC::~OOXMLContext_math_CT_MC()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MC::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MC::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_mcPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_MCPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MC::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MC::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MC::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MC::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MC::startAction()
{
}
void OOXMLContext_math_CT_MC::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MCS*/
OOXMLContext_math_CT_MCS::OOXMLContext_math_CT_MCS(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MCS::~OOXMLContext_math_CT_MCS()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MCS::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MCS::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_mc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_MC(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MCS::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MCS::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MCS::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MCS::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MCS::startAction()
{
}
void OOXMLContext_math_CT_MCS::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MPr*/
OOXMLContext_math_CT_MPr::OOXMLContext_math_CT_MPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MPr::~OOXMLContext_math_CT_MPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_baseJc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_YAlign(*this));
         }
             break;
     case OOXML_ELEMENT_math_plcHide:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_rSpRule:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SpacingRule(*this));
         }
             break;
     case OOXML_ELEMENT_math_cGpRule:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SpacingRule(*this));
         }
             break;
     case OOXML_ELEMENT_math_rSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_UnSignedInteger(*this));
         }
             break;
     case OOXML_ELEMENT_math_cSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_UnSignedInteger(*this));
         }
             break;
     case OOXML_ELEMENT_math_cGp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_UnSignedInteger(*this));
         }
             break;
     case OOXML_ELEMENT_math_mcs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_MCS(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MPr::startAction()
{
}
void OOXMLContext_math_CT_MPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MR*/
OOXMLContext_math_CT_MR::OOXMLContext_math_CT_MR(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MR::~OOXMLContext_math_CT_MR()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MR::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MR::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MR::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MR::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MR::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MR::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MR::startAction()
{
}
void OOXMLContext_math_CT_MR::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_M*/
OOXMLContext_math_CT_M::OOXMLContext_math_CT_M(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_M::~OOXMLContext_math_CT_M()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_M::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_M::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_mPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_MPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_mr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_MR(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_M::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_M::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_M::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_M::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_M::startAction()
{
}
void OOXMLContext_math_CT_M::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_NaryPr*/
OOXMLContext_math_CT_NaryPr::OOXMLContext_math_CT_NaryPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_NaryPr::~OOXMLContext_math_CT_NaryPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_NaryPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_NaryPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_chr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Char(*this));
         }
             break;
     case OOXML_ELEMENT_math_limLoc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimLoc(*this));
         }
             break;
     case OOXML_ELEMENT_math_grow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_subHide:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_supHide:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_NaryPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_NaryPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_NaryPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_NaryPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_NaryPr::startAction()
{
}
void OOXMLContext_math_CT_NaryPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Nary*/
OOXMLContext_math_CT_Nary::OOXMLContext_math_CT_Nary(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Nary::~OOXMLContext_math_CT_Nary()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Nary::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Nary::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_naryPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_NaryPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_sub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Nary::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Nary::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Nary::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Nary::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Nary::startAction()
{
}
void OOXMLContext_math_CT_Nary::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_PhantPr*/
OOXMLContext_math_CT_PhantPr::OOXMLContext_math_CT_PhantPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_PhantPr::~OOXMLContext_math_CT_PhantPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_PhantPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_PhantPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_show:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_zeroWid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_zeroAsc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_zeroDesc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_transp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_PhantPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_PhantPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_PhantPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_PhantPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_PhantPr::startAction()
{
}
void OOXMLContext_math_CT_PhantPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Phant*/
OOXMLContext_math_CT_Phant::OOXMLContext_math_CT_Phant(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Phant::~OOXMLContext_math_CT_Phant()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Phant::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Phant::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_phantPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_PhantPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Phant::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Phant::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Phant::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Phant::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Phant::startAction()
{
}
void OOXMLContext_math_CT_Phant::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_RadPr*/
OOXMLContext_math_CT_RadPr::OOXMLContext_math_CT_RadPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_RadPr::~OOXMLContext_math_CT_RadPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_RadPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_RadPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_degHide:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_RadPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_RadPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_RadPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_RadPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_RadPr::startAction()
{
}
void OOXMLContext_math_CT_RadPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_Rad*/
OOXMLContext_math_CT_Rad::OOXMLContext_math_CT_Rad(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_Rad::~OOXMLContext_math_CT_Rad()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_Rad::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_Rad::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_radPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_RadPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_deg:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_Rad::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_Rad::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_Rad::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_Rad::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_Rad::startAction()
{
}
void OOXMLContext_math_CT_Rad::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SPrePr*/
OOXMLContext_math_CT_SPrePr::OOXMLContext_math_CT_SPrePr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SPrePr::~OOXMLContext_math_CT_SPrePr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SPrePr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SPrePr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SPrePr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SPrePr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SPrePr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SPrePr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SPrePr::startAction()
{
}
void OOXMLContext_math_CT_SPrePr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SPre*/
OOXMLContext_math_CT_SPre::OOXMLContext_math_CT_SPre(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SPre::~OOXMLContext_math_CT_SPre()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SPre::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SPre::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_sPrePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SPrePr(*this));
         }
             break;
     case OOXML_ELEMENT_math_sub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SPre::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SPre::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SPre::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SPre::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SPre::startAction()
{
}
void OOXMLContext_math_CT_SPre::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSubPr*/
OOXMLContext_math_CT_SSubPr::OOXMLContext_math_CT_SSubPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSubPr::~OOXMLContext_math_CT_SSubPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSubPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSubPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSubPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSubPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSubPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSubPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSubPr::startAction()
{
}
void OOXMLContext_math_CT_SSubPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSub*/
OOXMLContext_math_CT_SSub::OOXMLContext_math_CT_SSub(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSub::~OOXMLContext_math_CT_SSub()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSub::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSub::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_sSubPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSubPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSub::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSub::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSub::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSub::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSub::startAction()
{
}
void OOXMLContext_math_CT_SSub::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSubSupPr*/
OOXMLContext_math_CT_SSubSupPr::OOXMLContext_math_CT_SSubSupPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSubSupPr::~OOXMLContext_math_CT_SSubSupPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSubSupPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSubSupPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_alnScr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSubSupPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSubSupPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSubSupPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSubSupPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSubSupPr::startAction()
{
}
void OOXMLContext_math_CT_SSubSupPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSubSup*/
OOXMLContext_math_CT_SSubSup::OOXMLContext_math_CT_SSubSup(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSubSup::~OOXMLContext_math_CT_SSubSup()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSubSup::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSubSup::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_sSubSupPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSubSupPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSubSup::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSubSup::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSubSup::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSubSup::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSubSup::startAction()
{
}
void OOXMLContext_math_CT_SSubSup::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSupPr*/
OOXMLContext_math_CT_SSupPr::OOXMLContext_math_CT_SSupPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSupPr::~OOXMLContext_math_CT_SSupPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSupPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSupPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSupPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSupPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSupPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSupPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSupPr::startAction()
{
}
void OOXMLContext_math_CT_SSupPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_SSup*/
OOXMLContext_math_CT_SSup::OOXMLContext_math_CT_SSup(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_SSup::~OOXMLContext_math_CT_SSup()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_SSup::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_SSup::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_sSupPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSupPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_e:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_ELEMENT_math_sup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArg(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_SSup::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_SSup::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_SSup::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_SSup::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_SSup::startAction()
{
}
void OOXMLContext_math_CT_SSup::endAction()
{
}
/* 
    class: OOXMLContext_math_EG_OMathMathElements*/
OOXMLContext_math_EG_OMathMathElements::OOXMLContext_math_EG_OMathMathElements(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_EG_OMathMathElements::~OOXMLContext_math_EG_OMathMathElements()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_EG_OMathMathElements::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_EG_OMathMathElements::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_acc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Acc(*this));
         }
             break;
     case OOXML_ELEMENT_math_bar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Bar(*this));
         }
             break;
     case OOXML_ELEMENT_math_box:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Box(*this));
         }
             break;
     case OOXML_ELEMENT_math_borderBox:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BorderBox(*this));
         }
             break;
     case OOXML_ELEMENT_math_d:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_D(*this));
         }
             break;
     case OOXML_ELEMENT_math_eqArr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_EqArr(*this));
         }
             break;
     case OOXML_ELEMENT_math_f:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_F(*this));
         }
             break;
     case OOXML_ELEMENT_math_func:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Func(*this));
         }
             break;
     case OOXML_ELEMENT_math_groupChr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_GroupChr(*this));
         }
             break;
     case OOXML_ELEMENT_math_limLow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimLow(*this));
         }
             break;
     case OOXML_ELEMENT_math_limUpp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimUpp(*this));
         }
             break;
     case OOXML_ELEMENT_math_m:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_M(*this));
         }
             break;
     case OOXML_ELEMENT_math_nary:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Nary(*this));
         }
             break;
     case OOXML_ELEMENT_math_phant:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Phant(*this));
         }
             break;
     case OOXML_ELEMENT_math_rad:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Rad(*this));
         }
             break;
     case OOXML_ELEMENT_math_sPre:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SPre(*this));
         }
             break;
     case OOXML_ELEMENT_math_sSub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSub(*this));
         }
             break;
     case OOXML_ELEMENT_math_sSubSup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSubSup(*this));
         }
             break;
     case OOXML_ELEMENT_math_sSup:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_SSup(*this));
         }
             break;
     case OOXML_ELEMENT_math_r:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_R(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_EG_OMathMathElements::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_EG_OMathMathElements::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_EG_OMathMathElements::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_EG_OMathMathElements::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_EG_OMathMathElements::startAction()
{
}
void OOXMLContext_math_EG_OMathMathElements::endAction()
{
}
/* 
    class: OOXMLContext_math_EG_OMathElements*/
OOXMLContext_math_EG_OMathElements::OOXMLContext_math_EG_OMathElements(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_EG_OMathElements::~OOXMLContext_math_EG_OMathElements()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_EG_OMathElements::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathMathElements(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_EG_OMathElements::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_EG_OMathElements::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_EG_OMathElements::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_EG_OMathElements::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathMathElements(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_EG_OMathElements::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_EG_OMathElements::startAction()
{
}
void OOXMLContext_math_EG_OMathElements::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMathArgPr*/
OOXMLContext_math_CT_OMathArgPr::OOXMLContext_math_CT_OMathArgPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_OMathArgPr::~OOXMLContext_math_CT_OMathArgPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMathArgPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMathArgPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_argSz:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_Integer2(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMathArgPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMathArgPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMathArgPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_OMathArgPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMathArgPr::startAction()
{
}
void OOXMLContext_math_CT_OMathArgPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMathArg*/
OOXMLContext_math_CT_OMathArg::OOXMLContext_math_CT_OMathArg(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_OMathArg::~OOXMLContext_math_CT_OMathArg()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMathArg::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathElements(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMathArg::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_argPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathArgPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_ctrlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_CtrlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMathArg::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMathArg::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMathArg::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathElements(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_CT_OMathArg::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMathArg::startAction()
{
}
void OOXMLContext_math_CT_OMathArg::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMathJc*/
OOXMLContext_math_CT_OMathJc::OOXMLContext_math_CT_OMathJc(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_OMathJc::~OOXMLContext_math_CT_OMathJc()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMathJc::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMathJc::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMathJc::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMathJc::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMathJc::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_OMathJc::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMathJc::startAction()
{
}
void OOXMLContext_math_CT_OMathJc::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMathParaPr*/
OOXMLContext_math_CT_OMathParaPr::OOXMLContext_math_CT_OMathParaPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_OMathParaPr::~OOXMLContext_math_CT_OMathParaPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMathParaPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMathParaPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_jc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathJc(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMathParaPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMathParaPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMathParaPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_OMathParaPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMathParaPr::startAction()
{
}
void OOXMLContext_math_CT_OMathParaPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_TwipsMeasure*/
OOXMLContext_math_CT_TwipsMeasure::OOXMLContext_math_CT_TwipsMeasure(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_TwipsMeasure::~OOXMLContext_math_CT_TwipsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_TwipsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_TwipsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_TwipsMeasure::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_TwipsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_TwipsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_TwipsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_TwipsMeasure::startAction()
{
}
void OOXMLContext_math_CT_TwipsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BreakBin*/
OOXMLContext_math_CT_BreakBin::OOXMLContext_math_CT_BreakBin(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_BreakBin::~OOXMLContext_math_CT_BreakBin()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BreakBin::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BreakBin::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BreakBin::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BreakBin::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BreakBin::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BreakBin::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_BreakBin::startAction()
{
}
void OOXMLContext_math_CT_BreakBin::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_BreakBinSub*/
OOXMLContext_math_CT_BreakBinSub::OOXMLContext_math_CT_BreakBinSub(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_math_CT_BreakBinSub::~OOXMLContext_math_CT_BreakBinSub()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_BreakBinSub::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_BreakBinSub::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_BreakBinSub::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_math_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_BreakBinSub::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_BreakBinSub::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_BreakBinSub::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_math_CT_BreakBinSub::startAction()
{
}
void OOXMLContext_math_CT_BreakBinSub::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_MathPr*/
OOXMLContext_math_CT_MathPr::OOXMLContext_math_CT_MathPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_MathPr::~OOXMLContext_math_CT_MathPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_MathPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_MathPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_mathFont:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_math_brkBin:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BreakBin(*this));
         }
             break;
     case OOXML_ELEMENT_math_brkBinSub:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_BreakBinSub(*this));
         }
             break;
     case OOXML_ELEMENT_math_smallFrac:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_dispDef:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_lMargin:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_rMargin:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_defJc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathJc(*this));
         }
             break;
     case OOXML_ELEMENT_math_preSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_postSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_interSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_intraSp:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_wrapIndent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_TwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_math_wrapRight:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_math_intLim:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimLoc(*this));
         }
             break;
     case OOXML_ELEMENT_math_naryLim:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_LimLoc(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_MathPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_MathPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_MathPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_MathPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_MathPr::startAction()
{
}
void OOXMLContext_math_CT_MathPr::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMathPara*/
OOXMLContext_math_CT_OMathPara::OOXMLContext_math_CT_OMathPara(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_OMathPara::~OOXMLContext_math_CT_OMathPara()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMathPara::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMathPara::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_oMathParaPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathParaPr(*this));
         }
             break;
     case OOXML_ELEMENT_math_oMath:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMath(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMathPara::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMathPara::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMathPara::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_CT_OMathPara::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMathPara::startAction()
{
}
void OOXMLContext_math_CT_OMathPara::endAction()
{
}
/* 
    class: OOXMLContext_math_CT_OMath*/
OOXMLContext_math_CT_OMath::OOXMLContext_math_CT_OMath(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_CT_OMath::~OOXMLContext_math_CT_OMath()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_CT_OMath::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathElements(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_CT_OMath::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_CT_OMath::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_CT_OMath::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_CT_OMath::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathElements(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_math_CT_OMath::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_CT_OMath::startAction()
{
}
void OOXMLContext_math_CT_OMath::endAction()
{
}
/* 
    class: OOXMLContext_math_oMathPara*/
OOXMLContext_math_oMathPara::OOXMLContext_math_oMathPara(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_oMathPara::~OOXMLContext_math_oMathPara()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_oMathPara::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_oMathPara::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_oMathPara:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMathPara(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_oMathPara::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_oMathPara::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_oMathPara::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_oMathPara::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_oMathPara::startAction()
{
}
void OOXMLContext_math_oMathPara::endAction()
{
}
/* 
    class: OOXMLContext_math_oMath*/
OOXMLContext_math_oMath::OOXMLContext_math_oMath(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_math_oMath::~OOXMLContext_math_oMath()
{
}

OOXMLContext::Pointer_t OOXMLContext_math_oMath::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_math_oMath::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_math_oMath:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_math_CT_OMath(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_math_oMath::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_math_oMath::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_math_oMath::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_math_oMath::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_math_oMath::startAction()
{
}
void OOXMLContext_math_oMath::endAction()
{
}
/* 
    class: OOXMLContext_picture_CT_PictureNonVisual*/
OOXMLContext_picture_CT_PictureNonVisual::OOXMLContext_picture_CT_PictureNonVisual(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_picture_CT_PictureNonVisual::~OOXMLContext_picture_CT_PictureNonVisual()
{
}

OOXMLContext::Pointer_t OOXMLContext_picture_CT_PictureNonVisual::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_picture_CT_PictureNonVisual::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_picture_cNvPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualDrawingProps(*this));
         }
             break;
     case OOXML_ELEMENT_picture_cNvPicPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_NonVisualPictureProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_picture_CT_PictureNonVisual::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_picture_CT_PictureNonVisual::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_picture_CT_PictureNonVisual::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_picture_CT_PictureNonVisual::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_picture_CT_PictureNonVisual::startAction()
{
}
void OOXMLContext_picture_CT_PictureNonVisual::endAction()
{
}
/* 
    class: OOXMLContext_picture_CT_Picture*/
OOXMLContext_picture_CT_Picture::OOXMLContext_picture_CT_Picture(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_picture_CT_Picture::~OOXMLContext_picture_CT_Picture()
{
}

OOXMLContext::Pointer_t OOXMLContext_picture_CT_Picture::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_picture_CT_Picture::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_picture_nvPicPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_picture_CT_PictureNonVisual(*this));
         }
             break;
     case OOXML_ELEMENT_picture_blipFill:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_BlipFillProperties(*this));
         }
             break;
     case OOXML_ELEMENT_picture_spPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_drawingml_CT_ShapeProperties(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_picture_CT_Picture::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_picture_CT_Picture::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_picture_CT_Picture::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_picture_CT_Picture::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_picture_CT_Picture::startAction()
{
}
void OOXMLContext_picture_CT_Picture::endAction()
{
}
/* 
    class: OOXMLContext_picture_pic*/
OOXMLContext_picture_pic::OOXMLContext_picture_pic(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_picture_pic::~OOXMLContext_picture_pic()
{
}

OOXMLContext::Pointer_t OOXMLContext_picture_pic::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_picture_pic::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_picture_pic:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_picture_CT_Picture(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_picture_pic::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_picture_pic::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_picture_pic::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_picture_pic::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_picture_pic::startAction()
{
}
void OOXMLContext_picture_pic::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Empty*/
OOXMLContext_wordprocessingml_CT_Empty::OOXMLContext_wordprocessingml_CT_Empty(const OOXMLContext & rContext)
: OOXMLContextSingleElement(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Empty::~OOXMLContext_wordprocessingml_CT_Empty()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Empty::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Empty::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Empty::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Empty::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Empty::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Empty::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextSingleElement::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Empty::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Empty::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_OnOff*/
OOXMLContext_wordprocessingml_CT_OnOff::OOXMLContext_wordprocessingml_CT_OnOff(const OOXMLContext & rContext)
: OOXMLContextBooleanValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_OnOff::~OOXMLContext_wordprocessingml_CT_OnOff()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_OnOff::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_OnOff::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_OnOff::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mbValue = OOXMLValue_wordprocessingml_ST_OnOff(rValue).getBool();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_OnOff::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_OnOff::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_OnOff::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextBooleanValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_OnOff::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_OnOff::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_LongHexNumber*/
OOXMLContext_wordprocessingml_CT_LongHexNumber::OOXMLContext_wordprocessingml_CT_LongHexNumber(const OOXMLContext & rContext)
: OOXMLContextHexValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_LongHexNumber::~OOXMLContext_wordprocessingml_CT_LongHexNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_LongHexNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_LongHexNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_LongHexNumber::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32(16);
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_LongHexNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_LongHexNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_LongHexNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextHexValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_LongHexNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_LongHexNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_ShortHexNumber*/
OOXMLContext_wordprocessingml_CT_ShortHexNumber::OOXMLContext_wordprocessingml_CT_ShortHexNumber(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_ShortHexNumber::~OOXMLContext_wordprocessingml_CT_ShortHexNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_ShortHexNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_ShortHexNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_ShortHexNumber::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_ShortHexNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_ShortHexNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_ShortHexNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_ShortHexNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_ShortHexNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_UcharHexNumber*/
OOXMLContext_wordprocessingml_CT_UcharHexNumber::OOXMLContext_wordprocessingml_CT_UcharHexNumber(const OOXMLContext & rContext)
: OOXMLContextHexValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_UcharHexNumber::~OOXMLContext_wordprocessingml_CT_UcharHexNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_UcharHexNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_UcharHexNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_UcharHexNumber::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32(16);
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_UcharHexNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_UcharHexNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_UcharHexNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextHexValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_UcharHexNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_UcharHexNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_DecimalNumber*/
OOXMLContext_wordprocessingml_CT_DecimalNumber::OOXMLContext_wordprocessingml_CT_DecimalNumber(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_DecimalNumber::~OOXMLContext_wordprocessingml_CT_DecimalNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_DecimalNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_DecimalNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_DecimalNumber::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_DecimalNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_DecimalNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_DecimalNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_DecimalNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_DecimalNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TwipsMeasure*/
OOXMLContext_wordprocessingml_CT_TwipsMeasure::OOXMLContext_wordprocessingml_CT_TwipsMeasure(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TwipsMeasure::~OOXMLContext_wordprocessingml_CT_TwipsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TwipsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TwipsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TwipsMeasure::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TwipsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TwipsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TwipsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TwipsMeasure::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TwipsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure*/
OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::~OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PixelsMeasure*/
OOXMLContext_wordprocessingml_CT_PixelsMeasure::OOXMLContext_wordprocessingml_CT_PixelsMeasure(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PixelsMeasure::~OOXMLContext_wordprocessingml_CT_PixelsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PixelsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PixelsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PixelsMeasure::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PixelsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PixelsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PixelsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PixelsMeasure::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PixelsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_HpsMeasure*/
OOXMLContext_wordprocessingml_CT_HpsMeasure::OOXMLContext_wordprocessingml_CT_HpsMeasure(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_HpsMeasure::~OOXMLContext_wordprocessingml_CT_HpsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_HpsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_HpsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_HpsMeasure::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_HpsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_HpsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_HpsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_HpsMeasure::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_HpsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SignedHpsMeasure*/
OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::OOXMLContext_wordprocessingml_CT_SignedHpsMeasure(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::~OOXMLContext_wordprocessingml_CT_SignedHpsMeasure()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SignedHpsMeasure::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MacroName*/
OOXMLContext_wordprocessingml_CT_MacroName::OOXMLContext_wordprocessingml_CT_MacroName(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MacroName::~OOXMLContext_wordprocessingml_CT_MacroName()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MacroName::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MacroName::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MacroName::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MacroName::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MacroName::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MacroName::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MacroName::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MacroName::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_String*/
OOXMLContext_wordprocessingml_CT_String::OOXMLContext_wordprocessingml_CT_String(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_String::~OOXMLContext_wordprocessingml_CT_String()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_String::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_String::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_String::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_String::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_String::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_String::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_String::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_String::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TextScale*/
OOXMLContext_wordprocessingml_CT_TextScale::OOXMLContext_wordprocessingml_CT_TextScale(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TextScale::~OOXMLContext_wordprocessingml_CT_TextScale()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TextScale::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TextScale::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TextScale::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TextScale::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TextScale::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TextScale::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TextScale::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TextScale::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Highlight*/
OOXMLContext_wordprocessingml_CT_Highlight::OOXMLContext_wordprocessingml_CT_Highlight(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Highlight::~OOXMLContext_wordprocessingml_CT_Highlight()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Highlight::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Highlight::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Highlight::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_HighlightColor(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Highlight::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Highlight::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Highlight::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Highlight::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Highlight::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Color*/
OOXMLContext_wordprocessingml_CT_Color::OOXMLContext_wordprocessingml_CT_Color(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Color::~OOXMLContext_wordprocessingml_CT_Color()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Color::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Color::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Color::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_HexColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ThemeColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Color::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Color : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_Color_val;
        break;
        // CT_Color : themeColor
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        nResult = NS_ooxml::LN_CT_Color_themeColor;
        break;
        // CT_Color : themeTint
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        nResult = NS_ooxml::LN_CT_Color_themeTint;
        break;
        // CT_Color : themeShade
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        nResult = NS_ooxml::LN_CT_Color_themeShade;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Color::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Color::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Color::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Color::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Lang*/
OOXMLContext_wordprocessingml_CT_Lang::OOXMLContext_wordprocessingml_CT_Lang(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Lang::~OOXMLContext_wordprocessingml_CT_Lang()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Lang::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Lang::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Lang::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Lang::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Lang::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Lang::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Lang::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Lang::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Guid*/
OOXMLContext_wordprocessingml_CT_Guid::OOXMLContext_wordprocessingml_CT_Guid(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Guid::~OOXMLContext_wordprocessingml_CT_Guid()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Guid::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Guid::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Guid::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Guid::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Guid::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Guid::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Guid::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Guid::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Underline*/
OOXMLContext_wordprocessingml_CT_Underline::OOXMLContext_wordprocessingml_CT_Underline(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Underline::~OOXMLContext_wordprocessingml_CT_Underline()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Underline::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Underline::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Underline::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Underline(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Underline::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Underline : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_Underline_val;
        break;
        // CT_Underline : color
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        nResult = NS_ooxml::LN_CT_Underline_color;
        break;
        // CT_Underline : themeColor
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        nResult = NS_ooxml::LN_CT_Underline_themeColor;
        break;
        // CT_Underline : themeTint
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        nResult = NS_ooxml::LN_CT_Underline_themeTint;
        break;
        // CT_Underline : themeShade
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        nResult = NS_ooxml::LN_CT_Underline_themeShade;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Underline::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Underline::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Underline::startAction()
{
        /*val*/
        
    attribute(OOXML_ATTRIBUTE_wordprocessingml_val, OOXMLValueString_single);
}
void OOXMLContext_wordprocessingml_CT_Underline::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TextEffect*/
OOXMLContext_wordprocessingml_CT_TextEffect::OOXMLContext_wordprocessingml_CT_TextEffect(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TextEffect::~OOXMLContext_wordprocessingml_CT_TextEffect()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TextEffect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TextEffect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TextEffect::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_TextEffect(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TextEffect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TextEffect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TextEffect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TextEffect::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TextEffect::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Border*/
OOXMLContext_wordprocessingml_CT_Border::OOXMLContext_wordprocessingml_CT_Border(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Border::~OOXMLContext_wordprocessingml_CT_Border()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Border::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Border::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Border::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Border(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_HexColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ThemeColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_sz:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_EighthPointMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_PointMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_shadow:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_frame:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Border::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Border : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_rtf::LN_BRCTYPE;
        break;
        // CT_Border : color
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        nResult = NS_ooxml::LN_CT_Border_color;
        break;
        // CT_Border : themeColor
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        nResult = NS_ooxml::LN_CT_Border_themeColor;
        break;
        // CT_Border : themeTint
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        nResult = NS_ooxml::LN_CT_Border_themeTint;
        break;
        // CT_Border : themeShade
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        nResult = NS_ooxml::LN_CT_Border_themeShade;
        break;
        // CT_Border : sz
     case OOXML_ATTRIBUTE_wordprocessingml_sz:
        nResult = NS_rtf::LN_DPTLINEWIDTH;
        break;
        // CT_Border : space
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        nResult = NS_rtf::LN_DPTSPACE;
        break;
        // CT_Border : shadow
     case OOXML_ATTRIBUTE_wordprocessingml_shadow:
        nResult = NS_rtf::LN_FSHADOW;
        break;
        // CT_Border : frame
     case OOXML_ATTRIBUTE_wordprocessingml_frame:
        nResult = NS_rtf::LN_FFRAME;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Border::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Border::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Border::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Border::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Shd*/
OOXMLContext_wordprocessingml_CT_Shd::OOXMLContext_wordprocessingml_CT_Shd(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Shd::~OOXMLContext_wordprocessingml_CT_Shd()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Shd::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Shd::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Shd::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Shd(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_HexColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ThemeColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_fill:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_HexColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeFill:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ThemeColor(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeFillTint:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_themeFillShade:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_UcharHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Shd::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Shd : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_Shd_val;
        break;
        // CT_Shd : color
     case OOXML_ATTRIBUTE_wordprocessingml_color:
        nResult = NS_ooxml::LN_CT_Shd_color;
        break;
        // CT_Shd : themeColor
     case OOXML_ATTRIBUTE_wordprocessingml_themeColor:
        nResult = NS_ooxml::LN_CT_Shd_themeColor;
        break;
        // CT_Shd : themeTint
     case OOXML_ATTRIBUTE_wordprocessingml_themeTint:
        nResult = NS_ooxml::LN_CT_Shd_themeTint;
        break;
        // CT_Shd : themeShade
     case OOXML_ATTRIBUTE_wordprocessingml_themeShade:
        nResult = NS_ooxml::LN_CT_Shd_themeShade;
        break;
        // CT_Shd : fill
     case OOXML_ATTRIBUTE_wordprocessingml_fill:
        nResult = NS_ooxml::LN_CT_Shd_fill;
        break;
        // CT_Shd : themeFill
     case OOXML_ATTRIBUTE_wordprocessingml_themeFill:
        nResult = NS_ooxml::LN_CT_Shd_themeFill;
        break;
        // CT_Shd : themeFillTint
     case OOXML_ATTRIBUTE_wordprocessingml_themeFillTint:
        nResult = NS_ooxml::LN_CT_Shd_themeFillTint;
        break;
        // CT_Shd : themeFillShade
     case OOXML_ATTRIBUTE_wordprocessingml_themeFillShade:
        nResult = NS_ooxml::LN_CT_Shd_themeFillShade;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Shd::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Shd::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Shd::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Shd::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_VerticalAlignRun*/
OOXMLContext_wordprocessingml_CT_VerticalAlignRun::OOXMLContext_wordprocessingml_CT_VerticalAlignRun(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_VerticalAlignRun::~OOXMLContext_wordprocessingml_CT_VerticalAlignRun()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_VerticalAlignRun::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_VerticalAlignRun::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_VerticalAlignRun::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_VerticalAlignRun::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_VerticalAlignRun::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_VerticalAlignRun::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_VerticalAlignRun::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_VerticalAlignRun::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FitText*/
OOXMLContext_wordprocessingml_CT_FitText::OOXMLContext_wordprocessingml_CT_FitText(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FitText::~OOXMLContext_wordprocessingml_CT_FitText()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FitText::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FitText::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FitText::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FitText::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FitText::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FitText::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FitText::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FitText::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Em*/
OOXMLContext_wordprocessingml_CT_Em::OOXMLContext_wordprocessingml_CT_Em(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Em::~OOXMLContext_wordprocessingml_CT_Em()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Em::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Em::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Em::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_Em(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Em::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Em::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Em::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Em::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Em::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Language*/
OOXMLContext_wordprocessingml_CT_Language::OOXMLContext_wordprocessingml_CT_Language(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Language::~OOXMLContext_wordprocessingml_CT_Language()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Language::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Language::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Language::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Lang(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsia:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Lang(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_bidi:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Lang(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Language::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Language : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_Language_val;
        break;
        // CT_Language : eastAsia
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsia:
        nResult = NS_ooxml::LN_CT_Language_eastAsia;
        break;
        // CT_Language : bidi
     case OOXML_ATTRIBUTE_wordprocessingml_bidi:
        nResult = NS_ooxml::LN_CT_Language_bidi;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Language::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Language::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Language::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Language::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_EastAsianLayout*/
OOXMLContext_wordprocessingml_CT_EastAsianLayout::OOXMLContext_wordprocessingml_CT_EastAsianLayout(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_EastAsianLayout::~OOXMLContext_wordprocessingml_CT_EastAsianLayout()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_EastAsianLayout::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_EastAsianLayout::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_EastAsianLayout::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_combine:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_combineBrackets:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_CombineBrackets(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_vert:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_vertCompress:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_EastAsianLayout::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_EastAsianLayout : id
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        nResult = NS_ooxml::LN_CT_EastAsianLayout_id;
        break;
        // CT_EastAsianLayout : combine
     case OOXML_ATTRIBUTE_wordprocessingml_combine:
        nResult = NS_ooxml::LN_CT_EastAsianLayout_combine;
        break;
        // CT_EastAsianLayout : combineBrackets
     case OOXML_ATTRIBUTE_wordprocessingml_combineBrackets:
        nResult = NS_ooxml::LN_CT_EastAsianLayout_combineBrackets;
        break;
        // CT_EastAsianLayout : vert
     case OOXML_ATTRIBUTE_wordprocessingml_vert:
        nResult = NS_ooxml::LN_CT_EastAsianLayout_vert;
        break;
        // CT_EastAsianLayout : vertCompress
     case OOXML_ATTRIBUTE_wordprocessingml_vertCompress:
        nResult = NS_ooxml::LN_CT_EastAsianLayout_vertCompress;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_EastAsianLayout::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_EastAsianLayout::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_EastAsianLayout::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_EastAsianLayout::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FramePr*/
OOXMLContext_wordprocessingml_CT_FramePr::OOXMLContext_wordprocessingml_CT_FramePr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FramePr::~OOXMLContext_wordprocessingml_CT_FramePr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FramePr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FramePr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FramePr::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_dropCap:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_lines:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_h:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_vSpace:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hSpace:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_wrap:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hAnchor:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_vAnchor:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_x:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_xAlign:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_y:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_yAlign:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hRule:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_anchorLock:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FramePr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_FramePr : dropCap
     case OOXML_ATTRIBUTE_wordprocessingml_dropCap:
        nResult = NS_ooxml::LN_CT_FramePr_dropCap;
        break;
        // CT_FramePr : lines
     case OOXML_ATTRIBUTE_wordprocessingml_lines:
        nResult = NS_ooxml::LN_CT_FramePr_lines;
        break;
        // CT_FramePr : w
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        nResult = NS_sprm::LN_PDxaWidth;
        break;
        // CT_FramePr : h
     case OOXML_ATTRIBUTE_wordprocessingml_h:
        nResult = NS_sprm::LN_PWHeightAbs;
        break;
        // CT_FramePr : vSpace
     case OOXML_ATTRIBUTE_wordprocessingml_vSpace:
        nResult = NS_sprm::LN_PDyaFromText;
        break;
        // CT_FramePr : hSpace
     case OOXML_ATTRIBUTE_wordprocessingml_hSpace:
        nResult = NS_sprm::LN_PDxaFromText;
        break;
        // CT_FramePr : wrap
     case OOXML_ATTRIBUTE_wordprocessingml_wrap:
        nResult = NS_sprm::LN_PWr;
        break;
        // CT_FramePr : hAnchor
     case OOXML_ATTRIBUTE_wordprocessingml_hAnchor:
        nResult = NS_ooxml::LN_CT_FramePr_hAnchor;
        break;
        // CT_FramePr : vAnchor
     case OOXML_ATTRIBUTE_wordprocessingml_vAnchor:
        nResult = NS_ooxml::LN_CT_FramePr_vAnchor;
        break;
        // CT_FramePr : x
     case OOXML_ATTRIBUTE_wordprocessingml_x:
        nResult = NS_ooxml::LN_CT_FramePr_x;
        break;
        // CT_FramePr : xAlign
     case OOXML_ATTRIBUTE_wordprocessingml_xAlign:
        nResult = NS_ooxml::LN_CT_FramePr_xAlign;
        break;
        // CT_FramePr : y
     case OOXML_ATTRIBUTE_wordprocessingml_y:
        nResult = NS_ooxml::LN_CT_FramePr_y;
        break;
        // CT_FramePr : yAlign
     case OOXML_ATTRIBUTE_wordprocessingml_yAlign:
        nResult = NS_ooxml::LN_CT_FramePr_yAlign;
        break;
        // CT_FramePr : hRule
     case OOXML_ATTRIBUTE_wordprocessingml_hRule:
        nResult = NS_ooxml::LN_CT_FramePr_hRule;
        break;
        // CT_FramePr : anchorLock
     case OOXML_ATTRIBUTE_wordprocessingml_anchorLock:
        nResult = NS_sprm::LN_PFLocked;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FramePr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FramePr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FramePr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FramePr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TabStop*/
OOXMLContext_wordprocessingml_CT_TabStop::OOXMLContext_wordprocessingml_CT_TabStop(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TabStop::~OOXMLContext_wordprocessingml_CT_TabStop()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TabStop::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TabStop::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TabStop::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TabJc(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_leader:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TabTlc(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_pos:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TabStop::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TabStop : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_TabStop_val;
        break;
        // CT_TabStop : leader
     case OOXML_ATTRIBUTE_wordprocessingml_leader:
        nResult = NS_ooxml::LN_CT_TabStop_leader;
        break;
        // CT_TabStop : pos
     case OOXML_ATTRIBUTE_wordprocessingml_pos:
        nResult = NS_ooxml::LN_CT_TabStop_pos;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TabStop::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TabStop::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TabStop::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TabStop::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Spacing*/
OOXMLContext_wordprocessingml_CT_Spacing::OOXMLContext_wordprocessingml_CT_Spacing(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Spacing::~OOXMLContext_wordprocessingml_CT_Spacing()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Spacing::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Spacing::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Spacing::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_before:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_beforeLines:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_beforeAutospacing:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_after:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_afterLines:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_afterAutospacing:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_line:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_lineRule:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_LineSpacingRule(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Spacing::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Spacing : before
     case OOXML_ATTRIBUTE_wordprocessingml_before:
        nResult = NS_ooxml::LN_CT_Spacing_before;
        break;
        // CT_Spacing : beforeLines
     case OOXML_ATTRIBUTE_wordprocessingml_beforeLines:
        nResult = NS_ooxml::LN_CT_Spacing_beforeLines;
        break;
        // CT_Spacing : beforeAutospacing
     case OOXML_ATTRIBUTE_wordprocessingml_beforeAutospacing:
        nResult = NS_ooxml::LN_CT_Spacing_beforeAutospacing;
        break;
        // CT_Spacing : after
     case OOXML_ATTRIBUTE_wordprocessingml_after:
        nResult = NS_ooxml::LN_CT_Spacing_after;
        break;
        // CT_Spacing : afterLines
     case OOXML_ATTRIBUTE_wordprocessingml_afterLines:
        nResult = NS_ooxml::LN_CT_Spacing_afterLines;
        break;
        // CT_Spacing : afterAutospacing
     case OOXML_ATTRIBUTE_wordprocessingml_afterAutospacing:
        nResult = NS_ooxml::LN_CT_Spacing_afterAutospacing;
        break;
        // CT_Spacing : line
     case OOXML_ATTRIBUTE_wordprocessingml_line:
        nResult = NS_ooxml::LN_CT_Spacing_line;
        break;
        // CT_Spacing : lineRule
     case OOXML_ATTRIBUTE_wordprocessingml_lineRule:
        nResult = NS_ooxml::LN_CT_Spacing_lineRule;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Spacing::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Spacing::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Spacing::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Spacing::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Ind*/
OOXMLContext_wordprocessingml_CT_Ind::OOXMLContext_wordprocessingml_CT_Ind(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Ind::~OOXMLContext_wordprocessingml_CT_Ind()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Ind::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Ind::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Ind::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_left:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_leftChars:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_right:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_rightChars:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hanging:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hangingChars:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_firstLine:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_firstLineChars:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Ind::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Ind : left
     case OOXML_ATTRIBUTE_wordprocessingml_left:
        nResult = NS_ooxml::LN_CT_Ind_left;
        break;
        // CT_Ind : leftChars
     case OOXML_ATTRIBUTE_wordprocessingml_leftChars:
        nResult = NS_ooxml::LN_CT_Ind_leftChars;
        break;
        // CT_Ind : right
     case OOXML_ATTRIBUTE_wordprocessingml_right:
        nResult = NS_ooxml::LN_CT_Ind_right;
        break;
        // CT_Ind : rightChars
     case OOXML_ATTRIBUTE_wordprocessingml_rightChars:
        nResult = NS_ooxml::LN_CT_Ind_rightChars;
        break;
        // CT_Ind : hanging
     case OOXML_ATTRIBUTE_wordprocessingml_hanging:
        nResult = NS_ooxml::LN_CT_Ind_hanging;
        break;
        // CT_Ind : hangingChars
     case OOXML_ATTRIBUTE_wordprocessingml_hangingChars:
        nResult = NS_ooxml::LN_CT_Ind_hangingChars;
        break;
        // CT_Ind : firstLine
     case OOXML_ATTRIBUTE_wordprocessingml_firstLine:
        nResult = NS_ooxml::LN_CT_Ind_firstLine;
        break;
        // CT_Ind : firstLineChars
     case OOXML_ATTRIBUTE_wordprocessingml_firstLineChars:
        nResult = NS_ooxml::LN_CT_Ind_firstLineChars;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Ind::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Ind::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Ind::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Ind::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Jc*/
OOXMLContext_wordprocessingml_CT_Jc::OOXMLContext_wordprocessingml_CT_Jc(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Jc::~OOXMLContext_wordprocessingml_CT_Jc()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Jc::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Jc::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Jc::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_Jc(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Jc::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Jc::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Jc::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Jc::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Jc::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_View*/
OOXMLContext_wordprocessingml_CT_View::OOXMLContext_wordprocessingml_CT_View(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_View::~OOXMLContext_wordprocessingml_CT_View()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_View::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_View::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_View::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_View::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_View::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_View::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_View::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_View::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Zoom*/
OOXMLContext_wordprocessingml_CT_Zoom::OOXMLContext_wordprocessingml_CT_Zoom(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Zoom::~OOXMLContext_wordprocessingml_CT_Zoom()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Zoom::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Zoom::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Zoom::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Zoom::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Zoom::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Zoom::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Zoom::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Zoom::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_WritingStyle*/
OOXMLContext_wordprocessingml_CT_WritingStyle::OOXMLContext_wordprocessingml_CT_WritingStyle(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_WritingStyle::~OOXMLContext_wordprocessingml_CT_WritingStyle()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_WritingStyle::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_WritingStyle::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_WritingStyle::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_WritingStyle::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_WritingStyle::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_WritingStyle::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_WritingStyle::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_WritingStyle::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Proof*/
OOXMLContext_wordprocessingml_CT_Proof::OOXMLContext_wordprocessingml_CT_Proof(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Proof::~OOXMLContext_wordprocessingml_CT_Proof()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Proof::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Proof::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Proof::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Proof::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Proof::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Proof::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Proof::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Proof::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_DocType*/
OOXMLContext_wordprocessingml_CT_DocType::OOXMLContext_wordprocessingml_CT_DocType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_DocType::~OOXMLContext_wordprocessingml_CT_DocType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_DocType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_DocType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_DocType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_DocType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_DocType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_DocType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_DocType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_DocType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_DocProtect*/
OOXMLContext_wordprocessingml_CT_DocProtect::OOXMLContext_wordprocessingml_CT_DocProtect(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_DocProtect::~OOXMLContext_wordprocessingml_CT_DocProtect()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_DocProtect::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_DocProtect::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_DocProtect::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_DocProtect::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_DocProtect::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_DocProtect::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_DocProtect::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_DocProtect::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MailMergeDocType*/
OOXMLContext_wordprocessingml_CT_MailMergeDocType::OOXMLContext_wordprocessingml_CT_MailMergeDocType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MailMergeDocType::~OOXMLContext_wordprocessingml_CT_MailMergeDocType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MailMergeDocType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MailMergeDocType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MailMergeDocType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MailMergeDocType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MailMergeDocType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MailMergeDocType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MailMergeDocType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MailMergeDocType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MailMergeDataType*/
OOXMLContext_wordprocessingml_CT_MailMergeDataType::OOXMLContext_wordprocessingml_CT_MailMergeDataType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MailMergeDataType::~OOXMLContext_wordprocessingml_CT_MailMergeDataType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MailMergeDataType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MailMergeDataType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MailMergeDataType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MailMergeDataType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MailMergeDataType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MailMergeDataType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MailMergeDataType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MailMergeDataType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MailMergeDest*/
OOXMLContext_wordprocessingml_CT_MailMergeDest::OOXMLContext_wordprocessingml_CT_MailMergeDest(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MailMergeDest::~OOXMLContext_wordprocessingml_CT_MailMergeDest()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MailMergeDest::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MailMergeDest::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MailMergeDest::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MailMergeDest::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MailMergeDest::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MailMergeDest::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MailMergeDest::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MailMergeDest::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType*/
OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::~OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MailMergeOdsoFMDFieldType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TrackChangesView*/
OOXMLContext_wordprocessingml_CT_TrackChangesView::OOXMLContext_wordprocessingml_CT_TrackChangesView(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TrackChangesView::~OOXMLContext_wordprocessingml_CT_TrackChangesView()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TrackChangesView::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TrackChangesView::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TrackChangesView::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TrackChangesView::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TrackChangesView::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TrackChangesView::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TrackChangesView::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TrackChangesView::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Kinsoku*/
OOXMLContext_wordprocessingml_CT_Kinsoku::OOXMLContext_wordprocessingml_CT_Kinsoku(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Kinsoku::~OOXMLContext_wordprocessingml_CT_Kinsoku()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Kinsoku::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Kinsoku::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Kinsoku::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_lang:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Kinsoku::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Kinsoku::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Kinsoku::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Kinsoku::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Kinsoku::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TextDirection*/
OOXMLContext_wordprocessingml_CT_TextDirection::OOXMLContext_wordprocessingml_CT_TextDirection(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TextDirection::~OOXMLContext_wordprocessingml_CT_TextDirection()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TextDirection::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TextDirection::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TextDirection::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_TextDirection(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TextDirection::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TextDirection::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TextDirection::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TextDirection::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TextDirection::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TextAlignment*/
OOXMLContext_wordprocessingml_CT_TextAlignment::OOXMLContext_wordprocessingml_CT_TextAlignment(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TextAlignment::~OOXMLContext_wordprocessingml_CT_TextAlignment()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TextAlignment::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TextAlignment::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TextAlignment::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TextAlignment::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TextAlignment::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TextAlignment::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TextAlignment::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TextAlignment::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Markup*/
OOXMLContext_wordprocessingml_CT_Markup::OOXMLContext_wordprocessingml_CT_Markup(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Markup::~OOXMLContext_wordprocessingml_CT_Markup()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Markup::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Markup::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Markup::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Markup::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Markup : id
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        nResult = NS_ooxml::LN_CT_Markup_id;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Markup::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Markup::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Markup::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Markup::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TrackChange*/
OOXMLContext_wordprocessingml_CT_TrackChange::OOXMLContext_wordprocessingml_CT_TrackChange(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TrackChange::~OOXMLContext_wordprocessingml_CT_TrackChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TrackChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TrackChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TrackChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_author:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_date:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
    default:
      ;
    }
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TrackChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TrackChange : author
     case OOXML_ATTRIBUTE_wordprocessingml_author:
        nResult = NS_ooxml::LN_CT_TrackChange_author;
        break;
        // CT_TrackChange : date
     case OOXML_ATTRIBUTE_wordprocessingml_date:
        nResult = NS_ooxml::LN_CT_TrackChange_date;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TrackChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TrackChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TrackChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TrackChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CellMergeTrackChange*/
OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::OOXMLContext_wordprocessingml_CT_CellMergeTrackChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::~OOXMLContext_wordprocessingml_CT_CellMergeTrackChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CellMergeTrackChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TrackChangeRange*/
OOXMLContext_wordprocessingml_CT_TrackChangeRange::OOXMLContext_wordprocessingml_CT_TrackChangeRange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TrackChangeRange::~OOXMLContext_wordprocessingml_CT_TrackChangeRange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TrackChangeRange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TrackChangeRange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TrackChangeRange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TrackChangeRange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TrackChangeRange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TrackChangeRange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TrackChangeRange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TrackChangeRange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MarkupRange*/
OOXMLContext_wordprocessingml_CT_MarkupRange::OOXMLContext_wordprocessingml_CT_MarkupRange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MarkupRange::~OOXMLContext_wordprocessingml_CT_MarkupRange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MarkupRange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MarkupRange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MarkupRange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MarkupRange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MarkupRange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MarkupRange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MarkupRange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MarkupRange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_BookmarkRange*/
OOXMLContext_wordprocessingml_CT_BookmarkRange::OOXMLContext_wordprocessingml_CT_BookmarkRange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_BookmarkRange::~OOXMLContext_wordprocessingml_CT_BookmarkRange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_BookmarkRange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_BookmarkRange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_BookmarkRange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_BookmarkRange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_BookmarkRange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_BookmarkRange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_BookmarkRange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_BookmarkRange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Bookmark*/
OOXMLContext_wordprocessingml_CT_Bookmark::OOXMLContext_wordprocessingml_CT_Bookmark(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Bookmark::~OOXMLContext_wordprocessingml_CT_Bookmark()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Bookmark::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_BookmarkRange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Bookmark::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Bookmark::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_BookmarkRange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Bookmark::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Bookmark::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_BookmarkRange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Bookmark::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Bookmark::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Bookmark::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_MoveBookmark*/
OOXMLContext_wordprocessingml_CT_MoveBookmark::OOXMLContext_wordprocessingml_CT_MoveBookmark(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_MoveBookmark::~OOXMLContext_wordprocessingml_CT_MoveBookmark()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_MoveBookmark::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Bookmark(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_MoveBookmark::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_MoveBookmark::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Bookmark(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_MoveBookmark::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_MoveBookmark::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Bookmark(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_MoveBookmark::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_MoveBookmark::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_MoveBookmark::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Comment*/
OOXMLContext_wordprocessingml_CT_Comment::OOXMLContext_wordprocessingml_CT_Comment(const OOXMLContext & rContext)
: OOXMLContextXNote(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Comment::~OOXMLContext_wordprocessingml_CT_Comment()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Comment::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_BlockLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Comment::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Comment::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_id:
        checkId(rValue);
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_initials:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
        bResult = true;
        break;
    default:
      ;
    }
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(getPropertySetAttrs());
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Comment::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Comment::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_BlockLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Comment::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextXNote::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Comment::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Comment::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TrackChangeNumbering*/
OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::OOXMLContext_wordprocessingml_CT_TrackChangeNumbering(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::~OOXMLContext_wordprocessingml_CT_TrackChangeNumbering()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TrackChangeNumbering::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblPrExChange*/
OOXMLContext_wordprocessingml_CT_TblPrExChange::OOXMLContext_wordprocessingml_CT_TblPrExChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblPrExChange::~OOXMLContext_wordprocessingml_CT_TblPrExChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblPrExChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblPrExChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tblPrEx:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblPrExBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblPrExChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblPrExChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblPrExChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblPrExChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblPrExChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblPrExChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcPrChange*/
OOXMLContext_wordprocessingml_CT_TcPrChange::OOXMLContext_wordprocessingml_CT_TcPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcPrChange::~OOXMLContext_wordprocessingml_CT_TcPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tcPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TcPrInner(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TcPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TcPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TcPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TrPrChange*/
OOXMLContext_wordprocessingml_CT_TrPrChange::OOXMLContext_wordprocessingml_CT_TrPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TrPrChange::~OOXMLContext_wordprocessingml_CT_TrPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TrPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TrPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_trPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrPrBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TrPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TrPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TrPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TrPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TrPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TrPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblGridChange*/
OOXMLContext_wordprocessingml_CT_TblGridChange::OOXMLContext_wordprocessingml_CT_TblGridChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblGridChange::~OOXMLContext_wordprocessingml_CT_TblGridChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblGridChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblGridChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tblGrid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblGridBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblGridChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblGridChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblGridChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblGridChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblGridChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblGridChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblPrChange*/
OOXMLContext_wordprocessingml_CT_TblPrChange::OOXMLContext_wordprocessingml_CT_TblPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblPrChange::~OOXMLContext_wordprocessingml_CT_TblPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tblPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblPrBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SectPrChange*/
OOXMLContext_wordprocessingml_CT_SectPrChange::OOXMLContext_wordprocessingml_CT_SectPrChange(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SectPrChange::~OOXMLContext_wordprocessingml_CT_SectPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SectPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SectPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sectPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SectPrBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SectPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SectPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_SectPrChange : sectPr
     case OOXML_ELEMENT_wordprocessingml_sectPr:
        nResult = NS_ooxml::LN_CT_SectPrChange_sectPr;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SectPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SectPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SectPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SectPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PPrChange*/
OOXMLContext_wordprocessingml_CT_PPrChange::OOXMLContext_wordprocessingml_CT_PPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PPrChange::~OOXMLContext_wordprocessingml_CT_PPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_pPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PPrBase(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RPrChange*/
OOXMLContext_wordprocessingml_CT_RPrChange::OOXMLContext_wordprocessingml_CT_RPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RPrChange::~OOXMLContext_wordprocessingml_CT_RPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPrOriginal(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_ParaRPrChange*/
OOXMLContext_wordprocessingml_CT_ParaRPrChange::OOXMLContext_wordprocessingml_CT_ParaRPrChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_ParaRPrChange::~OOXMLContext_wordprocessingml_CT_ParaRPrChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_ParaRPrChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_ParaRPrChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_ParaRPrOriginal(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_ParaRPrChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_ParaRPrChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_ParaRPrChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_ParaRPrChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_ParaRPrChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_ParaRPrChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RunTrackChange*/
OOXMLContext_wordprocessingml_CT_RunTrackChange::OOXMLContext_wordprocessingml_CT_RunTrackChange(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RunTrackChange::~OOXMLContext_wordprocessingml_CT_RunTrackChange()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RunTrackChange::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRunContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathMathElements(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RunTrackChange::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RunTrackChange::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RunTrackChange::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RunTrackChange::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRunContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_math_EG_OMathMathElements(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RunTrackChange::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RunTrackChange::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RunTrackChange::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_CellMarkupElements*/
OOXMLContext_wordprocessingml_EG_CellMarkupElements::OOXMLContext_wordprocessingml_EG_CellMarkupElements(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_CellMarkupElements::~OOXMLContext_wordprocessingml_EG_CellMarkupElements()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_CellMarkupElements::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_CellMarkupElements::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_cellIns:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cellDel:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cellMerge:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CellMergeTrackChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_CellMarkupElements::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_CellMarkupElements::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_CellMarkupElements::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_CellMarkupElements::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_CellMarkupElements::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_CellMarkupElements::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RangeMarkupElements*/
OOXMLContext_wordprocessingml_EG_RangeMarkupElements::OOXMLContext_wordprocessingml_EG_RangeMarkupElements(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RangeMarkupElements::~OOXMLContext_wordprocessingml_EG_RangeMarkupElements()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RangeMarkupElements::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RangeMarkupElements::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_bookmarkStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Bookmark(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bookmarkEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveFromRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MoveBookmark(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveFromRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveToRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MoveBookmark(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveToRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_commentRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_commentRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MarkupRange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlInsRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlInsRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlDelRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlDelRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlMoveFromRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlMoveFromRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlMoveToRangeStart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXmlMoveToRangeEnd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Markup(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RangeMarkupElements::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RangeMarkupElements::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RangeMarkupElements::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RangeMarkupElements::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RangeMarkupElements::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RangeMarkupElements::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_NumPr*/
OOXMLContext_wordprocessingml_CT_NumPr::OOXMLContext_wordprocessingml_CT_NumPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_NumPr::~OOXMLContext_wordprocessingml_CT_NumPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_NumPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_NumPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_ilvl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_numId:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_numberingChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChangeNumbering(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ins:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_NumPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_NumPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_NumPr : ilvl
     case OOXML_ELEMENT_wordprocessingml_ilvl:
        nResult = NS_sprm::LN_PIlvl;
        break;
        // CT_NumPr : numId
     case OOXML_ELEMENT_wordprocessingml_numId:
        nResult = NS_sprm::LN_PIlfo;
        break;
        // CT_NumPr : numberingChange
     case OOXML_ELEMENT_wordprocessingml_numberingChange:
        nResult = NS_ooxml::LN_CT_NumPr_numberingChange;
        break;
        // CT_NumPr : ins
     case OOXML_ELEMENT_wordprocessingml_ins:
        nResult = NS_ooxml::LN_CT_NumPr_ins;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_NumPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_NumPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_NumPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_NumPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PBdr*/
OOXMLContext_wordprocessingml_CT_PBdr::OOXMLContext_wordprocessingml_CT_PBdr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PBdr::~OOXMLContext_wordprocessingml_CT_PBdr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PBdr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PBdr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_top:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_left:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bottom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_right:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_between:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PBdr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PBdr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PBdr : top
     case OOXML_ELEMENT_wordprocessingml_top:
        nResult = NS_sprm::LN_PBrcTop;
        break;
        // CT_PBdr : left
     case OOXML_ELEMENT_wordprocessingml_left:
        nResult = NS_sprm::LN_PBrcLeft;
        break;
        // CT_PBdr : bottom
     case OOXML_ELEMENT_wordprocessingml_bottom:
        nResult = NS_sprm::LN_PBrcBottom;
        break;
        // CT_PBdr : right
     case OOXML_ELEMENT_wordprocessingml_right:
        nResult = NS_sprm::LN_PBrcRight;
        break;
        // CT_PBdr : between
     case OOXML_ELEMENT_wordprocessingml_between:
        nResult = NS_sprm::LN_PBrcBetween;
        break;
        // CT_PBdr : bar
     case OOXML_ELEMENT_wordprocessingml_bar:
        nResult = NS_sprm::LN_PBrcBar;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PBdr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PBdr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PBdr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PBdr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Tabs*/
OOXMLContext_wordprocessingml_CT_Tabs::OOXMLContext_wordprocessingml_CT_Tabs(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Tabs::~OOXMLContext_wordprocessingml_CT_Tabs()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Tabs::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Tabs::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tab:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TabStop(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Tabs::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Tabs::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Tabs : tab
     case OOXML_ELEMENT_wordprocessingml_tab:
        nResult = NS_ooxml::LN_CT_Tabs_tab;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Tabs::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Tabs::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Tabs::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Tabs::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TextboxTightWrap*/
OOXMLContext_wordprocessingml_CT_TextboxTightWrap::OOXMLContext_wordprocessingml_CT_TextboxTightWrap(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TextboxTightWrap::~OOXMLContext_wordprocessingml_CT_TextboxTightWrap()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TextboxTightWrap::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TextboxTightWrap::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TextboxTightWrap::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TextboxTightWrap::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TextboxTightWrap::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TextboxTightWrap::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TextboxTightWrap::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TextboxTightWrap::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PPrBase*/
OOXMLContext_wordprocessingml_CT_PPrBase::OOXMLContext_wordprocessingml_CT_PPrBase(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PPrBase::~OOXMLContext_wordprocessingml_CT_PPrBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PPrBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PPrBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_pStyle:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_keepNext:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_keepLines:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pageBreakBefore:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_framePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FramePr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_widowControl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_numPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_NumPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_suppressLineNumbers:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pBdr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PBdr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_shd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Shd(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tabs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Tabs(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_suppressAutoHyphens:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_kinsoku:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_wordWrap:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_overflowPunct:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_topLinePunct:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_autoSpaceDE:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_autoSpaceDN:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bidi:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_adjustRightInd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_snapToGrid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_spacing:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Spacing(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ind:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Ind(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_contextualSpacing:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_mirrorIndents:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_suppressOverlap:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_jc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Jc(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextDirection(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textAlignment:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextAlignment(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textboxTightWrap:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextboxTightWrap(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_outlineLvl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_divId:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cnfStyle:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Cnf(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PPrBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PPrBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PPrBase : pStyle
     case OOXML_ELEMENT_wordprocessingml_pStyle:
        nResult = NS_ooxml::LN_CT_PPrBase_pStyle;
        break;
        // CT_PPrBase : keepNext
     case OOXML_ELEMENT_wordprocessingml_keepNext:
        nResult = NS_sprm::LN_PFKeepFollow;
        break;
        // CT_PPrBase : keepLines
     case OOXML_ELEMENT_wordprocessingml_keepLines:
        nResult = NS_sprm::LN_PFKeep;
        break;
        // CT_PPrBase : pageBreakBefore
     case OOXML_ELEMENT_wordprocessingml_pageBreakBefore:
        nResult = NS_sprm::LN_PFPageBreakBefore;
        break;
        // CT_PPrBase : framePr
     case OOXML_ELEMENT_wordprocessingml_framePr:
        nResult = NS_ooxml::LN_CT_PPrBase_framePr;
        break;
        // CT_PPrBase : widowControl
     case OOXML_ELEMENT_wordprocessingml_widowControl:
        nResult = NS_ooxml::LN_CT_PPrBase_windowControl;
        break;
        // CT_PPrBase : numPr
     case OOXML_ELEMENT_wordprocessingml_numPr:
        nResult = NS_ooxml::LN_CT_PPrBase_numPr;
        break;
        // CT_PPrBase : suppressLineNumbers
     case OOXML_ELEMENT_wordprocessingml_suppressLineNumbers:
        nResult = NS_sprm::LN_PFNoLineNumb;
        break;
        // CT_PPrBase : pBdr
     case OOXML_ELEMENT_wordprocessingml_pBdr:
        nResult = NS_ooxml::LN_CT_PrBase_pBdr;
        break;
        // CT_PPrBase : shd
     case OOXML_ELEMENT_wordprocessingml_shd:
        nResult = NS_sprm::LN_PShd;
        break;
        // CT_PPrBase : tabs
     case OOXML_ELEMENT_wordprocessingml_tabs:
        nResult = NS_ooxml::LN_CT_PPrBase_tabs;
        break;
        // CT_PPrBase : suppressAutoHyphens
     case OOXML_ELEMENT_wordprocessingml_suppressAutoHyphens:
        nResult = NS_sprm::LN_PFNoAutoHyph;
        break;
        // CT_PPrBase : kinsoku
     case OOXML_ELEMENT_wordprocessingml_kinsoku:
        nResult = NS_ooxml::LN_CT_PPrBase_kinsoku;
        break;
        // CT_PPrBase : wordWrap
     case OOXML_ELEMENT_wordprocessingml_wordWrap:
        nResult = NS_ooxml::LN_CT_PPrBase_wordWrap;
        break;
        // CT_PPrBase : overflowPunct
     case OOXML_ELEMENT_wordprocessingml_overflowPunct:
        nResult = NS_sprm::LN_PFOverflowPunct;
        break;
        // CT_PPrBase : topLinePunct
     case OOXML_ELEMENT_wordprocessingml_topLinePunct:
        nResult = NS_sprm::LN_PFTopLinePunct;
        break;
        // CT_PPrBase : autoSpaceDE
     case OOXML_ELEMENT_wordprocessingml_autoSpaceDE:
        nResult = NS_sprm::LN_PFAutoSpaceDE;
        break;
        // CT_PPrBase : autoSpaceDN
     case OOXML_ELEMENT_wordprocessingml_autoSpaceDN:
        nResult = NS_sprm::LN_PFAutoSpaceDN;
        break;
        // CT_PPrBase : bidi
     case OOXML_ELEMENT_wordprocessingml_bidi:
        nResult = NS_sprm::LN_PFBiDi;
        break;
        // CT_PPrBase : adjustRightInd
     case OOXML_ELEMENT_wordprocessingml_adjustRightInd:
        nResult = NS_ooxml::LN_CT_PPrBase_adjustRightInd;
        break;
        // CT_PPrBase : snapToGrid
     case OOXML_ELEMENT_wordprocessingml_snapToGrid:
        nResult = NS_ooxml::LN_CT_PPrBase_snapToGrid;
        break;
        // CT_PPrBase : spacing
     case OOXML_ELEMENT_wordprocessingml_spacing:
        nResult = NS_ooxml::LN_CT_PPrBase_spacing;
        break;
        // CT_PPrBase : ind
     case OOXML_ELEMENT_wordprocessingml_ind:
        nResult = NS_ooxml::LN_CT_PPrBase_ind;
        break;
        // CT_PPrBase : contextualSpacing
     case OOXML_ELEMENT_wordprocessingml_contextualSpacing:
        nResult = 0x246d;
        break;
        // CT_PPrBase : mirrorIndents
     case OOXML_ELEMENT_wordprocessingml_mirrorIndents:
        nResult = 0x2470;
        break;
        // CT_PPrBase : suppressOverlap
     case OOXML_ELEMENT_wordprocessingml_suppressOverlap:
        nResult = 0x2462;
        break;
        // CT_PPrBase : jc
     case OOXML_ELEMENT_wordprocessingml_jc:
        nResult = NS_sprm::LN_PJc;
        break;
        // CT_PPrBase : textDirection
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        nResult = NS_sprm::LN_PFrameTextFlow;
        break;
        // CT_PPrBase : textAlignment
     case OOXML_ELEMENT_wordprocessingml_textAlignment:
        nResult = NS_sprm::LN_PWAlignFont;
        break;
        // CT_PPrBase : textboxTightWrap
     case OOXML_ELEMENT_wordprocessingml_textboxTightWrap:
        nResult = NS_sprm::LN_PTightWrap;
        break;
        // CT_PPrBase : outlineLvl
     case OOXML_ELEMENT_wordprocessingml_outlineLvl:
        nResult = NS_sprm::LN_POutLvl;
        break;
        // CT_PPrBase : divId
     case OOXML_ELEMENT_wordprocessingml_divId:
        nResult = NS_ooxml::LN_CT_PPrBase_divId;
        break;
        // CT_PPrBase : cnfStyle
     case OOXML_ELEMENT_wordprocessingml_cnfStyle:
        nResult = NS_ooxml::LN_CT_PPrBase_cnfStyle;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PPrBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PPrBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PPrBase::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PPrBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PPr*/
OOXMLContext_wordprocessingml_CT_PPr::OOXMLContext_wordprocessingml_CT_PPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PPr::~OOXMLContext_wordprocessingml_CT_PPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_ParaRPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sectPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SectPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pPrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PPr::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_PPrBase(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PPr : rPr
     case OOXML_ELEMENT_wordprocessingml_rPr:
        nResult = NS_ooxml::LN_CT_PPr_rPr;
        break;
        // CT_PPr : sectPr
     case OOXML_ELEMENT_wordprocessingml_sectPr:
        nResult = NS_ooxml::LN_CT_PPr_sectPr;
        break;
        // CT_PPr : pPrChange
     case OOXML_ELEMENT_wordprocessingml_pPrChange:
        nResult = NS_ooxml::LN_CT_PPr_pPrChange;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Control*/
OOXMLContext_wordprocessingml_CT_Control::OOXMLContext_wordprocessingml_CT_Control(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Control::~OOXMLContext_wordprocessingml_CT_Control()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Control::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Control::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Control::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Control::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Control::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Control::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Control::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Control::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Background*/
OOXMLContext_wordprocessingml_CT_Background::OOXMLContext_wordprocessingml_CT_Background(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Background::~OOXMLContext_wordprocessingml_CT_Background()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Background::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Background::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Background::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Background::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Background::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Background::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Background::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Background::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Rel*/
OOXMLContext_wordprocessingml_CT_Rel::OOXMLContext_wordprocessingml_CT_Rel(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Rel::~OOXMLContext_wordprocessingml_CT_Rel()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Rel::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Rel::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Rel::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_relationships_id:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Rel::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Rel : r:id
     case OOXML_ATTRIBUTE_relationships_id:
        nResult = NS_ooxml::LN_CT_Rel_id;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Rel::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Rel::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Rel::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Rel::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PictureBase*/
OOXMLContext_wordprocessingml_CT_PictureBase::OOXMLContext_wordprocessingml_CT_PictureBase(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PictureBase::~OOXMLContext_wordprocessingml_CT_PictureBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PictureBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PictureBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PictureBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PictureBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PictureBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PictureBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PictureBase::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PictureBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Object*/
OOXMLContext_wordprocessingml_CT_Object::OOXMLContext_wordprocessingml_CT_Object(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Object::~OOXMLContext_wordprocessingml_CT_Object()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Object::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Object::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_control:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Control(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Object::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Object::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Object::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Object::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Object::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Object::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Picture*/
OOXMLContext_wordprocessingml_CT_Picture::OOXMLContext_wordprocessingml_CT_Picture(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Picture::~OOXMLContext_wordprocessingml_CT_Picture()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Picture::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Picture::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_movie:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Rel(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_control:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Control(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Picture::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Picture::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Picture::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_PictureBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Picture::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Picture::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Picture::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Drawing*/
OOXMLContext_wordprocessingml_CT_Drawing::OOXMLContext_wordprocessingml_CT_Drawing(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Drawing::~OOXMLContext_wordprocessingml_CT_Drawing()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Drawing::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_anchor(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_inline(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Drawing::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Drawing::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Drawing::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Drawing::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_anchor(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingDrawing_inline(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Drawing::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Drawing::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Drawing::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SimpleField*/
OOXMLContext_wordprocessingml_CT_SimpleField::OOXMLContext_wordprocessingml_CT_SimpleField(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SimpleField::~OOXMLContext_wordprocessingml_CT_SimpleField()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SimpleField::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SimpleField::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_fldData:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SimpleField::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SimpleField::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SimpleField::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SimpleField::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SimpleField::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SimpleField::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFTextType*/
OOXMLContext_wordprocessingml_CT_FFTextType::OOXMLContext_wordprocessingml_CT_FFTextType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFTextType::~OOXMLContext_wordprocessingml_CT_FFTextType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFTextType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFTextType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFTextType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFTextType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFTextType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFTextType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFTextType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFTextType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFName*/
OOXMLContext_wordprocessingml_CT_FFName::OOXMLContext_wordprocessingml_CT_FFName(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFName::~OOXMLContext_wordprocessingml_CT_FFName()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFName::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFName::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFName::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFName::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFName::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFName::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFName::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFName::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FldChar*/
OOXMLContext_wordprocessingml_CT_FldChar::OOXMLContext_wordprocessingml_CT_FldChar(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FldChar::~OOXMLContext_wordprocessingml_CT_FldChar()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FldChar::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FldChar::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_fldData:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ffData:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFData(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_numberingChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChangeNumbering(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FldChar::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FldChar::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FldChar::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FldChar::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FldChar::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FldChar::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Hyperlink*/
OOXMLContext_wordprocessingml_CT_Hyperlink::OOXMLContext_wordprocessingml_CT_Hyperlink(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Hyperlink::~OOXMLContext_wordprocessingml_CT_Hyperlink()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Hyperlink::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Hyperlink::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Hyperlink::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Hyperlink::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Hyperlink::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Hyperlink::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Hyperlink::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Hyperlink::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFData*/
OOXMLContext_wordprocessingml_CT_FFData::OOXMLContext_wordprocessingml_CT_FFData(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFData::~OOXMLContext_wordprocessingml_CT_FFData()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFData::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFData::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_name:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFName(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_enabled:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_calcOnExit:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_entryMacro:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MacroName(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_exitMacro:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_MacroName(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_helpText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFHelpText(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_statusText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFStatusText(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_checkBox:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFCheckBox(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ddList:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFDDList(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textInput:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFTextInput(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFData::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFData::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFData::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFData::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFData::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFData::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFHelpText*/
OOXMLContext_wordprocessingml_CT_FFHelpText::OOXMLContext_wordprocessingml_CT_FFHelpText(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFHelpText::~OOXMLContext_wordprocessingml_CT_FFHelpText()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFHelpText::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFHelpText::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFHelpText::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFHelpText::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFHelpText::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFHelpText::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFHelpText::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFHelpText::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFStatusText*/
OOXMLContext_wordprocessingml_CT_FFStatusText::OOXMLContext_wordprocessingml_CT_FFStatusText(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFStatusText::~OOXMLContext_wordprocessingml_CT_FFStatusText()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFStatusText::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFStatusText::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFStatusText::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFStatusText::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFStatusText::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFStatusText::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFStatusText::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFStatusText::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFCheckBox*/
OOXMLContext_wordprocessingml_CT_FFCheckBox::OOXMLContext_wordprocessingml_CT_FFCheckBox(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFCheckBox::~OOXMLContext_wordprocessingml_CT_FFCheckBox()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFCheckBox::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFCheckBox::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_size:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sizeAuto:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_default:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_checked:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFCheckBox::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFCheckBox::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFCheckBox::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFCheckBox::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFCheckBox::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFCheckBox::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFDDList*/
OOXMLContext_wordprocessingml_CT_FFDDList::OOXMLContext_wordprocessingml_CT_FFDDList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFDDList::~OOXMLContext_wordprocessingml_CT_FFDDList()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFDDList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFDDList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_result:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_default:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_listEntry:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFDDList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFDDList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFDDList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFDDList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFDDList::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFDDList::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FFTextInput*/
OOXMLContext_wordprocessingml_CT_FFTextInput::OOXMLContext_wordprocessingml_CT_FFTextInput(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FFTextInput::~OOXMLContext_wordprocessingml_CT_FFTextInput()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FFTextInput::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FFTextInput::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_type:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FFTextType(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_default:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_maxLength:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_format:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FFTextInput::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FFTextInput::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FFTextInput::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FFTextInput::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FFTextInput::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FFTextInput::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SectType*/
OOXMLContext_wordprocessingml_CT_SectType::OOXMLContext_wordprocessingml_CT_SectType(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SectType::~OOXMLContext_wordprocessingml_CT_SectType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SectType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SectType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SectType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_SectionMark(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SectType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SectType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SectType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SectType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SectType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PaperSource*/
OOXMLContext_wordprocessingml_CT_PaperSource::OOXMLContext_wordprocessingml_CT_PaperSource(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PaperSource::~OOXMLContext_wordprocessingml_CT_PaperSource()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PaperSource::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PaperSource::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PaperSource::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PaperSource::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PaperSource::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PaperSource::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PaperSource::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PaperSource::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PageSz*/
OOXMLContext_wordprocessingml_CT_PageSz::OOXMLContext_wordprocessingml_CT_PageSz(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PageSz::~OOXMLContext_wordprocessingml_CT_PageSz()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PageSz::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PageSz::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PageSz::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_h:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_orient:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_PageOrientation(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_code:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PageSz::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PageSz : w
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        nResult = NS_ooxml::LN_CT_PageSz_w;
        break;
        // CT_PageSz : h
     case OOXML_ATTRIBUTE_wordprocessingml_h:
        nResult = NS_ooxml::LN_CT_PageSz_h;
        break;
        // CT_PageSz : orient
     case OOXML_ATTRIBUTE_wordprocessingml_orient:
        nResult = NS_ooxml::LN_CT_PageSz_orient;
        break;
        // CT_PageSz : code
     case OOXML_ATTRIBUTE_wordprocessingml_code:
        nResult = NS_ooxml::LN_CT_PageSz_code;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PageSz::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PageSz::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PageSz::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PageSz::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PageMar*/
OOXMLContext_wordprocessingml_CT_PageMar::OOXMLContext_wordprocessingml_CT_PageMar(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PageMar::~OOXMLContext_wordprocessingml_CT_PageMar()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PageMar::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PageMar::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PageMar::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_top:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_right:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_bottom:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_SignedTwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_left:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_header:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_footer:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_gutter:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PageMar::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PageMar : top
     case OOXML_ATTRIBUTE_wordprocessingml_top:
        nResult = NS_ooxml::LN_CT_PageMar_top;
        break;
        // CT_PageMar : right
     case OOXML_ATTRIBUTE_wordprocessingml_right:
        nResult = NS_ooxml::LN_CT_PageMar_right;
        break;
        // CT_PageMar : bottom
     case OOXML_ATTRIBUTE_wordprocessingml_bottom:
        nResult = NS_ooxml::LN_CT_PageMar_bottom;
        break;
        // CT_PageMar : left
     case OOXML_ATTRIBUTE_wordprocessingml_left:
        nResult = NS_ooxml::LN_CT_PageMar_left;
        break;
        // CT_PageMar : header
     case OOXML_ATTRIBUTE_wordprocessingml_header:
        nResult = NS_ooxml::LN_CT_PageMar_header;
        break;
        // CT_PageMar : footer
     case OOXML_ATTRIBUTE_wordprocessingml_footer:
        nResult = NS_ooxml::LN_CT_PageMar_footer;
        break;
        // CT_PageMar : gutter
     case OOXML_ATTRIBUTE_wordprocessingml_gutter:
        nResult = NS_ooxml::LN_CT_PageMar_gutter;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PageMar::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PageMar::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PageMar::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PageMar::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PageBorders*/
OOXMLContext_wordprocessingml_CT_PageBorders::OOXMLContext_wordprocessingml_CT_PageBorders(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PageBorders::~OOXMLContext_wordprocessingml_CT_PageBorders()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PageBorders::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PageBorders::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_top:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_left:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bottom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_right:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PageBorders::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PageBorders::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PageBorders::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PageBorders::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PageBorders::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PageBorders::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_LineNumber*/
OOXMLContext_wordprocessingml_CT_LineNumber::OOXMLContext_wordprocessingml_CT_LineNumber(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_LineNumber::~OOXMLContext_wordprocessingml_CT_LineNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_LineNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_LineNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_LineNumber::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_countBy:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_start:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_distance:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_restart:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_LineNumberRestart(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_LineNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_LineNumber : countBy
     case OOXML_ATTRIBUTE_wordprocessingml_countBy:
        nResult = NS_ooxml::LN_CT_LineNumber_countBy;
        break;
        // CT_LineNumber : start
     case OOXML_ATTRIBUTE_wordprocessingml_start:
        nResult = NS_ooxml::LN_CT_LineNumber_start;
        break;
        // CT_LineNumber : distance
     case OOXML_ATTRIBUTE_wordprocessingml_distance:
        nResult = NS_ooxml::LN_CT_LineNumber_distance;
        break;
        // CT_LineNumber : restart
     case OOXML_ATTRIBUTE_wordprocessingml_restart:
        nResult = NS_ooxml::LN_CT_LineNumber_restart;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_LineNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_LineNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_LineNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_LineNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PageNumber*/
OOXMLContext_wordprocessingml_CT_PageNumber::OOXMLContext_wordprocessingml_CT_PageNumber(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PageNumber::~OOXMLContext_wordprocessingml_CT_PageNumber()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PageNumber::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PageNumber::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PageNumber::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_fmt:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_NumberFormat(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_start:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_chapStyle:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_chapSep:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ChapterSep(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PageNumber::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PageNumber : fmt
     case OOXML_ATTRIBUTE_wordprocessingml_fmt:
        nResult = NS_ooxml::LN_CT_PageNumber_fmt;
        break;
        // CT_PageNumber : start
     case OOXML_ATTRIBUTE_wordprocessingml_start:
        nResult = NS_ooxml::LN_CT_PageNumber_start;
        break;
        // CT_PageNumber : chapStyle
     case OOXML_ATTRIBUTE_wordprocessingml_chapStyle:
        nResult = NS_ooxml::LN_CT_PageNumber_chapStyle;
        break;
        // CT_PageNumber : chapSep
     case OOXML_ATTRIBUTE_wordprocessingml_chapSep:
        nResult = NS_ooxml::LN_CT_PageNumber_chapSep;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PageNumber::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PageNumber::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PageNumber::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PageNumber::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Column*/
OOXMLContext_wordprocessingml_CT_Column::OOXMLContext_wordprocessingml_CT_Column(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Column::~OOXMLContext_wordprocessingml_CT_Column()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Column::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Column::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Column::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Column::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Column : space
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        nResult = NS_ooxml::LN_CT_Column_space;
        break;
        // CT_Column : w
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        nResult = NS_ooxml::LN_CT_Column_w;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Column::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Column::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Column::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Column::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Columns*/
OOXMLContext_wordprocessingml_CT_Columns::OOXMLContext_wordprocessingml_CT_Columns(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Columns::~OOXMLContext_wordprocessingml_CT_Columns()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Columns::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Columns::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_col:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Column(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Columns::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_equalWidth:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TwipsMeasure(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_num:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_sep:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_OnOff(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Columns::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Columns : equalWidth
     case OOXML_ATTRIBUTE_wordprocessingml_equalWidth:
        nResult = NS_ooxml::LN_CT_Columns_equalWidth;
        break;
        // CT_Columns : space
     case OOXML_ATTRIBUTE_wordprocessingml_space:
        nResult = NS_ooxml::LN_CT_Columns_space;
        break;
        // CT_Columns : num
     case OOXML_ATTRIBUTE_wordprocessingml_num:
        nResult = NS_ooxml::LN_CT_Columns_num;
        break;
        // CT_Columns : sep
     case OOXML_ATTRIBUTE_wordprocessingml_sep:
        nResult = NS_ooxml::LN_CT_Columns_sep;
        break;
        // CT_Columns : col
     case OOXML_ELEMENT_wordprocessingml_col:
        nResult = NS_ooxml::LN_CT_Columns_col;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Columns::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Columns::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Columns::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Columns::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_VerticalJc*/
OOXMLContext_wordprocessingml_CT_VerticalJc::OOXMLContext_wordprocessingml_CT_VerticalJc(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_VerticalJc::~OOXMLContext_wordprocessingml_CT_VerticalJc()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_VerticalJc::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_VerticalJc::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_VerticalJc::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_VerticalJc(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_VerticalJc::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_VerticalJc::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_VerticalJc::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_VerticalJc::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_VerticalJc::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_DocGrid*/
OOXMLContext_wordprocessingml_CT_DocGrid::OOXMLContext_wordprocessingml_CT_DocGrid(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_DocGrid::~OOXMLContext_wordprocessingml_CT_DocGrid()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_DocGrid::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_DocGrid::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_DocGrid::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_DocGrid::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_DocGrid::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_DocGrid::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_DocGrid::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_DocGrid::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_HdrFtrRef*/
OOXMLContext_wordprocessingml_CT_HdrFtrRef::OOXMLContext_wordprocessingml_CT_HdrFtrRef(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_HdrFtrRef::~OOXMLContext_wordprocessingml_CT_HdrFtrRef()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_HdrFtrRef::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Rel(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_HdrFtrRef::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_HdrFtrRef::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_HdrFtr(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_relationships_id:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Rel(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_HdrFtrRef::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_HdrFtrRef : type
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        nResult = NS_ooxml::LN_CT_HdrFtrRef_type;
        break;
        // CT_HdrFtrRef : r:id
     case OOXML_ATTRIBUTE_relationships_id:
        nResult = NS_ooxml::LN_CT_HdrFtrRef_id;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_HdrFtrRef::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Rel(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_HdrFtrRef::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_HdrFtrRef::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_HdrFtrRef::endAction()
{
    switch (meToken)
    {
    case OOXML_ELEMENT_wordprocessingml_footerReference:
        {
            OOXMLFooterHandler aFooterHandler(this);
            mpPropertySet->resolve(aFooterHandler);
        }
        break;
    case OOXML_ELEMENT_wordprocessingml_headerReference:
        {
            OOXMLHeaderHandler aHeaderHandler(this);
            mpPropertySet->resolve(aHeaderHandler);
        }
        break;
    default:
        break;
    }
}
/* 
    class: OOXMLContext_wordprocessingml_EG_HdrFtrReferences*/
OOXMLContext_wordprocessingml_EG_HdrFtrReferences::OOXMLContext_wordprocessingml_EG_HdrFtrReferences(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_EG_HdrFtrReferences::~OOXMLContext_wordprocessingml_EG_HdrFtrReferences()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_HdrFtrReferences::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_HdrFtrReferences::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_headerReference:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HdrFtrRef(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_footerReference:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HdrFtrRef(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_HdrFtrReferences::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_HdrFtrReferences::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // EG_HdrFtrReferences : headerReference
     case OOXML_ELEMENT_wordprocessingml_headerReference:
        nResult = NS_ooxml::LN_EG_HdrFtrReferences_headerReference;
        break;
        // EG_HdrFtrReferences : footerReference
     case OOXML_ELEMENT_wordprocessingml_footerReference:
        nResult = NS_ooxml::LN_EG_HdrFtrReferences_footerReference;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_HdrFtrReferences::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_HdrFtrReferences::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_HdrFtrReferences::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_HdrFtrReferences::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_HdrFtr*/
OOXMLContext_wordprocessingml_CT_HdrFtr::OOXMLContext_wordprocessingml_CT_HdrFtr(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_HdrFtr::~OOXMLContext_wordprocessingml_CT_HdrFtr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_HdrFtr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_BlockLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_HdrFtr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_HdrFtr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_HdrFtr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_HdrFtr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_BlockLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_HdrFtr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_HdrFtr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_HdrFtr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_SectPrContents*/
OOXMLContext_wordprocessingml_EG_SectPrContents::OOXMLContext_wordprocessingml_EG_SectPrContents(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_EG_SectPrContents::~OOXMLContext_wordprocessingml_EG_SectPrContents()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_SectPrContents::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_SectPrContents::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_footnotePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnProps(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_endnotePr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_EdnProps(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_type:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SectType(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pgSz:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PageSz(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pgMar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PageMar(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_paperSrc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PaperSource(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pgBorders:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PageBorders(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lnNumType:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_LineNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pgNumType:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PageNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cols:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Columns(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_formProt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_vAlign:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_VerticalJc(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_noEndnote:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_titlePg:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextDirection(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bidi:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_rtlGutter:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_docGrid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DocGrid(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_printerSettings:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Rel(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_SectPrContents::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_SectPrContents::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // EG_SectPrContents : bidi
     case OOXML_ELEMENT_wordprocessingml_bidi:
        nResult = NS_ooxml::LN_EG_SectPrContents_bidi;
        break;
        // EG_SectPrContents : cols
     case OOXML_ELEMENT_wordprocessingml_cols:
        nResult = NS_ooxml::LN_EG_SectPrContents_cols;
        break;
        // EG_SectPrContents : docGrid
     case OOXML_ELEMENT_wordprocessingml_docGrid:
        nResult = NS_ooxml::LN_EG_SectPrContents_docGrid;
        break;
        // EG_SectPrContents : endnotePr
     case OOXML_ELEMENT_wordprocessingml_endnotePr:
        nResult = NS_ooxml::LN_EG_SectPrContents_endnotePr;
        break;
        // EG_SectPrContents : footnotePr
     case OOXML_ELEMENT_wordprocessingml_footnotePr:
        nResult = NS_ooxml::LN_EG_SectPrContents_footnotePr;
        break;
        // EG_SectPrContents : formProt
     case OOXML_ELEMENT_wordprocessingml_formProt:
        nResult = NS_ooxml::LN_EG_SectPrContents_formProt;
        break;
        // EG_SectPrContents : lnNumType
     case OOXML_ELEMENT_wordprocessingml_lnNumType:
        nResult = NS_ooxml::LN_EG_SectPrContents_lnNumType;
        break;
        // EG_SectPrContents : noEndnote
     case OOXML_ELEMENT_wordprocessingml_noEndnote:
        nResult = NS_ooxml::LN_EG_SectPrContents_noEndnote;
        break;
        // EG_SectPrContents : paperSrc
     case OOXML_ELEMENT_wordprocessingml_paperSrc:
        nResult = NS_ooxml::LN_EG_SectPrContents_paperSrc;
        break;
        // EG_SectPrContents : pgBorders
     case OOXML_ELEMENT_wordprocessingml_pgBorders:
        nResult = NS_ooxml::LN_EG_SectPrContents_pgBorders;
        break;
        // EG_SectPrContents : pgMar
     case OOXML_ELEMENT_wordprocessingml_pgMar:
        nResult = NS_ooxml::LN_EG_SectPrContents_pgMar;
        break;
        // EG_SectPrContents : pgNumType
     case OOXML_ELEMENT_wordprocessingml_pgNumType:
        nResult = NS_ooxml::LN_EG_SectPrContents_pgNumType;
        break;
        // EG_SectPrContents : pgSz
     case OOXML_ELEMENT_wordprocessingml_pgSz:
        nResult = NS_ooxml::LN_EG_SectPrContents_pgSz;
        break;
        // EG_SectPrContents : printerSettings
     case OOXML_ELEMENT_wordprocessingml_printerSettings:
        nResult = NS_ooxml::LN_EG_SectPrContents_printerSettings;
        break;
        // EG_SectPrContents : rtlGutter
     case OOXML_ELEMENT_wordprocessingml_rtlGutter:
        nResult = NS_ooxml::LN_EG_SectPrContents_rtlGutter;
        break;
        // EG_SectPrContents : textDirection
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        nResult = NS_ooxml::LN_EG_SectPrContents_textDirection;
        break;
        // EG_SectPrContents : titlePg
     case OOXML_ELEMENT_wordprocessingml_titlePg:
        nResult = NS_ooxml::LN_EG_SectPrContents_titlePg;
        break;
        // EG_SectPrContents : type
     case OOXML_ELEMENT_wordprocessingml_type:
        nResult = NS_sprm::LN_SBkc;
        break;
        // EG_SectPrContents : vAlign
     case OOXML_ELEMENT_wordprocessingml_vAlign:
        nResult = NS_ooxml::LN_EG_SectPrContents_vAlign;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_SectPrContents::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_SectPrContents::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_SectPrContents::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_SectPrContents::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SectPrBase*/
OOXMLContext_wordprocessingml_CT_SectPrBase::OOXMLContext_wordprocessingml_CT_SectPrBase(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SectPrBase::~OOXMLContext_wordprocessingml_CT_SectPrBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SectPrBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_SectPrContents(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SectPrBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SectPrBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SectPrBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SectPrBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_SectPrContents(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SectPrBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SectPrBase::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SectPrBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SectPr*/
OOXMLContext_wordprocessingml_CT_SectPr::OOXMLContext_wordprocessingml_CT_SectPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SectPr::~OOXMLContext_wordprocessingml_CT_SectPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SectPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_HdrFtrReferences(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_SectPrContents(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SectPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sectPrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SectPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SectPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SectPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_SectPr : sectPrChange
     case OOXML_ELEMENT_wordprocessingml_sectPrChange:
        nResult = NS_ooxml::LN_CT_SectPr_sectPrChange;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SectPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_HdrFtrReferences(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_SectPrContents(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SectPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SectPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SectPr::endAction()
{
    setLastParagraphInSection();
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Br*/
OOXMLContext_wordprocessingml_CT_Br::OOXMLContext_wordprocessingml_CT_Br(const OOXMLContext & rContext)
: OOXMLContextSingleElement(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Br::~OOXMLContext_wordprocessingml_CT_Br()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Br::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Br::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Br::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_BrType(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_clear:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_BrClear(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Br::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Br : type
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        nResult = NS_ooxml::LN_CT_Br_type;
        break;
        // CT_Br : clear
     case OOXML_ATTRIBUTE_wordprocessingml_clear:
        nResult = NS_ooxml::LN_CT_Br_clear;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Br::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Br::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextSingleElement::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Br::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Br::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PTab*/
OOXMLContext_wordprocessingml_CT_PTab::OOXMLContext_wordprocessingml_CT_PTab(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PTab::~OOXMLContext_wordprocessingml_CT_PTab()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PTab::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PTab::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PTab::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_alignment:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_PTabAlignment(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_relativeTo:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_PTabRelativeTo(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_leader:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_PTabLeader(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PTab::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_PTab : alignment
     case OOXML_ATTRIBUTE_wordprocessingml_alignment:
        nResult = NS_ooxml::LN_CT_PTab_alignment;
        break;
        // CT_PTab : relativeTo
     case OOXML_ATTRIBUTE_wordprocessingml_relativeTo:
        nResult = NS_ooxml::LN_CT_PTab_relativeTo;
        break;
        // CT_PTab : leader
     case OOXML_ATTRIBUTE_wordprocessingml_leader:
        nResult = NS_ooxml::LN_CT_PTab_leader;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PTab::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PTab::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PTab::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PTab::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Sym*/
OOXMLContext_wordprocessingml_CT_Sym::OOXMLContext_wordprocessingml_CT_Sym(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Sym::~OOXMLContext_wordprocessingml_CT_Sym()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Sym::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Sym::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Sym::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_font:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_char:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_ShortHexNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Sym::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Sym : font
     case OOXML_ATTRIBUTE_wordprocessingml_font:
        nResult = NS_ooxml::LN_CT_Sym_font;
        break;
        // CT_Sym : char
     case OOXML_ATTRIBUTE_wordprocessingml_char:
        nResult = NS_ooxml::LN_CT_Sym_char;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Sym::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Sym::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Sym::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Sym::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_ProofErr*/
OOXMLContext_wordprocessingml_CT_ProofErr::OOXMLContext_wordprocessingml_CT_ProofErr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_ProofErr::~OOXMLContext_wordprocessingml_CT_ProofErr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_ProofErr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_ProofErr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_ProofErr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_ProofErr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_ProofErr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_ProofErr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_ProofErr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_ProofErr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Perm*/
OOXMLContext_wordprocessingml_CT_Perm::OOXMLContext_wordprocessingml_CT_Perm(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Perm::~OOXMLContext_wordprocessingml_CT_Perm()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Perm::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Perm::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Perm::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Perm::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Perm::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Perm::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Perm::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Perm::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PermStart*/
OOXMLContext_wordprocessingml_CT_PermStart::OOXMLContext_wordprocessingml_CT_PermStart(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PermStart::~OOXMLContext_wordprocessingml_CT_PermStart()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PermStart::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Perm(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PermStart::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PermStart::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContext::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_Perm(*this));
        pRefContext->setParentResource(getResource());
        
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PermStart::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PermStart::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_Perm(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PermStart::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PermStart::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PermStart::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Text*/
OOXMLContext_wordprocessingml_CT_Text::OOXMLContext_wordprocessingml_CT_Text(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Text::~OOXMLContext_wordprocessingml_CT_Text()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Text::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Text::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Text::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Text::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Text::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Text::lcl_characters(const rtl::OUString & sText) 
{

    mrStream.utext(reinterpret_cast < const sal_uInt8 * > 
                   (sText.getStr()), 
                   sText.getLength());
}
void OOXMLContext_wordprocessingml_CT_Text::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Text::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FtnEdnRefChar*/
OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::OOXMLContext_wordprocessingml_CT_FtnEdnRefChar(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::~OOXMLContext_wordprocessingml_CT_FtnEdnRefChar()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FtnEdnRefChar::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sFtnEdnRef, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FtnEdnSep*/
OOXMLContext_wordprocessingml_CT_FtnEdnSep::OOXMLContext_wordprocessingml_CT_FtnEdnSep(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FtnEdnSep::~OOXMLContext_wordprocessingml_CT_FtnEdnSep()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FtnEdnSep::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FtnEdnSep::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FtnEdnSep::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FtnEdnSep::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FtnEdnSep::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FtnEdnSep::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FtnEdnSep::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FtnEdnSep::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sFtnEdnSep, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_FtnEdnCont*/
OOXMLContext_wordprocessingml_CT_FtnEdnCont::OOXMLContext_wordprocessingml_CT_FtnEdnCont(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_FtnEdnCont::~OOXMLContext_wordprocessingml_CT_FtnEdnCont()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_FtnEdnCont::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_FtnEdnCont::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_FtnEdnCont::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_FtnEdnCont::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_FtnEdnCont::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_FtnEdnCont::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_FtnEdnCont::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_FtnEdnCont::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sFtnEdnCont, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_PgNum*/
OOXMLContext_wordprocessingml_CT_PgNum::OOXMLContext_wordprocessingml_CT_PgNum(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_PgNum::~OOXMLContext_wordprocessingml_CT_PgNum()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_PgNum::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_PgNum::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_PgNum::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_PgNum::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_PgNum::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_PgNum::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_PgNum::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_PgNum::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sPgNum, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Cr*/
OOXMLContext_wordprocessingml_CT_Cr::OOXMLContext_wordprocessingml_CT_Cr(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Cr::~OOXMLContext_wordprocessingml_CT_Cr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Cr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Cr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Cr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Cr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Cr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Cr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Cr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Cr::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sCR, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Tab*/
OOXMLContext_wordprocessingml_CT_Tab::OOXMLContext_wordprocessingml_CT_Tab(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Tab::~OOXMLContext_wordprocessingml_CT_Tab()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Tab::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Tab::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Tab::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Tab::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Tab::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Tab::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Tab::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Tab::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sTab, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RunInnerContent*/
OOXMLContext_wordprocessingml_EG_RunInnerContent::OOXMLContext_wordprocessingml_EG_RunInnerContent(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RunInnerContent::~OOXMLContext_wordprocessingml_EG_RunInnerContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RunInnerContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RunInnerContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_br:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Br(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_t:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_delText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_instrText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_delInstrText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Text(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_noBreakHyphen:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_softHyphen:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dayShort:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_monthShort:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_yearShort:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dayLong:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_monthLong:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_yearLong:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_annotationRef:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_footnoteRef:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnRefChar(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_endnoteRef:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnRefChar(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_separator:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnSep(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_continuationSeparator:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnCont(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sym:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Sym(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pgNum:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PgNum(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Cr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tab:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Tab(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_object:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Object(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_pict:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Picture(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_fldChar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FldChar(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ruby:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Ruby(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_footnoteReference:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnRef(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_endnoteReference:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FtnEdnRef(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_commentReference:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CommentRef(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_drawing:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Drawing(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_ptab:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PTab(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lastRenderedPageBreak:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RunInnerContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RunInnerContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RunInnerContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RunInnerContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RunInnerContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RunInnerContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_R*/
OOXMLContext_wordprocessingml_CT_R::OOXMLContext_wordprocessingml_CT_R(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_R::~OOXMLContext_wordprocessingml_CT_R()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_R::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunInnerContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_R::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_R::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_R::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_R::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunInnerContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_R::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_R::startAction()
{
    startCharacterGroup();
}
void OOXMLContext_wordprocessingml_CT_R::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Fonts*/
OOXMLContext_wordprocessingml_CT_Fonts::OOXMLContext_wordprocessingml_CT_Fonts(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Fonts::~OOXMLContext_wordprocessingml_CT_Fonts()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Fonts::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Fonts::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Fonts::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_hint:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Hint(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_ascii:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hAnsi:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsia:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_cs:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_String(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_asciiTheme:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Theme(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hAnsiTheme:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Theme(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsiaTheme:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Theme(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_cstheme:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_Theme(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Fonts::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Fonts : hint
     case OOXML_ATTRIBUTE_wordprocessingml_hint:
        nResult = NS_ooxml::LN_CT_Fonts_hint;
        break;
        // CT_Fonts : ascii
     case OOXML_ATTRIBUTE_wordprocessingml_ascii:
        nResult = NS_ooxml::LN_CT_Fonts_ascii;
        break;
        // CT_Fonts : hAnsi
     case OOXML_ATTRIBUTE_wordprocessingml_hAnsi:
        nResult = NS_ooxml::LN_CT_Fonts_hAnsi;
        break;
        // CT_Fonts : eastAsia
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsia:
        nResult = NS_ooxml::LN_CT_Fonts_eastAsia;
        break;
        // CT_Fonts : cs
     case OOXML_ATTRIBUTE_wordprocessingml_cs:
        nResult = NS_ooxml::LN_CT_Fonts_cs;
        break;
        // CT_Fonts : asciiTheme
     case OOXML_ATTRIBUTE_wordprocessingml_asciiTheme:
        nResult = NS_ooxml::LN_CT_Fonts_asciiTheme;
        break;
        // CT_Fonts : hAnsiTheme
     case OOXML_ATTRIBUTE_wordprocessingml_hAnsiTheme:
        nResult = NS_ooxml::LN_CT_Fonts_hAnsiTheme;
        break;
        // CT_Fonts : eastAsiaTheme
     case OOXML_ATTRIBUTE_wordprocessingml_eastAsiaTheme:
        nResult = NS_ooxml::LN_CT_Fonts_eastAsiaTheme;
        break;
        // CT_Fonts : cstheme
     case OOXML_ATTRIBUTE_wordprocessingml_cstheme:
        nResult = NS_ooxml::LN_CT_Fonts_cstheme;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Fonts::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Fonts::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Fonts::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Fonts::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RPrBase*/
OOXMLContext_wordprocessingml_EG_RPrBase::OOXMLContext_wordprocessingml_EG_RPrBase(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RPrBase::~OOXMLContext_wordprocessingml_EG_RPrBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RPrBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RPrBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rStyle:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_rFonts:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Fonts(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_b:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bCs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_i:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_iCs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_caps:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_smallCaps:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_strike:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dstrike:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_outline:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_shadow:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_emboss:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_imprint:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_noProof:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_snapToGrid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_vanish:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_webHidden:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_color:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Color(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_spacing:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SignedTwipsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_w:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextScale(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_kern:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_position:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SignedHpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sz:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_szCs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_highlight:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Highlight(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_u:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Underline(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_effect:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextEffect(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bdr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_shd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Shd(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_fitText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_FitText(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_vertAlign:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_VerticalAlignRun(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_rtl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_cs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_em:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Em(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lang:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Language(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_eastAsianLayout:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_EastAsianLayout(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_specVanish:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_oMath:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RPrBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RPrBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // EG_RPrBase : rStyle
     case OOXML_ELEMENT_wordprocessingml_rStyle:
        nResult = NS_ooxml::LN_EG_RPrBase_rStyle;
        break;
        // EG_RPrBase : rFonts
     case OOXML_ELEMENT_wordprocessingml_rFonts:
        nResult = NS_ooxml::LN_EG_RPrBase_rFonts;
        break;
        // EG_RPrBase : b
     case OOXML_ELEMENT_wordprocessingml_b:
        nResult = NS_sprm::LN_CFBold;
        break;
        // EG_RPrBase : bCs
     case OOXML_ELEMENT_wordprocessingml_bCs:
        nResult = NS_sprm::LN_CFBoldBi;
        break;
        // EG_RPrBase : i
     case OOXML_ELEMENT_wordprocessingml_i:
        nResult = NS_sprm::LN_CFItalic;
        break;
        // EG_RPrBase : iCs
     case OOXML_ELEMENT_wordprocessingml_iCs:
        nResult = NS_sprm::LN_CFItalicBi;
        break;
        // EG_RPrBase : caps
     case OOXML_ELEMENT_wordprocessingml_caps:
        nResult = NS_sprm::LN_CFCaps;
        break;
        // EG_RPrBase : smallCaps
     case OOXML_ELEMENT_wordprocessingml_smallCaps:
        nResult = NS_sprm::LN_CFSmallCaps;
        break;
        // EG_RPrBase : strike
     case OOXML_ELEMENT_wordprocessingml_strike:
        nResult = NS_sprm::LN_CFStrike;
        break;
        // EG_RPrBase : dstrike
     case OOXML_ELEMENT_wordprocessingml_dstrike:
        nResult = NS_sprm::LN_CFDStrike;
        break;
        // EG_RPrBase : outline
     case OOXML_ELEMENT_wordprocessingml_outline:
        nResult = NS_sprm::LN_CFOutline;
        break;
        // EG_RPrBase : shadow
     case OOXML_ELEMENT_wordprocessingml_shadow:
        nResult = NS_sprm::LN_CFShadow;
        break;
        // EG_RPrBase : emboss
     case OOXML_ELEMENT_wordprocessingml_emboss:
        nResult = NS_sprm::LN_CFEmboss;
        break;
        // EG_RPrBase : imprint
     case OOXML_ELEMENT_wordprocessingml_imprint:
        nResult = NS_sprm::LN_CFImprint;
        break;
        // EG_RPrBase : noProof
     case OOXML_ELEMENT_wordprocessingml_noProof:
        nResult = NS_sprm::LN_CFNoProof;
        break;
        // EG_RPrBase : snapToGrid
     case OOXML_ELEMENT_wordprocessingml_snapToGrid:
        nResult = NS_ooxml::LN_EG_RPrBase_snapToGrid;
        break;
        // EG_RPrBase : vanish
     case OOXML_ELEMENT_wordprocessingml_vanish:
        nResult = NS_sprm::LN_CFVanish;
        break;
        // EG_RPrBase : webHidden
     case OOXML_ELEMENT_wordprocessingml_webHidden:
        nResult = NS_sprm::LN_CFVanish;
        break;
        // EG_RPrBase : color
     case OOXML_ELEMENT_wordprocessingml_color:
        nResult = NS_ooxml::LN_EG_RPrBase_color;
        break;
        // EG_RPrBase : spacing
     case OOXML_ELEMENT_wordprocessingml_spacing:
        nResult = NS_sprm::LN_CDxaSpace;
        break;
        // EG_RPrBase : w
     case OOXML_ELEMENT_wordprocessingml_w:
        nResult = NS_sprm::LN_CCharScale;
        break;
        // EG_RPrBase : kern
     case OOXML_ELEMENT_wordprocessingml_kern:
        nResult = NS_sprm::LN_CHpsKern;
        break;
        // EG_RPrBase : position
     case OOXML_ELEMENT_wordprocessingml_position:
        nResult = NS_sprm::LN_CHpsPos;
        break;
        // EG_RPrBase : sz
     case OOXML_ELEMENT_wordprocessingml_sz:
        nResult = NS_sprm::LN_CHps;
        break;
        // EG_RPrBase : szCs
     case OOXML_ELEMENT_wordprocessingml_szCs:
        nResult = NS_sprm::LN_CHpsBi;
        break;
        // EG_RPrBase : highlight
     case OOXML_ELEMENT_wordprocessingml_highlight:
        nResult = NS_sprm::LN_CHighlight;
        break;
        // EG_RPrBase : u
     case OOXML_ELEMENT_wordprocessingml_u:
        nResult = NS_ooxml::LN_EG_RPrBase_u;
        break;
        // EG_RPrBase : effect
     case OOXML_ELEMENT_wordprocessingml_effect:
        nResult = NS_sprm::LN_CSfxText;
        break;
        // EG_RPrBase : bdr
     case OOXML_ELEMENT_wordprocessingml_bdr:
        nResult = NS_ooxml::LN_EG_RPrBase_bdr;
        break;
        // EG_RPrBase : shd
     case OOXML_ELEMENT_wordprocessingml_shd:
        nResult = NS_ooxml::LN_EG_RPrBase_shd;
        break;
        // EG_RPrBase : fitText
     case OOXML_ELEMENT_wordprocessingml_fitText:
        nResult = NS_ooxml::LN_EG_RPrBase_fitText;
        break;
        // EG_RPrBase : vertAlign
     case OOXML_ELEMENT_wordprocessingml_vertAlign:
        nResult = NS_ooxml::LN_EG_RPrBase_vertAlign;
        break;
        // EG_RPrBase : rtl
     case OOXML_ELEMENT_wordprocessingml_rtl:
        nResult = NS_ooxml::LN_EG_RPrBase_rtl;
        break;
        // EG_RPrBase : cs
     case OOXML_ELEMENT_wordprocessingml_cs:
        nResult = NS_sprm::LN_CComplexScript;
        break;
        // EG_RPrBase : em
     case OOXML_ELEMENT_wordprocessingml_em:
        nResult = NS_sprm::LN_CKcd;
        break;
        // EG_RPrBase : lang
     case OOXML_ELEMENT_wordprocessingml_lang:
        nResult = NS_ooxml::LN_EG_RPrBase_lang;
        break;
        // EG_RPrBase : eastAsianLayout
     case OOXML_ELEMENT_wordprocessingml_eastAsianLayout:
        nResult = NS_ooxml::LN_EG_RPrBase_eastAsianLayout;
        break;
        // EG_RPrBase : specVanish
     case OOXML_ELEMENT_wordprocessingml_specVanish:
        nResult = 0x818;
        break;
        // EG_RPrBase : oMath
     case OOXML_ELEMENT_wordprocessingml_oMath:
        nResult = NS_ooxml::LN_EG_RPrBase_oMath;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RPrBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RPrBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RPrBase::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RPrBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RPrContent*/
OOXMLContext_wordprocessingml_EG_RPrContent::OOXMLContext_wordprocessingml_EG_RPrContent(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RPrContent::~OOXMLContext_wordprocessingml_EG_RPrContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RPrContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RPrContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RPrContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RPrContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RPrContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RPrContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RPrContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RPrContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RPr*/
OOXMLContext_wordprocessingml_CT_RPr::OOXMLContext_wordprocessingml_CT_RPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RPr::~OOXMLContext_wordprocessingml_CT_RPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RPr*/
OOXMLContext_wordprocessingml_EG_RPr::OOXMLContext_wordprocessingml_EG_RPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RPr::~OOXMLContext_wordprocessingml_EG_RPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RPr::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RPrMath*/
OOXMLContext_wordprocessingml_EG_RPrMath::OOXMLContext_wordprocessingml_EG_RPrMath(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RPrMath::~OOXMLContext_wordprocessingml_EG_RPrMath()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RPrMath::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RPrMath::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_ins:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPrChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_del:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RPrMath::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RPrMath::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RPrMath::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPr(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RPrMath::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RPrMath::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RPrMath::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RPrOriginal*/
OOXMLContext_wordprocessingml_CT_RPrOriginal::OOXMLContext_wordprocessingml_CT_RPrOriginal(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RPrOriginal::~OOXMLContext_wordprocessingml_CT_RPrOriginal()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RPrOriginal::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RPrOriginal::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RPrOriginal::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RPrOriginal::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RPrOriginal::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RPrOriginal::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RPrOriginal::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RPrOriginal::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_ParaRPrOriginal*/
OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::OOXMLContext_wordprocessingml_CT_ParaRPrOriginal(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::~OOXMLContext_wordprocessingml_CT_ParaRPrOriginal()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_ParaRPrOriginal::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_ParaRPr*/
OOXMLContext_wordprocessingml_CT_ParaRPr::OOXMLContext_wordprocessingml_CT_ParaRPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_ParaRPr::~OOXMLContext_wordprocessingml_CT_ParaRPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_ParaRPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_ParaRPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_ParaRPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_ParaRPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_ParaRPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_ParaRPr : rPrChange
     case OOXML_ELEMENT_wordprocessingml_rPrChange:
        nResult = NS_ooxml::LN_CT_ParaRPr_rPrChange;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_ParaRPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_ParaRPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_ParaRPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_ParaRPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges*/
OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::~OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_ins:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_del:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveFrom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_moveTo:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TrackChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_ParaRPrTrackChanges::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_AltChunk*/
OOXMLContext_wordprocessingml_CT_AltChunk::OOXMLContext_wordprocessingml_CT_AltChunk(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_AltChunk::~OOXMLContext_wordprocessingml_CT_AltChunk()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_AltChunk::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_AltChunk::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_altChunkPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_AltChunkPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_AltChunk::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_AltChunk::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_AltChunk::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_AltChunk::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_AltChunk::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_AltChunk::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_AltChunkPr*/
OOXMLContext_wordprocessingml_CT_AltChunkPr::OOXMLContext_wordprocessingml_CT_AltChunkPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_AltChunkPr::~OOXMLContext_wordprocessingml_CT_AltChunkPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_AltChunkPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_AltChunkPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_matchSrc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_AltChunkPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_AltChunkPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_AltChunkPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_AltChunkPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_AltChunkPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_AltChunkPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RubyAlign*/
OOXMLContext_wordprocessingml_CT_RubyAlign::OOXMLContext_wordprocessingml_CT_RubyAlign(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RubyAlign::~OOXMLContext_wordprocessingml_CT_RubyAlign()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RubyAlign::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RubyAlign::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RubyAlign::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RubyAlign::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RubyAlign::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RubyAlign::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RubyAlign::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RubyAlign::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RubyPr*/
OOXMLContext_wordprocessingml_CT_RubyPr::OOXMLContext_wordprocessingml_CT_RubyPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RubyPr::~OOXMLContext_wordprocessingml_CT_RubyPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RubyPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RubyPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rubyAlign:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RubyAlign(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hps:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hpsRaise:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hpsBaseText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HpsMeasure(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Lang(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dirty:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RubyPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RubyPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RubyPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RubyPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RubyPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RubyPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_RubyContent*/
OOXMLContext_wordprocessingml_EG_RubyContent::OOXMLContext_wordprocessingml_EG_RubyContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_RubyContent::~OOXMLContext_wordprocessingml_EG_RubyContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_RubyContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_RubyContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_r:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_R(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_RubyContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_RubyContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_RubyContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_RubyContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_RubyContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_RubyContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_RubyContent*/
OOXMLContext_wordprocessingml_CT_RubyContent::OOXMLContext_wordprocessingml_CT_RubyContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_RubyContent::~OOXMLContext_wordprocessingml_CT_RubyContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_RubyContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RubyContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_RubyContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_RubyContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_RubyContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_RubyContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RubyContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_RubyContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_RubyContent::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_RubyContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Ruby*/
OOXMLContext_wordprocessingml_CT_Ruby::OOXMLContext_wordprocessingml_CT_Ruby(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Ruby::~OOXMLContext_wordprocessingml_CT_Ruby()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Ruby::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Ruby::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rubyPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RubyPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_rt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RubyContent(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_rubyBase:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RubyContent(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Ruby::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Ruby::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Ruby::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Ruby::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Ruby::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Ruby::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Lock*/
OOXMLContext_wordprocessingml_CT_Lock::OOXMLContext_wordprocessingml_CT_Lock(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Lock::~OOXMLContext_wordprocessingml_CT_Lock()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Lock::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Lock::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Lock::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Lock::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Lock::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Lock::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Lock::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Lock::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtListItem*/
OOXMLContext_wordprocessingml_CT_SdtListItem::OOXMLContext_wordprocessingml_CT_SdtListItem(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtListItem::~OOXMLContext_wordprocessingml_CT_SdtListItem()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtListItem::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtListItem::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtListItem::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtListItem::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtListItem::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtListItem::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtListItem::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtListItem::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtDateMappingType*/
OOXMLContext_wordprocessingml_CT_SdtDateMappingType::OOXMLContext_wordprocessingml_CT_SdtDateMappingType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtDateMappingType::~OOXMLContext_wordprocessingml_CT_SdtDateMappingType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtDateMappingType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtDateMappingType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtDateMappingType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtDateMappingType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtDateMappingType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtDateMappingType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtDateMappingType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtDateMappingType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CalendarType*/
OOXMLContext_wordprocessingml_CT_CalendarType::OOXMLContext_wordprocessingml_CT_CalendarType(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CalendarType::~OOXMLContext_wordprocessingml_CT_CalendarType()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CalendarType::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CalendarType::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CalendarType::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CalendarType::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CalendarType::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CalendarType::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CalendarType::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CalendarType::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtDate*/
OOXMLContext_wordprocessingml_CT_SdtDate::OOXMLContext_wordprocessingml_CT_SdtDate(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtDate::~OOXMLContext_wordprocessingml_CT_SdtDate()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtDate::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtDate::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_dateFormat:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lid:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Lang(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_storeMappedDataAs:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtDateMappingType(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_calendar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CalendarType(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtDate::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtDate::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtDate::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtDate::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtDate::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtDate::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtComboBox*/
OOXMLContext_wordprocessingml_CT_SdtComboBox::OOXMLContext_wordprocessingml_CT_SdtComboBox(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtComboBox::~OOXMLContext_wordprocessingml_CT_SdtComboBox()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtComboBox::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtComboBox::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_listItem:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtListItem(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtComboBox::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtComboBox::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtComboBox::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtComboBox::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtComboBox::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtComboBox::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtDocPart*/
OOXMLContext_wordprocessingml_CT_SdtDocPart::OOXMLContext_wordprocessingml_CT_SdtDocPart(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtDocPart::~OOXMLContext_wordprocessingml_CT_SdtDocPart()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtDocPart::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtDocPart::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_docPartGallery:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_docPartCategory:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_docPartUnique:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtDocPart::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtDocPart::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtDocPart::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtDocPart::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtDocPart::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtDocPart::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtDropDownList*/
OOXMLContext_wordprocessingml_CT_SdtDropDownList::OOXMLContext_wordprocessingml_CT_SdtDropDownList(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtDropDownList::~OOXMLContext_wordprocessingml_CT_SdtDropDownList()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtDropDownList::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtDropDownList::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_listItem:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtListItem(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtDropDownList::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtDropDownList::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtDropDownList::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtDropDownList::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtDropDownList::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtDropDownList::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Placeholder*/
OOXMLContext_wordprocessingml_CT_Placeholder::OOXMLContext_wordprocessingml_CT_Placeholder(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Placeholder::~OOXMLContext_wordprocessingml_CT_Placeholder()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Placeholder::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Placeholder::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_docPart:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Placeholder::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Placeholder::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Placeholder::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Placeholder::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Placeholder::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Placeholder::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtText*/
OOXMLContext_wordprocessingml_CT_SdtText::OOXMLContext_wordprocessingml_CT_SdtText(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtText::~OOXMLContext_wordprocessingml_CT_SdtText()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtText::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtText::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtText::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtText::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtText::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtText::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtText::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtText::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_DataBinding*/
OOXMLContext_wordprocessingml_CT_DataBinding::OOXMLContext_wordprocessingml_CT_DataBinding(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_DataBinding::~OOXMLContext_wordprocessingml_CT_DataBinding()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_DataBinding::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_DataBinding::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_DataBinding::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_DataBinding::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_DataBinding::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_DataBinding::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_DataBinding::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_DataBinding::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtPr*/
OOXMLContext_wordprocessingml_CT_SdtPr::OOXMLContext_wordprocessingml_CT_SdtPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtPr::~OOXMLContext_wordprocessingml_CT_SdtPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_alias:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_lock:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Lock(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_placeholder:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Placeholder(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_showingPlcHdr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dataBinding:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DataBinding(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_temporary:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_id:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tag:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_equation:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_comboBox:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtComboBox(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_date:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtDate(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_docPartObj:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtDocPart(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_docPartList:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtDocPart(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_dropDownList:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtDropDownList(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_picture:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_richText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_text:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtText(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_citation:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_group:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bibliography:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Empty(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtEndPr*/
OOXMLContext_wordprocessingml_CT_SdtEndPr::OOXMLContext_wordprocessingml_CT_SdtEndPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtEndPr::~OOXMLContext_wordprocessingml_CT_SdtEndPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtEndPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtEndPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_rPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_RPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtEndPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtEndPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtEndPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtEndPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtEndPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtEndPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_ContentRunContent*/
OOXMLContext_wordprocessingml_EG_ContentRunContent::OOXMLContext_wordprocessingml_EG_ContentRunContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_ContentRunContent::~OOXMLContext_wordprocessingml_EG_ContentRunContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_ContentRunContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_ContentRunContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXml:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlRun(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_smartTag:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SmartTagRun(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtRun(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_r:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_R(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_ContentRunContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_ContentRunContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_ContentRunContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_ContentRunContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_ContentRunContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_ContentRunContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtContentRun*/
OOXMLContext_wordprocessingml_CT_SdtContentRun::OOXMLContext_wordprocessingml_CT_SdtContentRun(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtContentRun::~OOXMLContext_wordprocessingml_CT_SdtContentRun()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtContentRun::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtContentRun::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtContentRun::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtContentRun::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtContentRun::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtContentRun::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtContentRun::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtContentRun::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_ContentBlockContent*/
OOXMLContext_wordprocessingml_EG_ContentBlockContent::OOXMLContext_wordprocessingml_EG_ContentBlockContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_ContentBlockContent::~OOXMLContext_wordprocessingml_EG_ContentBlockContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_ContentBlockContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_ContentBlockContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXml:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlBlock(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtBlock(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_p:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_P(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tbl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Tbl(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_ContentBlockContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_ContentBlockContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_ContentBlockContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_ContentBlockContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_ContentBlockContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_ContentBlockContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtContentBlock*/
OOXMLContext_wordprocessingml_CT_SdtContentBlock::OOXMLContext_wordprocessingml_CT_SdtContentBlock(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtContentBlock::~OOXMLContext_wordprocessingml_CT_SdtContentBlock()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtContentBlock::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentBlockContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtContentBlock::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtContentBlock::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtContentBlock::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtContentBlock::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentBlockContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtContentBlock::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtContentBlock::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtContentBlock::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_ContentRowContent*/
OOXMLContext_wordprocessingml_EG_ContentRowContent::OOXMLContext_wordprocessingml_EG_ContentRowContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_ContentRowContent::~OOXMLContext_wordprocessingml_EG_ContentRowContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_ContentRowContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_ContentRowContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Row(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXml:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlRow(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtRow(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_ContentRowContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_ContentRowContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_ContentRowContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_ContentRowContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_ContentRowContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_ContentRowContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtContentRow*/
OOXMLContext_wordprocessingml_CT_SdtContentRow::OOXMLContext_wordprocessingml_CT_SdtContentRow(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtContentRow::~OOXMLContext_wordprocessingml_CT_SdtContentRow()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtContentRow::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRowContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtContentRow::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtContentRow::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtContentRow::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtContentRow::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRowContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtContentRow::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtContentRow::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtContentRow::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_ContentCellContent*/
OOXMLContext_wordprocessingml_EG_ContentCellContent::OOXMLContext_wordprocessingml_EG_ContentCellContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_ContentCellContent::~OOXMLContext_wordprocessingml_EG_ContentCellContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_ContentCellContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_ContentCellContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Tc(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_customXml:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlCell(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdt:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtCell(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_ContentCellContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_ContentCellContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_ContentCellContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_RunLevelElts(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_ContentCellContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_ContentCellContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_ContentCellContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtContentCell*/
OOXMLContext_wordprocessingml_CT_SdtContentCell::OOXMLContext_wordprocessingml_CT_SdtContentCell(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtContentCell::~OOXMLContext_wordprocessingml_CT_SdtContentCell()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtContentCell::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentCellContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtContentCell::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtContentCell::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtContentCell::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtContentCell::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentCellContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtContentCell::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtContentCell::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtContentCell::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtBlock*/
OOXMLContext_wordprocessingml_CT_SdtBlock::OOXMLContext_wordprocessingml_CT_SdtBlock(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtBlock::~OOXMLContext_wordprocessingml_CT_SdtBlock()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtBlock::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtBlock::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sdtPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtEndPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtEndPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtContent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtContentBlock(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtBlock::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtBlock::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtBlock::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtBlock::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtBlock::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtBlock::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtRun*/
OOXMLContext_wordprocessingml_CT_SdtRun::OOXMLContext_wordprocessingml_CT_SdtRun(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtRun::~OOXMLContext_wordprocessingml_CT_SdtRun()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtRun::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtRun::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sdtPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtEndPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtEndPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtContent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtContentRun(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtRun::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtRun::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtRun::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtRun::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtRun::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtRun::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtCell*/
OOXMLContext_wordprocessingml_CT_SdtCell::OOXMLContext_wordprocessingml_CT_SdtCell(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtCell::~OOXMLContext_wordprocessingml_CT_SdtCell()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtCell::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtCell::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sdtPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtEndPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtEndPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtContent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtContentCell(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtCell::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtCell::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtCell::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtCell::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtCell::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtCell::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SdtRow*/
OOXMLContext_wordprocessingml_CT_SdtRow::OOXMLContext_wordprocessingml_CT_SdtRow(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SdtRow::~OOXMLContext_wordprocessingml_CT_SdtRow()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SdtRow::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SdtRow::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_sdtPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtEndPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtEndPr(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_sdtContent:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SdtContentRow(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SdtRow::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SdtRow::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SdtRow::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SdtRow::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SdtRow::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SdtRow::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Attr*/
OOXMLContext_wordprocessingml_CT_Attr::OOXMLContext_wordprocessingml_CT_Attr(const OOXMLContext & rContext)
: OOXMLContextStringValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Attr::~OOXMLContext_wordprocessingml_CT_Attr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Attr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Attr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Attr::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_uri:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_name:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        msValue = OOXMLStringValue(rValue).getString();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Attr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Attr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Attr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStringValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Attr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Attr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CustomXmlRun*/
OOXMLContext_wordprocessingml_CT_CustomXmlRun::OOXMLContext_wordprocessingml_CT_CustomXmlRun(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CustomXmlRun::~OOXMLContext_wordprocessingml_CT_CustomXmlRun()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CustomXmlRun::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CustomXmlRun::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXmlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CustomXmlRun::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CustomXmlRun::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CustomXmlRun::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CustomXmlRun::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CustomXmlRun::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CustomXmlRun::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SmartTagRun*/
OOXMLContext_wordprocessingml_CT_SmartTagRun::OOXMLContext_wordprocessingml_CT_SmartTagRun(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SmartTagRun::~OOXMLContext_wordprocessingml_CT_SmartTagRun()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SmartTagRun::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SmartTagRun::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_smartTagPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SmartTagPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SmartTagRun::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SmartTagRun::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SmartTagRun::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SmartTagRun::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SmartTagRun::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SmartTagRun::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CustomXmlBlock*/
OOXMLContext_wordprocessingml_CT_CustomXmlBlock::OOXMLContext_wordprocessingml_CT_CustomXmlBlock(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CustomXmlBlock::~OOXMLContext_wordprocessingml_CT_CustomXmlBlock()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CustomXmlBlock::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentBlockContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CustomXmlBlock::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXmlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CustomXmlBlock::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CustomXmlBlock::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CustomXmlBlock::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentBlockContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CustomXmlBlock::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CustomXmlBlock::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CustomXmlBlock::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CustomXmlPr*/
OOXMLContext_wordprocessingml_CT_CustomXmlPr::OOXMLContext_wordprocessingml_CT_CustomXmlPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CustomXmlPr::~OOXMLContext_wordprocessingml_CT_CustomXmlPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CustomXmlPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CustomXmlPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_placeholder:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_String(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_attr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Attr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CustomXmlPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CustomXmlPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CustomXmlPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CustomXmlPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CustomXmlPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CustomXmlPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CustomXmlRow*/
OOXMLContext_wordprocessingml_CT_CustomXmlRow::OOXMLContext_wordprocessingml_CT_CustomXmlRow(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CustomXmlRow::~OOXMLContext_wordprocessingml_CT_CustomXmlRow()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CustomXmlRow::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRowContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CustomXmlRow::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXmlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CustomXmlRow::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CustomXmlRow::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CustomXmlRow::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRowContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CustomXmlRow::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CustomXmlRow::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CustomXmlRow::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_CustomXmlCell*/
OOXMLContext_wordprocessingml_CT_CustomXmlCell::OOXMLContext_wordprocessingml_CT_CustomXmlCell(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_CustomXmlCell::~OOXMLContext_wordprocessingml_CT_CustomXmlCell()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_CustomXmlCell::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentCellContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_CustomXmlCell::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_customXmlPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_CustomXmlPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_CustomXmlCell::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_CustomXmlCell::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_CustomXmlCell::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentCellContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_CustomXmlCell::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_CustomXmlCell::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_CustomXmlCell::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_SmartTagPr*/
OOXMLContext_wordprocessingml_CT_SmartTagPr::OOXMLContext_wordprocessingml_CT_SmartTagPr(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_CT_SmartTagPr::~OOXMLContext_wordprocessingml_CT_SmartTagPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_SmartTagPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_SmartTagPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_attr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Attr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_SmartTagPr::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_SmartTagPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_SmartTagPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_SmartTagPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_SmartTagPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_SmartTagPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_EG_PContent*/
OOXMLContext_wordprocessingml_EG_PContent::OOXMLContext_wordprocessingml_EG_PContent(const OOXMLContext & rContext)
: OOXMLContext(rContext)
{
}
OOXMLContext_wordprocessingml_EG_PContent::~OOXMLContext_wordprocessingml_EG_PContent()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_EG_PContent::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRunContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_EG_PContent::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_fldSimple:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_SimpleField(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hyperlink:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Hyperlink(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_subDoc:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Rel(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_EG_PContent::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_EG_PContent::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_EG_PContent::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_ContentRunContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_EG_PContent::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContext::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_EG_PContent::startAction()
{
}
void OOXMLContext_wordprocessingml_EG_PContent::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_P*/
OOXMLContext_wordprocessingml_CT_P::OOXMLContext_wordprocessingml_CT_P(const OOXMLContext & rContext)
: OOXMLContextStream(rContext)
{
}
OOXMLContext_wordprocessingml_CT_P::~OOXMLContext_wordprocessingml_CT_P()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_P::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_P::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_pPr:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_PPr(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_P::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_P::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_P::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_PContent(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_P::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextStream::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_P::startAction()
{
    startParagraphGroup();
    sendTableDepth();
}
void OOXMLContext_wordprocessingml_CT_P::endAction()
{
    if (isForwardEvents())        
        mrStream.utext(sCR, 1);
}
/* 
    class: OOXMLContext_wordprocessingml_CT_Height*/
OOXMLContext_wordprocessingml_CT_Height::OOXMLContext_wordprocessingml_CT_Height(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_Height::~OOXMLContext_wordprocessingml_CT_Height()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_Height::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_Height::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_Height::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_hRule:
        {
            OOXMLValue::Pointer_t pVal(new OOXMLStringValue(rValue));
            newProperty(nToken, pVal);
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_Height::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_Height : val
     case OOXML_ATTRIBUTE_wordprocessingml_val:
        nResult = NS_ooxml::LN_CT_Height_val;
        break;
        // CT_Height : hRule
     case OOXML_ATTRIBUTE_wordprocessingml_hRule:
        nResult = NS_ooxml::LN_CT_Height_hRule;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_Height::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_Height::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_Height::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_Height::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblWidth*/
OOXMLContext_wordprocessingml_CT_TblWidth::OOXMLContext_wordprocessingml_CT_TblWidth(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblWidth::~OOXMLContext_wordprocessingml_CT_TblWidth()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblWidth::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblWidth::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblWidth::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_DecimalNumber(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        {
          OOXMLValue::Pointer_t pVal(new OOXMLValue_wordprocessingml_ST_TblWidth(rValue));
          newProperty(nToken, pVal);

          bResult = true;
        }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblWidth::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TblWidth : w
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        nResult = NS_ooxml::LN_CT_TblWidth_w;
        break;
        // CT_TblWidth : type
     case OOXML_ATTRIBUTE_wordprocessingml_type:
        nResult = NS_ooxml::LN_CT_TblWidth_type;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblWidth::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblWidth::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblWidth::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblWidth::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblGridCol*/
OOXMLContext_wordprocessingml_CT_TblGridCol::OOXMLContext_wordprocessingml_CT_TblGridCol(const OOXMLContext & rContext)
: OOXMLContextIntegerValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblGridCol::~OOXMLContext_wordprocessingml_CT_TblGridCol()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblGridCol::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblGridCol::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblGridCol::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_w:
        mnValue = rValue.toInt32();
        bResult = true;
        break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblGridCol::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblGridCol::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblGridCol::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextIntegerValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblGridCol::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblGridCol::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblGridBase*/
OOXMLContext_wordprocessingml_CT_TblGridBase::OOXMLContext_wordprocessingml_CT_TblGridBase(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblGridBase::~OOXMLContext_wordprocessingml_CT_TblGridBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblGridBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblGridBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_gridCol:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblGridCol(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblGridBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblGridBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TblGridBase : gridCol
     case OOXML_ELEMENT_wordprocessingml_gridCol:
        nResult = NS_ooxml::LN_CT_TblGridBase_gridCol;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblGridBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblGridBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblGridBase::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblGridBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TblGrid*/
OOXMLContext_wordprocessingml_CT_TblGrid::OOXMLContext_wordprocessingml_CT_TblGrid(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TblGrid::~OOXMLContext_wordprocessingml_CT_TblGrid()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TblGrid::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TblGridBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TblGrid::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tblGridChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblGridChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TblGrid::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TblGridBase(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TblGrid::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TblGrid : tblGridChange
     case OOXML_ELEMENT_wordprocessingml_tblGridChange:
        nResult = NS_ooxml::LN_CT_TblGrid_tblGridChange;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TblGrid::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TblGridBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TblGrid::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TblGrid::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TblGrid::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcBorders*/
OOXMLContext_wordprocessingml_CT_TcBorders::OOXMLContext_wordprocessingml_CT_TcBorders(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcBorders::~OOXMLContext_wordprocessingml_CT_TcBorders()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcBorders::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcBorders::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_top:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_left:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bottom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_right:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_insideH:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_insideV:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tl2br:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tr2bl:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Border(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcBorders::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcBorders::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TcBorders : top
     case OOXML_ELEMENT_wordprocessingml_top:
        nResult = NS_ooxml::LN_CT_TcBorders_top;
        break;
        // CT_TcBorders : left
     case OOXML_ELEMENT_wordprocessingml_left:
        nResult = NS_ooxml::LN_CT_TcBorders_left;
        break;
        // CT_TcBorders : bottom
     case OOXML_ELEMENT_wordprocessingml_bottom:
        nResult = NS_ooxml::LN_CT_TcBorders_bottom;
        break;
        // CT_TcBorders : right
     case OOXML_ELEMENT_wordprocessingml_right:
        nResult = NS_ooxml::LN_CT_TcBorders_right;
        break;
        // CT_TcBorders : insideH
     case OOXML_ELEMENT_wordprocessingml_insideH:
        nResult = NS_ooxml::LN_CT_TcBorders_insideH;
        break;
        // CT_TcBorders : insideV
     case OOXML_ELEMENT_wordprocessingml_insideV:
        nResult = NS_ooxml::LN_CT_TcBorders_insideV;
        break;
        // CT_TcBorders : tl2br
     case OOXML_ELEMENT_wordprocessingml_tl2br:
        nResult = NS_ooxml::LN_CT_TcBorders_tl2br;
        break;
        // CT_TcBorders : tr2bl
     case OOXML_ELEMENT_wordprocessingml_tr2bl:
        nResult = NS_ooxml::LN_CT_TcBorders_tr2bl;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcBorders::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TcBorders::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TcBorders::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TcBorders::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcMar*/
OOXMLContext_wordprocessingml_CT_TcMar::OOXMLContext_wordprocessingml_CT_TcMar(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcMar::~OOXMLContext_wordprocessingml_CT_TcMar()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcMar::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcMar::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_top:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblWidth(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_left:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblWidth(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_bottom:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblWidth(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_right:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblWidth(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcMar::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcMar::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TcMar : top
     case OOXML_ELEMENT_wordprocessingml_top:
        nResult = NS_ooxml::LN_CT_TcMar_top;
        break;
        // CT_TcMar : left
     case OOXML_ELEMENT_wordprocessingml_left:
        nResult = NS_ooxml::LN_CT_TcMar_left;
        break;
        // CT_TcMar : bottom
     case OOXML_ELEMENT_wordprocessingml_bottom:
        nResult = NS_ooxml::LN_CT_TcMar_bottom;
        break;
        // CT_TcMar : right
     case OOXML_ELEMENT_wordprocessingml_right:
        nResult = NS_ooxml::LN_CT_TcMar_right;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcMar::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TcMar::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TcMar::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TcMar::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_VMerge*/
OOXMLContext_wordprocessingml_CT_VMerge::OOXMLContext_wordprocessingml_CT_VMerge(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_VMerge::~OOXMLContext_wordprocessingml_CT_VMerge()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_VMerge::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_VMerge::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_VMerge::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_Merge(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_VMerge::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_VMerge::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_VMerge::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_VMerge::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_VMerge::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_HMerge*/
OOXMLContext_wordprocessingml_CT_HMerge::OOXMLContext_wordprocessingml_CT_HMerge(const OOXMLContext & rContext)
: OOXMLContextListValue(rContext)
{
}
OOXMLContext_wordprocessingml_CT_HMerge::~OOXMLContext_wordprocessingml_CT_HMerge()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_HMerge::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_HMerge::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_HMerge::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    switch (nToken)
    {
     case OOXML_ATTRIBUTE_wordprocessingml_val:
      {
          mnValue = OOXMLValue_wordprocessingml_ST_Merge(rValue).getInt();
          bResult = true;
      }
      break;
    default:
      ;
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_HMerge::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_HMerge::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_HMerge::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextListValue::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_HMerge::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_HMerge::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcPrBase*/
OOXMLContext_wordprocessingml_CT_TcPrBase::OOXMLContext_wordprocessingml_CT_TcPrBase(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcPrBase::~OOXMLContext_wordprocessingml_CT_TcPrBase()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcPrBase::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcPrBase::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_cnfStyle:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Cnf(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tcW:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TblWidth(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_gridSpan:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_DecimalNumber(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hMerge:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_HMerge(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_vMerge:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_VMerge(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tcBorders:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TcBorders(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_shd:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_Shd(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_noWrap:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tcMar:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TcMar(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TextDirection(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_tcFitText:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_vAlign:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_VerticalJc(*this));
         }
             break;
     case OOXML_ELEMENT_wordprocessingml_hideMark:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_OnOff(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcPrBase::lcl_attribute(TokenEnum_t /*nToken*/, const rtl::OUString & /*rValue*/)
{
    bool bResult = false;
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcPrBase::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    switch (nToken)
    {
        // CT_TcPrBase : cnfStyle
     case OOXML_ELEMENT_wordprocessingml_cnfStyle:
        nResult = NS_ooxml::LN_CT_TcPrBase_cnfStyle;
        break;
        // CT_TcPrBase : tcW
     case OOXML_ELEMENT_wordprocessingml_tcW:
        nResult = NS_ooxml::LN_CT_TcPrBase_tcW;
        break;
        // CT_TcPrBase : gridSpan
     case OOXML_ELEMENT_wordprocessingml_gridSpan:
        nResult = NS_ooxml::LN_CT_TcPrBase_gridSpan;
        break;
        // CT_TcPrBase : hMerge
     case OOXML_ELEMENT_wordprocessingml_hMerge:
        nResult = NS_ooxml::LN_CT_TcPrBase_hMerge;
        break;
        // CT_TcPrBase : vMerge
     case OOXML_ELEMENT_wordprocessingml_vMerge:
        nResult = NS_ooxml::LN_CT_TcPrBase_vMerge;
        break;
        // CT_TcPrBase : tcBorders
     case OOXML_ELEMENT_wordprocessingml_tcBorders:
        nResult = NS_ooxml::LN_CT_TcPrBase_tcBorders;
        break;
        // CT_TcPrBase : shd
     case OOXML_ELEMENT_wordprocessingml_shd:
        nResult = NS_ooxml::LN_CT_TcPrBase_shd;
        break;
        // CT_TcPrBase : noWrap
     case OOXML_ELEMENT_wordprocessingml_noWrap:
        nResult = NS_ooxml::LN_CT_TcPrBase_noWrap;
        break;
        // CT_TcPrBase : tcMar
     case OOXML_ELEMENT_wordprocessingml_tcMar:
        nResult = NS_ooxml::LN_CT_TcPrBase_tcMar;
        break;
        // CT_TcPrBase : textDirection
     case OOXML_ELEMENT_wordprocessingml_textDirection:
        nResult = NS_ooxml::LN_CT_TcPrBase_textDirection;
        break;
        // CT_TcPrBase : tcFitText
     case OOXML_ELEMENT_wordprocessingml_tcFitText:
        nResult = NS_ooxml::LN_CT_TcPrBase_tcFitText;
        break;
        // CT_TcPrBase : vAlign
     case OOXML_ELEMENT_wordprocessingml_vAlign:
        nResult = NS_ooxml::LN_CT_TcPrBase_vAlign;
        break;
        // CT_TcPrBase : hideMark
     case OOXML_ELEMENT_wordprocessingml_hideMark:
        nResult = NS_ooxml::LN_CT_TcPrBase_hideMark;
        break;
    case OOXML_TOKENS_END: // prevent warning
        break;
    default:
        nResult = getIdFromRefs(nToken);
        break;
    }
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcPrBase::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TcPrBase::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TcPrBase::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TcPrBase::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcPr*/
OOXMLContext_wordprocessingml_CT_TcPr::OOXMLContext_wordprocessingml_CT_TcPr(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcPr::~OOXMLContext_wordprocessingml_CT_TcPr()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcPr::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TcPrInner(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcPr::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
    switch (nToken)
    {
     case OOXML_ELEMENT_wordprocessingml_tcPrChange:
        {
            pResult = OOXMLContext::Pointer_t
               ( new OOXMLContext_wordprocessingml_CT_TcPrChange(*this));
         }
             break;
     case OOXML_TOKENS_END:
         break;
     default:
         pResult = elementFromRefs(nToken);
              break;
     }

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcPr::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TcPrInner(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcPr::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcPr::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TcPrInner(*this));
        doctok::Id nId = pSubContext->getId(nToken);

        if (nId != 0x0)
            return nId;
     }
    
    return 0x0;
}
    
void OOXMLContext_wordprocessingml_CT_TcPr::lcl_characters(const rtl::OUString & sText) 
{
OOXMLContextProperties::lcl_characters(sText);
}
void OOXMLContext_wordprocessingml_CT_TcPr::startAction()
{
}
void OOXMLContext_wordprocessingml_CT_TcPr::endAction()
{
}
/* 
    class: OOXMLContext_wordprocessingml_CT_TcPrInner*/
OOXMLContext_wordprocessingml_CT_TcPrInner::OOXMLContext_wordprocessingml_CT_TcPrInner(const OOXMLContext & rContext)
: OOXMLContextProperties(rContext)
{
}
OOXMLContext_wordprocessingml_CT_TcPrInner::~OOXMLContext_wordprocessingml_CT_TcPrInner()
{
}

OOXMLContext::Pointer_t OOXMLContext_wordprocessingml_CT_TcPrInner::elementFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TcPrBase(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_EG_CellMarkupElements(*this));
        OOXMLContext::Pointer_t pContext(pSubContext->element(nToken));

        if (pContext.get() != NULL)
            return pContext;
     }
    
    return OOXMLContext::Pointer_t();
}
    
OOXMLContext::Pointer_t
OOXMLContext_wordprocessingml_CT_TcPrInner::element(TokenEnum_t nToken)
{
    OOXMLContext::Pointer_t pResult;
    
     pResult = elementFromRefs(nToken);

    if (pResult.get() != NULL)
        pResult->setToken(nToken);

    return pResult;
}
     
bool OOXMLContext_wordprocessingml_CT_TcPrInner::lcl_attribute(TokenEnum_t nToken, const rtl::OUString & rValue)
{
    bool bResult = false;
    if (! bResult)
    {
        OOXMLContextProperties::Pointer_t pRefContext( new OOXMLContext_wordprocessingml_CT_TcPrBase(*this));
        pRefContext->setParentResource(getResource());
        
        pRefContext->setPropertySet(mpPropertySet);
        bResult = pRefContext->attribute(nToken, rValue);
        
    }
    
    return bResult;
}
doctok::Id
OOXMLContext_wordprocessingml_CT_TcPrInner::getId(TokenEnum_t nToken)
{
    doctok::Id nResult = 0x0;
    
    nResult = getIdFromRefs(nToken);
    return nResult;  
}
    
doctok::Id OOXMLContext_wordprocessingml_CT_TcPrInner::getIdFromRefs(TokenEnum_t nToken)
{
    TokenEnum_t tmpToken;
    tmpToken = nToken; // prevent warning
    {       
        OOXMLContext::Pointer_t pSubContext = OOXMLContext::Pointer_t
            ( new OOXMLContext_wordprocessingml_CT_TcPrBase(*this));
        doctok::Id nId = pSubContext->getId(nToken);