// Derived from:
// Id: XSLTransformEngine.java 96 2005-02-28 21:07:29Z blindsey
// And added methods required by XmlSearch

// Copyright (c) 1998, 1999 James Clark

// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// ``Software''), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:

// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JAMES CLARK BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.

// Except as contained in this notice, the name of James Clark shall
// not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization
// from James Clark.


package com.jclark.xsl.dom;

import com.jclark.xsl.tr.*;
import com.jclark.xsl.om.*;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import java.net.URL;
import java.io.IOException;

public class XmlSearchXSLTransformEngine
    implements TransformEngine, XMLProcessor
{
    private Engine engine;
    private DOMExtensions extend;

    public Node load(URL url,
                   int documentIndex,
                   LoadContext context,
                   NameTable nameTable) throws XSLException
    {
      throw new XSLException("external documents not supported");
    }

    public Result createResult(Node baseNode,
                             int documentIndex,
                             LoadContext loadContext,
                             Node[] rootNodeRef) throws XSLException
    {
      if (baseNode == null)
          throw new XSLException("cannot convert result tree fragment returned by extension function to a node-set with the DOM");
      RootNode root = ((NodeBase)baseNode).root;
      org.w3c.dom.DocumentFragment docFrag
          = root.ownerDocument.createDocumentFragment();
      String base = null;
      URL baseURL = baseNode.getURL();
      if (baseURL != null)
          base = baseURL.toString();
      rootNodeRef[0] =
          new RootNode(docFrag,
                       extend,
                       loadContext,
                       engine.getNameTable(),
                       base,
                       documentIndex);
      return new MultiNamespaceResult(new DOMBuilder(docFrag), null);
    }

    public XmlSearchXSLTransformEngine()
    {
      engine = new EngineImpl(this, new ExtensionHandlerImpl());
    }

    public XmlSearchXSLTransformEngine(DOMExtensions extend)
    {
      this();
      this.extend = extend;
    }

    private class TransformImpl implements XmlSearchTransform, ParameterSet
    {
      private Sheet sheet;

      TransformImpl (Sheet sheet) {
          this.sheet = sheet;
      }

      public void transform(org.w3c.dom.Node sourceRoot,
                            org.w3c.dom.Node resultRoot)
          throws TransformException {
          try {
              sheet.process(new RootNode(sourceRoot,
                                         extend,
                                         sheet.getSourceLoadContext(),
                                         engine.getNameTable(),
                                         null,
                                         0),
                            XmlSearchXSLTransformEngine.this,
                            this, // ParameterSet
                            new MultiNamespaceResult(new DOMBuilder(resultRoot),
                                                     null));
          }
          catch (XSLException e) {
              throw toTransformException(e);
          }
      }

      public void transform(Node sourceRoot,
                            Result result)
          throws TransformException {
          try {
              sheet.process(sourceRoot,
                            XmlSearchXSLTransformEngine.this,
                            this, // ParameterSet
                            result);
          }
          catch (XSLException e) {
              throw toTransformException(e);
          }
      }
      public Object getParameter(Name name) {
          return null;
      }
    }

    public Transform createTransform(org.w3c.dom.Node domNode)
      throws TransformException
    {
      try {
          return new TransformImpl(engine.createSheet(new RootNode(domNode,
                                                                   extend,
                                                                   engine.getSheetLoadContext(),
                                                                   engine.getNameTable(),
                                                                   null,
                                                                   0)));
      }
      catch (XSLException e) {
          throw toTransformException(e);
      }
      catch (IOException e) {
          throw new Error("unexpected exception: " + e);
      }
    }

    public NameTable getNameTable()
    {
      return engine.getNameTable();
    }

    public LoadContext getSourceLoadContext()
    {
      return engine.getSheetLoadContext();
    }

    private TransformException toTransformException(XSLException e)
    {
      org.w3c.dom.Node domNode = null;
      Node node = e.getNode();
      if (node != null) {
          domNode = ((NodeBase)node).domNode;
      }
      String message = e.getMessage();
      if (e == null) {
          message = e.getException().toString();
      }
      return new TransformException(message, domNode);
    }
}
