/**
 * ===========================================
 * LibLayout : a free Java layouting library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/liblayout/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: FontSmoothReadHandler.java,v 1.5 2007/04/02 11:41:08 taqua Exp $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.layouting.input.style.parser.stylehandler.font;

import org.jfree.layouting.input.style.keys.font.FontSmooth;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

/**
 * Creation-Date: 28.11.2005, 17:28:44
 *
 * @author Thomas Morgner
 */
public class FontSmoothReadHandler extends OneOfConstantsReadHandler
{
  public FontSmoothReadHandler()
  {
    super(true);
    addValue(FontSmooth.ALWAYS);
    addValue(FontSmooth.NEVER);
  }

  protected CSSValue lookupValue(final LexicalUnit value)
  {
    final CSSValue cssValue = super.lookupValue(value);
    if (cssValue != null)
    {
      return cssValue;
    }

    final CSSValue number = CSSValueFactory.createNumericValue(value);
    if (number != null)
    {
      return number;
    }
    return CSSValueFactory.createLengthValue(value);
  }
}
