/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.annotations.Annotation;
import com.jrefinery.chart.annotations.XYAnnotation;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XYPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
PropertyChangeListener {
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private XYItemRenderer renderer;
    private XYPlot parent = null;
    private int weight = 1;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this(xYDataset, valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, new StandardXYItemRenderer());
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this(xYDataset, valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, xYItemRenderer);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, XYItemRenderer xYItemRenderer) {
        super(xYDataset, insets, paint, image, f, stroke, paint2, f2);
        this.renderer = xYItemRenderer;
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            this.renderer.addPropertyChangeListener(this);
        }
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
    }

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(XYPlot xYPlot) {
        this.parent = xYPlot;
    }

    public boolean isSubplot() {
        return this.parent != null;
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    public List getLegendItemLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(xYDataset.getSeriesName(n2));
                ++n2;
            }
        }
        return arrayList;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                LegendItem legendItem = this.renderer.getLegendItem(n2);
                legendItemCollection.add(legendItem);
                ++n2;
            }
        }
        return legendItemCollection;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public XYItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        boolean bl = false;
        if (this.renderer != null) {
            if (!this.renderer.equals(xYItemRenderer)) {
                this.renderer.removePropertyChangeListener(this);
                this.renderer = xYItemRenderer;
                bl = true;
            }
        } else if (xYItemRenderer != null) {
            this.renderer = xYItemRenderer;
            bl = true;
        }
        if (bl) {
            this.renderer.setPlot(this);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public XYDataset getXYDataset() {
        return (XYDataset)this.dataset;
    }

    public ValueAxis getDomainAxis() {
        ValueAxis valueAxis = this.domainAxis;
        if (valueAxis == null && this.parent != null) {
            valueAxis = this.parent.getDomainAxis();
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setDomainAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getRangeAxis() {
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && this.parent != null) {
            valueAxis = this.parent.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        if (this.domainMarkers == null) {
            this.domainMarkers = new ArrayList();
        }
        this.domainMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.domainMarkers != null) {
            this.domainMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addAnnotation(Annotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCompatibleDomainAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof HorizontalAxis;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            object = (VerticalAxis)((Object)this.rangeAxis);
            d2 = object.reserveAxisArea(graphics2D, this, rectangle2D, d).getWidth();
        }
        object = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawOutlineAndBackground(graphics2D, (Rectangle2D)object);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        }
        if (this.renderer != null) {
            Object object2;
            Iterator iterator;
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip((Shape)object);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            if (this.domainMarkers != null) {
                iterator = this.domainMarkers.iterator();
                while (iterator.hasNext()) {
                    object2 = (Marker)iterator.next();
                    this.renderer.drawDomainMarker(graphics2D, this, this.getDomainAxis(), (Marker)object2, (Rectangle2D)object);
                }
            }
            if (this.rangeMarkers != null) {
                iterator = this.rangeMarkers.iterator();
                while (iterator.hasNext()) {
                    object2 = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), (Marker)object2, (Rectangle2D)object);
                }
            }
            this.render(graphics2D, (Rectangle2D)object, chartRenderingInfo, crosshairInfo);
            if (this.annotations != null) {
                iterator = this.annotations.iterator();
                while (iterator.hasNext()) {
                    object2 = (Annotation)iterator.next();
                    if (!(object2 instanceof XYAnnotation)) continue;
                    XYAnnotation xYAnnotation = (XYAnnotation)object2;
                    xYAnnotation.draw(graphics2D, (Rectangle2D)object, this.getDomainAxis(), this.getRangeAxis());
                }
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            this.renderer.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    this.renderer.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, xYDataset, n2, n4, crosshairInfo);
                    ++n4;
                }
                ++n2;
            }
            valueAxis.setCrosshairValue(crosshairInfo.getCrosshairX(), false);
            if (valueAxis.isCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, valueAxis.getCrosshairValue(), valueAxis.getCrosshairStroke(), valueAxis.getCrosshairPaint());
            }
            valueAxis2.setCrosshairValue(crosshairInfo.getCrosshairY(), false);
            if (valueAxis2.isCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, valueAxis2.getCrosshairValue(), valueAxis2.getCrosshairStroke(), valueAxis2.getCrosshairPaint());
            }
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis;
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            double d = valueAxis2.translateJava2DtoValue(n, chartRenderingInfo.getDataArea());
            valueAxis2.setAnchorValue(d);
            valueAxis2.setCrosshairValue(d);
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            double d = valueAxis.translateJava2DtoValue(n2, chartRenderingInfo.getDataArea());
            valueAxis.setAnchorValue(d);
            valueAxis.setCrosshairValue(d);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getMaximumAxisValue() - valueAxis2.getMinimumAxisValue();
            d3 = d2 * d;
            valueAxis2.setAnchoredRange(d3);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "XY Plot";
    }

    public Range getHorizontalDataRange() {
        Range range = null;
        if (this.dataset != null) {
            range = DatasetUtilities.getDomainExtent(this.dataset);
        }
        return range;
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.dataset != null) {
            range = DatasetUtilities.getRangeExtent(this.dataset);
        }
        return range;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.parent != null) {
            this.parent.datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.getDomainAxis());
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.getRangeAxis());
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    public XYItemRenderer getItemRenderer() {
        return this.getRenderer();
    }

    public void setXYItemRenderer(XYItemRenderer xYItemRenderer) {
        this.setRenderer(xYItemRenderer);
    }

    public void addHorizontalLine(Number number) {
        this.addRangeMarker(new Marker(number.doubleValue()));
    }

    public void addHorizontalLine(Number number, Paint paint) {
        this.addRangeMarker(new Marker(number.doubleValue(), paint, null, paint, 1.0f));
    }

    public void addVerticalLine(Number number) {
        this.addDomainMarker(new Marker(number.doubleValue()));
    }

    public void addVerticalLine(Number number, Paint paint) {
        this.addDomainMarker(new Marker(number.doubleValue(), paint, null, paint, 1.0f));
    }
}

