/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: ITextFontRecord.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.itext;

import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontType;

/**
 * Creation-Date: 20.07.2007, 19:59:37
 *
 * @author Thomas Morgner
 */
public class ITextFontRecord implements FontRecord, FontIdentifier
{
  private FontFamily fontFamily;
  private boolean bold;
  private boolean italic;
  private boolean oblique;

  public ITextFontRecord(final FontFamily fontFamily,
                         final boolean bold,
                         final boolean italic,
                         final boolean oblique)
  {
    if (fontFamily == null)
    {
      throw new NullPointerException();
    }
    this.fontFamily = fontFamily;
    this.bold = bold;
    this.italic = italic;
    this.oblique = oblique;
  }

  public FontFamily getFamily()
  {
    return fontFamily;
  }

  public boolean isBold()
  {
    return bold;
  }

  public boolean isItalic()
  {
    return italic;
  }

  public boolean isOblique()
  {
    return oblique;
  }

  public FontIdentifier getIdentifier()
  {
    return this;
  }

  public boolean isScalable()
  {
    return true;
  }

  public FontType getFontType()
  {
    return FontType.OTHER;
  }

  public boolean equals(final Object o)
  {
    if (this == o)
    {
      return true;
    }
    if (o == null || getClass() != o.getClass())
    {
      return false;
    }

    final ITextFontRecord that = (ITextFontRecord) o;

    if (bold != that.bold)
    {
      return false;
    }
    if (italic != that.italic)
    {
      return false;
    }
    if (oblique != that.oblique)
    {
      return false;
    }
    if (!fontFamily.equals(that.fontFamily))
    {
      return false;
    }

    return true;
  }

  public int hashCode()
  {
    int result = fontFamily.hashCode();
    result = 29 * result + (bold ? 1 : 0);
    result = 29 * result + (italic ? 1 : 0);
    result = 29 * result + (oblique ? 1 : 0);
    return result;
  }
}
