/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: componentclientmonitor.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: fs $ $Date: 2006/09/18 10:42:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBAUI_COMPONENTCLIENTMONITOR_HXX
#define DBAUI_COMPONENTCLIENTMONITOR_HXX

#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_ 
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	//=====================================================================
	//= OComponentClientMonitor
	//=====================================================================
	typedef ::cppu::WeakImplHelper1	<	::com::sun::star::lang::XEventListener
									>	OComponentClientMonitor_Base;

	/** a class which is able to monitor clients of a connection for disposal

		<p>You can use this class if you have a connection which should be shared by different clients (normally
		tasks which contain DBA components, such as a query design). An instance of this class ensures that when
		the last client dies, the connection is disposed automatically.</p>
	*/
	class OComponentClientMonitor : public OComponentClientMonitor_Base
	{
	protected:
		::osl::Mutex	m_aMutex;
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
						m_xComponent;

		DECLARE_STL_VECTOR( ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >, ComponentArray );
		ComponentArray	m_aClients;
		sal_Int32		m_nAnonymousClients;

	public:
		OComponentClientMonitor( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >& _rxConnection ) SAL_THROW(());

		/// adds a client to be monitored
		void	registerClient( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent>& _rxClient ) SAL_THROW(());

		/** registers  a client which does not live in the UNO world
			<p>Clients added using this method must be revoked explicitly using <method>revokeAnonymousClient</method>.</p>
		*/
		void	registerAnonymousClient() SAL_THROW(());

		/** revokes a non-UNO client which has previously been registered with <method>registerAnonymousClient</method>.
		*/
		void	revokeAnonymousClient() SAL_THROW(());

		/// returns the connections whichs clients are monitored
		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >&
			getComponent() const SAL_THROW(()) { return m_xComponent; }

	protected:
		~OComponentClientMonitor() SAL_THROW(());

	protected:
	    virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& _rEvent ) throw (::com::sun::star::uno::RuntimeException);

	private:
		/** is to be called when a client (no matter which kind of client) is gone.
			<p>This method has to be called with m_aMutex beeing aquired.</p>
		*/
		void	clientGone( ) SAL_THROW(());
	};

//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // DBAUI_COMPONENTCLIENTMONITOR_HXX

