#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/time.h>
#include <limits.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <sys/poll.h>

// here are some string from me (VG)
#include <map>
#include <algorithm>
#include <errno.h>
#include <stdlib.h>
#include <string>

#define BYTE        1
#define KILOBYTE    1024
#define MEGABYTE    KILOBYTE * 1024
#define GIGABYTE    MEGABYTE * 1024
#define HOME    "HOME"
#define CWS_WORK_STAMP   "CWS_WORK_STAMP"
#define UPDATER   "UPDATER"
#define DEFAULT_OUTPUT_PATH "/develop4/update/merge/EIS/SyscallImport"
#define OUTPUT_FILE "/lib_output"

using namespace std;

typedef pair < unsigned, unsigned > Pair;   // (bytes, times) pair structure
typedef map < unsigned, Pair > Map;         // (grade, (bytes, times)) map
typedef Map::value_type MapEntry;           // (grade, (bytes, times)) entity

static Map ReadBytesMap;
static Map WrittenBytesMap;
static Map MallocedBytesMap;
static bool Maps_initialized = false;
static FILE* OutputFile;

static sig_atomic_t nBytesWritten;
static sig_atomic_t nBytesRead;
static sig_atomic_t nMallocs;
static sig_atomic_t nBytesMalloced;
static sig_atomic_t nFrees;
extern int errno;

// Enhancement for furver investigation
static sig_atomic_t nPolls;
static sig_atomic_t nSelects;

void init_map(Map& map_to_init) {
    map_to_init[BYTE] = Pair(0,0);
};

void put_value (unsigned const Value, Map& map_to_fill) {
    unsigned key = map_to_fill.begin() -> first;
    while (Value > key) key *= 2;
    Map::iterator iter = map_to_fill.find(key);
    
    if (iter ==  map_to_fill.end()) {
        map_to_fill[key] = Pair(Value, 1);
        return;
    };
    
    (*iter).second.first += Value;  // bytes
    (*iter).second.second++;        // times 
};

bool open_info_file() {
    char* tinp_dir = getenv("TEMP");
    if (!tinp_dir)
        return false;
    return true;
};

void print_entry(const MapEntry& entry_to_print) {
    /*if (entry_to_print.first >= MEGABYTE)
        fprintf(OutputFile, "%d GB", entry_to_print.first/GIGABYTE);
    else if (entry_to_print.first >= MEGABYTE)
        fprintf(OutputFile, "%d MB", entry_to_print.first/MEGABYTE);
    else if (entry_to_print.first >= KILOBYTE)
        fprintf(OutputFile, "%d KB", entry_to_print.first/KILOBYTE);
    else
        fprintf(OutputFile, "%d B", entry_to_print.first);
    fprintf(OutputFile, "\t%d\t\t%d\n", entry_to_print.second.first, entry_to_print.second.second); */
    fprintf(OutputFile, "%d\t%d\t%d\t\n", entry_to_print.first, entry_to_print.second.first, entry_to_print.second.second);
};

static void print_map_stats(Map& map_to_print) {
    unsigned top = map_to_print.rbegin() -> first;
    unsigned key = map_to_print.begin() -> first;
    while ( key != top ) {
        if (map_to_print.find(key) == map_to_print.end()) 
            map_to_print[key] = Pair(0, 0);
        key *= 2;
    };
    
    //fprintf(OutputFile, "Grade\tBytes total\tTimes\n");
    for_each(map_to_print.begin(), map_to_print.end(), print_entry);
}; 

ssize_t read(int nFd, void *pBuf, size_t nCount)
{
    static ssize_t (*pfRead)(int, void *, size_t);
    ssize_t n;

    if ( !pfRead ) {
        pfRead = (ssize_t (*)(int, void *, size_t))dlsym(RTLD_NEXT, "read");
    }

    n = (*pfRead)(nFd, pBuf, nCount);
    if ( n > 0 ) {
        if (Maps_initialized) put_value( (unsigned) n, ReadBytesMap);
        nBytesRead += n;
    };
    return n;
}
    
ssize_t write(int nFd, const void *pBuf, size_t nCount)
{
    static ssize_t (*pfWrite)(int, const void *, size_t);
    ssize_t n;

    if ( !pfWrite ) {
        pfWrite = (ssize_t (*)(int, const void *, size_t))dlsym(RTLD_NEXT, "write");
    }
    n = (*pfWrite)(nFd, pBuf, nCount);
    if ( n > 0 )
        if (Maps_initialized) put_value( (unsigned) n, WrittenBytesMap);
        nBytesWritten += n;
    return n;
};

int select(int  n,  fd_set  *readfds,  fd_set  *writefds, fd_set *exceptfds, struct timeval *timeout)
{
    static int (*pfSelect)(int,  fd_set *,  fd_set *, fd_set *, struct timeval *);

    if ( !pfSelect ) {
        pfSelect = (int (*)(int,  fd_set *,  fd_set *, fd_set *, struct timeval *))dlsym(RTLD_NEXT, "select");
    }
    nSelects++;
    return (*pfSelect)( n, readfds, writefds, exceptfds, timeout);
};

int poll(struct pollfd *ufds, unsigned int nfds, int timeout)
{
    static int (*pfPoll)(struct pollfd *, unsigned int, int);

    if ( !pfPoll ) {
        pfPoll = (int (*)(struct pollfd *, unsigned int, int))dlsym(RTLD_NEXT, "poll");
    }
    nPolls++;
    return (*pfPoll)(ufds, nfds, timeout);
};

void* malloc(size_t size)
{
    static void* (*pfMalloc)(size_t);
    void*   p;

    if ( !pfMalloc ) {
        pfMalloc = (void* (*)(size_t))dlsym(RTLD_NEXT, "malloc");
    }
    p = (*pfMalloc)(size);
    if ( p ) {
        nMallocs++;
        if (Maps_initialized) put_value( (unsigned) size, MallocedBytesMap);
        nBytesMalloced += size;
    }
    return p;
}


void free(void* ptr)
{
    static void (*pfFree)(void *ptr);

    if ( !pfFree ) {
        pfFree = (void (*)(void*))dlsym(RTLD_NEXT, "free");
    }
    (*pfFree)(ptr);
    nFrees++;
    return;
}

int get_process_name(char *pCommand, size_t nSize)
{
    char    pPath[PATH_MAX];
    size_t  nLen;
    
    snprintf(pPath, sizeof(pPath), "%s%d%s", "/proc/", getpid(), "/exe");
    nLen = readlink(pPath, pCommand, nSize);
    if ( nLen > nSize-1 ) {
        pCommand[nSize-1] = '\0';
        return -1;
    }
    pCommand[nLen] = '\0';
    return nLen;
}

    
static void print_stats() 
{
    char pCommand[PATH_MAX];

    fprintf(OutputFile, "========================================\n");
    if ( get_process_name(pCommand, sizeof(pCommand)) != -1 )
        fprintf(OutputFile, "Command: %s\n", pCommand);

    fprintf(OutputFile, "Bytes read via read(2): %d\n", nBytesRead);
    fprintf(OutputFile, "Bytes written via write(2): %d\n", nBytesWritten);
    fprintf(OutputFile, "Calls to malloc(3): %d\n", nMallocs);
    fprintf(OutputFile, "Bytes malloced: %d\n", nBytesMalloced);
    fprintf(OutputFile, "Calls to free(3): %d\n", nFrees);
    fprintf(OutputFile, "Calls to poll(2): %d\n", nPolls);
    fprintf(OutputFile, "Calls to select(2): %d\n", nSelects);
    fprintf(OutputFile, "========================================\nBytes read statistic:\n");
    print_map_stats(ReadBytesMap);
    fprintf(OutputFile, "========================================\nBytes written statistic:\n");
    print_map_stats(WrittenBytesMap);
    fprintf(OutputFile, "========================================\nBytes malloced statistic:\n");
    print_map_stats(MallocedBytesMap);
}

unsigned char SVMain()
{
    init_map(ReadBytesMap);
    init_map(WrittenBytesMap);
    init_map(MallocedBytesMap);
    string FileName;
    if ((!getenv(CWS_WORK_STAMP)) && getenv(UPDATER))
        FileName = DEFAULT_OUTPUT_PATH;
    else
        FileName = getenv(HOME);
    
    FileName += OUTPUT_FILE;
    unlink(FileName.data());
    //printf(FileName.data());
    const char mode = 'w';
    if (!open_info_file()) 
        exit(errno);
    OutputFile = fopen(FileName.data(), &mode);
    
    Maps_initialized = true;
    static unsigned char (*pfSVMain)();
    if ( !pfSVMain ) {
        pfSVMain = (unsigned char (*)())dlsym(RTLD_NEXT, "_Z6SVMainv");
    }

    (*pfSVMain)();
    print_stats();
    fclose(OutputFile);
    return 0;
}

#if 0
int main(int argc, char* argv[])
{
    static int (*pfmain)(int argc, char* argv[]);
    if ( !pfmain ) {
        pfmain = (int (*)())dlsym(RTLD_NEXT, "main");
    }

    (*pfmain)(argc, argv);
    print_stats();
    return 0;
}
#endif
