/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: txtnum.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 12:31:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include <hintids.hxx>
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SVX_NUMITEM_HXX //autogen
#include <svx/numitem.hxx>
#endif
#ifndef _SVX_BRSHITEM_HXX //autogen wg. SvxBrushItem
#include <svx/brshitem.hxx>
#endif

#include "cmdid.h"
#include "wrtsh.hxx"
#include "view.hxx"
#include "viewopt.hxx"
#include "wdocsh.hxx"
#include "textsh.hxx"
#include "uiitems.hxx"
#include "swabstdlg.hxx"
#include <globals.hrc>
#include <sfx2/tabdlg.hxx>

void SwTextShell::ExecEnterNum(SfxRequest &rReq)
{
	//wg. Aufzeichnung schon vor dem evtl. Shellwechsel
	switch(rReq.GetSlot())
	{
	case FN_NUM_NUMBERING_ON:
	{
        SFX_REQUEST_ARG( rReq, pItem, SfxBoolItem, FN_PARAM_1 , sal_False );
        BOOL bMode = !GetShell().HasNumber(); // #i29560#
        if ( pItem )
            bMode = pItem->GetValue();
        else
            rReq.AppendItem( SfxBoolItem( FN_PARAM_1, bMode ) );

        if ( bMode != (GetShell().HasNumber()) ) // #i29560#
        {
            rReq.Done();
            if( bMode )
                GetShell().NumOn();
            else
                GetShell().NumOrBulletOff(); // #i29560#
        }
	}
	break;
	case FN_NUM_BULLET_ON:
	{
        SFX_REQUEST_ARG( rReq, pItem, SfxBoolItem, FN_PARAM_1 , sal_False );
        BOOL bMode = !GetShell().HasBullet(); // #i29560#
        if ( pItem )
            bMode = pItem->GetValue();
        else
            rReq.AppendItem( SfxBoolItem( FN_PARAM_1, bMode ) );

        if ( bMode != (GetShell().HasBullet()) ) // #i29560#
        {
            rReq.Done();
            if( bMode )
                GetShell().BulletOn();
            else
                GetShell().NumOrBulletOff(); // #i29560#
        }
	}
	break;
	case FN_NUMBER_BULLETS:
	{
		// per default TRUE, damit die Schleife im Dialog richtig arbeitet!
		BOOL bHasChild = TRUE;
		SfxItemSet aSet(GetPool(),
				SID_HTML_MODE, SID_HTML_MODE,
				SID_ATTR_NUMBERING_RULE, SID_PARAM_CUR_NUM_LEVEL,
				0 );
		SwDocShell* pDocSh = GetView().GetDocShell();
		BOOL bHtml = 0 != PTR_CAST(SwWebDocShell, pDocSh);
		const SwNumRule* pCurRule = GetShell().GetCurNumRule();
		if( pCurRule )
		{
			SvxNumRule aRule = pCurRule->MakeSvxNumRule();

			//convert type of linked bitmaps from SVX_NUM_BITMAP to (SVX_NUM_BITMAP|LINK_TOKEN)
			for(USHORT i = 0; i < aRule.GetLevelCount(); i++)
			{
				SvxNumberFormat aFmt(aRule.GetLevel(i));
				if(SVX_NUM_BITMAP == aFmt.GetNumberingType())
				{
					const SvxBrushItem* pBrush = aFmt.GetBrush();
					const String* pLinkStr;
					if(pBrush &&
						0 != (pLinkStr = pBrush->GetGraphicLink()) &&
							pLinkStr->Len())
						aFmt.SetNumberingType(SvxExtNumType(SVX_NUM_BITMAP|LINK_TOKEN));
					aRule.SetLevel(i, aFmt, aRule.Get(i) != 0);
				}
			}
			if(bHtml)
				aRule.SetFeatureFlag(NUM_ENABLE_EMBEDDED_BMP, FALSE);

			aSet.Put(SvxNumBulletItem(aRule));
			USHORT nLevel = GetRealLevel(GetShell().GetNumLevel( &bHasChild ));
			if( nLevel < MAXLEVEL )
			{
				nLevel = 1<<nLevel;
				aSet.Put( SfxUInt16Item( SID_PARAM_CUR_NUM_LEVEL, nLevel ));
			}
		}
		else
		{
			SwNumRule aRule( GetShell().GetUniqueNumRuleName() );
			SvxNumRule aSvxRule = aRule.MakeSvxNumRule();
            const bool bRightToLeft = GetShell().IsInRightToLeftText( 0 );

            if( bHtml || bRightToLeft )
			{
                for( BYTE n = 0; n < MAXLEVEL; ++n )
				{
					SvxNumberFormat aFmt( aSvxRule.GetLevel( n ) );
                    if ( n && bHtml )
                    {
                        // 1/2" fuer HTML
                        aFmt.SetLSpace(720);
                        aFmt.SetAbsLSpace(n * 720);
                    }
                    // --> FME 2005-01-21 #i38904#  Default alignment for
                    // numbering/bullet should be rtl in rtl paragraph:
                    if ( bRightToLeft )
                    {
                        aFmt.SetNumAdjust( SVX_ADJUST_RIGHT );
                    }
                    // <--
                    aSvxRule.SetLevel( n, aFmt, FALSE );
				}
				aSvxRule.SetFeatureFlag(NUM_ENABLE_EMBEDDED_BMP, FALSE);
			}
			aSet.Put(SvxNumBulletItem(aSvxRule));
		}

		aSet.Put( SfxBoolItem( SID_PARAM_CHILD_LEVELS, bHasChild ));
		aSet.Put( SfxBoolItem( SID_PARAM_NUM_PRESET,FALSE ));

		// vor dem Dialog wird der HtmlMode an der DocShell versenkt
		pDocSh->PutItem(SfxUInt16Item(SID_HTML_MODE, ::GetHtmlMode(pDocSh)));

		SwAbstractDialogFactory* pFact = SwAbstractDialogFactory::Create();
        DBG_ASSERT(pFact, "Dialogdiet fail!");
        SfxAbstractTabDialog* pDlg = pFact->CreateSwTabDialog( DLG_SVXTEST_NUM_BULLET,
														GetView().GetWindow(), &aSet, GetShell());
        DBG_ASSERT(pDlg, "Dialogdiet fail!");
		USHORT nRet = pDlg->Execute();
		const SfxPoolItem* pItem;
		if( RET_OK == nRet )
		{
			if( SFX_ITEM_SET == pDlg->GetOutputItemSet()->GetItemState( SID_ATTR_NUMBERING_RULE, FALSE, &pItem ))
			{
				rReq.AppendItem(*pItem);
				rReq.Done();
				SvxNumRule* pSetRule = ((SvxNumBulletItem*)pItem)->GetNumRule();
				pSetRule->UnLinkGraphics();
				SwNumRule aSetRule( pCurRule
										? pCurRule->GetName()
										: GetShell().GetUniqueNumRuleName());
				aSetRule.SetSvxRule( *pSetRule, GetShell().GetDoc());
				aSetRule.SetAutoRule( TRUE );
				GetShell().SetCurNumRule( aSetRule );
			}
			// wenn der Dialog mit OK verlassen wurde, aber nichts ausgewaehlt
			// wurde dann muss die Numerierung zumindest eingeschaltet werden,
			// wenn sie das noch nicht ist
			else if( !pCurRule && SFX_ITEM_SET == aSet.GetItemState( SID_ATTR_NUMBERING_RULE, FALSE, &pItem ))
			{
				rReq.AppendItem( *pItem );
				rReq.Done();
				SvxNumRule* pSetRule = ((SvxNumBulletItem*)pItem)->GetNumRule();
				SwNumRule aSetRule(GetShell().GetUniqueNumRuleName());
				aSetRule.SetSvxRule(*pSetRule, GetShell().GetDoc());
				aSetRule.SetAutoRule( TRUE );
				GetShell().SetCurNumRule( aSetRule );
			}
		}
		else if(RET_USER == nRet)
			GetShell().DelNumRules();

		delete pDlg;
	}
	break;
	default:
		ASSERT(FALSE,  falscher Dispatcher);
		return;
	}
}


