/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * CSVTokenizerTest
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */


package org.pentaho.reporting.libraries.util;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

/**
 * @author Thomas Morgner
 * @author Rob Edgeler
 */
public class CSVTokenizerTest  extends TestCase
{
  public CSVTokenizerTest(final String name)
  {
    super(name);
  }

  public void testHasMoreTokens()
  {
    CSVTokenizer tokeniser = new CSVTokenizer("", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertTrue("Should have no more tokens.", (!tokeniser.hasMoreTokens()));

    tokeniser = new CSVTokenizer("a,b,c", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("a", tokeniser.nextToken());
    assertEquals("b", tokeniser.nextToken());
    assertEquals("c", tokeniser.nextToken());

    tokeniser = new CSVTokenizer(",b,c", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("", tokeniser.nextToken());
    assertEquals("b", tokeniser.nextToken());
    assertEquals("c", tokeniser.nextToken());

    tokeniser = new CSVTokenizer("a,,c", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("a", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());
    assertEquals("c", tokeniser.nextToken());

    tokeniser = new CSVTokenizer("a,b,", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("a", tokeniser.nextToken());
    assertEquals("b", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());

    tokeniser = new CSVTokenizer(",,", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());

    tokeniser = new CSVTokenizer("\"\",\"\",\"\"", CSVTokenizer.SEPARATOR_COMMA,
            CSVTokenizer.DOUBLE_QUATE);
    assertEquals("Should count tokens correctly", 3, tokeniser.countTokens());
    assertEquals("", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());
    assertEquals("", tokeniser.nextToken());
  }

  /** @return a <code>TestSuite</code> */
  public static Test suite()
  {
    final TestSuite suite = new TestSuite();
    suite.setName("Test for CSVTokenizer.");
    suite.addTest(new CSVTokenizerTest("testHasMoreTokens"));
    return suite;
  }

}
