/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * SVGDrawable.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.apache.batik.gvt.GraphicsNode;

/**
 * Creation-Date: 21.12.2005, 20:25:29
 *
 * @author Thomas Morgner
 */
public class SVGDrawable
{
  private GraphicsNode rootNode;
  private int width;
  private int height;

  public SVGDrawable(final GraphicsNode rootNode)
  {
    if (rootNode == null)
    {
      throw new NullPointerException();
    }
    this.rootNode = rootNode;
    final Rectangle2D bounds = rootNode.getBounds();
    this.width = (int) bounds.getWidth();
    this.height = (int) bounds.getHeight();
  }

  /**
   * Returns the preferred size of the drawable. If the drawable is aspect ratio
   * aware, these bounds should be used to compute the preferred aspect ratio
   * for this drawable.
   *
   * @return the preferred size.
   */
  public Dimension getPreferredSize()
  {
    return new Dimension(width, height);
  }

  /**
   * Returns true, if this drawable will preserve an aspect ratio during the
   * drawing.
   *
   * @return true, if an aspect ratio is preserved, false otherwise.
   */
  public boolean isPreserveAspectRatio()
  {
    return true;
  }

  /**
   * Draws the object.
   *
   * @param g   the graphics device.
   * @param area the area inside which the object should be drawn.
   */
  public void draw(final Graphics2D g, final Rectangle2D area)
  {
    final Graphics2D g2 = (Graphics2D) g.create();
    try
    {
      g2.translate(-area.getX(), -area.getY());
      final double sx = area.getWidth() / width;
      final double sy = area.getHeight() / height;
      final double sm = Math.min (sx, sy);
      g2.scale(sm, sm);

      rootNode.paint(g2);
    }
    finally
    {
      g2.dispose();
    }
  }
}
