/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api;

import com.ogprover.api.OGPAPI;
import com.ogprover.api.converter.GGThmConverterForAlgebraicProvers;
import com.ogprover.api.converter.GGThmConverterForAreaMethod;
import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.geogebra.GeoGebraTheorem;
import com.ogprover.main.OGPParameters;
import com.ogprover.main.OGPReport;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.GeoTheorem;
import com.ogprover.pp.GeoGebraOGPInputProverProtocol;
import com.ogprover.pp.GeoGebraOGPOutputProverProtocol;
import com.ogprover.pp.OGPInputProverProtocol;
import com.ogprover.pp.OGPOutputProverProtocol;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.thmprover.AreaMethodProver;
import com.ogprover.thmprover.TheoremProver;
import com.ogprover.thmprover.WuMethodProver;
import com.ogprover.utilities.OGPTimer;
import com.ogprover.utilities.OGPUtilities;
import com.ogprover.utilities.Stopwatch;
import com.ogprover.utilities.io.LaTeXFileWriter;
import com.ogprover.utilities.io.OGPDocHandler;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.io.QDParser;
import com.ogprover.utilities.io.XMLFileWriter;
import com.ogprover.utilities.logger.GeoGebraLogger;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.io.StringReader;

public class GeoGebraOGPInterface
implements OGPAPI {
    public static final String VERSION_NUM = "1.00";

    private OGPOutputProverProtocol exitProver(GeoGebraOGPOutputProverProtocol outputObject, String errorMsg) {
        OpenGeoProver.settings.getOutput().close();
        outputObject.setOutputResult("success", "false");
        outputObject.setOutputResult("failureMessage", errorMsg);
        OpenGeoProver.settings.getTimer().cancel();
        return outputObject;
    }

    private boolean populateParameters(GeoGebraOGPInputProverProtocol inputObject) {
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        ILogger logger = OpenGeoProver.settings.getLogger();
        String method = inputObject.getIntputParameter("method");
        if (method.equals("WU")) {
            parameters.putProver(0);
        } else if (method.equals("GROEBNER")) {
            parameters.putProver(1);
        } else if (method.equals("AREA")) {
            parameters.putProver(2);
        } else {
            logger.error("Unknown prover method");
            return false;
        }
        double timeLimitInMilliSec = Double.parseDouble(inputObject.getIntputParameter("timeout")) * 1000.0;
        if (timeLimitInMilliSec > 0.0) {
            parameters.putTimeLimit(timeLimitInMilliSec);
        } else {
            logger.warn("Incorrect timeout prover parameter - setting default timeout of 10000 milliseconds.");
            parameters.putTimeLimit(Double.parseDouble("10000"));
        }
        int maxTerms = Integer.parseInt(inputObject.getIntputParameter("maxterms"));
        if (maxTerms > 0) {
            parameters.putSpaceLimit(maxTerms);
        } else {
            logger.warn("Incorrect maximal number of terms as prover parameter - setting default number of 2000 terms.");
            parameters.putSpaceLimit(Integer.parseInt("2000"));
        }
        String reportFormat = inputObject.getIntputParameter("reportFormat");
        if (reportFormat.equals("TEX")) {
            parameters.putOutputFormat("L");
        } else if (reportFormat.equals("XML")) {
            parameters.putOutputFormat("X");
        } else if (reportFormat.equals("ALL")) {
            parameters.putOutputFormat("A");
        } else if (reportFormat.equals("NONE")) {
            parameters.putOutputFormat("N");
        } else {
            logger.warn("Incorrect parameter for format of output report - setting default value of A");
            parameters.putOutputFormat("A");
        }
        ((GeoGebraLogger)logger).setLogLevel(parameters.getLogLevel());
        return true;
    }

    private boolean readGeometryTheorem(GeoGebraOGPInputProverProtocol inputObject, OGPTP theoremProtocol) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        StringReader sr = new StringReader(inputObject.getGeometryTheoremText());
        OGPDocHandler dh = new OGPDocHandler();
        QDParser qdParser = new QDParser();
        try {
            qdParser.parse(dh, sr);
        }
        catch (Exception e) {
            logger.error("Parser exception caught: " + e.toString());
            e.printStackTrace();
            return false;
        }
        if (!dh.isSuccess()) {
            logger.error("Failed to parse geometry theorem");
            return false;
        }
        GeoGebraTheorem ggThm = dh.getTheorem();
        GeoGebraTheoremConverter thmCnv = null;
        int proverType = OpenGeoProver.settings.getParameters().getProver();
        if (!(proverType != 0 && proverType != 1 || (thmCnv = new GGThmConverterForAlgebraicProvers(ggThm, theoremProtocol)).convert())) {
            logger.error("Failed to convert geometry theorem");
            return false;
        }
        if (proverType == 2 && !(thmCnv = new GGThmConverterForAreaMethod(ggThm, theoremProtocol)).convert()) {
            logger.error("Failed to convert geometry theorem");
            return false;
        }
        return true;
    }

    @Override
    public OGPOutputProverProtocol prove(OGPInputProverProtocol proverInput) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        Stopwatch stopwatch = OpenGeoProver.settings.getStopwacth();
        OGPTP thmProtocol = new OGPTP();
        int retCode = 0;
        GeoTheorem theorem = null;
        OpenGeoProver.settings.setParsedTP(null);
        GeoGebraOGPOutputProverProtocol outputObject = new GeoGebraOGPOutputProverProtocol();
        outputObject.setOutputResult("success", "true");
        if (!(proverInput instanceof GeoGebraOGPInputProverProtocol)) {
            return this.exitProver(outputObject, "Incorrect input object");
        }
        GeoGebraOGPInputProverProtocol inputObject = (GeoGebraOGPInputProverProtocol)proverInput;
        if (!this.populateParameters(inputObject)) {
            return this.exitProver(outputObject, "Failed in reading input prover parameters");
        }
        int proverType = parameters.getProver();
        logger.info("Reading input geometry problem...");
        if (!this.readGeometryTheorem(inputObject, thmProtocol)) {
            return this.exitProver(outputObject, "Failed in reading input geometry theorem");
        }
        OpenGeoProver.settings.setParsedTP(thmProtocol);
        if (parameters.createReport()) {
            String outputFmt = parameters.getOutputFormat();
            String outputFile = parameters.getOutputFile();
            LaTeXFileWriter latexWriter = null;
            XMLFileWriter xmlWriter = null;
            if (outputFile == null) {
                logger.error("Missing output file name");
                return this.exitProver(outputObject, "Failed to create output files");
            }
            if (!(outputFmt.equals("A") || outputFmt.equals("L") || outputFmt.equals("X"))) {
                logger.error("Invalid format of output file");
                return this.exitProver(outputObject, "Failed to create output files");
            }
            if (outputFmt.equals("A") || outputFmt.equals("L")) {
                try {
                    latexWriter = new LaTeXFileWriter(outputFile);
                }
                catch (IOException e) {
                    logger.error("Failed to open LaTeX output file.");
                    if (latexWriter != null) {
                        latexWriter.close();
                    }
                    latexWriter = null;
                }
            }
            if (outputFmt.equals("A") || outputFmt.equals("X")) {
                try {
                    xmlWriter = new XMLFileWriter(outputFile);
                }
                catch (IOException e) {
                    logger.error("Failed to open XML output file.");
                    if (xmlWriter != null) {
                        xmlWriter.close();
                    }
                    xmlWriter = null;
                }
            }
            output = new OGPOutput(latexWriter, xmlWriter);
            OpenGeoProver.settings.setOutput(output);
        }
        OGPReport report = new OGPReport(thmProtocol);
        report.openReport();
        if (!thmProtocol.isValid()) {
            output.close();
            return this.exitProver(outputObject, "Theorem protocol is invalid");
        }
        Double conversionToAlgFormTime = 0.0;
        if (proverType == 0 || proverType == 1) {
            stopwatch.startMeasureTime();
            try {
                output.openSection("Transformation of Construction Protocol to algebraic form");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return this.exitProver(outputObject, "Failed writing to output files");
            }
            retCode = thmProtocol.convertToAlgebraicForm();
            if (retCode != 0) {
                output.close();
                return this.exitProver(outputObject, "Failed conversion of geometry theorem to algebraic form");
            }
            theorem = thmProtocol.getAlgebraicGeoTheorem();
            OpenGeoProver.settings.getStopwacth().endMeasureTime();
            conversionToAlgFormTime = OGPUtilities.roundUpToPrecision(stopwatch.getTimeIntSec());
            outputObject.setOutputResult("time", conversionToAlgFormTime.toString());
            try {
                output.openSubSection("Time spent for transformation of Construction Protocol to algebraic form", false);
                output.openEnum("itemize");
                output.openItem();
                output.writePlainText(conversionToAlgFormTime + " seconds");
                output.closeItem();
                output.closeEnum("itemize");
                output.closeSubSection();
                output.closeSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return this.exitProver(outputObject, "Failed writing to output files");
            }
        }
        logger.info("Invoking prover method...");
        TheoremProver proverMethod = null;
        OGPTimer timer = OpenGeoProver.settings.getTimer();
        if (proverType == 0) {
            proverMethod = new WuMethodProver(theorem);
        }
        if (proverType == 2) {
            proverMethod = new AreaMethodProver(thmProtocol);
        }
        timer.setTimer(parameters.getTimeLimit());
        stopwatch.startMeasureTime();
        retCode = proverMethod.prove();
        stopwatch.endMeasureTime();
        timer.cancel();
        logger.info("Prover results:\n");
        report.printProverResults(retCode, outputObject);
        return outputObject;
    }
}

