/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GeoGebraConstructionConverter;
import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.geogebra.command.construction.GeoGebraConstructionCommand;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.geoconstruction.AngleBisector;
import com.ogprover.pp.tp.geoconstruction.CenterOfCircle;
import com.ogprover.pp.tp.geoconstruction.CentralSymmetricPoint;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndPoint;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndRadius;
import com.ogprover.pp.tp.geoconstruction.CircleWithDiameter;
import com.ogprover.pp.tp.geoconstruction.CircumscribedCircle;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.ConicSectionWithFivePoints;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.GeneralConicSection;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.InverseOfPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.ListOfConstructions;
import com.ogprover.pp.tp.geoconstruction.MidPoint;
import com.ogprover.pp.tp.geoconstruction.ParallelLine;
import com.ogprover.pp.tp.geoconstruction.PerpendicularBisector;
import com.ogprover.pp.tp.geoconstruction.PerpendicularLine;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.Polar;
import com.ogprover.pp.tp.geoconstruction.Pole;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromGeneralConic;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromLine;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.pp.tp.geoconstruction.ReflectedPoint;
import com.ogprover.pp.tp.geoconstruction.RotatedPoint;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoconstruction.ShortcutConstruction;
import com.ogprover.pp.tp.geoconstruction.TangentLine;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.pp.tp.geoobject.PolygonLine;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.Vector;

public class GGConsConverterForAlgebraicProvers
extends GeoGebraConstructionConverter {
    public static final String VERSION_NUM = "1.00";

    public GGConsConverterForAlgebraicProvers(GeoGebraTheoremConverter ggThmCnv) {
        super(ggThmCnv);
    }

    @Override
    protected GeoConstruction convertFreePointCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 0, 0, 1, 1)) {
            logger.error("Failed to validate command: FreePoint");
            return null;
        }
        return new FreePoint(ggCmd.getGeoObjectLabel());
    }

    @Override
    protected GeoConstruction convertPointCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 1, 1, 1)) {
            logger.error("Failed to validate command: Point");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.get(0).contains("Circle[")) {
                return new FreePoint(oArgs.get(0));
            }
            GeoConstruction gc = this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            if (gc != null) {
                return RandomPointFromSetOfPoints.createRandomPoint(oArgs.get(0), (SetOfPoints)((Object)gc));
            }
            GeoObject gobj = (GeoObject)this.auxiliaryObjectsMap.get(iArgs.get(0));
            if (gobj != null && gobj instanceof PolygonLine) {
                return new RandomPointFromLine(oArgs.get(0), (Line)this.thmProtocol.getConstructionMap().get(((PolygonLine)gobj).getEdgesLabels().get(0)));
            }
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPointInCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 1, 1, 1)) {
            logger.error("Failed to validate command: PointIn");
            return null;
        }
        ArrayList<String> oArgs = ggCmd.getOutputArgs();
        return new FreePoint(oArgs.get(0));
    }

    private Line findPerpLine(Line baseLine, Point perpLinePt) {
        Line pl;
        Line plBaseLine;
        Line paraLBaseLine;
        ParallelLine paraL;
        Line perpL;
        Line perpLBaseLine = null;
        if (baseLine instanceof PerpendicularLine) {
            perpL = (PerpendicularLine)baseLine;
            perpLBaseLine = ((PerpendicularLine)perpL).getBaseLine();
        } else if (baseLine instanceof PerpendicularBisector) {
            perpL = (PerpendicularBisector)baseLine;
            Point ptA = ((PerpendicularBisector)perpL).getSegment().getFirstEndPoint();
            Point ptB = ((PerpendicularBisector)perpL).getSegment().getSecondEndPoint();
            for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
                Line l;
                Vector<Point> pts;
                if (!(gc instanceof Line) || !(pts = (l = (Line)gc).getPoints()).contains(ptA) || !pts.contains(ptB)) continue;
                perpLBaseLine = l;
                break;
            }
        }
        if (perpLBaseLine != null) {
            if (perpLBaseLine.getPoints().contains(perpLinePt)) {
                return perpLBaseLine;
            }
            if (perpLBaseLine instanceof ParallelLine) {
                paraL = (ParallelLine)perpLBaseLine;
                paraLBaseLine = paraL.getBaseLine();
                if (paraLBaseLine.getPoints().contains(perpLinePt)) {
                    return paraLBaseLine;
                }
            } else {
                for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
                    if (!(gc instanceof ParallelLine) || (plBaseLine = ((ParallelLine)(pl = (ParallelLine)gc)).getBaseLine()).getGeoObjectLabel() != perpLBaseLine.getGeoObjectLabel() || !pl.getPoints().contains(perpLinePt)) continue;
                    return plBaseLine;
                }
            }
        } else if (baseLine instanceof ParallelLine) {
            paraL = (ParallelLine)baseLine;
            paraLBaseLine = paraL.getBaseLine();
            if (paraLBaseLine instanceof PerpendicularLine) {
                PerpendicularLine perpL2 = (PerpendicularLine)paraLBaseLine;
                Line perpLBaseLine2 = perpL2.getBaseLine();
                if (perpLBaseLine2.getPoints().contains(perpLinePt)) {
                    return perpLBaseLine2;
                }
            } else {
                for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
                    PerpendicularLine pl2;
                    Line plBaseLine2;
                    if (!(gc instanceof PerpendicularLine) || (plBaseLine2 = (pl2 = (PerpendicularLine)gc).getBaseLine()).getGeoObjectLabel() != paraLBaseLine.getGeoObjectLabel() || !pl2.getPoints().contains(perpLinePt)) continue;
                    return plBaseLine2;
                }
            }
        } else {
            for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
                if (!(gc instanceof PerpendicularLine) || (plBaseLine = ((PerpendicularLine)(pl = (PerpendicularLine)gc)).getBaseLine()).getGeoObjectLabel() != baseLine.getGeoObjectLabel() || !plBaseLine.getPoints().contains(perpLinePt)) continue;
                return plBaseLine;
            }
        }
        return null;
    }

    private Point findIntersectionPointOfTwoLines(Line line1, Line line2) {
        for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
            IntersectionPoint intPt;
            if (!(gc instanceof IntersectionPoint) || ((intPt = (IntersectionPoint)gc).getFirstPointSet().getGeoObjectLabel() != line1.getGeoObjectLabel() || intPt.getSecondPointSet().getGeoObjectLabel() != line2.getGeoObjectLabel()) && (intPt.getFirstPointSet().getGeoObjectLabel() != line2.getGeoObjectLabel() || intPt.getSecondPointSet().getGeoObjectLabel() != line1.getGeoObjectLabel())) continue;
            return intPt;
        }
        return null;
    }

    @Override
    protected GeoConstruction convertIntersectCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, -1)) {
            logger.error("Failed to validate command: Intersect");
            return null;
        }
        try {
            IntersectionPoint intPt1;
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            SetOfPoints firstSet = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(0)));
            SetOfPoints secondSet = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(1)));
            IntersectionPoint intersectionPoint = intPt1 = oArgs.get(0) != null && oArgs.get(0).length() > 0 ? new IntersectionPoint(oArgs.get(0), firstSet, secondSet) : null;
            if (intPt1 == null) {
                logger.error("Failed to contruct first intersection point");
                return null;
            }
            if (oArgs.size() == 1) {
                return intPt1;
            }
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            Vector<String> ptLabelList = new Vector<String>();
            for (String ptLabel : oArgs) {
                if (ptLabel == null || ptLabel.length() <= 0) continue;
                ptLabelList.add(ptLabel);
            }
            if (ptLabelList.size() == 1) {
                return intPt1;
            }
            consList.add(intPt1);
            if (ptLabelList.size() == 2) {
                String pt2Label = (String)ptLabelList.get(1);
                if (firstSet instanceof Circle) {
                    Circle c1 = (Circle)firstSet;
                    Point center1 = c1.getCenter();
                    if (center1 == null) {
                        CenterOfCircle shCenter1 = new CenterOfCircle("center-" + c1.getGeoObjectLabel(), c1);
                        consList.addAll(shCenter1.getShortcutListOfConstructions());
                        center1 = shCenter1.getPoint();
                    }
                    if (secondSet instanceof Line) {
                        Line l2 = (Line)secondSet;
                        if (l2.getPoints().contains(center1)) {
                            consList.add(new CentralSymmetricPoint(pt2Label, intPt1, center1));
                        } else {
                            Point ip;
                            Line n12 = this.findPerpLine(l2, center1);
                            if (n12 == null) {
                                n12 = new PerpendicularLine("perpLine-" + center1.getGeoObjectLabel() + "-" + l2.getGeoObjectLabel(), l2, center1);
                                consList.add(n12);
                            }
                            if ((ip = this.findIntersectionPointOfTwoLines(l2, n12)) == null) {
                                ip = new IntersectionPoint("intPt-" + l2.getGeoObjectLabel() + "-" + n12.getGeoObjectLabel(), l2, n12);
                                consList.add(ip);
                            }
                            consList.add(new CentralSymmetricPoint(pt2Label, intPt1, ip));
                        }
                    } else if (secondSet instanceof Circle) {
                        Circle c2 = (Circle)secondSet;
                        Point center2 = c2.getCenter();
                        if (center2 == null) {
                            CenterOfCircle shCenter2 = new CenterOfCircle("center-" + c2.getGeoObjectLabel(), c2);
                            consList.addAll(shCenter2.getShortcutListOfConstructions());
                            center2 = shCenter2.getPoint();
                        }
                        LineThroughTwoPoints centerLine = new LineThroughTwoPoints("centerLine-" + center1.getGeoObjectLabel() + "-" + center2.getGeoObjectLabel(), center1, center2);
                        consList.add(centerLine);
                        Line n12 = this.findPerpLine(centerLine, intPt1);
                        if (n12 != null) {
                            Point ip = this.findIntersectionPointOfTwoLines(centerLine, n12);
                            if (ip == null) {
                                ip = new IntersectionPoint("intPt-" + centerLine.getGeoObjectLabel() + "-" + n12.getGeoObjectLabel(), centerLine, n12);
                                consList.add(ip);
                            }
                            consList.add(new CentralSymmetricPoint(pt2Label, intPt1, ip));
                        } else {
                            ReflectedPoint shRP2 = new ReflectedPoint(pt2Label, intPt1, centerLine);
                            consList.addAll(shRP2.getShortcutListOfConstructions());
                        }
                    } else {
                        consList.add(new IntersectionPoint(pt2Label, firstSet, secondSet));
                    }
                } else if (secondSet instanceof Circle) {
                    Circle c2 = (Circle)secondSet;
                    Point center2 = c2.getCenter();
                    if (center2 == null) {
                        CenterOfCircle shCenter2 = new CenterOfCircle("center-" + c2.getGeoObjectLabel(), c2);
                        consList.addAll(shCenter2.getShortcutListOfConstructions());
                        center2 = shCenter2.getPoint();
                    }
                    if (firstSet instanceof Line) {
                        Line l1 = (Line)firstSet;
                        if (l1.getPoints().contains(center2)) {
                            consList.add(new CentralSymmetricPoint(pt2Label, intPt1, center2));
                        } else {
                            Point ip;
                            Line n21 = this.findPerpLine(l1, center2);
                            if (n21 == null) {
                                n21 = new PerpendicularLine("perpLine-" + center2.getGeoObjectLabel() + "-" + l1.getGeoObjectLabel(), l1, center2);
                                consList.add(n21);
                            }
                            if ((ip = this.findIntersectionPointOfTwoLines(l1, n21)) == null) {
                                ip = new IntersectionPoint("intPt-" + l1.getGeoObjectLabel() + "-" + n21.getGeoObjectLabel(), l1, n21);
                                consList.add(ip);
                            }
                            consList.add(new CentralSymmetricPoint(pt2Label, intPt1, ip));
                        }
                    } else {
                        consList.add(new IntersectionPoint(pt2Label, firstSet, secondSet));
                    }
                } else {
                    consList.add(new IntersectionPoint(pt2Label, firstSet, secondSet));
                }
            } else {
                int jj = ptLabelList.size();
                for (int ii = 1; ii < jj; ++ii) {
                    consList.add(new IntersectionPoint((String)ptLabelList.get(ii), firstSet, secondSet));
                }
            }
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertMidpointCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 2, 1, 1)) {
            logger.error("Failed to validate command: Midpoint");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.size() == 1) {
                Line s = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Vector<Point> points = s.getPoints();
                return new MidPoint(oArgs.get(0), points.get(0), points.get(1));
            }
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new MidPoint(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCenterCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 1, 1, 1)) {
            logger.error("Failed to validate command: Center");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(0)));
            if (!(conic instanceof Circle)) {
                logger.error("Can't construct center on object which is not circle and conic section.");
                return null;
            }
            Circle c = (Circle)conic;
            return new CenterOfCircle(oArgs.get(0), c);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Line");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            GeoObject obj2 = this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            if (obj2 instanceof Point) {
                return new LineThroughTwoPoints(oArgs.get(0), pt1, (Point)obj2);
            }
            return new ParallelLine(oArgs.get(0), (Line)obj2, pt1);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertOrthogonalLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: OrthogonalLine");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Line line = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new PerpendicularLine(oArgs.get(0), line, pt);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertLineBisectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 2, 1, 1)) {
            logger.error("Failed to validate command: LineBisector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.size() == 1) {
                Line s = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Vector<Point> points = s.getPoints();
                return new PerpendicularBisector(oArgs.get(0), points.get(0), points.get(1));
            }
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new PerpendicularBisector(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertAngularBisectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: AngularBisector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point ptRay1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point ptVertex = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point ptRay2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            return new AngleBisector(oArgs.get(0), ptRay1, ptVertex, ptRay2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertTangentCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 2, 2)) {
            logger.error("Failed to validate command: Tangent");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(1)));
            if (!(conic instanceof Circle) && !(conic instanceof ConicSection)) {
                logger.error("Can't construct tangent on object which is not circle and conic section.");
                return null;
            }
            String tanLabel1 = oArgs.get(0);
            String tanLabel2 = oArgs.get(1);
            if (tanLabel2.length() == 0) {
                return new TangentLine(tanLabel1, pt, conic);
            }
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            consList.add(new TangentLine(tanLabel1, pt, conic));
            consList.add(new TangentLine(tanLabel2, pt, conic));
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPolarCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Polar");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(1)));
            if (!(conic instanceof Circle) && !(conic instanceof ConicSection)) {
                logger.error("Can't construct polar on object which is not circle and conic section.");
                return null;
            }
            return new Polar(oArgs.get(0), pt, conic);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertDiameterCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Diameter");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Line line = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(1)));
            if (!(conic instanceof Circle)) {
                logger.error("Can't construct diameter line on object which is not circle and conic section.");
                return null;
            }
            Circle c = (Circle)conic;
            CenterOfCircle center = new CenterOfCircle(GeoGebraConstructionConverter.generateRandomLabel(c.getGeoObjectLabel() + "_center"), c);
            Pole pole = new Pole(GeoGebraConstructionConverter.generateRandomLabel(line.getGeoObjectLabel() + "_pole"), line, c);
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            for (GeoConstruction gc : center.getShortcutListOfConstructions()) {
                consList.add(gc);
            }
            for (GeoConstruction gc : pole.getShortcutListOfConstructions()) {
                consList.add(gc);
            }
            consList.add(new LineThroughTwoPoints(oArgs.get(0), ((ShortcutConstruction)center).getPoint(), ((ShortcutConstruction)pole).getPoint()));
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, 1)) {
            logger.error("Failed to validate command: Circle");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.size() == 3) {
                Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
                Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
                return new CircumscribedCircle(oArgs.get(0), pt1, pt2, pt3);
            }
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            String label2 = iArgs.get(1);
            if (label2.startsWith("Segment[")) {
                int pt1Idx = label2.indexOf("[") + 1;
                int commaIdx = label2.indexOf(",");
                int pt2Idx = commaIdx + 2;
                int rbracIdx = label2.indexOf("]");
                String pt1Label = label2.substring(pt1Idx, commaIdx);
                String pt2Label = label2.substring(pt2Idx, rbracIdx);
                Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(pt1Label);
                Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(pt2Label);
                return new CircleWithCenterAndRadius(oArgs.get(0), pt, pt1, pt2);
            }
            GeoObject geoObj = this.thmProtocol.getConstructionMap().get(label2);
            if (geoObj == null) {
                try {
                    Integer.parseInt(label2);
                    Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
                    FreePoint pt1 = new FreePoint(GeoGebraConstructionConverter.generateRandomLabel(oArgs.get(0) + "_pt"));
                    consList.add(pt1);
                    consList.add(new CircleWithCenterAndPoint(oArgs.get(0), pt, pt1));
                    return new ListOfConstructions(consList);
                }
                catch (NumberFormatException ex) {
                    logger.error("Incorrect second input argument for construction of circle.");
                    return null;
                }
            }
            if (geoObj instanceof Line) {
                Line l = (Line)geoObj;
                Vector<Point> points = l.getPoints();
                return new CircleWithCenterAndRadius(oArgs.get(0), pt, points.get(0), points.get(1));
            }
            return new CircleWithCenterAndPoint(oArgs.get(0), pt, (Point)geoObj);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertConicCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 5, 5, 1, 1)) {
            logger.error("Failed to validate command: Conic");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            Point pt4 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(3));
            Point pt5 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(4));
            return new ConicSectionWithFivePoints(oArgs.get(0), pt1, pt2, pt3, pt4, pt5);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertEllipseCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: Ellipse");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point conicPt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            this.constructionsToRemove.add(conicPt);
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            GeneralConicSection conic = new GeneralConicSection(oArgs.get(0));
            consList.add(conic);
            consList.add(new RandomPointFromGeneralConic(conicPt.getGeoObjectLabel(), conic));
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertHyperbolaCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: Hyperbola");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point conicPt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            this.constructionsToRemove.add(conicPt);
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            GeneralConicSection conic = new GeneralConicSection(oArgs.get(0));
            consList.add(conic);
            consList.add(new RandomPointFromGeneralConic(conicPt.getGeoObjectLabel(), conic));
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertParabolaCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Parabola");
            return null;
        }
        ArrayList<String> oArgs = ggCmd.getOutputArgs();
        return new GeneralConicSection(oArgs.get(0));
    }

    private Point getPointFromConstruction(GeoConstruction gc) {
        if (gc == null) {
            return null;
        }
        if (gc instanceof Point) {
            return (Point)gc;
        }
        if (gc instanceof ShortcutConstruction) {
            return ((ShortcutConstruction)gc).getPoint();
        }
        return null;
    }

    private Vector<Point> getCommonPointsOfTwoSets(SetOfPoints set1, SetOfPoints set2) {
        Vector<Point> vpts = new Vector<Point>();
        String label1 = set1.getGeoObjectLabel();
        String label2 = set1.getGeoObjectLabel();
        for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
            if (!(gc instanceof IntersectionPoint)) continue;
            IntersectionPoint intP = (IntersectionPoint)gc;
            String intPLabel1 = intP.getFirstPointSet().getGeoObjectLabel();
            String intPLabel2 = intP.getSecondPointSet().getGeoObjectLabel();
            if ((!intPLabel1.equals(label1) || !intPLabel2.equals(label2)) && (!intPLabel1.equals(label2) || !intPLabel2.equals(label1))) continue;
            vpts.add(intP);
        }
        return vpts;
    }

    private GeoConstruction getMirrorPointCons(String mirroredPtLabel, Point originalPt, GeoObject mirrorCenter) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (originalPt == null || mirrorCenter == null) {
            logger.error("Can't mirror - missing some input element");
            return null;
        }
        if (mirroredPtLabel == null || mirroredPtLabel.length() == 0) {
            logger.error("Can't mirror - label of result point is not provided");
            return null;
        }
        if (mirrorCenter instanceof Line) {
            return new ReflectedPoint(mirroredPtLabel, originalPt, (Line)mirrorCenter);
        }
        if (mirrorCenter instanceof Point) {
            return new CentralSymmetricPoint(mirroredPtLabel, originalPt, (Point)mirrorCenter);
        }
        if (mirrorCenter instanceof Circle) {
            return new InverseOfPoint(mirroredPtLabel, originalPt, (Circle)mirrorCenter);
        }
        logger.error("Can't mirror about object which is not line, circle or point");
        return null;
    }

    private Vector<GeoConstruction> mirrorPoints(Vector<Point> ptList, GeoObject mirrorCenter) {
        Vector<GeoConstruction> mptList = new Vector<GeoConstruction>();
        for (Point pt : ptList) {
            String ptLabel = GeoGebraConstructionConverter.generateRandomLabel(pt.getGeoObjectLabel() + "_m");
            GeoConstruction gc = this.getMirrorPointCons(ptLabel, pt, mirrorCenter);
            if (gc == null) {
                return null;
            }
            mptList.add(gc);
        }
        return mptList;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected GeoConstruction convertMirrorCmd(GeoGebraConstructionCommand ggCmd) {
        int siz;
        int jj;
        Vector<String> edges;
        Vector<Point> vertices;
        Vector<GeoConstruction> mpts;
        String oLabel;
        Vector<GeoConstruction> consList;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Mirror");
            return null;
        }
        try {
            Vector<Point> ptsToMirror;
            Line line;
            Circle invC;
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            consList = new Vector<GeoConstruction>();
            oLabel = oArgs.get(0);
            if (oLabel.length() == 0) {
                logger.warn("Undefined result of mirror operation");
                return new ListOfConstructions(consList);
            }
            GeoObject objToMirror = this.getGeoObject(iArgs.get(0));
            if (!(objToMirror instanceof Point || objToMirror instanceof Line || objToMirror instanceof PolygonLine || objToMirror instanceof Circle || objToMirror instanceof ConicSection || objToMirror instanceof Segment)) {
                logger.error("Unsupported input object type for mirror operation");
                return null;
            }
            GeoObject mirrorCenter = this.getGeoObject(iArgs.get(1));
            if (!(mirrorCenter instanceof Line || mirrorCenter instanceof Point || mirrorCenter instanceof Circle)) {
                logger.error("Cannot reflect the object about another object which is not a line, point or circle");
                return null;
            }
            String objType = ggCmd.getObjectType();
            if (objType.equals("curvecartesian") || objType.equals("implicitpoly") || objType.equals("")) {
                logger.error("Unsupported output object type for mirror operation");
                return null;
            }
            Point invCCenter = null;
            if (mirrorCenter instanceof Circle && (invCCenter = (invC = (Circle)mirrorCenter).getCenter()) == null) {
                CenterOfCircle sc = new CenterOfCircle(GeoGebraConstructionConverter.generateRandomLabel(invC.getGeoObjectLabel() + "_c"), invC);
                consList.add(sc);
                invCCenter = ((ShortcutConstruction)sc).getPoint();
            }
            if (objToMirror instanceof Point) {
                consList.add(this.getMirrorPointCons(oLabel, (Point)objToMirror, mirrorCenter));
                return new ListOfConstructions(consList);
            }
            if (objToMirror instanceof Line && this.auxiliaryObjectsMap.get(objToMirror.getGeoObjectLabel()) == null) {
                line = (Line)objToMirror;
                ptsToMirror = this.getOrCreatePointsFromPointSet(line, 2, consList);
                if (ptsToMirror == null) {
                    logger.error("Failed to get or create points from set of points " + line.getGeoObjectLabel());
                    return null;
                }
                Vector<GeoConstruction> mpts2 = this.mirrorPoints(ptsToMirror, mirrorCenter);
                if (mpts2 == null) {
                    logger.error("Failed to mirror point list");
                    return null;
                }
                consList.addAll(mpts2);
                Point mpt1 = this.getPointFromConstruction(mpts2.get(0));
                Point point = this.getPointFromConstruction(mpts2.get(1));
                if (!(mirrorCenter instanceof Circle)) {
                    consList.add(new LineThroughTwoPoints(oLabel, mpt1, point));
                    return new ListOfConstructions(consList);
                }
                if (ggCmd.getObjectType().equals("line")) {
                    LineThroughTwoPoints mline = new LineThroughTwoPoints(oLabel, mpt1, point);
                    if (invCCenter != null) {
                        mline.addPointToSet(invCCenter);
                    }
                    consList.add(mline);
                    mline.getPoints().addAll(line.getPoints());
                    Vector<Point> linePts = line.getPoints();
                    linePts.add(mpt1);
                    linePts.add(point);
                    if (linePts.indexOf(invCCenter) >= 0) return new ListOfConstructions(consList);
                    linePts.add(invCCenter);
                    return new ListOfConstructions(consList);
                }
                if (ggCmd.getObjectType().equals("conic")) {
                    CircumscribedCircle mcircle = new CircumscribedCircle(oLabel, mpt1, point, invCCenter);
                    consList.add(mcircle);
                    mcircle.getPoints().addAll(this.getCommonPointsOfTwoSets(line, (Circle)mirrorCenter));
                    return new ListOfConstructions(consList);
                }
                logger.error("Incorrect output object type for circle inversion of line " + line.getGeoObjectLabel());
                return null;
            }
            if (objToMirror instanceof Circle) {
                Circle circle = (Circle)objToMirror;
                ptsToMirror = this.getOrCreatePointsFromPointSet(circle, 3, consList);
                if (ptsToMirror == null) {
                    logger.error("Failed to get or create points from set of points " + circle.getGeoObjectLabel());
                    return null;
                }
                Vector<GeoConstruction> mpts3 = this.mirrorPoints(ptsToMirror, mirrorCenter);
                if (mpts3 == null) {
                    logger.error("Failed to mirror point list");
                    return null;
                }
                consList.addAll(mpts3);
                Point mpt1 = this.getPointFromConstruction(mpts3.get(0));
                Point point = this.getPointFromConstruction(mpts3.get(1));
                Point mpt3 = this.getPointFromConstruction(mpts3.get(2));
                if (!(mirrorCenter instanceof Circle)) {
                    consList.add(new LineThroughTwoPoints(oLabel, mpt1, point));
                    return new ListOfConstructions(consList);
                }
                if (ggCmd.getObjectType().equals("line")) {
                    LineThroughTwoPoints mline = new LineThroughTwoPoints(oLabel, mpt1, point);
                    mline.addPointToSet(mpt3);
                    consList.add(mline);
                    Vector<Point> circlePts = circle.getPoints();
                    if (circlePts.indexOf(invCCenter) < 0) {
                        circlePts.add(invCCenter);
                    }
                    mline.getPoints().addAll(this.getCommonPointsOfTwoSets(circle, (Circle)mirrorCenter));
                    return new ListOfConstructions(consList);
                }
                if (ggCmd.getObjectType().equals("conic")) {
                    CircumscribedCircle mcircle = new CircumscribedCircle(oLabel, mpt1, point, invCCenter);
                    mcircle.getPoints().addAll(this.getCommonPointsOfTwoSets(circle, (Circle)mirrorCenter));
                    consList.add(mcircle);
                    return new ListOfConstructions(consList);
                }
                logger.error("Incorrect output object type for circle inversion of circle " + circle.getGeoObjectLabel());
                return null;
            }
            if (objToMirror instanceof PolygonLine) {
                PolygonLine p = (PolygonLine)objToMirror;
                mpts = this.mirrorPoints(p.getPoints(), mirrorCenter);
                if (mpts == null) {
                    logger.error("Failed to mirror point list");
                    return null;
                }
            } else {
                if (objToMirror instanceof ConicSection) {
                    consList.add(new GeneralConicSection(oLabel));
                    return new ListOfConstructions(consList);
                }
                if (objToMirror instanceof Line && this.auxiliaryObjectsMap.get(objToMirror.getGeoObjectLabel()) != null) {
                    void var15_30;
                    line = (Line)objToMirror;
                    Vector<Point> pts = line.getPoints();
                    Point pt1 = pts.get(0);
                    Point pt2 = pts.get(1);
                    Object var15_27 = null;
                    if (mirrorCenter instanceof Point) {
                        Point point = pt1;
                    } else {
                        if (!(mirrorCenter instanceof Line)) {
                            logger.error("Unable to mirror vector about object which is not point and line");
                            return null;
                        }
                        Line rline = (Line)mirrorCenter;
                        ParallelLine pline = new ParallelLine(GeoGebraConstructionConverter.generateRandomLabel(rline.getGeoObjectLabel() + "_l"), rline, pt1);
                        consList.add(pline);
                        ParallelLine parallelLine = pline;
                    }
                    GeoConstruction mpt2cons = this.getMirrorPointCons(GeoGebraConstructionConverter.generateRandomLabel(pt2.getGeoObjectLabel() + "_m"), pt2, (GeoObject)var15_30);
                    consList.add(mpt2cons);
                    Point mpt2 = this.getPointFromConstruction(mpt2cons);
                    if (mpt2 == null) {
                        logger.error("Failed to get mirrored point" + mpt2cons.getGeoObjectLabel());
                        return null;
                    }
                    consList.add(new LineThroughTwoPoints(oLabel, pt1, mpt2));
                    this.auxiliaryObjectsMap.put(oLabel, new Segment(pt1, mpt2, oLabel));
                    return new ListOfConstructions(consList);
                }
                logger.error("Incorrect type of input object for mirror operation");
                return null;
            }
            consList.addAll(mpts);
            vertices = new Vector<Point>();
            edges = new Vector<String>();
            boolean bl = false;
            jj = 1;
            siz = mpts.size();
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
        while (true) {
            void var15_26;
            if (var15_26 >= siz) {
                this.auxiliaryObjectsMap.put(oLabel, new PolygonLine(vertices, edges, oLabel));
                return new ListOfConstructions(consList);
            }
            GeoConstruction gc1 = mpts.get((int)var15_26);
            GeoConstruction gc2 = mpts.get(jj % siz);
            Point pt1 = this.getPointFromConstruction(gc1);
            if (pt1 == null) {
                logger.error("Failed to get mirrored point");
                return null;
            }
            vertices.add(pt1);
            Point pt2 = this.getPointFromConstruction(gc2);
            if (pt2 == null) {
                logger.error("Failed to get mirrored point");
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(pt1.getGeoObjectLabel());
            sb.append(pt2.getGeoObjectLabel());
            sb.append("_l");
            String lineLabel = GeoGebraConstructionConverter.generateRandomLabel(sb.toString());
            consList.add(new LineThroughTwoPoints(lineLabel, pt1, pt2));
            edges.add(lineLabel);
            ++var15_26;
            ++jj;
        }
    }

    @Override
    protected GeoConstruction convertRotateCmd(GeoGebraConstructionCommand ggCmd) {
        return null;
    }

    @Override
    protected GeoConstruction convertTranslateCmd(GeoGebraConstructionCommand ggCmd) {
        return null;
    }

    @Override
    protected GeoConstruction convertDilateCmd(GeoGebraConstructionCommand ggCmd) {
        return null;
    }

    @Override
    protected GeoConstruction convertSegmentCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Segment");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Segment seg = new Segment(pt1, pt2, oArgs.get(0));
            this.auxiliaryObjectsMap.put(seg.getGeoObjectLabel(), seg);
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertVectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Vector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Segment seg = new Segment(pt1, pt2, oArgs.get(0));
            this.auxiliaryObjectsMap.put(seg.getGeoObjectLabel(), seg);
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertRayCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Ray");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertAngleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, 1)) {
            logger.error("Failed to validate command: Angle");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            if (iArgs.size() == 3) {
                Point ptRay1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Point ptVertex = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
                Point ptRay2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
                Angle ang = new Angle(ptRay1, ptVertex, ptRay2, oArgs.get(0));
                this.auxiliaryObjectsMap.put(ang.getGeoObjectLabel(), ang);
                return new ListOfConstructions(consList);
            }
            Line line1 = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Line line2 = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            GeoConstruction intersecPt = null;
            for (GeoConstruction gc : this.thmProtocol.getConstructionSteps()) {
                if (!(gc instanceof IntersectionPoint)) continue;
                IntersectionPoint intPt = (IntersectionPoint)gc;
                SetOfPoints set1 = intPt.getFirstPointSet();
                SetOfPoints set2 = intPt.getSecondPointSet();
                if ((!set1.getGeoObjectLabel().equals(line1.getGeoObjectLabel()) || !set2.getGeoObjectLabel().equals(line2.getGeoObjectLabel())) && (!set1.getGeoObjectLabel().equals(line2.getGeoObjectLabel()) || !set2.getGeoObjectLabel().equals(line1.getGeoObjectLabel()))) continue;
                intersecPt = intPt;
                break;
            }
            if (intersecPt == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(line1.getGeoObjectLabel());
                sb.append(line2.getGeoObjectLabel());
                sb.append("_pt");
                consList.add(new IntersectionPoint(GeoGebraConstructionConverter.generateRandomLabel(sb.toString()), line1, line2));
            }
            Point pt1 = null;
            for (Point pt : line1.getPoints()) {
                if (pt.getGeoObjectLabel().equals(intersecPt.getGeoObjectLabel())) continue;
                pt1 = pt;
                break;
            }
            if (pt1 == null) {
                consList.add(new RandomPointFromLine(GeoGebraConstructionConverter.generateRandomLabel(line1.getGeoObjectLabel() + "_pt"), line1));
            }
            Point pt2 = null;
            for (Point pt : line2.getPoints()) {
                if (pt.getGeoObjectLabel().equals(intersecPt.getGeoObjectLabel())) continue;
                pt2 = pt;
                break;
            }
            if (pt2 == null) {
                consList.add(new RandomPointFromLine(GeoGebraConstructionConverter.generateRandomLabel(line2.getGeoObjectLabel() + "_pt"), line2));
            }
            Angle ang = new Angle(pt1, (Point)intersecPt, pt2, oArgs.get(0));
            this.auxiliaryObjectsMap.put(ang.getGeoObjectLabel(), ang);
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPolygonCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        logger.info("launching convertPolygonCmd");
        if (!this.validateCmdArguments(ggCmd, 3, -1, 1, -1)) {
            logger.error("Failed to validate command: Polygon");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            String oLabel = oArgs.get(0);
            boolean bIsRegular = false;
            int numVertices = 0;
            Vector<Point> vertices = new Vector<Point>();
            Vector<String> edges = new Vector<String>();
            if (oArgs.size() == 3) {
                try {
                    numVertices = Integer.parseInt(oArgs.get(2));
                    if (numVertices < 3) {
                        logger.error("Incorrect number of vertices passed in for construction of regular polygon");
                        return null;
                    }
                    bIsRegular = true;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (!bIsRegular) {
                numVertices = iArgs.size();
                if (oArgs.size() != numVertices + 1) {
                    logger.error("Incorrect number of output arguments for construction of polygon " + oLabel);
                    return null;
                }
                for (String ptLabel : iArgs) {
                    Point pt = (Point)this.thmProtocol.getConstructionMap().get(ptLabel);
                    vertices.add(pt);
                }
            } else {
                if (oArgs.size() != 2 * numVertices - 1) {
                    logger.error("Incorrect number of output arguments for construction of polygon " + oLabel);
                    return null;
                }
                Point originalPt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Point center = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
                vertices.add(originalPt);
                vertices.add(center);
                double angMeasureInDegrees = (double)(-(numVertices - 2)) * 180.0 / (double)numVertices;
                for (int ii = numVertices + 1; ii < numVertices; ++ii) {
                    RotatedPoint vPt = new RotatedPoint(oArgs.get(ii), originalPt, center, angMeasureInDegrees);
                    vertices.add(vPt);
                    consList.add(vPt);
                    originalPt = center;
                    center = vPt;
                }
            }
            int ii = 0;
            int jj = 1;
            while (ii < numVertices) {
                Point pt1 = (Point)vertices.get(ii);
                Point pt2 = vertices.get(jj % numVertices);
                String lineLabel = oArgs.get(ii + 1);
                consList.add(new LineThroughTwoPoints(lineLabel, pt1, pt2));
                edges.add(lineLabel);
                ++ii;
                ++jj;
            }
            PolygonLine poly = new PolygonLine(vertices, edges, oLabel);
            this.auxiliaryObjectsMap.put(oLabel, poly);
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPolyLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, -1, 1, 1)) {
            logger.error("Failed to validate command: PolyLine");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Vector<GeoConstruction> consList = new Vector<GeoConstruction>();
            String oLabel = oArgs.get(0);
            Vector<Point> vertices = new Vector<Point>();
            Vector<String> edges = new Vector<String>();
            for (String ptLabel : iArgs) {
                Point pt = (Point)this.thmProtocol.getConstructionMap().get(ptLabel);
                vertices.add(pt);
                consList.add(pt);
            }
            int ii = 0;
            int jj = 1;
            int numVertices = iArgs.size();
            while (ii < numVertices) {
                Point pt1 = (Point)vertices.get(ii);
                Point pt2 = vertices.get(jj % numVertices);
                StringBuilder sb = new StringBuilder();
                sb.append(pt1.getGeoObjectLabel());
                sb.append(pt2.getGeoObjectLabel());
                sb.append("_l");
                String lineLabel = GeoGebraConstructionConverter.generateRandomLabel(sb.toString());
                consList.add(new LineThroughTwoPoints(lineLabel, pt1, pt2));
                edges.add(lineLabel);
                ++ii;
                ++jj;
            }
            PolygonLine poly = new PolygonLine(vertices, edges, oLabel);
            this.auxiliaryObjectsMap.put(oLabel, poly);
            return new ListOfConstructions(consList);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircleArcCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircleArc");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new CircleWithCenterAndPoint(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircumcircleArcCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircumcircleArc");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            return new CircumscribedCircle(oArgs.get(0), pt1, pt2, pt3);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircleSectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircleSector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new CircleWithCenterAndPoint(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircumcircleSectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircumcircleSector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            return new CircumscribedCircle(oArgs.get(0), pt1, pt2, pt3);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertSemicircleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Semicircle");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            return new CircleWithDiameter(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }
}

