/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GGConsConverterForAlgebraicProvers;
import com.ogprover.api.converter.GeoGebraConstructionConverter;
import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.geogebra.command.construction.GeoGebraConstructionCommand;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.RatioOfCollinearSegments;
import com.ogprover.pp.tp.geoconstruction.AMFootPoint;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.CenterOfCircle;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndPoint;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IgnoredConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.PRatioPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoconstruction.TRatioPoint;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.ndgcondition.DistinctPoints;
import com.ogprover.pp.tp.ndgcondition.NonParallelLines;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.Vector;

public class GGConsConverterForAreaMethod
extends GGConsConverterForAlgebraicProvers {
    public static final String VERSION_NUM = "1.00";
    public static int lastUsedNumber = 0;

    public GGConsConverterForAreaMethod(GeoGebraTheoremConverter ggThmCnv) {
        super(ggThmCnv);
    }

    @Override
    protected GeoConstruction convertPointCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 1, 1, 1)) {
            logger.error("Failed to validate command: Point");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.get(0).contains("Circle[")) {
                return new FreePoint(oArgs.get(0));
            }
            GeoConstruction gc = this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            if (gc != null) {
                if (gc instanceof LineThroughTwoPoints) {
                    Point point1 = ((Line)gc).getPoints().get(0);
                    Point point2 = ((Line)gc).getPoints().get(1);
                    FreePoint freePoint = new FreePoint(this.nextAvailableName());
                    this.thmProtocol.addGeoConstruction(freePoint);
                    return new AMFootPoint(oArgs.get(0), freePoint, point1, point2);
                }
                if (gc instanceof CircleWithCenterAndPoint) {
                    Point center = ((Circle)gc).getCenter();
                    Point pointOnCircle = ((Circle)gc).getPoints().get(0);
                    FreePoint freePoint = new FreePoint(this.nextAvailableName());
                    this.thmProtocol.addGeoConstruction(freePoint);
                    AMFootPoint footPoint = new AMFootPoint(this.nextAvailableName(), freePoint, center, pointOnCircle);
                    this.thmProtocol.addGeoConstruction(footPoint);
                    RatioOfCollinearSegments ratio = new RatioOfCollinearSegments(center, pointOnCircle, center, footPoint);
                    return new PRatioPoint(oArgs.get(0), center, center, freePoint, ratio);
                }
                if (gc instanceof Line || gc instanceof Circle) {
                    logger.error("Object " + gc.getGeoObjectLabel() + " has not been converted into an area method-compatible class.");
                    return null;
                }
            }
            logger.error("Object " + gc.getGeoObjectLabel() + " can not be used with the area method.");
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertIntersectCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, -1)) {
            logger.error("Failed to validate command: Intersect");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            GeoConstruction firstSet = this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            GeoConstruction secondSet = this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            if (oArgs.size() == 1) {
                if (firstSet instanceof LineThroughTwoPoints && secondSet instanceof LineThroughTwoPoints) {
                    Point point1 = ((Line)firstSet).getPoints().get(0);
                    Point point2 = ((Line)firstSet).getPoints().get(1);
                    Point secondPoint1 = ((Line)secondSet).getPoints().get(0);
                    Point secondPoint2 = ((Line)secondSet).getPoints().get(1);
                    this.thmProtocol.addSimpleNDGCondition(new NonParallelLines(point1, point2, secondPoint1, secondPoint2));
                    return new AMIntersectionPoint(oArgs.get(0), point1, point2, secondPoint1, secondPoint2);
                }
                if (firstSet instanceof CircleWithCenterAndPoint && secondSet instanceof LineThroughTwoPoints) {
                    GeoConstruction temp = firstSet;
                    firstSet = secondSet;
                    secondSet = temp;
                }
                if (firstSet instanceof LineThroughTwoPoints && secondSet instanceof CircleWithCenterAndPoint) {
                    Point point1 = ((Line)firstSet).getPoints().get(0);
                    Point point2 = ((Line)firstSet).getPoints().get(1);
                    Point center = ((Line)secondSet).getPoints().get(0);
                    Point pointOnCircle = ((Line)secondSet).getPoints().get(1);
                    if (point1.equals(pointOnCircle)) {
                        AMFootPoint footPoint = new AMFootPoint(this.nextAvailableName(), center, point1, point2);
                        this.thmProtocol.addGeoConstruction(footPoint);
                        return new PRatioPoint(oArgs.get(0), footPoint, point1, footPoint, new BasicNumber(1));
                    }
                    if (point2.equals(pointOnCircle)) {
                        AMFootPoint footPoint = new AMFootPoint(this.nextAvailableName(), center, point1, point2);
                        this.thmProtocol.addGeoConstruction(footPoint);
                        return new PRatioPoint(oArgs.get(0), footPoint, point2, footPoint, new BasicNumber(1));
                    }
                    logger.error("To use the area method on the intersection between a line and a circle, the line must have been generated using one of two intersection points.");
                    return null;
                }
                if (firstSet instanceof CircleWithCenterAndPoint && secondSet instanceof CircleWithCenterAndPoint) {
                    Point center1 = ((Line)firstSet).getPoints().get(0);
                    Point pointOnCircle1 = ((Line)secondSet).getPoints().get(1);
                    Point center2 = ((Line)firstSet).getPoints().get(0);
                    Point pointOnCircle2 = ((Line)secondSet).getPoints().get(1);
                    if (pointOnCircle1.equals(pointOnCircle2)) {
                        AMFootPoint midPoint = new AMFootPoint(this.nextAvailableName(), pointOnCircle1, center1, center2);
                        this.thmProtocol.addGeoConstruction(midPoint);
                        return new PRatioPoint(oArgs.get(0), midPoint, pointOnCircle1, midPoint, new BasicNumber(1));
                    }
                    logger.error("To use the area method on the intersection between two circles, the two circles must have been generated using the same point");
                    return null;
                }
                if (firstSet instanceof Circle || firstSet instanceof Line) {
                    logger.error("Object " + firstSet.getGeoObjectLabel() + " has not been converted into an area method-compatible class.");
                    return null;
                }
                if (secondSet instanceof Circle || secondSet instanceof Line) {
                    logger.error("Object " + secondSet.getGeoObjectLabel() + " has not been converted into an area method-compatible class.");
                    return null;
                }
                logger.error("The area method cannot deal with intersection between general conics.");
            }
            logger.error("The area method cannot deal with intersection between objects which intersect themselves several times");
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertMidpointCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 2, 1, 1)) {
            logger.error("Failed to validate command: Midpoint");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = null;
            Point pt2 = null;
            if (iArgs.size() == 1) {
                Line s = (Line)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Vector<Point> points = s.getPoints();
                pt1 = points.get(0);
                pt2 = points.get(1);
            }
            if (iArgs.size() == 2) {
                pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            }
            return new PRatioPoint(oArgs.get(0), pt1, pt1, pt2, new Fraction(1, 2));
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCenterCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 1, 1, 1)) {
            logger.error("Failed to validate command: Center");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(0)));
            if (!(conic instanceof Circle)) {
                logger.error("Can't construct center on object which is not circle and conic section.");
                return null;
            }
            if (!(conic instanceof CircleWithCenterAndPoint)) {
                logger.error("Object " + conic.getGeoObjectLabel() + " has not been converted into an area method-compatible class.");
                return null;
            }
            Circle c = (Circle)conic;
            return new CenterOfCircle(oArgs.get(0), c);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Line");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            GeoObject obj2 = this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            if (obj2 instanceof Point) {
                this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, (Point)obj2));
                return new LineThroughTwoPoints(oArgs.get(0), pt1, (Point)obj2);
            }
            LineThroughTwoPoints line = (LineThroughTwoPoints)obj2;
            Point pointOnLine1 = line.getPoints().get(0);
            Point pointOnLine2 = line.getPoints().get(1);
            PRatioPoint aux = new PRatioPoint(this.nextAvailableName(), pt1, pointOnLine1, pointOnLine2, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(aux);
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(aux, pt1));
            return new LineThroughTwoPoints(oArgs.get(0), aux, pt1);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertOrthogonalLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: OrthogonalLine");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            LineThroughTwoPoints line = (LineThroughTwoPoints)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pointOnLine1 = line.getPoints().get(0);
            Point pointOnLine2 = line.getPoints().get(1);
            AMFootPoint footPoint = new AMFootPoint(this.nextAvailableName(), pt, pointOnLine1, pointOnLine2);
            this.thmProtocol.addGeoConstruction(footPoint);
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(footPoint, pt));
            return new LineThroughTwoPoints(oArgs.get(0), footPoint, pt);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertLineBisectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 1, 2, 1, 1)) {
            logger.error("Failed to validate command: LineBisector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = null;
            Point pt2 = null;
            if (iArgs.size() == 1) {
                LineThroughTwoPoints line = (LineThroughTwoPoints)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                pt1 = line.getPoints().get(0);
                pt2 = line.getPoints().get(1);
            } else {
                pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            }
            PRatioPoint midPoint = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt2, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint);
            TRatioPoint aux = new TRatioPoint(this.nextAvailableName(), midPoint, pt2, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(aux);
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(midPoint, aux));
            return new LineThroughTwoPoints(oArgs.get(0), midPoint, aux);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertAngularBisectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: AngularBisector");
            return null;
        }
        try {
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertTangentCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 2, 2)) {
            logger.error("Failed to validate command: Tangent");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            SetOfPoints conic = (SetOfPoints)((Object)this.thmProtocol.getConstructionMap().get(iArgs.get(1)));
            if (!(conic instanceof Circle) && !(conic instanceof ConicSection)) {
                logger.error("Can't construct tangent on object which is not circle and conic section.");
                return null;
            }
            if (!(conic instanceof Circle)) {
                logger.error("Currently, the area method cannot deal with conics.");
                return null;
            }
            String secondLabel = oArgs.get(1);
            if (secondLabel.length() != 0) {
                logger.error("The area method cannot deal with the construction of two tangents at the same time");
                return null;
            }
            CircleWithCenterAndPoint circle = (CircleWithCenterAndPoint)conic;
            Point center = circle.getCenter();
            if (circle.getPoints().contains(pt)) {
                TRatioPoint aux = new TRatioPoint(this.nextAvailableName(), pt, center, new BasicNumber(1));
                this.thmProtocol.addGeoConstruction(aux);
                this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt, aux));
                return new LineThroughTwoPoints(oArgs.get(0), pt, aux);
            }
            logger.error("Invalid input (the point is not on the circle, but only one label is given)");
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPolarCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Polar");
            return null;
        }
        try {
            logger.error("convertPolarCmd() command is not compatible with the area method.");
            return null;
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, 1)) {
            logger.error("Failed to validate command: Circle");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            if (iArgs.size() == 3) {
                Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
                Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
                Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
                PRatioPoint midPoint1 = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt2, new Fraction(1, 2));
                this.thmProtocol.addGeoConstruction(midPoint1);
                TRatioPoint aux1 = new TRatioPoint(this.nextAvailableName(), midPoint1, pt1, new BasicNumber(1));
                this.thmProtocol.addGeoConstruction(aux1);
                PRatioPoint midPoint2 = new PRatioPoint(this.nextAvailableName(), pt2, pt2, pt3, new Fraction(1, 2));
                this.thmProtocol.addGeoConstruction(midPoint2);
                TRatioPoint aux2 = new TRatioPoint(this.nextAvailableName(), midPoint2, pt2, new BasicNumber(1));
                this.thmProtocol.addGeoConstruction(aux2);
                AMIntersectionPoint center = new AMIntersectionPoint(this.nextAvailableName(), midPoint1, aux1, midPoint2, aux2);
                this.thmProtocol.addGeoConstruction(center);
                return new CircleWithCenterAndPoint(oArgs.get(0), center, pt1);
            }
            Point pt = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            String label2 = iArgs.get(1);
            if (label2.startsWith("Segment[")) {
                int pt1Idx = label2.indexOf("[") + 1;
                int commaIdx = label2.indexOf(",");
                int pt2Idx = commaIdx + 2;
                int rbracIdx = label2.indexOf("]");
                String pt1Label = label2.substring(pt1Idx, commaIdx);
                String pt2Label = label2.substring(pt2Idx, rbracIdx);
                Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(pt1Label);
                Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(pt2Label);
                PRatioPoint pointOnCircle = new PRatioPoint(this.nextAvailableName(), pt, pt1, pt2, new BasicNumber(1));
                return new CircleWithCenterAndPoint(oArgs.get(0), pt, pointOnCircle);
            }
            GeoObject geoObj = this.thmProtocol.getConstructionMap().get(label2);
            if (geoObj == null) {
                try {
                    Integer.parseInt(label2);
                    FreePoint pt1 = new FreePoint(this.nextAvailableName());
                    this.thmProtocol.addGeoConstruction(pt1);
                    return new CircleWithCenterAndPoint(oArgs.get(0), pt, pt1);
                }
                catch (NumberFormatException ex) {
                    logger.error("Incorrect second input argument for construction of circle.");
                    return null;
                }
            }
            if (geoObj instanceof LineThroughTwoPoints) {
                LineThroughTwoPoints l = (LineThroughTwoPoints)geoObj;
                Point pt1 = l.getPoints().get(0);
                Point pt2 = l.getPoints().get(1);
                PRatioPoint pointOnCircle = new PRatioPoint(this.nextAvailableName(), pt, pt1, pt2, new BasicNumber(1));
                return new CircleWithCenterAndPoint(oArgs.get(0), pt, pointOnCircle);
            }
            if (geoObj instanceof Line) {
                logger.error("Object " + geoObj.getGeoObjectLabel() + " has not been converted into an area method-compatible class.");
            }
            return new CircleWithCenterAndPoint(oArgs.get(0), pt, (Point)geoObj);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertConicCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 5, 5, 1, 1)) {
            logger.error("Failed to validate command: Conic");
            return null;
        }
        logger.error("The use of general conics is impossible wih the area method.");
        return null;
    }

    @Override
    protected GeoConstruction convertEllipseCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: Ellipse");
            return null;
        }
        logger.error("The use of general conics is impossible wih the area method.");
        return null;
    }

    @Override
    protected GeoConstruction convertHyperbolaCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: Hyperbola");
            return null;
        }
        logger.error("The use of general conics is impossible wih the area method.");
        return null;
    }

    @Override
    protected GeoConstruction convertParabolaCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Parabola");
            return null;
        }
        logger.error("The use of general conics is impossible wih the area method.");
        return null;
    }

    @Override
    protected GeoConstruction convertSegmentCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Segment");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, pt2));
            Segment seg = new Segment(pt1, pt2, oArgs.get(0));
            this.auxiliaryObjectsMap.put(seg.getGeoObjectLabel(), seg);
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertVectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Vector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, pt2));
            Segment seg = new Segment(pt1, pt2, oArgs.get(0));
            this.auxiliaryObjectsMap.put(seg.getGeoObjectLabel(), seg);
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertRayCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Ray");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, pt2));
            return new LineThroughTwoPoints(oArgs.get(0), pt1, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertAngleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 3, 1, 1)) {
            logger.error("Failed to validate command: Angle");
            return null;
        }
        logger.error("The use of angles is impossible wih the area method - please describe you angles using lines.");
        return null;
    }

    @Override
    protected GeoConstruction convertPolygonCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, -1, 1, -1)) {
            logger.error("Failed to validate command: Polygon");
            return null;
        }
        logger.info("The use of polygons is strongly not recommanded wih the area method - you should describe your polygons using lines.");
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            String oLabel = oArgs.get(0);
            boolean bIsRegular = false;
            int numVertices = 0;
            Vector<Point> vertices = new Vector<Point>();
            Vector<String> edges = new Vector<String>();
            if (oArgs.size() == 3) {
                try {
                    numVertices = Integer.parseInt(oArgs.get(2));
                    if (numVertices < 3) {
                        logger.error("Incorrect number of vertices passed in for construction of regular polygon");
                        return null;
                    }
                    bIsRegular = true;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (!bIsRegular) {
                numVertices = iArgs.size();
                if (oArgs.size() != numVertices + 1) {
                    logger.error("Incorrect number of output arguments for construction of polygon " + oLabel);
                    return null;
                }
                for (String ptLabel : iArgs) {
                    Point pt = (Point)this.thmProtocol.getConstructionMap().get(ptLabel);
                    vertices.add(pt);
                }
            } else {
                if (oArgs.size() != 2 * numVertices - 1) {
                    logger.error("Incorrect number of output arguments for construction of polygon " + oLabel);
                    return null;
                }
                logger.error("The area method does not currently deal with regular polygons. Please construct the regular polygon by hand");
            }
            int ii = 0;
            int jj = 1;
            while (ii < numVertices) {
                Point pt1 = (Point)vertices.get(ii);
                Point pt2 = (Point)vertices.get(jj % numVertices);
                String lineLabel = oArgs.get(ii + 1);
                this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, pt2));
                this.thmProtocol.addGeoConstruction(new LineThroughTwoPoints(lineLabel, pt1, pt2));
                edges.add(lineLabel);
                ++ii;
                ++jj;
            }
            return new IgnoredConstruction();
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertPolyLineCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, -1, 1, 1)) {
            logger.error("Failed to validate command: PolyLine");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            Vector<Point> consList = new Vector<Point>();
            Vector<Point> vertices = new Vector<Point>();
            Vector<String> edges = new Vector<String>();
            logger.error("The use of polylines is not recommanded wih the area method - you should describe your construction using simple lines.");
            for (String ptLabel : iArgs) {
                Point pt = (Point)this.thmProtocol.getConstructionMap().get(ptLabel);
                vertices.add(pt);
                consList.add(pt);
            }
            int ii = 0;
            int jj = 1;
            int numVertices = iArgs.size();
            while (ii < numVertices) {
                Point pt1 = (Point)vertices.get(ii);
                Point pt2 = (Point)vertices.get(jj % numVertices);
                StringBuilder sb = new StringBuilder();
                sb.append(pt1.getGeoObjectLabel());
                sb.append(pt2.getGeoObjectLabel());
                sb.append("_l");
                String lineLabel = GeoGebraConstructionConverter.generateRandomLabel(sb.toString());
                this.thmProtocol.addSimpleNDGCondition(new DistinctPoints(pt1, pt2));
                this.thmProtocol.addGeoConstruction(new LineThroughTwoPoints(lineLabel, pt1, pt2));
                edges.add(lineLabel);
                ++ii;
                ++jj;
            }
            return new IgnoredConstruction();
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircumcircleArcCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircumcircleArc");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            PRatioPoint midPoint1 = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt2, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint1);
            PRatioPoint midPoint2 = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt3, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint2);
            TRatioPoint pointOnLine1 = new TRatioPoint(this.nextAvailableName(), midPoint1, pt1, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(pointOnLine1);
            TRatioPoint pointOnLine2 = new TRatioPoint(this.nextAvailableName(), midPoint2, pt1, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(pointOnLine2);
            return new AMIntersectionPoint(oArgs.get(0), midPoint1, pointOnLine1, midPoint2, pointOnLine2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertCircumcircleSectorCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 3, 3, 1, 1)) {
            logger.error("Failed to validate command: CircumcircleSector");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            Point pt3 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(2));
            PRatioPoint midPoint1 = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt2, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint1);
            PRatioPoint midPoint2 = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt3, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint2);
            TRatioPoint pointOnLine1 = new TRatioPoint(this.nextAvailableName(), midPoint1, pt1, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(pointOnLine1);
            TRatioPoint pointOnLine2 = new TRatioPoint(this.nextAvailableName(), midPoint2, pt1, new BasicNumber(1));
            this.thmProtocol.addGeoConstruction(pointOnLine2);
            return new AMIntersectionPoint(oArgs.get(0), midPoint1, pointOnLine1, midPoint2, pointOnLine2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    protected GeoConstruction convertSemicircleCmd(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!this.validateCmdArguments(ggCmd, 2, 2, 1, 1)) {
            logger.error("Failed to validate command: Semicircle");
            return null;
        }
        try {
            ArrayList<String> iArgs = ggCmd.getInputArgs();
            ArrayList<String> oArgs = ggCmd.getOutputArgs();
            Point pt1 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(0));
            Point pt2 = (Point)this.thmProtocol.getConstructionMap().get(iArgs.get(1));
            PRatioPoint midPoint = new PRatioPoint(this.nextAvailableName(), pt1, pt1, pt2, new Fraction(1, 2));
            this.thmProtocol.addGeoConstruction(midPoint);
            return new CircleWithCenterAndPoint(oArgs.get(0), midPoint, pt2);
        }
        catch (ClassCastException ex) {
            logger.error(GeoGebraConstructionConverter.getClassCastExceptionMessage(ggCmd, ex));
            return null;
        }
        catch (Exception ex) {
            logger.error("Unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    protected String nextAvailableName() {
        return "iP".concat(String.valueOf(lastUsedNumber++));
    }
}

