/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GeoGebraStatementConverter;
import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.parse.ExpressionParser;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.CollinearPoints;
import com.ogprover.pp.tp.thmstatement.ConcurrentCircles;
import com.ogprover.pp.tp.thmstatement.ConcurrentLines;
import com.ogprover.pp.tp.thmstatement.ConcyclicPoints;
import com.ogprover.pp.tp.thmstatement.EqualAngles;
import com.ogprover.pp.tp.thmstatement.EqualityOfExpressions;
import com.ogprover.pp.tp.thmstatement.False;
import com.ogprover.pp.tp.thmstatement.IdenticalPoints;
import com.ogprover.pp.tp.thmstatement.SegmentsOfEqualLengths;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import com.ogprover.pp.tp.thmstatement.True;
import com.ogprover.pp.tp.thmstatement.TwoParallelLines;
import com.ogprover.pp.tp.thmstatement.TwoPerpendicularLines;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;

public class GGStatConverterForAreaMethod
extends GeoGebraStatementConverter {
    public static final String VERSION_NUM = "1.00";

    public GGStatConverterForAreaMethod(GeoGebraTheoremConverter ggThmCnv) {
        super(ggThmCnv);
    }

    @Override
    public ThmStatement convertBoolean() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 1) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        String statementText = new String(statementArgs.get(0)).toUpperCase();
        if (statementText.equals("TRUE")) {
            return new True(this.thmProtocol);
        }
        if (statementText.equals("FALSE")) {
            return new False(this.thmProtocol);
        }
        logger.error("Failed to convert statement - incorrect boolean statement");
        return null;
    }

    @Override
    public ThmStatement convertCollinear() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 3) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            Point p1 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
            Point p2 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            Point p3 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(2));
            if (p1 == null || p2 == null || p3 == null) {
                logger.error("Failed to convert statement - missing input argument");
                return null;
            }
            ArrayList<Point> alp = new ArrayList<Point>();
            alp.add(p1);
            alp.add(p2);
            alp.add(p3);
            return new CollinearPoints(alp);
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    public ThmStatement convertConcyclic() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 4) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            Point p1 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
            Point p2 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            Point p3 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(2));
            Point p4 = (Point)this.thmProtocol.getConstructionMap().get(statementArgs.get(3));
            if (p1 == null || p2 == null || p3 == null || p4 == null) {
                logger.error("Failed to convert statement - missing input argument");
                return null;
            }
            ArrayList<Point> alp = new ArrayList<Point>();
            alp.add(p1);
            alp.add(p2);
            alp.add(p3);
            alp.add(p4);
            return new ConcyclicPoints(alp);
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    public ThmStatement convertConcurrent() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 3) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            GeoObject gobj1 = this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
            GeoObject gobj2 = this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            GeoObject gobj3 = this.thmProtocol.getConstructionMap().get(statementArgs.get(2));
            if (gobj1 == null || gobj2 == null || gobj3 == null) {
                logger.error("Failed to convert statement - missing input argument");
                return null;
            }
            if (gobj1 instanceof Line) {
                ArrayList<Line> all = new ArrayList<Line>();
                all.add((Line)gobj1);
                all.add((Line)gobj2);
                all.add((Line)gobj3);
                return new ConcurrentLines(all);
            }
            if (gobj1 instanceof Circle) {
                ArrayList<Circle> alc = new ArrayList<Circle>();
                alc.add((Circle)gobj1);
                alc.add((Circle)gobj2);
                alc.add((Circle)gobj3);
                return new ConcurrentCircles(alc);
            }
            logger.error("Failed to convert statement - unsupported input argument type");
            return null;
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    public ThmStatement convertEqual() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        logger.info("Converting equal statement. Arguments :");
        for (String arg : statementArgs) {
            logger.info("  " + arg);
        }
        if (statementArgs.size() != 2) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            GeoObject gobj1 = (GeoObject)this.auxiliaryObjectsMap.get(statementArgs.get(0));
            GeoObject gobj2 = (GeoObject)this.auxiliaryObjectsMap.get(statementArgs.get(1));
            if (gobj1 == null || gobj2 == null) {
                gobj1 = this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
                gobj2 = this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            }
            if (gobj1 == null || gobj2 == null) {
                logger.error("A part of the equality is not the label of a known construction - trying to parse it as an expression");
                AMExpression expr1 = ExpressionParser.convert(statementArgs.get(0));
                AMExpression expr2 = ExpressionParser.convert(statementArgs.get(1));
                return new EqualityOfExpressions(expr1, expr2);
            }
            if (gobj1 instanceof Point) {
                return new IdenticalPoints((Point)gobj1, (Point)gobj2);
            }
            if (gobj1 instanceof Segment) {
                return new SegmentsOfEqualLengths((Segment)gobj1, (Segment)gobj2);
            }
            if (gobj1 instanceof Angle) {
                return new EqualAngles((Angle)gobj1, (Angle)gobj2);
            }
            if (gobj1 instanceof GeoConstruction) {
                logger.error("Failed to convert statement - unsupported input argument type : " + ((GeoConstruction)gobj1).getConstructionDesc());
            } else {
                logger.error("Failed to convert statement - unsupported input argument type : " + gobj1.getGeoObjectLabel() + " is not a GeoConstruction instance");
            }
            return null;
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    public ThmStatement convertParallel() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 2) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            Line l1 = (Line)this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
            Line l2 = (Line)this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            if (l1 == null || l2 == null) {
                logger.error("Failed to convert statement - missing input argument");
                return null;
            }
            return new TwoParallelLines(l1, l2);
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }

    @Override
    public ThmStatement convertPerpendicular() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        ArrayList<String> statementArgs = this.ggStatCmd.getInputArgs();
        if (statementArgs.size() != 2) {
            logger.error("Failed to convert statement - incorrect number of arguments");
            return null;
        }
        try {
            Line l1 = (Line)this.thmProtocol.getConstructionMap().get(statementArgs.get(0));
            Line l2 = (Line)this.thmProtocol.getConstructionMap().get(statementArgs.get(1));
            if (l1 == null || l2 == null) {
                logger.error("Failed to convert statement - missing input argument");
                return null;
            }
            return new TwoPerpendicularLines(l1, l2);
        }
        catch (ClassCastException ex) {
            logger.error("Failed to convert statement due to following reason: " + ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error("Failed to convert statement - unexpected exception caught: " + ex.toString());
            return null;
        }
    }
}

