/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.geogebra.command.GeoGebraCommand;
import com.ogprover.geogebra.command.construction.GeoGebraConstructionCommand;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IgnoredConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class GeoGebraConstructionConverter {
    public static final String VERSION_NUM = "1.00";
    protected Vector<GeoGebraConstructionCommand> ggCmdList;
    protected OGPTP thmProtocol;
    protected Vector<GeoConstruction> constructionsToRemove;
    protected Map<String, GeoObject> auxiliaryObjectsMap;
    protected boolean bSuccess;

    protected abstract GeoConstruction convertFreePointCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertPointCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertPointInCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertIntersectCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertMidpointCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCenterCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertLineCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertOrthogonalLineCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertLineBisectorCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertAngularBisectorCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertTangentCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertPolarCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertDiameterCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCircleCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertConicCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertEllipseCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertHyperbolaCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertParabolaCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertMirrorCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertRotateCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertTranslateCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertDilateCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertSegmentCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertPolygonCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertPolyLineCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertRayCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertAngleCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertVectorCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertSemicircleCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCircleArcCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCircumcircleArcCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCircleSectorCmd(GeoGebraConstructionCommand var1);

    protected abstract GeoConstruction convertCircumcircleSectorCmd(GeoGebraConstructionCommand var1);

    public Vector<GeoGebraConstructionCommand> getConstructionCmdList() {
        return this.ggCmdList;
    }

    public OGPTP getThmProtocol() {
        return this.thmProtocol;
    }

    public Map<String, GeoObject> getAuxiliaryObjectsMap() {
        return this.auxiliaryObjectsMap;
    }

    public boolean isbSuccess() {
        return this.bSuccess;
    }

    public GeoGebraConstructionConverter(GeoGebraTheoremConverter ggThmCnv) {
        this.ggCmdList = ggThmCnv.getTheorem().getConstructionList();
        this.thmProtocol = ggThmCnv.getThmProtocol();
        this.constructionsToRemove = new Vector();
        this.auxiliaryObjectsMap = new HashMap<String, GeoObject>();
        this.bSuccess = true;
    }

    public boolean convert() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        this.bSuccess = true;
        if (this.ggCmdList == null) {
            logger.error("Can't convert constructions - Missing input list with GeoGebra's commands");
            this.bSuccess = false;
            return false;
        }
        if (this.thmProtocol == null) {
            logger.error("Can't convert constructions - Missing storage for converted constructions");
            this.bSuccess = false;
            return false;
        }
        for (GeoGebraConstructionCommand ggCmd : this.ggCmdList) {
            this.constructionsToRemove.clear();
            GeoConstruction geoCons = this.convertConstruction(ggCmd);
            if (geoCons == null) {
                logger.error("Failed to convert GeoGebra command " + (ggCmd != null ? ggCmd.getDescription() : ""));
                this.bSuccess = false;
                return false;
            }
            if (this.constructionsToRemove.size() > 0) {
                for (GeoConstruction gc : this.constructionsToRemove) {
                    this.thmProtocol.removeGeoConstruction(gc);
                }
            }
            if (geoCons instanceof IgnoredConstruction) continue;
            this.thmProtocol.addGeoConstruction(geoCons);
        }
        return true;
    }

    protected GeoConstruction convertConstruction(GeoGebraConstructionCommand ggCmd) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        String consName = ggCmd.getCommandName();
        if (consName.equals("FreePoint")) {
            return this.convertFreePointCmd(ggCmd);
        }
        if (consName.equals("Point")) {
            return this.convertPointCmd(ggCmd);
        }
        if (consName.equals("PointIn")) {
            return this.convertPointInCmd(ggCmd);
        }
        if (consName.equals("Intersect")) {
            return this.convertIntersectCmd(ggCmd);
        }
        if (consName.equals("Midpoint")) {
            return this.convertMidpointCmd(ggCmd);
        }
        if (consName.equals("Center")) {
            return this.convertCenterCmd(ggCmd);
        }
        if (consName.equals("Line")) {
            return this.convertLineCmd(ggCmd);
        }
        if (consName.equals("OrthogonalLine")) {
            return this.convertOrthogonalLineCmd(ggCmd);
        }
        if (consName.equals("LineBisector")) {
            return this.convertLineBisectorCmd(ggCmd);
        }
        if (consName.equals("AngularBisector")) {
            return this.convertAngularBisectorCmd(ggCmd);
        }
        if (consName.equals("Tangent")) {
            return this.convertTangentCmd(ggCmd);
        }
        if (consName.equals("Polar")) {
            return this.convertPolarCmd(ggCmd);
        }
        if (consName.equals("Diameter")) {
            return this.convertDiameterCmd(ggCmd);
        }
        if (consName.equals("Circle")) {
            return this.convertCircleCmd(ggCmd);
        }
        if (consName.equals("Conic")) {
            return this.convertConicCmd(ggCmd);
        }
        if (consName.equals("Ellipse")) {
            return this.convertEllipseCmd(ggCmd);
        }
        if (consName.equals("Hyperbola")) {
            return this.convertHyperbolaCmd(ggCmd);
        }
        if (consName.equals("Parabola")) {
            return this.convertParabolaCmd(ggCmd);
        }
        if (consName.equals("Mirror")) {
            return this.convertMirrorCmd(ggCmd);
        }
        if (consName.equals("Rotate")) {
            return this.convertRotateCmd(ggCmd);
        }
        if (consName.equals("Translate")) {
            return this.convertTranslateCmd(ggCmd);
        }
        if (consName.equals("Dilate")) {
            return this.convertDilateCmd(ggCmd);
        }
        if (consName.equals("Segment")) {
            return this.convertSegmentCmd(ggCmd);
        }
        if (consName.equals("Vector")) {
            return this.convertVectorCmd(ggCmd);
        }
        if (consName.equals("Ray")) {
            return this.convertRayCmd(ggCmd);
        }
        if (consName.equals("Angle")) {
            return this.convertAngleCmd(ggCmd);
        }
        if (consName.equals("Polygon")) {
            return this.convertPolygonCmd(ggCmd);
        }
        if (consName.equals("PolyLine")) {
            return this.convertPolyLineCmd(ggCmd);
        }
        if (consName.equals("CircleArc")) {
            return this.convertCircleArcCmd(ggCmd);
        }
        if (consName.equals("CircumcircleArc")) {
            return this.convertCircumcircleArcCmd(ggCmd);
        }
        if (consName.equals("CircleSector")) {
            return this.convertCircleSectorCmd(ggCmd);
        }
        if (consName.equals("CircumcircleSector")) {
            return this.convertCircumcircleSectorCmd(ggCmd);
        }
        if (consName.equals("Semicircle")) {
            return this.convertSemicircleCmd(ggCmd);
        }
        logger.error("Unknown GeoGebra command - cannot convert.");
        return null;
    }

    protected boolean validateCmdArguments(GeoGebraConstructionCommand ggCmd, int minInputSize, int maxInputSize, int minOutputSize, int maxOutputSize) {
        ArrayList<String> oArgs;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (ggCmd == null) {
            logger.error("Cannot convert null command");
            return false;
        }
        ArrayList<String> iArgs = ggCmd.getInputArgs();
        if (iArgs == null && minInputSize > 0) {
            logger.error("List of input arguments is null for command " + ggCmd.getDescription());
            return false;
        }
        if (iArgs != null) {
            int iSize = iArgs.size();
            if (iSize < minInputSize || maxInputSize != -1 && iSize > maxInputSize) {
                logger.error("List of input arguments is with incorrect number of elements for command " + ggCmd.getDescription());
                return false;
            }
            for (int ii = 0; ii < iSize; ++ii) {
                String iLabel = iArgs.get(ii);
                if (iLabel == null) {
                    logger.error("Some of input arguments is null for command " + ggCmd.getDescription());
                    return false;
                }
                if (iLabel.length() == 0) {
                    logger.error("Empty label is not allowed for input argument in command " + ggCmd.getDescription());
                    return false;
                }
                if (this.getGeoObject(iLabel) != null || iLabel.contains("[") && iLabel.contains("]")) continue;
                try {
                    Double.parseDouble(iLabel);
                    continue;
                }
                catch (NumberFormatException ex) {
                    logger.error("The format of input label is incorrect for command " + ggCmd.getDescription());
                    return false;
                }
            }
        }
        if ((oArgs = ggCmd.getOutputArgs()) == null) {
            logger.error("List of output arguments is null for command " + ggCmd.getDescription());
            return false;
        }
        int oSize = oArgs.size();
        if (oSize < minOutputSize || maxOutputSize != -1 && oSize > maxOutputSize) {
            logger.error("List of output arguments is with incorrect number of elements for command " + ggCmd.getDescription());
            return false;
        }
        for (int ii = 0; ii < oSize; ++ii) {
            String oLabel = oArgs.get(ii);
            if (oLabel == null) {
                logger.error("Some of output arguments is null for command " + ggCmd.getDescription());
                return false;
            }
            if (this.getGeoObject(oLabel) == null) continue;
            logger.error("Bad output label (already used in previous construction) for command " + ggCmd.getDescription());
            return false;
        }
        return true;
    }

    protected GeoObject getGeoObject(String objLabel) {
        GeoConstruction gc = this.thmProtocol.getConstructionMap().get(objLabel);
        if (gc != null) {
            return gc;
        }
        return this.auxiliaryObjectsMap.get(objLabel);
    }

    protected Vector<Point> getOrCreatePointsFromPointSet(SetOfPoints ptSet, int numOfPts, Vector<GeoConstruction> consList) {
        if (ptSet == null) {
            return null;
        }
        Vector<Point> vpts = new Vector<Point>();
        Vector<Point> setPts = ptSet.getPoints();
        int numSetPts = setPts == null ? 0 : setPts.size();
        for (int ii = 0; ii < numOfPts; ++ii) {
            Point pt;
            Point point = pt = numSetPts > ii ? setPts.get(ii) : null;
            if (pt == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(ptSet.getGeoObjectLabel());
                sb.append("_pt");
                sb.append(ii + 1);
                sb.append("_");
                sb.append(Math.round(Math.random() * 1000.0));
                String ptLabel = GeoGebraConstructionConverter.generateRandomLabel(sb.toString());
                pt = RandomPointFromSetOfPoints.createRandomPoint(ptLabel, ptSet);
                if (pt == null) {
                    return null;
                }
                consList.add(pt);
            }
            vpts.add(pt);
        }
        return vpts;
    }

    protected static String generateRandomLabel(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(Math.round(Math.random() * 1000.0));
        return sb.toString();
    }

    protected static String getClassCastExceptionMessage(GeoGebraCommand ggCmd, Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("Can't cast input argument(s) for command ");
        sb.append(ggCmd.getCommandName());
        sb.append(" exception caught: ");
        sb.append(ex.toString());
        return sb.toString();
    }
}

