/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GeoGebraTheoremConverter;
import com.ogprover.geogebra.command.statement.GeoGebraStatementCommand;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import com.ogprover.utilities.logger.ILogger;
import java.util.Map;

public abstract class GeoGebraStatementConverter {
    public static final String VERSION_NUM = "1.00";
    protected GeoGebraStatementCommand ggStatCmd;
    protected OGPTP thmProtocol;
    protected Map<String, GeoObject> auxiliaryObjectsMap;
    protected boolean bSuccess;

    public abstract ThmStatement convertBoolean();

    public abstract ThmStatement convertCollinear();

    public abstract ThmStatement convertConcyclic();

    public abstract ThmStatement convertConcurrent();

    public abstract ThmStatement convertParallel();

    public abstract ThmStatement convertPerpendicular();

    public abstract ThmStatement convertEqual();

    public GeoGebraStatementCommand getStatementCmd() {
        return this.ggStatCmd;
    }

    public OGPTP getThmProtocol() {
        return this.thmProtocol;
    }

    public Map<String, GeoObject> getAuxObjMap() {
        return this.auxiliaryObjectsMap;
    }

    public boolean isbSuccess() {
        return this.bSuccess;
    }

    public GeoGebraStatementConverter(GeoGebraTheoremConverter ggThmCnv) {
        this.ggStatCmd = ggThmCnv.getTheorem().getStatement();
        this.thmProtocol = ggThmCnv.getThmProtocol();
        this.auxiliaryObjectsMap = ggThmCnv.getConsConverter().getAuxiliaryObjectsMap();
        this.bSuccess = true;
    }

    public boolean convert() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        String statementName = this.ggStatCmd.getCommandName();
        this.bSuccess = true;
        ThmStatement thmStat = null;
        if (statementName.equalsIgnoreCase("boolean")) {
            thmStat = this.convertBoolean();
        } else if (statementName.equalsIgnoreCase("AreCollinear")) {
            thmStat = this.convertCollinear();
        } else if (statementName.equalsIgnoreCase("AreConcyclic")) {
            thmStat = this.convertConcyclic();
        } else if (statementName.equalsIgnoreCase("AreConcurrent")) {
            thmStat = this.convertConcurrent();
        } else if (statementName.equalsIgnoreCase("AreEqual")) {
            thmStat = this.convertEqual();
        } else if (statementName.equalsIgnoreCase("AreParallel")) {
            thmStat = this.convertParallel();
        } else if (statementName.equalsIgnoreCase("ArePerpendicular")) {
            thmStat = this.convertPerpendicular();
        }
        if (thmStat == null) {
            logger.error("Failed to convert statement - unknown statement name");
            this.bSuccess = false;
            return this.bSuccess;
        }
        this.thmProtocol.addThmStatement(thmStat);
        return true;
    }
}

