/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.api.converter;

import com.ogprover.api.converter.GeoGebraConstructionConverter;
import com.ogprover.api.converter.GeoGebraStatementConverter;
import com.ogprover.geogebra.GeoGebraTheorem;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.utilities.logger.ILogger;

public abstract class GeoGebraTheoremConverter {
    public static final String VERSION_NUM = "1.00";
    protected GeoGebraTheorem theorem;
    protected GeoGebraConstructionConverter consConverter;
    protected GeoGebraStatementConverter statConverter;
    protected OGPTP thmProtocol;
    protected boolean bSuccess;

    public GeoGebraTheorem getTheorem() {
        return this.theorem;
    }

    public GeoGebraConstructionConverter getConsConverter() {
        return this.consConverter;
    }

    public GeoGebraStatementConverter getStatConverter() {
        return this.statConverter;
    }

    public OGPTP getThmProtocol() {
        return this.thmProtocol;
    }

    public boolean isbSuccess() {
        return this.bSuccess;
    }

    public GeoGebraTheoremConverter(GeoGebraTheorem theorem, OGPTP ogpTP) {
        this.theorem = theorem;
        this.thmProtocol = ogpTP;
        this.bSuccess = true;
        this.consConverter = null;
        this.statConverter = null;
    }

    public boolean convert() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        this.bSuccess = true;
        this.thmProtocol.setTheoremName(this.getTheorem().getTheoremName());
        if (!this.consConverter.convert()) {
            logger.error("Failed to convert constructions necessary for theorem");
            this.bSuccess = false;
            return false;
        }
        if (!this.statConverter.convert()) {
            logger.error("Failed to convert theorem statement");
            this.bSuccess = false;
            return false;
        }
        return true;
    }
}

