/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.main;

import com.ogprover.main.OGPParameters;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.utilities.OGPTimer;
import com.ogprover.utilities.Stopwatch;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.GeoGebraLogger;
import com.ogprover.utilities.logger.ILogger;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class OGPConfigurationSettings {
    public static final String VERSION_NUM = "1.00";
    private OGPParameters parameters = null;
    private OGPOutput output = null;
    private OGPTimer timer = null;
    private Stopwatch stopwatch = null;
    private int maxNumOfTerms = 0;
    private String logFileName = null;
    public static final String defaultLogFileName = OpenGeoProver.class.getSimpleName();
    public static final String dateTimeFormat1 = "[MM_dd_yyyy@HH_mm_ss]";
    private ILogger logger = null;
    private OGPTP parsedTP = null;
    private int retCodeOfPseudoDivision = 0;

    public void setParameters(OGPParameters parameters) {
        this.parameters = parameters;
    }

    public OGPParameters getParameters() {
        return this.parameters;
    }

    public void setOutput(OGPOutput output) {
        this.output = output;
    }

    public OGPOutput getOutput() {
        return this.output;
    }

    public void setTimer(OGPTimer timer) {
        this.timer = timer;
    }

    public OGPTimer getTimer() {
        return this.timer;
    }

    public void setStopwacth(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    public Stopwatch getStopwacth() {
        return this.stopwatch;
    }

    public void setMaxNumOfTerms(int maxNumOfTerms) {
        this.maxNumOfTerms = maxNumOfTerms;
    }

    public int getMaxNumOfTerms() {
        return this.maxNumOfTerms;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setParsedTP(OGPTP parsedTP) {
        this.parsedTP = parsedTP;
    }

    public OGPTP getParsedTP() {
        return this.parsedTP;
    }

    public void setRetCodeOfPseudoDivision(int retCodeOfPseudoDivision) {
        this.retCodeOfPseudoDivision = retCodeOfPseudoDivision;
    }

    public int getRetCodeOfPseudoDivision() {
        return this.retCodeOfPseudoDivision;
    }

    public OGPConfigurationSettings() {
        this(null);
    }

    public OGPConfigurationSettings(String logFileName) {
        this(logFileName, null);
    }

    public OGPConfigurationSettings(String logFileName, String logFileRootDirectory) {
        OGPParameters params = new OGPParameters();
        params.putLogLevel(GeoGebraLogger.DEBUG);
        this.setParameters(params);
        this.setOutput(new OGPOutput(null, null));
        this.setTimer(new OGPTimer());
        this.setStopwacth(new Stopwatch());
        if (logFileName != null) {
            this.logFileName = logFileName;
        } else {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat1);
            this.logFileName = defaultLogFileName + sdf.format(cal.getTime());
        }
        this.setLogger(GeoGebraLogger.factory(this.logFileName, logFileRootDirectory));
    }

    public void logSpaceErrorInPseudoDivision(int numOfTerms) {
        StringBuilder sb = new StringBuilder();
        sb.append("Space limit exceeded in pseudo division. Obtained polynomial with ");
        sb.append(numOfTerms);
        sb.append(" terms");
        this.logger.error(sb.toString());
        this.setRetCodeOfPseudoDivision(-3);
        this.maxNumOfTerms = numOfTerms;
    }

    public void logTimeErrorInPseudoDivision() {
        this.logger.error("Time limit exceeded in pseudo division");
        this.setRetCodeOfPseudoDivision(-2);
    }

    public void logGeneralErrorInPseudoDivision(String errorMsg) {
        this.logger.error(errorMsg);
        this.setRetCodeOfPseudoDivision(-1);
    }
}

