/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.main;

import com.ogprover.main.OGPConstants;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.utilities.logger.GeoGebraLogger;
import com.ogprover.utilities.logger.ILogger;
import java.util.HashMap;

public class OGPParameters {
    public static final String VERSION_NUM = "1.00";
    public static final String PARAM_INPUT_FILE = "I";
    public static final String PARAM_INPUT_FORMAT = "i";
    public static final String PARAM_OUTPUT_FILE = "O";
    public static final String PARAM_OUTPUT_FORMAT = "o";
    public static final String PARAM_PROVER = "p";
    public static final String PARAM_CONCURRENCY_LEVEL = "c";
    public static final String PARAM_LOG_LEVEL = "l";
    public static final String PARAM_VERBOSE = "v";
    public static final String PARAM_TIME_LIMIT = "t";
    public static final String PARAM_SPACE_LIMIT = "s";
    private HashMap<String, String> params = new HashMap();

    public String put(String key, String value) {
        if (key.equals(PARAM_INPUT_FILE) || key.equals(PARAM_INPUT_FORMAT) || key.equals(PARAM_OUTPUT_FILE) || key.equals(PARAM_OUTPUT_FORMAT) || key.equals(PARAM_PROVER) || key.equals(PARAM_CONCURRENCY_LEVEL) || key.equals(PARAM_LOG_LEVEL) || key.equals(PARAM_VERBOSE) || key.equals(PARAM_TIME_LIMIT) || key.equals(PARAM_SPACE_LIMIT)) {
            return this.params.put(key, value);
        }
        OpenGeoProver.settings.getLogger().error("Bad parameter name passed in.");
        return null;
    }

    public String putInputFile(String fileName) {
        return this.put(PARAM_INPUT_FILE, fileName);
    }

    public String putInputFormat(String fmt) {
        return this.put(PARAM_INPUT_FORMAT, fmt);
    }

    public String putOutputFile(String fileName) {
        return this.put(PARAM_OUTPUT_FILE, fileName);
    }

    public String putOutputFormat(String fmt) {
        return this.put(PARAM_OUTPUT_FORMAT, fmt);
    }

    public String putProver(int proverType) {
        String retCode = null;
        switch (proverType) {
            case 0: {
                retCode = this.put(PARAM_PROVER, "W");
                break;
            }
            case 1: {
                retCode = this.put(PARAM_PROVER, "G");
                break;
            }
            case 2: {
                retCode = this.put(PARAM_PROVER, "A");
                break;
            }
            default: {
                retCode = this.put(PARAM_PROVER, "W");
            }
        }
        return retCode;
    }

    public String putConLevel(int n) {
        if (n <= 0 || n > 100) {
            OpenGeoProver.settings.getLogger().error("Attempt to put bad number of threads. Setting to default value of 1.");
            return this.put(PARAM_CONCURRENCY_LEVEL, "1");
        }
        return this.put(PARAM_CONCURRENCY_LEVEL, n + "");
    }

    public String putLogLevel(GeoGebraLogger.Level logLevel) {
        String retCode = null;
        retCode = logLevel == null ? this.put(PARAM_LOG_LEVEL, "N") : (logLevel.equals(GeoGebraLogger.INFO) ? this.put(PARAM_LOG_LEVEL, PARAM_INPUT_FILE) : (logLevel.equals(GeoGebraLogger.ERROR) ? this.put(PARAM_LOG_LEVEL, "E") : (logLevel.equals(GeoGebraLogger.WARN) ? this.put(PARAM_LOG_LEVEL, "W") : (logLevel.equals(GeoGebraLogger.DEBUG) ? this.put(PARAM_LOG_LEVEL, "D") : this.put(PARAM_LOG_LEVEL, "D")))));
        return retCode;
    }

    public String putVerbose(boolean verbose) {
        if (verbose) {
            return this.put(PARAM_VERBOSE, "true");
        }
        return this.put(PARAM_VERBOSE, "false");
    }

    public String putTimeLimit(double timeLim) {
        if (timeLim <= 0.0) {
            OpenGeoProver.settings.getLogger().error("Time limit in milliseconds must be a positive value.");
            this.put(PARAM_TIME_LIMIT, "10000");
        }
        return this.put(PARAM_TIME_LIMIT, timeLim + "");
    }

    public String putSpaceLimit(int spaceLim) {
        if (spaceLim <= 0) {
            OpenGeoProver.settings.getLogger().error("Space limit in number of terms must be positive value.");
            this.put(PARAM_SPACE_LIMIT, "2000");
        }
        return this.put(PARAM_SPACE_LIMIT, spaceLim + "");
    }

    public String get(String key) {
        if (key.equals(PARAM_INPUT_FILE) || key.equals(PARAM_INPUT_FORMAT) || key.equals(PARAM_OUTPUT_FILE) || key.equals(PARAM_OUTPUT_FORMAT) || key.equals(PARAM_PROVER) || key.equals(PARAM_CONCURRENCY_LEVEL) || key.equals(PARAM_LOG_LEVEL) || key.equals(PARAM_VERBOSE) || key.equals(PARAM_TIME_LIMIT) || key.equals(PARAM_SPACE_LIMIT)) {
            return this.params.get(key);
        }
        OpenGeoProver.settings.getLogger().error("Bad parameter name passed in.");
        return null;
    }

    public String getInputFile() {
        return this.get(PARAM_INPUT_FILE);
    }

    public String getInputFormat() {
        return this.get(PARAM_INPUT_FORMAT);
    }

    public String getOutputFile() {
        return this.get(PARAM_OUTPUT_FILE);
    }

    public String getOutputFormat() {
        return this.get(PARAM_OUTPUT_FORMAT);
    }

    public int getProver() {
        String value = this.get(PARAM_PROVER);
        if (value.equals("W")) {
            return 0;
        }
        if (value.equals("G")) {
            return 1;
        }
        if (value.equals("A")) {
            return 2;
        }
        OpenGeoProver.settings.getLogger().error("Bad value assigned to parameter");
        return -1;
    }

    public int getConLevel() {
        String value = this.get(PARAM_CONCURRENCY_LEVEL);
        int n = Integer.parseInt(value);
        if (n <= 0 || n > 100) {
            OpenGeoProver.settings.getLogger().error("Bad value assigned to parameter");
            return -1;
        }
        return n;
    }

    public GeoGebraLogger.Level getLogLevel() {
        String value = this.get(PARAM_LOG_LEVEL);
        GeoGebraLogger.Level retCode = GeoGebraLogger.INFO;
        switch (value.charAt(0)) {
            case 'N': {
                retCode = null;
                break;
            }
            case 'B': {
                retCode = GeoGebraLogger.INFO;
                break;
            }
            case 'E': {
                retCode = GeoGebraLogger.ERROR;
                break;
            }
            case 'I': {
                retCode = GeoGebraLogger.INFO;
                break;
            }
            case 'W': {
                retCode = GeoGebraLogger.WARN;
                break;
            }
            case 'D': {
                retCode = GeoGebraLogger.DEBUG;
                break;
            }
            default: {
                OpenGeoProver.settings.getLogger().error("Bad value assigned to log level parameter.");
            }
        }
        return retCode;
    }

    public boolean getVerbose() {
        String value = this.get(PARAM_VERBOSE);
        return value.equals("true");
    }

    public long getTimeLimit() {
        String value = this.get(PARAM_TIME_LIMIT);
        long timeLim = Math.round(Double.parseDouble(value));
        if (timeLim <= 0L) {
            OpenGeoProver.settings.getLogger().error("Bad value assigned to parameter");
            return -1L;
        }
        return timeLim;
    }

    public int getSpaceLimit() {
        String value = this.get(PARAM_SPACE_LIMIT);
        int spaceLim = Integer.parseInt(value);
        if (spaceLim <= 0) {
            OpenGeoProver.settings.getLogger().error("Bad value assigned to parameter");
            return -1;
        }
        return spaceLim;
    }

    public OGPParameters() {
        this.init();
    }

    private void init() {
        this.params.put(PARAM_INPUT_FILE, OGPConstants.DEF_VAL_PARAM_INPUT_FILE);
        this.params.put(PARAM_INPUT_FORMAT, PARAM_OUTPUT_FILE);
        this.params.put(PARAM_OUTPUT_FILE, "output");
        this.params.put(PARAM_OUTPUT_FORMAT, "A");
        this.params.put(PARAM_PROVER, "W");
        this.params.put(PARAM_CONCURRENCY_LEVEL, "1");
        this.params.put(PARAM_LOG_LEVEL, "B");
        this.params.put(PARAM_VERBOSE, "false");
        this.params.put(PARAM_TIME_LIMIT, "10000");
        this.params.put(PARAM_SPACE_LIMIT, "2000");
    }

    public static void printHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Correct command line should include following options/parameters: ");
        sb.append("\n\n-I\tname of input file (format can be gclc or xml file);\n\t name is not required - if not set, theorems from internal memory will be used");
        sb.append("\n\n-i\tformat of input file - can be \"G\" for gclc file, \"O\" for OGP xml file or \n\t\"A\" for xml file with theorem in algebraic form; default is \"");
        sb.append(PARAM_OUTPUT_FILE);
        sb.append("\"");
        sb.append("\n\n-O\tname of output file (format can be tex or xml file);\n\t name is not required - default name is \"");
        sb.append("output");
        sb.append("\"");
        sb.append("\n\n-o\tformat of output file - can be \"L\" for (la)tex file, \"X\" for xml file,\n\t \"A\" for all formats or \"N\" to not create the output reports; \n\tdefault is \"");
        sb.append("A");
        sb.append("\"");
        sb.append("\n\n-p\tprover method - can be \"W\" for Wu's method or \"G\" for Groebner basis method - default is \"");
        sb.append("W");
        sb.append("\"");
        sb.append("\n\n-c\tlevel of concurrency i.e. number of parallel threads for polynomials' multiplying -\n\t default is ");
        sb.append("1");
        sb.append(" and maximal value is ");
        sb.append(100);
        sb.append("\n\n-l\tlog level - can be \"N\" (no logging), \"B\" (basic - errors, infos and warnings),\n\t \"E\" (errors), \"W\" (warnings and errors), \"I\" (infos, errors and warnings - same as basic level)\n\t and \"D\" (debug + basic); default is \"");
        sb.append("B");
        sb.append("\"");
        sb.append("\n\n-v\tverbose flag - to print log messages to standard output (not required)");
        sb.append("\n\n-t\ttime limit in seconds for proving of single theorem; default is ");
        sb.append(Double.parseDouble("10000") / 1000.0);
        sb.append("\n\n-s\tspace limit as maximal number of terms in single polynomial obtained during proving process;\n\t default is ");
        sb.append("2000");
        sb.append("\n\n");
        System.out.println(sb.toString());
    }

    public static int readParametersFromCommandLine(String[] args) {
        int ii = 0;
        int argc = args.length;
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        ILogger logger = OpenGeoProver.settings.getLogger();
        boolean setInputFmt = false;
        boolean setInputName = false;
        int retCode = 0;
        if (parameters == null) {
            parameters = new OGPParameters();
            OpenGeoProver.settings.setParameters(parameters);
        }
        while (ii < argc && retCode == 0) {
            String currArg = args[ii];
            if (currArg.charAt(0) == '-') {
                String extension;
                String paramValue;
                String paramName = currArg.substring(1);
                String string = paramValue = ii + 1 < argc ? args[ii + 1] : null;
                if (paramValue != null && paramValue.charAt(0) == '-') {
                    paramValue = null;
                }
                if (paramName.equals(PARAM_INPUT_FILE)) {
                    if (paramValue == null) {
                        logger.error("Missing input file name - ignoring this parameter.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    int lastPoint = paramValue.lastIndexOf(46);
                    if (lastPoint >= 0) {
                        extension = paramValue.substring(lastPoint + 1);
                        if (extension == null || !extension.equals("xml") && !extension.equals("gcl")) {
                            logger.error("Bad extension provided - ignoring this parameter.");
                            retCode = -1;
                        }
                    } else if (setInputFmt) {
                        String inputFmt = parameters.getInputFormat();
                        if (inputFmt == null) {
                            logger.error("Missing input format - unable to attach extension to input file name.");
                            retCode = -1;
                        } else if (inputFmt.equals(PARAM_OUTPUT_FILE) || inputFmt.equals("A")) {
                            paramValue = paramValue.concat(".xml");
                        } else if (inputFmt.equals("G")) {
                            paramValue = paramValue.concat(".gcl");
                        } else {
                            logger.error("Unknown input format - unable to attach extension to input file name.");
                            retCode = -1;
                        }
                    }
                    if (retCode == 0) {
                        parameters.putInputFile(paramValue);
                        setInputName = true;
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_INPUT_FORMAT)) {
                    if (paramValue == null) {
                        logger.error("Missing input format - OGP XML is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    if (!(paramValue.equals(PARAM_OUTPUT_FILE) || paramValue.equals("A") || paramValue.equals("G"))) {
                        logger.error("Bad extension provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        String inputName;
                        parameters.putInputFormat(paramValue);
                        setInputFmt = true;
                        if (setInputName && (inputName = parameters.getInputFile()).lastIndexOf(46) < 0) {
                            inputName = paramValue.equals(PARAM_OUTPUT_FILE) || paramValue.equals("A") ? inputName.concat(".xml") : inputName.concat(".gcl");
                            parameters.putInputFile(inputName);
                        }
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_OUTPUT_FILE)) {
                    if (paramValue == null) {
                        logger.error("Missing output file name - ignoring this parameter.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    int lastPoint = paramValue.lastIndexOf(46);
                    if (lastPoint >= 0) {
                        extension = paramValue.substring(lastPoint + 1);
                        if (extension == null || !extension.equals("xml") && !extension.equals("tex")) {
                            logger.error("Bad extension provided - ignoring this parameter.");
                            retCode = -1;
                        } else if ((paramValue = paramValue.substring(0, lastPoint)) == null) {
                            logger.error("Null output file name provided - ignoring this parameter.");
                            retCode = -1;
                        }
                    }
                    if (retCode == 0) {
                        parameters.putOutputFile(paramValue);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_OUTPUT_FORMAT)) {
                    if (paramValue == null) {
                        logger.error("Missing output format - all is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    if (!(paramValue.equals("X") || paramValue.equals("L") || paramValue.equals("A") || paramValue.equals("N"))) {
                        logger.error("Bad output format provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.putOutputFormat(paramValue);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_PROVER)) {
                    if (paramValue == null) {
                        logger.error("Missing prover type - Wu's method is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    if (!paramValue.equals("W") && !paramValue.equals("G")) {
                        logger.error("Bad prover type provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.put(PARAM_PROVER, paramValue);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_CONCURRENCY_LEVEL)) {
                    if (paramValue == null) {
                        logger.error("Missing concurrency level - single thread is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    int value = Integer.parseInt(paramValue);
                    if (value <= 0 || value > 100) {
                        logger.error("Bad concurrency level provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.putConLevel(value);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_LOG_LEVEL)) {
                    if (paramValue == null) {
                        logger.error("Missing log level - basic is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    if (!(paramValue.equals("N") || paramValue.equals("B") || paramValue.equals("E") || paramValue.equals(PARAM_INPUT_FILE) || paramValue.equals("W") || paramValue.equals("D"))) {
                        logger.error("Bad log level provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.put(PARAM_LOG_LEVEL, paramValue);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_VERBOSE)) {
                    parameters.putVerbose(true);
                    ++ii;
                    continue;
                }
                if (paramName.equals(PARAM_TIME_LIMIT)) {
                    if (paramValue == null) {
                        logger.error("Missing time limit - 10000 milliseconds is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    double value = Double.parseDouble(paramValue);
                    if (value <= 0.0) {
                        logger.error("Bad time limit provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.putTimeLimit(value * 1000.0);
                    }
                    ii += 2;
                    continue;
                }
                if (paramName.equals(PARAM_SPACE_LIMIT)) {
                    if (paramValue == null) {
                        logger.error("Missing space limit - 2000 terms is default.");
                        retCode = -1;
                        ++ii;
                        continue;
                    }
                    int value = Integer.parseInt(paramValue);
                    if (value <= 0) {
                        logger.error("Bad space limit provided - ignoring this parameter.");
                        retCode = -1;
                    } else {
                        parameters.putSpaceLimit(value);
                    }
                    ii += 2;
                    continue;
                }
                logger.error("Found unknown parameter '" + paramName + "'.");
                retCode = -1;
                continue;
            }
            logger.error("Non-parametric argument found when expected parameter name.");
            retCode = -1;
            ++ii;
        }
        return retCode;
    }

    public boolean createReport() {
        return !OpenGeoProver.settings.getParameters().getOutputFormat().equals("N");
    }
}

